package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PersistentVolumeListBuilder extends PersistentVolumeListFluentImpl<PersistentVolumeListBuilder> implements VisitableBuilder<PersistentVolumeList,PersistentVolumeListBuilder>{
  public PersistentVolumeListBuilder() {
    this(false);
  }
  public PersistentVolumeListBuilder(Boolean validationEnabled) {
    this(new PersistentVolumeList(), validationEnabled);
  }
  public PersistentVolumeListBuilder(PersistentVolumeListFluent<?> fluent) {
    this(fluent, false);
  }
  public PersistentVolumeListBuilder(PersistentVolumeListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new PersistentVolumeList(), validationEnabled);
  }
  public PersistentVolumeListBuilder(PersistentVolumeListFluent<?> fluent,PersistentVolumeList instance) {
    this(fluent, instance, false);
  }
  public PersistentVolumeListBuilder(PersistentVolumeListFluent<?> fluent,PersistentVolumeList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public PersistentVolumeListBuilder(PersistentVolumeList instance) {
    this(instance,false);
  }
  public PersistentVolumeListBuilder(PersistentVolumeList instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  PersistentVolumeListFluent<?> fluent;
  Boolean validationEnabled;
  public PersistentVolumeList build() {
    PersistentVolumeList buildable = new PersistentVolumeList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}