package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class LocalVolumeSourceBuilder extends LocalVolumeSourceFluentImpl<LocalVolumeSourceBuilder> implements VisitableBuilder<LocalVolumeSource,LocalVolumeSourceBuilder>{
  public LocalVolumeSourceBuilder() {
    this(false);
  }
  public LocalVolumeSourceBuilder(Boolean validationEnabled) {
    this(new LocalVolumeSource(), validationEnabled);
  }
  public LocalVolumeSourceBuilder(LocalVolumeSourceFluent<?> fluent) {
    this(fluent, false);
  }
  public LocalVolumeSourceBuilder(LocalVolumeSourceFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new LocalVolumeSource(), validationEnabled);
  }
  public LocalVolumeSourceBuilder(LocalVolumeSourceFluent<?> fluent,LocalVolumeSource instance) {
    this(fluent, instance, false);
  }
  public LocalVolumeSourceBuilder(LocalVolumeSourceFluent<?> fluent,LocalVolumeSource instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withFsType(instance.getFsType());
      fluent.withPath(instance.getPath());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public LocalVolumeSourceBuilder(LocalVolumeSource instance) {
    this(instance,false);
  }
  public LocalVolumeSourceBuilder(LocalVolumeSource instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withFsType(instance.getFsType());
      this.withPath(instance.getPath());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  LocalVolumeSourceFluent<?> fluent;
  Boolean validationEnabled;
  public LocalVolumeSource build() {
    LocalVolumeSource buildable = new LocalVolumeSource(fluent.getFsType(),fluent.getPath());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}