package io.fabric8.kubernetes.api.model;

import java.lang.String;
import java.lang.Deprecated;
import java.lang.Long;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.model.version.Info;
import java.lang.Integer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import java.lang.Object;
import java.util.Map;
import io.fabric8.kubernetes.api.model.version.InfoBuilder;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.model.version.InfoFluentImpl;
import io.fabric8.kubernetes.api.builder.Nested;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class KubeSchemaFluentImpl<A extends KubeSchemaFluent<A>> extends BaseFluent<A> implements KubeSchemaFluent<A>{
  public KubeSchemaFluentImpl() {
  }
  public KubeSchemaFluentImpl(KubeSchema instance) {
    if (instance != null) {
      this.withAPIGroup(instance.getAPIGroup());
      this.withAPIGroupList(instance.getAPIGroupList());
      this.withAPIResource(instance.getAPIResource());
      this.withAPIResourceList(instance.getAPIResourceList());
      this.withAPIService(instance.getAPIService());
      this.withAPIServiceList(instance.getAPIServiceList());
      this.withBinding(instance.getBinding());
      this.withComponentStatus(instance.getComponentStatus());
      this.withComponentStatusList(instance.getComponentStatusList());
      this.withCondition(instance.getCondition());
      this.withConfig(instance.getConfig());
      this.withConfigMap(instance.getConfigMap());
      this.withConfigMapList(instance.getConfigMapList());
      this.withContainerStatus(instance.getContainerStatus());
      this.withCreateOptions(instance.getCreateOptions());
      this.withDeleteOptions(instance.getDeleteOptions());
      this.withEndpointPort(instance.getEndpointPort());
      this.withEndpoints(instance.getEndpoints());
      this.withEndpointsList(instance.getEndpointsList());
      this.withEnvVar(instance.getEnvVar());
      this.withEvent(instance.getEvent());
      this.withEventList(instance.getEventList());
      this.withEventSeries(instance.getEventSeries());
      this.withEventSource(instance.getEventSource());
      this.withGetOptions(instance.getGetOptions());
      this.withGroupKind(instance.getGroupKind());
      this.withGroupVersionKind(instance.getGroupVersionKind());
      this.withGroupVersionResource(instance.getGroupVersionResource());
      this.withInfo(instance.getInfo());
      this.withKubernetesList(instance.getKubernetesList());
      this.withLimitRangeList(instance.getLimitRangeList());
      this.withListOptions(instance.getListOptions());
      this.withMicroTime(instance.getMicroTime());
      this.withNamespace(instance.getNamespace());
      this.withNamespaceList(instance.getNamespaceList());
      this.withNode(instance.getNode());
      this.withNodeList(instance.getNodeList());
      this.withObjectMeta(instance.getObjectMeta());
      this.withPatch(instance.getPatch());
      this.withPatchOptions(instance.getPatchOptions());
      this.withPersistentVolume(instance.getPersistentVolume());
      this.withPersistentVolumeClaim(instance.getPersistentVolumeClaim());
      this.withPersistentVolumeClaimList(instance.getPersistentVolumeClaimList());
      this.withPersistentVolumeList(instance.getPersistentVolumeList());
      this.withPodExecOptions(instance.getPodExecOptions());
      this.withPodList(instance.getPodList());
      this.withPodTemplateList(instance.getPodTemplateList());
      this.withQuantity(instance.getQuantity());
      this.withReplicationControllerList(instance.getReplicationControllerList());
      this.withResourceQuota(instance.getResourceQuota());
      this.withResourceQuotaList(instance.getResourceQuotaList());
      this.withRootPaths(instance.getRootPaths());
      this.withSecret(instance.getSecret());
      this.withSecretList(instance.getSecretList());
      this.withServiceAccount(instance.getServiceAccount());
      this.withServiceAccountList(instance.getServiceAccountList());
      this.withServiceList(instance.getServiceList());
      this.withStatus(instance.getStatus());
      this.withTime(instance.getTime());
      this.withToleration(instance.getToleration());
      this.withTopologySelectorTerm(instance.getTopologySelectorTerm());
      this.withTypeMeta(instance.getTypeMeta());
      this.withUpdateOptions(instance.getUpdateOptions());
      this.withWatchEvent(instance.getWatchEvent());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private APIGroupBuilder aPIGroup;
  private APIGroupListBuilder aPIGroupList;
  private APIResourceBuilder aPIResource;
  private APIResourceListBuilder aPIResourceList;
  private APIServiceBuilder aPIService;
  private APIServiceListBuilder aPIServiceList;
  private BindingBuilder binding;
  private ComponentStatusBuilder componentStatus;
  private ComponentStatusListBuilder componentStatusList;
  private ConditionBuilder condition;
  private ConfigBuilder config;
  private ConfigMapBuilder configMap;
  private ConfigMapListBuilder configMapList;
  private ContainerStatusBuilder containerStatus;
  private CreateOptionsBuilder createOptions;
  private DeleteOptionsBuilder deleteOptions;
  private EndpointPortBuilder endpointPort;
  private EndpointsBuilder endpoints;
  private EndpointsListBuilder endpointsList;
  private EnvVarBuilder envVar;
  private EventBuilder event;
  private EventListBuilder eventList;
  private EventSeriesBuilder eventSeries;
  private EventSourceBuilder eventSource;
  private GetOptionsBuilder getOptions;
  private GroupKindBuilder groupKind;
  private GroupVersionKindBuilder groupVersionKind;
  private GroupVersionResourceBuilder groupVersionResource;
  private InfoBuilder info;
  private KubernetesListBuilder kubernetesList;
  private LimitRangeListBuilder limitRangeList;
  private ListOptionsBuilder listOptions;
  private MicroTimeBuilder microTime;
  private NamespaceBuilder namespace;
  private NamespaceListBuilder namespaceList;
  private NodeBuilder node;
  private NodeListBuilder nodeList;
  private ObjectMetaBuilder objectMeta;
  private PatchBuilder patch;
  private PatchOptionsBuilder patchOptions;
  private PersistentVolumeBuilder persistentVolume;
  private PersistentVolumeClaimBuilder persistentVolumeClaim;
  private PersistentVolumeClaimListBuilder persistentVolumeClaimList;
  private PersistentVolumeListBuilder persistentVolumeList;
  private PodExecOptionsBuilder podExecOptions;
  private PodListBuilder podList;
  private PodTemplateListBuilder podTemplateList;
  private QuantityBuilder quantity;
  private ReplicationControllerListBuilder replicationControllerList;
  private ResourceQuotaBuilder resourceQuota;
  private ResourceQuotaListBuilder resourceQuotaList;
  private RootPathsBuilder rootPaths;
  private SecretBuilder secret;
  private SecretListBuilder secretList;
  private ServiceAccountBuilder serviceAccount;
  private ServiceAccountListBuilder serviceAccountList;
  private ServiceListBuilder serviceList;
  private StatusBuilder status;
  private String time;
  private TolerationBuilder toleration;
  private TopologySelectorTermBuilder topologySelectorTerm;
  private TypeMetaBuilder typeMeta;
  private UpdateOptionsBuilder updateOptions;
  private WatchEventBuilder watchEvent;
  private Map<String,Object> additionalProperties;
  
  /**
   * This method has been deprecated, please use method buildAPIGroup instead.
   * @return The buildable object.
   */
  @Deprecated
  public APIGroup getAPIGroup() {
    return this.aPIGroup!=null ?this.aPIGroup.build():null;
  }
  public APIGroup buildAPIGroup() {
    return this.aPIGroup!=null ?this.aPIGroup.build():null;
  }
  public A withAPIGroup(APIGroup aPIGroup) {
    _visitables.get("aPIGroup").remove(this.aPIGroup);
    if (aPIGroup!=null){ this.aPIGroup= new APIGroupBuilder(aPIGroup); _visitables.get("aPIGroup").add(this.aPIGroup);} else { this.aPIGroup = null; _visitables.get("aPIGroup").remove(this.aPIGroup); } return (A) this;
  }
  public Boolean hasAPIGroup() {
    return this.aPIGroup != null;
  }
  public KubeSchemaFluentImpl.APIGroupNested<A> withNewAPIGroup() {
    return new KubeSchemaFluentImpl.APIGroupNestedImpl();
  }
  public KubeSchemaFluentImpl.APIGroupNested<A> withNewAPIGroupLike(APIGroup item) {
    return new KubeSchemaFluentImpl.APIGroupNestedImpl(item);
  }
  public KubeSchemaFluentImpl.APIGroupNested<A> editAPIGroup() {
    return withNewAPIGroupLike(getAPIGroup());
  }
  public KubeSchemaFluentImpl.APIGroupNested<A> editOrNewAPIGroup() {
    return withNewAPIGroupLike(getAPIGroup() != null ? getAPIGroup(): new APIGroupBuilder().build());
  }
  public KubeSchemaFluentImpl.APIGroupNested<A> editOrNewAPIGroupLike(APIGroup item) {
    return withNewAPIGroupLike(getAPIGroup() != null ? getAPIGroup(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildAPIGroupList instead.
   * @return The buildable object.
   */
  @Deprecated
  public APIGroupList getAPIGroupList() {
    return this.aPIGroupList!=null ?this.aPIGroupList.build():null;
  }
  public APIGroupList buildAPIGroupList() {
    return this.aPIGroupList!=null ?this.aPIGroupList.build():null;
  }
  public A withAPIGroupList(APIGroupList aPIGroupList) {
    _visitables.get("aPIGroupList").remove(this.aPIGroupList);
    if (aPIGroupList!=null){ this.aPIGroupList= new APIGroupListBuilder(aPIGroupList); _visitables.get("aPIGroupList").add(this.aPIGroupList);} else { this.aPIGroupList = null; _visitables.get("aPIGroupList").remove(this.aPIGroupList); } return (A) this;
  }
  public Boolean hasAPIGroupList() {
    return this.aPIGroupList != null;
  }
  public KubeSchemaFluentImpl.APIGroupListNested<A> withNewAPIGroupList() {
    return new KubeSchemaFluentImpl.APIGroupListNestedImpl();
  }
  public KubeSchemaFluentImpl.APIGroupListNested<A> withNewAPIGroupListLike(APIGroupList item) {
    return new KubeSchemaFluentImpl.APIGroupListNestedImpl(item);
  }
  public KubeSchemaFluentImpl.APIGroupListNested<A> editAPIGroupList() {
    return withNewAPIGroupListLike(getAPIGroupList());
  }
  public KubeSchemaFluentImpl.APIGroupListNested<A> editOrNewAPIGroupList() {
    return withNewAPIGroupListLike(getAPIGroupList() != null ? getAPIGroupList(): new APIGroupListBuilder().build());
  }
  public KubeSchemaFluentImpl.APIGroupListNested<A> editOrNewAPIGroupListLike(APIGroupList item) {
    return withNewAPIGroupListLike(getAPIGroupList() != null ? getAPIGroupList(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildAPIResource instead.
   * @return The buildable object.
   */
  @Deprecated
  public APIResource getAPIResource() {
    return this.aPIResource!=null ?this.aPIResource.build():null;
  }
  public APIResource buildAPIResource() {
    return this.aPIResource!=null ?this.aPIResource.build():null;
  }
  public A withAPIResource(APIResource aPIResource) {
    _visitables.get("aPIResource").remove(this.aPIResource);
    if (aPIResource!=null){ this.aPIResource= new APIResourceBuilder(aPIResource); _visitables.get("aPIResource").add(this.aPIResource);} else { this.aPIResource = null; _visitables.get("aPIResource").remove(this.aPIResource); } return (A) this;
  }
  public Boolean hasAPIResource() {
    return this.aPIResource != null;
  }
  public KubeSchemaFluentImpl.APIResourceNested<A> withNewAPIResource() {
    return new KubeSchemaFluentImpl.APIResourceNestedImpl();
  }
  public KubeSchemaFluentImpl.APIResourceNested<A> withNewAPIResourceLike(APIResource item) {
    return new KubeSchemaFluentImpl.APIResourceNestedImpl(item);
  }
  public KubeSchemaFluentImpl.APIResourceNested<A> editAPIResource() {
    return withNewAPIResourceLike(getAPIResource());
  }
  public KubeSchemaFluentImpl.APIResourceNested<A> editOrNewAPIResource() {
    return withNewAPIResourceLike(getAPIResource() != null ? getAPIResource(): new APIResourceBuilder().build());
  }
  public KubeSchemaFluentImpl.APIResourceNested<A> editOrNewAPIResourceLike(APIResource item) {
    return withNewAPIResourceLike(getAPIResource() != null ? getAPIResource(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildAPIResourceList instead.
   * @return The buildable object.
   */
  @Deprecated
  public APIResourceList getAPIResourceList() {
    return this.aPIResourceList!=null ?this.aPIResourceList.build():null;
  }
  public APIResourceList buildAPIResourceList() {
    return this.aPIResourceList!=null ?this.aPIResourceList.build():null;
  }
  public A withAPIResourceList(APIResourceList aPIResourceList) {
    _visitables.get("aPIResourceList").remove(this.aPIResourceList);
    if (aPIResourceList!=null){ this.aPIResourceList= new APIResourceListBuilder(aPIResourceList); _visitables.get("aPIResourceList").add(this.aPIResourceList);} else { this.aPIResourceList = null; _visitables.get("aPIResourceList").remove(this.aPIResourceList); } return (A) this;
  }
  public Boolean hasAPIResourceList() {
    return this.aPIResourceList != null;
  }
  public KubeSchemaFluentImpl.APIResourceListNested<A> withNewAPIResourceList() {
    return new KubeSchemaFluentImpl.APIResourceListNestedImpl();
  }
  public KubeSchemaFluentImpl.APIResourceListNested<A> withNewAPIResourceListLike(APIResourceList item) {
    return new KubeSchemaFluentImpl.APIResourceListNestedImpl(item);
  }
  public KubeSchemaFluentImpl.APIResourceListNested<A> editAPIResourceList() {
    return withNewAPIResourceListLike(getAPIResourceList());
  }
  public KubeSchemaFluentImpl.APIResourceListNested<A> editOrNewAPIResourceList() {
    return withNewAPIResourceListLike(getAPIResourceList() != null ? getAPIResourceList(): new APIResourceListBuilder().build());
  }
  public KubeSchemaFluentImpl.APIResourceListNested<A> editOrNewAPIResourceListLike(APIResourceList item) {
    return withNewAPIResourceListLike(getAPIResourceList() != null ? getAPIResourceList(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildAPIService instead.
   * @return The buildable object.
   */
  @Deprecated
  public APIService getAPIService() {
    return this.aPIService!=null ?this.aPIService.build():null;
  }
  public APIService buildAPIService() {
    return this.aPIService!=null ?this.aPIService.build():null;
  }
  public A withAPIService(APIService aPIService) {
    _visitables.get("aPIService").remove(this.aPIService);
    if (aPIService!=null){ this.aPIService= new APIServiceBuilder(aPIService); _visitables.get("aPIService").add(this.aPIService);} else { this.aPIService = null; _visitables.get("aPIService").remove(this.aPIService); } return (A) this;
  }
  public Boolean hasAPIService() {
    return this.aPIService != null;
  }
  public KubeSchemaFluentImpl.APIServiceNested<A> withNewAPIService() {
    return new KubeSchemaFluentImpl.APIServiceNestedImpl();
  }
  public KubeSchemaFluentImpl.APIServiceNested<A> withNewAPIServiceLike(APIService item) {
    return new KubeSchemaFluentImpl.APIServiceNestedImpl(item);
  }
  public KubeSchemaFluentImpl.APIServiceNested<A> editAPIService() {
    return withNewAPIServiceLike(getAPIService());
  }
  public KubeSchemaFluentImpl.APIServiceNested<A> editOrNewAPIService() {
    return withNewAPIServiceLike(getAPIService() != null ? getAPIService(): new APIServiceBuilder().build());
  }
  public KubeSchemaFluentImpl.APIServiceNested<A> editOrNewAPIServiceLike(APIService item) {
    return withNewAPIServiceLike(getAPIService() != null ? getAPIService(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildAPIServiceList instead.
   * @return The buildable object.
   */
  @Deprecated
  public APIServiceList getAPIServiceList() {
    return this.aPIServiceList!=null ?this.aPIServiceList.build():null;
  }
  public APIServiceList buildAPIServiceList() {
    return this.aPIServiceList!=null ?this.aPIServiceList.build():null;
  }
  public A withAPIServiceList(APIServiceList aPIServiceList) {
    _visitables.get("aPIServiceList").remove(this.aPIServiceList);
    if (aPIServiceList!=null){ this.aPIServiceList= new APIServiceListBuilder(aPIServiceList); _visitables.get("aPIServiceList").add(this.aPIServiceList);} else { this.aPIServiceList = null; _visitables.get("aPIServiceList").remove(this.aPIServiceList); } return (A) this;
  }
  public Boolean hasAPIServiceList() {
    return this.aPIServiceList != null;
  }
  public KubeSchemaFluentImpl.APIServiceListNested<A> withNewAPIServiceList() {
    return new KubeSchemaFluentImpl.APIServiceListNestedImpl();
  }
  public KubeSchemaFluentImpl.APIServiceListNested<A> withNewAPIServiceListLike(APIServiceList item) {
    return new KubeSchemaFluentImpl.APIServiceListNestedImpl(item);
  }
  public KubeSchemaFluentImpl.APIServiceListNested<A> editAPIServiceList() {
    return withNewAPIServiceListLike(getAPIServiceList());
  }
  public KubeSchemaFluentImpl.APIServiceListNested<A> editOrNewAPIServiceList() {
    return withNewAPIServiceListLike(getAPIServiceList() != null ? getAPIServiceList(): new APIServiceListBuilder().build());
  }
  public KubeSchemaFluentImpl.APIServiceListNested<A> editOrNewAPIServiceListLike(APIServiceList item) {
    return withNewAPIServiceListLike(getAPIServiceList() != null ? getAPIServiceList(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildBinding instead.
   * @return The buildable object.
   */
  @Deprecated
  public Binding getBinding() {
    return this.binding!=null ?this.binding.build():null;
  }
  public Binding buildBinding() {
    return this.binding!=null ?this.binding.build():null;
  }
  public A withBinding(Binding binding) {
    _visitables.get("binding").remove(this.binding);
    if (binding!=null){ this.binding= new BindingBuilder(binding); _visitables.get("binding").add(this.binding);} else { this.binding = null; _visitables.get("binding").remove(this.binding); } return (A) this;
  }
  public Boolean hasBinding() {
    return this.binding != null;
  }
  public KubeSchemaFluentImpl.BindingNested<A> withNewBinding() {
    return new KubeSchemaFluentImpl.BindingNestedImpl();
  }
  public KubeSchemaFluentImpl.BindingNested<A> withNewBindingLike(Binding item) {
    return new KubeSchemaFluentImpl.BindingNestedImpl(item);
  }
  public KubeSchemaFluentImpl.BindingNested<A> editBinding() {
    return withNewBindingLike(getBinding());
  }
  public KubeSchemaFluentImpl.BindingNested<A> editOrNewBinding() {
    return withNewBindingLike(getBinding() != null ? getBinding(): new BindingBuilder().build());
  }
  public KubeSchemaFluentImpl.BindingNested<A> editOrNewBindingLike(Binding item) {
    return withNewBindingLike(getBinding() != null ? getBinding(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildComponentStatus instead.
   * @return The buildable object.
   */
  @Deprecated
  public ComponentStatus getComponentStatus() {
    return this.componentStatus!=null ?this.componentStatus.build():null;
  }
  public ComponentStatus buildComponentStatus() {
    return this.componentStatus!=null ?this.componentStatus.build():null;
  }
  public A withComponentStatus(ComponentStatus componentStatus) {
    _visitables.get("componentStatus").remove(this.componentStatus);
    if (componentStatus!=null){ this.componentStatus= new ComponentStatusBuilder(componentStatus); _visitables.get("componentStatus").add(this.componentStatus);} else { this.componentStatus = null; _visitables.get("componentStatus").remove(this.componentStatus); } return (A) this;
  }
  public Boolean hasComponentStatus() {
    return this.componentStatus != null;
  }
  public KubeSchemaFluentImpl.ComponentStatusNested<A> withNewComponentStatus() {
    return new KubeSchemaFluentImpl.ComponentStatusNestedImpl();
  }
  public KubeSchemaFluentImpl.ComponentStatusNested<A> withNewComponentStatusLike(ComponentStatus item) {
    return new KubeSchemaFluentImpl.ComponentStatusNestedImpl(item);
  }
  public KubeSchemaFluentImpl.ComponentStatusNested<A> editComponentStatus() {
    return withNewComponentStatusLike(getComponentStatus());
  }
  public KubeSchemaFluentImpl.ComponentStatusNested<A> editOrNewComponentStatus() {
    return withNewComponentStatusLike(getComponentStatus() != null ? getComponentStatus(): new ComponentStatusBuilder().build());
  }
  public KubeSchemaFluentImpl.ComponentStatusNested<A> editOrNewComponentStatusLike(ComponentStatus item) {
    return withNewComponentStatusLike(getComponentStatus() != null ? getComponentStatus(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildComponentStatusList instead.
   * @return The buildable object.
   */
  @Deprecated
  public ComponentStatusList getComponentStatusList() {
    return this.componentStatusList!=null ?this.componentStatusList.build():null;
  }
  public ComponentStatusList buildComponentStatusList() {
    return this.componentStatusList!=null ?this.componentStatusList.build():null;
  }
  public A withComponentStatusList(ComponentStatusList componentStatusList) {
    _visitables.get("componentStatusList").remove(this.componentStatusList);
    if (componentStatusList!=null){ this.componentStatusList= new ComponentStatusListBuilder(componentStatusList); _visitables.get("componentStatusList").add(this.componentStatusList);} else { this.componentStatusList = null; _visitables.get("componentStatusList").remove(this.componentStatusList); } return (A) this;
  }
  public Boolean hasComponentStatusList() {
    return this.componentStatusList != null;
  }
  public KubeSchemaFluentImpl.ComponentStatusListNested<A> withNewComponentStatusList() {
    return new KubeSchemaFluentImpl.ComponentStatusListNestedImpl();
  }
  public KubeSchemaFluentImpl.ComponentStatusListNested<A> withNewComponentStatusListLike(ComponentStatusList item) {
    return new KubeSchemaFluentImpl.ComponentStatusListNestedImpl(item);
  }
  public KubeSchemaFluentImpl.ComponentStatusListNested<A> editComponentStatusList() {
    return withNewComponentStatusListLike(getComponentStatusList());
  }
  public KubeSchemaFluentImpl.ComponentStatusListNested<A> editOrNewComponentStatusList() {
    return withNewComponentStatusListLike(getComponentStatusList() != null ? getComponentStatusList(): new ComponentStatusListBuilder().build());
  }
  public KubeSchemaFluentImpl.ComponentStatusListNested<A> editOrNewComponentStatusListLike(ComponentStatusList item) {
    return withNewComponentStatusListLike(getComponentStatusList() != null ? getComponentStatusList(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildCondition instead.
   * @return The buildable object.
   */
  @Deprecated
  public Condition getCondition() {
    return this.condition!=null ?this.condition.build():null;
  }
  public Condition buildCondition() {
    return this.condition!=null ?this.condition.build():null;
  }
  public A withCondition(Condition condition) {
    _visitables.get("condition").remove(this.condition);
    if (condition!=null){ this.condition= new ConditionBuilder(condition); _visitables.get("condition").add(this.condition);} else { this.condition = null; _visitables.get("condition").remove(this.condition); } return (A) this;
  }
  public Boolean hasCondition() {
    return this.condition != null;
  }
  public KubeSchemaFluentImpl.ConditionNested<A> withNewCondition() {
    return new KubeSchemaFluentImpl.ConditionNestedImpl();
  }
  public KubeSchemaFluentImpl.ConditionNested<A> withNewConditionLike(Condition item) {
    return new KubeSchemaFluentImpl.ConditionNestedImpl(item);
  }
  public KubeSchemaFluentImpl.ConditionNested<A> editCondition() {
    return withNewConditionLike(getCondition());
  }
  public KubeSchemaFluentImpl.ConditionNested<A> editOrNewCondition() {
    return withNewConditionLike(getCondition() != null ? getCondition(): new ConditionBuilder().build());
  }
  public KubeSchemaFluentImpl.ConditionNested<A> editOrNewConditionLike(Condition item) {
    return withNewConditionLike(getCondition() != null ? getCondition(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildConfig instead.
   * @return The buildable object.
   */
  @Deprecated
  public Config getConfig() {
    return this.config!=null ?this.config.build():null;
  }
  public Config buildConfig() {
    return this.config!=null ?this.config.build():null;
  }
  public A withConfig(Config config) {
    _visitables.get("config").remove(this.config);
    if (config!=null){ this.config= new ConfigBuilder(config); _visitables.get("config").add(this.config);} else { this.config = null; _visitables.get("config").remove(this.config); } return (A) this;
  }
  public Boolean hasConfig() {
    return this.config != null;
  }
  public KubeSchemaFluentImpl.ConfigNested<A> withNewConfig() {
    return new KubeSchemaFluentImpl.ConfigNestedImpl();
  }
  public KubeSchemaFluentImpl.ConfigNested<A> withNewConfigLike(Config item) {
    return new KubeSchemaFluentImpl.ConfigNestedImpl(item);
  }
  public KubeSchemaFluentImpl.ConfigNested<A> editConfig() {
    return withNewConfigLike(getConfig());
  }
  public KubeSchemaFluentImpl.ConfigNested<A> editOrNewConfig() {
    return withNewConfigLike(getConfig() != null ? getConfig(): new ConfigBuilder().build());
  }
  public KubeSchemaFluentImpl.ConfigNested<A> editOrNewConfigLike(Config item) {
    return withNewConfigLike(getConfig() != null ? getConfig(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildConfigMap instead.
   * @return The buildable object.
   */
  @Deprecated
  public ConfigMap getConfigMap() {
    return this.configMap!=null ?this.configMap.build():null;
  }
  public ConfigMap buildConfigMap() {
    return this.configMap!=null ?this.configMap.build():null;
  }
  public A withConfigMap(ConfigMap configMap) {
    _visitables.get("configMap").remove(this.configMap);
    if (configMap!=null){ this.configMap= new ConfigMapBuilder(configMap); _visitables.get("configMap").add(this.configMap);} else { this.configMap = null; _visitables.get("configMap").remove(this.configMap); } return (A) this;
  }
  public Boolean hasConfigMap() {
    return this.configMap != null;
  }
  public KubeSchemaFluentImpl.ConfigMapNested<A> withNewConfigMap() {
    return new KubeSchemaFluentImpl.ConfigMapNestedImpl();
  }
  public KubeSchemaFluentImpl.ConfigMapNested<A> withNewConfigMapLike(ConfigMap item) {
    return new KubeSchemaFluentImpl.ConfigMapNestedImpl(item);
  }
  public KubeSchemaFluentImpl.ConfigMapNested<A> editConfigMap() {
    return withNewConfigMapLike(getConfigMap());
  }
  public KubeSchemaFluentImpl.ConfigMapNested<A> editOrNewConfigMap() {
    return withNewConfigMapLike(getConfigMap() != null ? getConfigMap(): new ConfigMapBuilder().build());
  }
  public KubeSchemaFluentImpl.ConfigMapNested<A> editOrNewConfigMapLike(ConfigMap item) {
    return withNewConfigMapLike(getConfigMap() != null ? getConfigMap(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildConfigMapList instead.
   * @return The buildable object.
   */
  @Deprecated
  public ConfigMapList getConfigMapList() {
    return this.configMapList!=null ?this.configMapList.build():null;
  }
  public ConfigMapList buildConfigMapList() {
    return this.configMapList!=null ?this.configMapList.build():null;
  }
  public A withConfigMapList(ConfigMapList configMapList) {
    _visitables.get("configMapList").remove(this.configMapList);
    if (configMapList!=null){ this.configMapList= new ConfigMapListBuilder(configMapList); _visitables.get("configMapList").add(this.configMapList);} else { this.configMapList = null; _visitables.get("configMapList").remove(this.configMapList); } return (A) this;
  }
  public Boolean hasConfigMapList() {
    return this.configMapList != null;
  }
  public KubeSchemaFluentImpl.ConfigMapListNested<A> withNewConfigMapList() {
    return new KubeSchemaFluentImpl.ConfigMapListNestedImpl();
  }
  public KubeSchemaFluentImpl.ConfigMapListNested<A> withNewConfigMapListLike(ConfigMapList item) {
    return new KubeSchemaFluentImpl.ConfigMapListNestedImpl(item);
  }
  public KubeSchemaFluentImpl.ConfigMapListNested<A> editConfigMapList() {
    return withNewConfigMapListLike(getConfigMapList());
  }
  public KubeSchemaFluentImpl.ConfigMapListNested<A> editOrNewConfigMapList() {
    return withNewConfigMapListLike(getConfigMapList() != null ? getConfigMapList(): new ConfigMapListBuilder().build());
  }
  public KubeSchemaFluentImpl.ConfigMapListNested<A> editOrNewConfigMapListLike(ConfigMapList item) {
    return withNewConfigMapListLike(getConfigMapList() != null ? getConfigMapList(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildContainerStatus instead.
   * @return The buildable object.
   */
  @Deprecated
  public ContainerStatus getContainerStatus() {
    return this.containerStatus!=null ?this.containerStatus.build():null;
  }
  public ContainerStatus buildContainerStatus() {
    return this.containerStatus!=null ?this.containerStatus.build():null;
  }
  public A withContainerStatus(ContainerStatus containerStatus) {
    _visitables.get("containerStatus").remove(this.containerStatus);
    if (containerStatus!=null){ this.containerStatus= new ContainerStatusBuilder(containerStatus); _visitables.get("containerStatus").add(this.containerStatus);} else { this.containerStatus = null; _visitables.get("containerStatus").remove(this.containerStatus); } return (A) this;
  }
  public Boolean hasContainerStatus() {
    return this.containerStatus != null;
  }
  public KubeSchemaFluentImpl.ContainerStatusNested<A> withNewContainerStatus() {
    return new KubeSchemaFluentImpl.ContainerStatusNestedImpl();
  }
  public KubeSchemaFluentImpl.ContainerStatusNested<A> withNewContainerStatusLike(ContainerStatus item) {
    return new KubeSchemaFluentImpl.ContainerStatusNestedImpl(item);
  }
  public KubeSchemaFluentImpl.ContainerStatusNested<A> editContainerStatus() {
    return withNewContainerStatusLike(getContainerStatus());
  }
  public KubeSchemaFluentImpl.ContainerStatusNested<A> editOrNewContainerStatus() {
    return withNewContainerStatusLike(getContainerStatus() != null ? getContainerStatus(): new ContainerStatusBuilder().build());
  }
  public KubeSchemaFluentImpl.ContainerStatusNested<A> editOrNewContainerStatusLike(ContainerStatus item) {
    return withNewContainerStatusLike(getContainerStatus() != null ? getContainerStatus(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildCreateOptions instead.
   * @return The buildable object.
   */
  @Deprecated
  public CreateOptions getCreateOptions() {
    return this.createOptions!=null ?this.createOptions.build():null;
  }
  public CreateOptions buildCreateOptions() {
    return this.createOptions!=null ?this.createOptions.build():null;
  }
  public A withCreateOptions(CreateOptions createOptions) {
    _visitables.get("createOptions").remove(this.createOptions);
    if (createOptions!=null){ this.createOptions= new CreateOptionsBuilder(createOptions); _visitables.get("createOptions").add(this.createOptions);} else { this.createOptions = null; _visitables.get("createOptions").remove(this.createOptions); } return (A) this;
  }
  public Boolean hasCreateOptions() {
    return this.createOptions != null;
  }
  public KubeSchemaFluentImpl.CreateOptionsNested<A> withNewCreateOptions() {
    return new KubeSchemaFluentImpl.CreateOptionsNestedImpl();
  }
  public KubeSchemaFluentImpl.CreateOptionsNested<A> withNewCreateOptionsLike(CreateOptions item) {
    return new KubeSchemaFluentImpl.CreateOptionsNestedImpl(item);
  }
  public KubeSchemaFluentImpl.CreateOptionsNested<A> editCreateOptions() {
    return withNewCreateOptionsLike(getCreateOptions());
  }
  public KubeSchemaFluentImpl.CreateOptionsNested<A> editOrNewCreateOptions() {
    return withNewCreateOptionsLike(getCreateOptions() != null ? getCreateOptions(): new CreateOptionsBuilder().build());
  }
  public KubeSchemaFluentImpl.CreateOptionsNested<A> editOrNewCreateOptionsLike(CreateOptions item) {
    return withNewCreateOptionsLike(getCreateOptions() != null ? getCreateOptions(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildDeleteOptions instead.
   * @return The buildable object.
   */
  @Deprecated
  public DeleteOptions getDeleteOptions() {
    return this.deleteOptions!=null ?this.deleteOptions.build():null;
  }
  public DeleteOptions buildDeleteOptions() {
    return this.deleteOptions!=null ?this.deleteOptions.build():null;
  }
  public A withDeleteOptions(DeleteOptions deleteOptions) {
    _visitables.get("deleteOptions").remove(this.deleteOptions);
    if (deleteOptions!=null){ this.deleteOptions= new DeleteOptionsBuilder(deleteOptions); _visitables.get("deleteOptions").add(this.deleteOptions);} else { this.deleteOptions = null; _visitables.get("deleteOptions").remove(this.deleteOptions); } return (A) this;
  }
  public Boolean hasDeleteOptions() {
    return this.deleteOptions != null;
  }
  public KubeSchemaFluentImpl.DeleteOptionsNested<A> withNewDeleteOptions() {
    return new KubeSchemaFluentImpl.DeleteOptionsNestedImpl();
  }
  public KubeSchemaFluentImpl.DeleteOptionsNested<A> withNewDeleteOptionsLike(DeleteOptions item) {
    return new KubeSchemaFluentImpl.DeleteOptionsNestedImpl(item);
  }
  public KubeSchemaFluentImpl.DeleteOptionsNested<A> editDeleteOptions() {
    return withNewDeleteOptionsLike(getDeleteOptions());
  }
  public KubeSchemaFluentImpl.DeleteOptionsNested<A> editOrNewDeleteOptions() {
    return withNewDeleteOptionsLike(getDeleteOptions() != null ? getDeleteOptions(): new DeleteOptionsBuilder().build());
  }
  public KubeSchemaFluentImpl.DeleteOptionsNested<A> editOrNewDeleteOptionsLike(DeleteOptions item) {
    return withNewDeleteOptionsLike(getDeleteOptions() != null ? getDeleteOptions(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildEndpointPort instead.
   * @return The buildable object.
   */
  @Deprecated
  public EndpointPort getEndpointPort() {
    return this.endpointPort!=null ?this.endpointPort.build():null;
  }
  public EndpointPort buildEndpointPort() {
    return this.endpointPort!=null ?this.endpointPort.build():null;
  }
  public A withEndpointPort(EndpointPort endpointPort) {
    _visitables.get("endpointPort").remove(this.endpointPort);
    if (endpointPort!=null){ this.endpointPort= new EndpointPortBuilder(endpointPort); _visitables.get("endpointPort").add(this.endpointPort);} else { this.endpointPort = null; _visitables.get("endpointPort").remove(this.endpointPort); } return (A) this;
  }
  public Boolean hasEndpointPort() {
    return this.endpointPort != null;
  }
  public A withNewEndpointPort(String appProtocol,String name,Integer port,String protocol) {
    return (A)withEndpointPort(new EndpointPort(appProtocol, name, port, protocol));
  }
  public KubeSchemaFluentImpl.EndpointPortNested<A> withNewEndpointPort() {
    return new KubeSchemaFluentImpl.EndpointPortNestedImpl();
  }
  public KubeSchemaFluentImpl.EndpointPortNested<A> withNewEndpointPortLike(EndpointPort item) {
    return new KubeSchemaFluentImpl.EndpointPortNestedImpl(item);
  }
  public KubeSchemaFluentImpl.EndpointPortNested<A> editEndpointPort() {
    return withNewEndpointPortLike(getEndpointPort());
  }
  public KubeSchemaFluentImpl.EndpointPortNested<A> editOrNewEndpointPort() {
    return withNewEndpointPortLike(getEndpointPort() != null ? getEndpointPort(): new EndpointPortBuilder().build());
  }
  public KubeSchemaFluentImpl.EndpointPortNested<A> editOrNewEndpointPortLike(EndpointPort item) {
    return withNewEndpointPortLike(getEndpointPort() != null ? getEndpointPort(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildEndpoints instead.
   * @return The buildable object.
   */
  @Deprecated
  public Endpoints getEndpoints() {
    return this.endpoints!=null ?this.endpoints.build():null;
  }
  public Endpoints buildEndpoints() {
    return this.endpoints!=null ?this.endpoints.build():null;
  }
  public A withEndpoints(Endpoints endpoints) {
    _visitables.get("endpoints").remove(this.endpoints);
    if (endpoints!=null){ this.endpoints= new EndpointsBuilder(endpoints); _visitables.get("endpoints").add(this.endpoints);} else { this.endpoints = null; _visitables.get("endpoints").remove(this.endpoints); } return (A) this;
  }
  public Boolean hasEndpoints() {
    return this.endpoints != null;
  }
  public KubeSchemaFluentImpl.EndpointsNested<A> withNewEndpoints() {
    return new KubeSchemaFluentImpl.EndpointsNestedImpl();
  }
  public KubeSchemaFluentImpl.EndpointsNested<A> withNewEndpointsLike(Endpoints item) {
    return new KubeSchemaFluentImpl.EndpointsNestedImpl(item);
  }
  public KubeSchemaFluentImpl.EndpointsNested<A> editEndpoints() {
    return withNewEndpointsLike(getEndpoints());
  }
  public KubeSchemaFluentImpl.EndpointsNested<A> editOrNewEndpoints() {
    return withNewEndpointsLike(getEndpoints() != null ? getEndpoints(): new EndpointsBuilder().build());
  }
  public KubeSchemaFluentImpl.EndpointsNested<A> editOrNewEndpointsLike(Endpoints item) {
    return withNewEndpointsLike(getEndpoints() != null ? getEndpoints(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildEndpointsList instead.
   * @return The buildable object.
   */
  @Deprecated
  public EndpointsList getEndpointsList() {
    return this.endpointsList!=null ?this.endpointsList.build():null;
  }
  public EndpointsList buildEndpointsList() {
    return this.endpointsList!=null ?this.endpointsList.build():null;
  }
  public A withEndpointsList(EndpointsList endpointsList) {
    _visitables.get("endpointsList").remove(this.endpointsList);
    if (endpointsList!=null){ this.endpointsList= new EndpointsListBuilder(endpointsList); _visitables.get("endpointsList").add(this.endpointsList);} else { this.endpointsList = null; _visitables.get("endpointsList").remove(this.endpointsList); } return (A) this;
  }
  public Boolean hasEndpointsList() {
    return this.endpointsList != null;
  }
  public KubeSchemaFluentImpl.EndpointsListNested<A> withNewEndpointsList() {
    return new KubeSchemaFluentImpl.EndpointsListNestedImpl();
  }
  public KubeSchemaFluentImpl.EndpointsListNested<A> withNewEndpointsListLike(EndpointsList item) {
    return new KubeSchemaFluentImpl.EndpointsListNestedImpl(item);
  }
  public KubeSchemaFluentImpl.EndpointsListNested<A> editEndpointsList() {
    return withNewEndpointsListLike(getEndpointsList());
  }
  public KubeSchemaFluentImpl.EndpointsListNested<A> editOrNewEndpointsList() {
    return withNewEndpointsListLike(getEndpointsList() != null ? getEndpointsList(): new EndpointsListBuilder().build());
  }
  public KubeSchemaFluentImpl.EndpointsListNested<A> editOrNewEndpointsListLike(EndpointsList item) {
    return withNewEndpointsListLike(getEndpointsList() != null ? getEndpointsList(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildEnvVar instead.
   * @return The buildable object.
   */
  @Deprecated
  public EnvVar getEnvVar() {
    return this.envVar!=null ?this.envVar.build():null;
  }
  public EnvVar buildEnvVar() {
    return this.envVar!=null ?this.envVar.build():null;
  }
  public A withEnvVar(EnvVar envVar) {
    _visitables.get("envVar").remove(this.envVar);
    if (envVar!=null){ this.envVar= new EnvVarBuilder(envVar); _visitables.get("envVar").add(this.envVar);} else { this.envVar = null; _visitables.get("envVar").remove(this.envVar); } return (A) this;
  }
  public Boolean hasEnvVar() {
    return this.envVar != null;
  }
  public KubeSchemaFluentImpl.EnvVarNested<A> withNewEnvVar() {
    return new KubeSchemaFluentImpl.EnvVarNestedImpl();
  }
  public KubeSchemaFluentImpl.EnvVarNested<A> withNewEnvVarLike(EnvVar item) {
    return new KubeSchemaFluentImpl.EnvVarNestedImpl(item);
  }
  public KubeSchemaFluentImpl.EnvVarNested<A> editEnvVar() {
    return withNewEnvVarLike(getEnvVar());
  }
  public KubeSchemaFluentImpl.EnvVarNested<A> editOrNewEnvVar() {
    return withNewEnvVarLike(getEnvVar() != null ? getEnvVar(): new EnvVarBuilder().build());
  }
  public KubeSchemaFluentImpl.EnvVarNested<A> editOrNewEnvVarLike(EnvVar item) {
    return withNewEnvVarLike(getEnvVar() != null ? getEnvVar(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildEvent instead.
   * @return The buildable object.
   */
  @Deprecated
  public Event getEvent() {
    return this.event!=null ?this.event.build():null;
  }
  public Event buildEvent() {
    return this.event!=null ?this.event.build():null;
  }
  public A withEvent(Event event) {
    _visitables.get("event").remove(this.event);
    if (event!=null){ this.event= new EventBuilder(event); _visitables.get("event").add(this.event);} else { this.event = null; _visitables.get("event").remove(this.event); } return (A) this;
  }
  public Boolean hasEvent() {
    return this.event != null;
  }
  public KubeSchemaFluentImpl.EventNested<A> withNewEvent() {
    return new KubeSchemaFluentImpl.EventNestedImpl();
  }
  public KubeSchemaFluentImpl.EventNested<A> withNewEventLike(Event item) {
    return new KubeSchemaFluentImpl.EventNestedImpl(item);
  }
  public KubeSchemaFluentImpl.EventNested<A> editEvent() {
    return withNewEventLike(getEvent());
  }
  public KubeSchemaFluentImpl.EventNested<A> editOrNewEvent() {
    return withNewEventLike(getEvent() != null ? getEvent(): new EventBuilder().build());
  }
  public KubeSchemaFluentImpl.EventNested<A> editOrNewEventLike(Event item) {
    return withNewEventLike(getEvent() != null ? getEvent(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildEventList instead.
   * @return The buildable object.
   */
  @Deprecated
  public EventList getEventList() {
    return this.eventList!=null ?this.eventList.build():null;
  }
  public EventList buildEventList() {
    return this.eventList!=null ?this.eventList.build():null;
  }
  public A withEventList(EventList eventList) {
    _visitables.get("eventList").remove(this.eventList);
    if (eventList!=null){ this.eventList= new EventListBuilder(eventList); _visitables.get("eventList").add(this.eventList);} else { this.eventList = null; _visitables.get("eventList").remove(this.eventList); } return (A) this;
  }
  public Boolean hasEventList() {
    return this.eventList != null;
  }
  public KubeSchemaFluentImpl.EventListNested<A> withNewEventList() {
    return new KubeSchemaFluentImpl.EventListNestedImpl();
  }
  public KubeSchemaFluentImpl.EventListNested<A> withNewEventListLike(EventList item) {
    return new KubeSchemaFluentImpl.EventListNestedImpl(item);
  }
  public KubeSchemaFluentImpl.EventListNested<A> editEventList() {
    return withNewEventListLike(getEventList());
  }
  public KubeSchemaFluentImpl.EventListNested<A> editOrNewEventList() {
    return withNewEventListLike(getEventList() != null ? getEventList(): new EventListBuilder().build());
  }
  public KubeSchemaFluentImpl.EventListNested<A> editOrNewEventListLike(EventList item) {
    return withNewEventListLike(getEventList() != null ? getEventList(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildEventSeries instead.
   * @return The buildable object.
   */
  @Deprecated
  public EventSeries getEventSeries() {
    return this.eventSeries!=null ?this.eventSeries.build():null;
  }
  public EventSeries buildEventSeries() {
    return this.eventSeries!=null ?this.eventSeries.build():null;
  }
  public A withEventSeries(EventSeries eventSeries) {
    _visitables.get("eventSeries").remove(this.eventSeries);
    if (eventSeries!=null){ this.eventSeries= new EventSeriesBuilder(eventSeries); _visitables.get("eventSeries").add(this.eventSeries);} else { this.eventSeries = null; _visitables.get("eventSeries").remove(this.eventSeries); } return (A) this;
  }
  public Boolean hasEventSeries() {
    return this.eventSeries != null;
  }
  public KubeSchemaFluentImpl.EventSeriesNested<A> withNewEventSeries() {
    return new KubeSchemaFluentImpl.EventSeriesNestedImpl();
  }
  public KubeSchemaFluentImpl.EventSeriesNested<A> withNewEventSeriesLike(EventSeries item) {
    return new KubeSchemaFluentImpl.EventSeriesNestedImpl(item);
  }
  public KubeSchemaFluentImpl.EventSeriesNested<A> editEventSeries() {
    return withNewEventSeriesLike(getEventSeries());
  }
  public KubeSchemaFluentImpl.EventSeriesNested<A> editOrNewEventSeries() {
    return withNewEventSeriesLike(getEventSeries() != null ? getEventSeries(): new EventSeriesBuilder().build());
  }
  public KubeSchemaFluentImpl.EventSeriesNested<A> editOrNewEventSeriesLike(EventSeries item) {
    return withNewEventSeriesLike(getEventSeries() != null ? getEventSeries(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildEventSource instead.
   * @return The buildable object.
   */
  @Deprecated
  public EventSource getEventSource() {
    return this.eventSource!=null ?this.eventSource.build():null;
  }
  public EventSource buildEventSource() {
    return this.eventSource!=null ?this.eventSource.build():null;
  }
  public A withEventSource(EventSource eventSource) {
    _visitables.get("eventSource").remove(this.eventSource);
    if (eventSource!=null){ this.eventSource= new EventSourceBuilder(eventSource); _visitables.get("eventSource").add(this.eventSource);} else { this.eventSource = null; _visitables.get("eventSource").remove(this.eventSource); } return (A) this;
  }
  public Boolean hasEventSource() {
    return this.eventSource != null;
  }
  public A withNewEventSource(String component,String host) {
    return (A)withEventSource(new EventSource(component, host));
  }
  public KubeSchemaFluentImpl.EventSourceNested<A> withNewEventSource() {
    return new KubeSchemaFluentImpl.EventSourceNestedImpl();
  }
  public KubeSchemaFluentImpl.EventSourceNested<A> withNewEventSourceLike(EventSource item) {
    return new KubeSchemaFluentImpl.EventSourceNestedImpl(item);
  }
  public KubeSchemaFluentImpl.EventSourceNested<A> editEventSource() {
    return withNewEventSourceLike(getEventSource());
  }
  public KubeSchemaFluentImpl.EventSourceNested<A> editOrNewEventSource() {
    return withNewEventSourceLike(getEventSource() != null ? getEventSource(): new EventSourceBuilder().build());
  }
  public KubeSchemaFluentImpl.EventSourceNested<A> editOrNewEventSourceLike(EventSource item) {
    return withNewEventSourceLike(getEventSource() != null ? getEventSource(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildGetOptions instead.
   * @return The buildable object.
   */
  @Deprecated
  public GetOptions getGetOptions() {
    return this.getOptions!=null ?this.getOptions.build():null;
  }
  public GetOptions buildGetOptions() {
    return this.getOptions!=null ?this.getOptions.build():null;
  }
  public A withGetOptions(GetOptions getOptions) {
    _visitables.get("getOptions").remove(this.getOptions);
    if (getOptions!=null){ this.getOptions= new GetOptionsBuilder(getOptions); _visitables.get("getOptions").add(this.getOptions);} else { this.getOptions = null; _visitables.get("getOptions").remove(this.getOptions); } return (A) this;
  }
  public Boolean hasGetOptions() {
    return this.getOptions != null;
  }
  public A withNewGetOptions(String apiVersion,String kind,String resourceVersion) {
    return (A)withGetOptions(new GetOptions(apiVersion, kind, resourceVersion));
  }
  public KubeSchemaFluentImpl.GetOptionsNested<A> withNewGetOptions() {
    return new KubeSchemaFluentImpl.GetOptionsNestedImpl();
  }
  public KubeSchemaFluentImpl.GetOptionsNested<A> withNewGetOptionsLike(GetOptions item) {
    return new KubeSchemaFluentImpl.GetOptionsNestedImpl(item);
  }
  public KubeSchemaFluentImpl.GetOptionsNested<A> editGetOptions() {
    return withNewGetOptionsLike(getGetOptions());
  }
  public KubeSchemaFluentImpl.GetOptionsNested<A> editOrNewGetOptions() {
    return withNewGetOptionsLike(getGetOptions() != null ? getGetOptions(): new GetOptionsBuilder().build());
  }
  public KubeSchemaFluentImpl.GetOptionsNested<A> editOrNewGetOptionsLike(GetOptions item) {
    return withNewGetOptionsLike(getGetOptions() != null ? getGetOptions(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildGroupKind instead.
   * @return The buildable object.
   */
  @Deprecated
  public GroupKind getGroupKind() {
    return this.groupKind!=null ?this.groupKind.build():null;
  }
  public GroupKind buildGroupKind() {
    return this.groupKind!=null ?this.groupKind.build():null;
  }
  public A withGroupKind(GroupKind groupKind) {
    _visitables.get("groupKind").remove(this.groupKind);
    if (groupKind!=null){ this.groupKind= new GroupKindBuilder(groupKind); _visitables.get("groupKind").add(this.groupKind);} else { this.groupKind = null; _visitables.get("groupKind").remove(this.groupKind); } return (A) this;
  }
  public Boolean hasGroupKind() {
    return this.groupKind != null;
  }
  public A withNewGroupKind(String group,String kind) {
    return (A)withGroupKind(new GroupKind(group, kind));
  }
  public KubeSchemaFluentImpl.GroupKindNested<A> withNewGroupKind() {
    return new KubeSchemaFluentImpl.GroupKindNestedImpl();
  }
  public KubeSchemaFluentImpl.GroupKindNested<A> withNewGroupKindLike(GroupKind item) {
    return new KubeSchemaFluentImpl.GroupKindNestedImpl(item);
  }
  public KubeSchemaFluentImpl.GroupKindNested<A> editGroupKind() {
    return withNewGroupKindLike(getGroupKind());
  }
  public KubeSchemaFluentImpl.GroupKindNested<A> editOrNewGroupKind() {
    return withNewGroupKindLike(getGroupKind() != null ? getGroupKind(): new GroupKindBuilder().build());
  }
  public KubeSchemaFluentImpl.GroupKindNested<A> editOrNewGroupKindLike(GroupKind item) {
    return withNewGroupKindLike(getGroupKind() != null ? getGroupKind(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildGroupVersionKind instead.
   * @return The buildable object.
   */
  @Deprecated
  public GroupVersionKind getGroupVersionKind() {
    return this.groupVersionKind!=null ?this.groupVersionKind.build():null;
  }
  public GroupVersionKind buildGroupVersionKind() {
    return this.groupVersionKind!=null ?this.groupVersionKind.build():null;
  }
  public A withGroupVersionKind(GroupVersionKind groupVersionKind) {
    _visitables.get("groupVersionKind").remove(this.groupVersionKind);
    if (groupVersionKind!=null){ this.groupVersionKind= new GroupVersionKindBuilder(groupVersionKind); _visitables.get("groupVersionKind").add(this.groupVersionKind);} else { this.groupVersionKind = null; _visitables.get("groupVersionKind").remove(this.groupVersionKind); } return (A) this;
  }
  public Boolean hasGroupVersionKind() {
    return this.groupVersionKind != null;
  }
  public A withNewGroupVersionKind(String group,String kind,String version) {
    return (A)withGroupVersionKind(new GroupVersionKind(group, kind, version));
  }
  public KubeSchemaFluentImpl.GroupVersionKindNested<A> withNewGroupVersionKind() {
    return new KubeSchemaFluentImpl.GroupVersionKindNestedImpl();
  }
  public KubeSchemaFluentImpl.GroupVersionKindNested<A> withNewGroupVersionKindLike(GroupVersionKind item) {
    return new KubeSchemaFluentImpl.GroupVersionKindNestedImpl(item);
  }
  public KubeSchemaFluentImpl.GroupVersionKindNested<A> editGroupVersionKind() {
    return withNewGroupVersionKindLike(getGroupVersionKind());
  }
  public KubeSchemaFluentImpl.GroupVersionKindNested<A> editOrNewGroupVersionKind() {
    return withNewGroupVersionKindLike(getGroupVersionKind() != null ? getGroupVersionKind(): new GroupVersionKindBuilder().build());
  }
  public KubeSchemaFluentImpl.GroupVersionKindNested<A> editOrNewGroupVersionKindLike(GroupVersionKind item) {
    return withNewGroupVersionKindLike(getGroupVersionKind() != null ? getGroupVersionKind(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildGroupVersionResource instead.
   * @return The buildable object.
   */
  @Deprecated
  public GroupVersionResource getGroupVersionResource() {
    return this.groupVersionResource!=null ?this.groupVersionResource.build():null;
  }
  public GroupVersionResource buildGroupVersionResource() {
    return this.groupVersionResource!=null ?this.groupVersionResource.build():null;
  }
  public A withGroupVersionResource(GroupVersionResource groupVersionResource) {
    _visitables.get("groupVersionResource").remove(this.groupVersionResource);
    if (groupVersionResource!=null){ this.groupVersionResource= new GroupVersionResourceBuilder(groupVersionResource); _visitables.get("groupVersionResource").add(this.groupVersionResource);} else { this.groupVersionResource = null; _visitables.get("groupVersionResource").remove(this.groupVersionResource); } return (A) this;
  }
  public Boolean hasGroupVersionResource() {
    return this.groupVersionResource != null;
  }
  public A withNewGroupVersionResource(String group,String resource,String version) {
    return (A)withGroupVersionResource(new GroupVersionResource(group, resource, version));
  }
  public KubeSchemaFluentImpl.GroupVersionResourceNested<A> withNewGroupVersionResource() {
    return new KubeSchemaFluentImpl.GroupVersionResourceNestedImpl();
  }
  public KubeSchemaFluentImpl.GroupVersionResourceNested<A> withNewGroupVersionResourceLike(GroupVersionResource item) {
    return new KubeSchemaFluentImpl.GroupVersionResourceNestedImpl(item);
  }
  public KubeSchemaFluentImpl.GroupVersionResourceNested<A> editGroupVersionResource() {
    return withNewGroupVersionResourceLike(getGroupVersionResource());
  }
  public KubeSchemaFluentImpl.GroupVersionResourceNested<A> editOrNewGroupVersionResource() {
    return withNewGroupVersionResourceLike(getGroupVersionResource() != null ? getGroupVersionResource(): new GroupVersionResourceBuilder().build());
  }
  public KubeSchemaFluentImpl.GroupVersionResourceNested<A> editOrNewGroupVersionResourceLike(GroupVersionResource item) {
    return withNewGroupVersionResourceLike(getGroupVersionResource() != null ? getGroupVersionResource(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildInfo instead.
   * @return The buildable object.
   */
  @Deprecated
  public Info getInfo() {
    return this.info!=null ?this.info.build():null;
  }
  public Info buildInfo() {
    return this.info!=null ?this.info.build():null;
  }
  public A withInfo(Info info) {
    _visitables.get("info").remove(this.info);
    if (info!=null){ this.info= new InfoBuilder(info); _visitables.get("info").add(this.info);} else { this.info = null; _visitables.get("info").remove(this.info); } return (A) this;
  }
  public Boolean hasInfo() {
    return this.info != null;
  }
  public KubeSchemaFluentImpl.InfoNested<A> withNewInfo() {
    return new KubeSchemaFluentImpl.InfoNestedImpl();
  }
  public KubeSchemaFluentImpl.InfoNested<A> withNewInfoLike(Info item) {
    return new KubeSchemaFluentImpl.InfoNestedImpl(item);
  }
  public KubeSchemaFluentImpl.InfoNested<A> editInfo() {
    return withNewInfoLike(getInfo());
  }
  public KubeSchemaFluentImpl.InfoNested<A> editOrNewInfo() {
    return withNewInfoLike(getInfo() != null ? getInfo(): new InfoBuilder().build());
  }
  public KubeSchemaFluentImpl.InfoNested<A> editOrNewInfoLike(Info item) {
    return withNewInfoLike(getInfo() != null ? getInfo(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildKubernetesList instead.
   * @return The buildable object.
   */
  @Deprecated
  public KubernetesList getKubernetesList() {
    return this.kubernetesList!=null ?this.kubernetesList.build():null;
  }
  public KubernetesList buildKubernetesList() {
    return this.kubernetesList!=null ?this.kubernetesList.build():null;
  }
  public A withKubernetesList(KubernetesList kubernetesList) {
    _visitables.get("kubernetesList").remove(this.kubernetesList);
    if (kubernetesList!=null){ this.kubernetesList= new KubernetesListBuilder(kubernetesList); _visitables.get("kubernetesList").add(this.kubernetesList);} else { this.kubernetesList = null; _visitables.get("kubernetesList").remove(this.kubernetesList); } return (A) this;
  }
  public Boolean hasKubernetesList() {
    return this.kubernetesList != null;
  }
  public KubeSchemaFluentImpl.KubernetesListNested<A> withNewKubernetesList() {
    return new KubeSchemaFluentImpl.KubernetesListNestedImpl();
  }
  public KubeSchemaFluentImpl.KubernetesListNested<A> withNewKubernetesListLike(KubernetesList item) {
    return new KubeSchemaFluentImpl.KubernetesListNestedImpl(item);
  }
  public KubeSchemaFluentImpl.KubernetesListNested<A> editKubernetesList() {
    return withNewKubernetesListLike(getKubernetesList());
  }
  public KubeSchemaFluentImpl.KubernetesListNested<A> editOrNewKubernetesList() {
    return withNewKubernetesListLike(getKubernetesList() != null ? getKubernetesList(): new KubernetesListBuilder().build());
  }
  public KubeSchemaFluentImpl.KubernetesListNested<A> editOrNewKubernetesListLike(KubernetesList item) {
    return withNewKubernetesListLike(getKubernetesList() != null ? getKubernetesList(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildLimitRangeList instead.
   * @return The buildable object.
   */
  @Deprecated
  public LimitRangeList getLimitRangeList() {
    return this.limitRangeList!=null ?this.limitRangeList.build():null;
  }
  public LimitRangeList buildLimitRangeList() {
    return this.limitRangeList!=null ?this.limitRangeList.build():null;
  }
  public A withLimitRangeList(LimitRangeList limitRangeList) {
    _visitables.get("limitRangeList").remove(this.limitRangeList);
    if (limitRangeList!=null){ this.limitRangeList= new LimitRangeListBuilder(limitRangeList); _visitables.get("limitRangeList").add(this.limitRangeList);} else { this.limitRangeList = null; _visitables.get("limitRangeList").remove(this.limitRangeList); } return (A) this;
  }
  public Boolean hasLimitRangeList() {
    return this.limitRangeList != null;
  }
  public KubeSchemaFluentImpl.LimitRangeListNested<A> withNewLimitRangeList() {
    return new KubeSchemaFluentImpl.LimitRangeListNestedImpl();
  }
  public KubeSchemaFluentImpl.LimitRangeListNested<A> withNewLimitRangeListLike(LimitRangeList item) {
    return new KubeSchemaFluentImpl.LimitRangeListNestedImpl(item);
  }
  public KubeSchemaFluentImpl.LimitRangeListNested<A> editLimitRangeList() {
    return withNewLimitRangeListLike(getLimitRangeList());
  }
  public KubeSchemaFluentImpl.LimitRangeListNested<A> editOrNewLimitRangeList() {
    return withNewLimitRangeListLike(getLimitRangeList() != null ? getLimitRangeList(): new LimitRangeListBuilder().build());
  }
  public KubeSchemaFluentImpl.LimitRangeListNested<A> editOrNewLimitRangeListLike(LimitRangeList item) {
    return withNewLimitRangeListLike(getLimitRangeList() != null ? getLimitRangeList(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildListOptions instead.
   * @return The buildable object.
   */
  @Deprecated
  public ListOptions getListOptions() {
    return this.listOptions!=null ?this.listOptions.build():null;
  }
  public ListOptions buildListOptions() {
    return this.listOptions!=null ?this.listOptions.build():null;
  }
  public A withListOptions(ListOptions listOptions) {
    _visitables.get("listOptions").remove(this.listOptions);
    if (listOptions!=null){ this.listOptions= new ListOptionsBuilder(listOptions); _visitables.get("listOptions").add(this.listOptions);} else { this.listOptions = null; _visitables.get("listOptions").remove(this.listOptions); } return (A) this;
  }
  public Boolean hasListOptions() {
    return this.listOptions != null;
  }
  public KubeSchemaFluentImpl.ListOptionsNested<A> withNewListOptions() {
    return new KubeSchemaFluentImpl.ListOptionsNestedImpl();
  }
  public KubeSchemaFluentImpl.ListOptionsNested<A> withNewListOptionsLike(ListOptions item) {
    return new KubeSchemaFluentImpl.ListOptionsNestedImpl(item);
  }
  public KubeSchemaFluentImpl.ListOptionsNested<A> editListOptions() {
    return withNewListOptionsLike(getListOptions());
  }
  public KubeSchemaFluentImpl.ListOptionsNested<A> editOrNewListOptions() {
    return withNewListOptionsLike(getListOptions() != null ? getListOptions(): new ListOptionsBuilder().build());
  }
  public KubeSchemaFluentImpl.ListOptionsNested<A> editOrNewListOptionsLike(ListOptions item) {
    return withNewListOptionsLike(getListOptions() != null ? getListOptions(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildMicroTime instead.
   * @return The buildable object.
   */
  @Deprecated
  public MicroTime getMicroTime() {
    return this.microTime!=null ?this.microTime.build():null;
  }
  public MicroTime buildMicroTime() {
    return this.microTime!=null ?this.microTime.build():null;
  }
  public A withMicroTime(MicroTime microTime) {
    _visitables.get("microTime").remove(this.microTime);
    if (microTime!=null){ this.microTime= new MicroTimeBuilder(microTime); _visitables.get("microTime").add(this.microTime);} else { this.microTime = null; _visitables.get("microTime").remove(this.microTime); } return (A) this;
  }
  public Boolean hasMicroTime() {
    return this.microTime != null;
  }
  public A withNewMicroTime(String time) {
    return (A)withMicroTime(new MicroTime(time));
  }
  public KubeSchemaFluentImpl.MicroTimeNested<A> withNewMicroTime() {
    return new KubeSchemaFluentImpl.MicroTimeNestedImpl();
  }
  public KubeSchemaFluentImpl.MicroTimeNested<A> withNewMicroTimeLike(MicroTime item) {
    return new KubeSchemaFluentImpl.MicroTimeNestedImpl(item);
  }
  public KubeSchemaFluentImpl.MicroTimeNested<A> editMicroTime() {
    return withNewMicroTimeLike(getMicroTime());
  }
  public KubeSchemaFluentImpl.MicroTimeNested<A> editOrNewMicroTime() {
    return withNewMicroTimeLike(getMicroTime() != null ? getMicroTime(): new MicroTimeBuilder().build());
  }
  public KubeSchemaFluentImpl.MicroTimeNested<A> editOrNewMicroTimeLike(MicroTime item) {
    return withNewMicroTimeLike(getMicroTime() != null ? getMicroTime(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildNamespace instead.
   * @return The buildable object.
   */
  @Deprecated
  public Namespace getNamespace() {
    return this.namespace!=null ?this.namespace.build():null;
  }
  public Namespace buildNamespace() {
    return this.namespace!=null ?this.namespace.build():null;
  }
  public A withNamespace(Namespace namespace) {
    _visitables.get("namespace").remove(this.namespace);
    if (namespace!=null){ this.namespace= new NamespaceBuilder(namespace); _visitables.get("namespace").add(this.namespace);} else { this.namespace = null; _visitables.get("namespace").remove(this.namespace); } return (A) this;
  }
  public Boolean hasNamespace() {
    return this.namespace != null;
  }
  public KubeSchemaFluentImpl.NamespaceNested<A> withNewNamespace() {
    return new KubeSchemaFluentImpl.NamespaceNestedImpl();
  }
  public KubeSchemaFluentImpl.NamespaceNested<A> withNewNamespaceLike(Namespace item) {
    return new KubeSchemaFluentImpl.NamespaceNestedImpl(item);
  }
  public KubeSchemaFluentImpl.NamespaceNested<A> editNamespace() {
    return withNewNamespaceLike(getNamespace());
  }
  public KubeSchemaFluentImpl.NamespaceNested<A> editOrNewNamespace() {
    return withNewNamespaceLike(getNamespace() != null ? getNamespace(): new NamespaceBuilder().build());
  }
  public KubeSchemaFluentImpl.NamespaceNested<A> editOrNewNamespaceLike(Namespace item) {
    return withNewNamespaceLike(getNamespace() != null ? getNamespace(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildNamespaceList instead.
   * @return The buildable object.
   */
  @Deprecated
  public NamespaceList getNamespaceList() {
    return this.namespaceList!=null ?this.namespaceList.build():null;
  }
  public NamespaceList buildNamespaceList() {
    return this.namespaceList!=null ?this.namespaceList.build():null;
  }
  public A withNamespaceList(NamespaceList namespaceList) {
    _visitables.get("namespaceList").remove(this.namespaceList);
    if (namespaceList!=null){ this.namespaceList= new NamespaceListBuilder(namespaceList); _visitables.get("namespaceList").add(this.namespaceList);} else { this.namespaceList = null; _visitables.get("namespaceList").remove(this.namespaceList); } return (A) this;
  }
  public Boolean hasNamespaceList() {
    return this.namespaceList != null;
  }
  public KubeSchemaFluentImpl.NamespaceListNested<A> withNewNamespaceList() {
    return new KubeSchemaFluentImpl.NamespaceListNestedImpl();
  }
  public KubeSchemaFluentImpl.NamespaceListNested<A> withNewNamespaceListLike(NamespaceList item) {
    return new KubeSchemaFluentImpl.NamespaceListNestedImpl(item);
  }
  public KubeSchemaFluentImpl.NamespaceListNested<A> editNamespaceList() {
    return withNewNamespaceListLike(getNamespaceList());
  }
  public KubeSchemaFluentImpl.NamespaceListNested<A> editOrNewNamespaceList() {
    return withNewNamespaceListLike(getNamespaceList() != null ? getNamespaceList(): new NamespaceListBuilder().build());
  }
  public KubeSchemaFluentImpl.NamespaceListNested<A> editOrNewNamespaceListLike(NamespaceList item) {
    return withNewNamespaceListLike(getNamespaceList() != null ? getNamespaceList(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildNode instead.
   * @return The buildable object.
   */
  @Deprecated
  public Node getNode() {
    return this.node!=null ?this.node.build():null;
  }
  public Node buildNode() {
    return this.node!=null ?this.node.build():null;
  }
  public A withNode(Node node) {
    _visitables.get("node").remove(this.node);
    if (node!=null){ this.node= new NodeBuilder(node); _visitables.get("node").add(this.node);} else { this.node = null; _visitables.get("node").remove(this.node); } return (A) this;
  }
  public Boolean hasNode() {
    return this.node != null;
  }
  public KubeSchemaFluentImpl.NodeNested<A> withNewNode() {
    return new KubeSchemaFluentImpl.NodeNestedImpl();
  }
  public KubeSchemaFluentImpl.NodeNested<A> withNewNodeLike(Node item) {
    return new KubeSchemaFluentImpl.NodeNestedImpl(item);
  }
  public KubeSchemaFluentImpl.NodeNested<A> editNode() {
    return withNewNodeLike(getNode());
  }
  public KubeSchemaFluentImpl.NodeNested<A> editOrNewNode() {
    return withNewNodeLike(getNode() != null ? getNode(): new NodeBuilder().build());
  }
  public KubeSchemaFluentImpl.NodeNested<A> editOrNewNodeLike(Node item) {
    return withNewNodeLike(getNode() != null ? getNode(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildNodeList instead.
   * @return The buildable object.
   */
  @Deprecated
  public NodeList getNodeList() {
    return this.nodeList!=null ?this.nodeList.build():null;
  }
  public NodeList buildNodeList() {
    return this.nodeList!=null ?this.nodeList.build():null;
  }
  public A withNodeList(NodeList nodeList) {
    _visitables.get("nodeList").remove(this.nodeList);
    if (nodeList!=null){ this.nodeList= new NodeListBuilder(nodeList); _visitables.get("nodeList").add(this.nodeList);} else { this.nodeList = null; _visitables.get("nodeList").remove(this.nodeList); } return (A) this;
  }
  public Boolean hasNodeList() {
    return this.nodeList != null;
  }
  public KubeSchemaFluentImpl.NodeListNested<A> withNewNodeList() {
    return new KubeSchemaFluentImpl.NodeListNestedImpl();
  }
  public KubeSchemaFluentImpl.NodeListNested<A> withNewNodeListLike(NodeList item) {
    return new KubeSchemaFluentImpl.NodeListNestedImpl(item);
  }
  public KubeSchemaFluentImpl.NodeListNested<A> editNodeList() {
    return withNewNodeListLike(getNodeList());
  }
  public KubeSchemaFluentImpl.NodeListNested<A> editOrNewNodeList() {
    return withNewNodeListLike(getNodeList() != null ? getNodeList(): new NodeListBuilder().build());
  }
  public KubeSchemaFluentImpl.NodeListNested<A> editOrNewNodeListLike(NodeList item) {
    return withNewNodeListLike(getNodeList() != null ? getNodeList(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildObjectMeta instead.
   * @return The buildable object.
   */
  @Deprecated
  public ObjectMeta getObjectMeta() {
    return this.objectMeta!=null ?this.objectMeta.build():null;
  }
  public ObjectMeta buildObjectMeta() {
    return this.objectMeta!=null ?this.objectMeta.build():null;
  }
  public A withObjectMeta(ObjectMeta objectMeta) {
    _visitables.get("objectMeta").remove(this.objectMeta);
    if (objectMeta!=null){ this.objectMeta= new ObjectMetaBuilder(objectMeta); _visitables.get("objectMeta").add(this.objectMeta);} else { this.objectMeta = null; _visitables.get("objectMeta").remove(this.objectMeta); } return (A) this;
  }
  public Boolean hasObjectMeta() {
    return this.objectMeta != null;
  }
  public KubeSchemaFluentImpl.ObjectMetaNested<A> withNewObjectMeta() {
    return new KubeSchemaFluentImpl.ObjectMetaNestedImpl();
  }
  public KubeSchemaFluentImpl.ObjectMetaNested<A> withNewObjectMetaLike(ObjectMeta item) {
    return new KubeSchemaFluentImpl.ObjectMetaNestedImpl(item);
  }
  public KubeSchemaFluentImpl.ObjectMetaNested<A> editObjectMeta() {
    return withNewObjectMetaLike(getObjectMeta());
  }
  public KubeSchemaFluentImpl.ObjectMetaNested<A> editOrNewObjectMeta() {
    return withNewObjectMetaLike(getObjectMeta() != null ? getObjectMeta(): new ObjectMetaBuilder().build());
  }
  public KubeSchemaFluentImpl.ObjectMetaNested<A> editOrNewObjectMetaLike(ObjectMeta item) {
    return withNewObjectMetaLike(getObjectMeta() != null ? getObjectMeta(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildPatch instead.
   * @return The buildable object.
   */
  @Deprecated
  public Patch getPatch() {
    return this.patch!=null ?this.patch.build():null;
  }
  public Patch buildPatch() {
    return this.patch!=null ?this.patch.build():null;
  }
  public A withPatch(Patch patch) {
    _visitables.get("patch").remove(this.patch);
    if (patch!=null){ this.patch= new PatchBuilder(patch); _visitables.get("patch").add(this.patch);} else { this.patch = null; _visitables.get("patch").remove(this.patch); } return (A) this;
  }
  public Boolean hasPatch() {
    return this.patch != null;
  }
  public KubeSchemaFluentImpl.PatchNested<A> withNewPatch() {
    return new KubeSchemaFluentImpl.PatchNestedImpl();
  }
  public KubeSchemaFluentImpl.PatchNested<A> withNewPatchLike(Patch item) {
    return new KubeSchemaFluentImpl.PatchNestedImpl(item);
  }
  public KubeSchemaFluentImpl.PatchNested<A> editPatch() {
    return withNewPatchLike(getPatch());
  }
  public KubeSchemaFluentImpl.PatchNested<A> editOrNewPatch() {
    return withNewPatchLike(getPatch() != null ? getPatch(): new PatchBuilder().build());
  }
  public KubeSchemaFluentImpl.PatchNested<A> editOrNewPatchLike(Patch item) {
    return withNewPatchLike(getPatch() != null ? getPatch(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildPatchOptions instead.
   * @return The buildable object.
   */
  @Deprecated
  public PatchOptions getPatchOptions() {
    return this.patchOptions!=null ?this.patchOptions.build():null;
  }
  public PatchOptions buildPatchOptions() {
    return this.patchOptions!=null ?this.patchOptions.build():null;
  }
  public A withPatchOptions(PatchOptions patchOptions) {
    _visitables.get("patchOptions").remove(this.patchOptions);
    if (patchOptions!=null){ this.patchOptions= new PatchOptionsBuilder(patchOptions); _visitables.get("patchOptions").add(this.patchOptions);} else { this.patchOptions = null; _visitables.get("patchOptions").remove(this.patchOptions); } return (A) this;
  }
  public Boolean hasPatchOptions() {
    return this.patchOptions != null;
  }
  public KubeSchemaFluentImpl.PatchOptionsNested<A> withNewPatchOptions() {
    return new KubeSchemaFluentImpl.PatchOptionsNestedImpl();
  }
  public KubeSchemaFluentImpl.PatchOptionsNested<A> withNewPatchOptionsLike(PatchOptions item) {
    return new KubeSchemaFluentImpl.PatchOptionsNestedImpl(item);
  }
  public KubeSchemaFluentImpl.PatchOptionsNested<A> editPatchOptions() {
    return withNewPatchOptionsLike(getPatchOptions());
  }
  public KubeSchemaFluentImpl.PatchOptionsNested<A> editOrNewPatchOptions() {
    return withNewPatchOptionsLike(getPatchOptions() != null ? getPatchOptions(): new PatchOptionsBuilder().build());
  }
  public KubeSchemaFluentImpl.PatchOptionsNested<A> editOrNewPatchOptionsLike(PatchOptions item) {
    return withNewPatchOptionsLike(getPatchOptions() != null ? getPatchOptions(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildPersistentVolume instead.
   * @return The buildable object.
   */
  @Deprecated
  public PersistentVolume getPersistentVolume() {
    return this.persistentVolume!=null ?this.persistentVolume.build():null;
  }
  public PersistentVolume buildPersistentVolume() {
    return this.persistentVolume!=null ?this.persistentVolume.build():null;
  }
  public A withPersistentVolume(PersistentVolume persistentVolume) {
    _visitables.get("persistentVolume").remove(this.persistentVolume);
    if (persistentVolume!=null){ this.persistentVolume= new PersistentVolumeBuilder(persistentVolume); _visitables.get("persistentVolume").add(this.persistentVolume);} else { this.persistentVolume = null; _visitables.get("persistentVolume").remove(this.persistentVolume); } return (A) this;
  }
  public Boolean hasPersistentVolume() {
    return this.persistentVolume != null;
  }
  public KubeSchemaFluentImpl.PersistentVolumeNested<A> withNewPersistentVolume() {
    return new KubeSchemaFluentImpl.PersistentVolumeNestedImpl();
  }
  public KubeSchemaFluentImpl.PersistentVolumeNested<A> withNewPersistentVolumeLike(PersistentVolume item) {
    return new KubeSchemaFluentImpl.PersistentVolumeNestedImpl(item);
  }
  public KubeSchemaFluentImpl.PersistentVolumeNested<A> editPersistentVolume() {
    return withNewPersistentVolumeLike(getPersistentVolume());
  }
  public KubeSchemaFluentImpl.PersistentVolumeNested<A> editOrNewPersistentVolume() {
    return withNewPersistentVolumeLike(getPersistentVolume() != null ? getPersistentVolume(): new PersistentVolumeBuilder().build());
  }
  public KubeSchemaFluentImpl.PersistentVolumeNested<A> editOrNewPersistentVolumeLike(PersistentVolume item) {
    return withNewPersistentVolumeLike(getPersistentVolume() != null ? getPersistentVolume(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildPersistentVolumeClaim instead.
   * @return The buildable object.
   */
  @Deprecated
  public PersistentVolumeClaim getPersistentVolumeClaim() {
    return this.persistentVolumeClaim!=null ?this.persistentVolumeClaim.build():null;
  }
  public PersistentVolumeClaim buildPersistentVolumeClaim() {
    return this.persistentVolumeClaim!=null ?this.persistentVolumeClaim.build():null;
  }
  public A withPersistentVolumeClaim(PersistentVolumeClaim persistentVolumeClaim) {
    _visitables.get("persistentVolumeClaim").remove(this.persistentVolumeClaim);
    if (persistentVolumeClaim!=null){ this.persistentVolumeClaim= new PersistentVolumeClaimBuilder(persistentVolumeClaim); _visitables.get("persistentVolumeClaim").add(this.persistentVolumeClaim);} else { this.persistentVolumeClaim = null; _visitables.get("persistentVolumeClaim").remove(this.persistentVolumeClaim); } return (A) this;
  }
  public Boolean hasPersistentVolumeClaim() {
    return this.persistentVolumeClaim != null;
  }
  public KubeSchemaFluentImpl.PersistentVolumeClaimNested<A> withNewPersistentVolumeClaim() {
    return new KubeSchemaFluentImpl.PersistentVolumeClaimNestedImpl();
  }
  public KubeSchemaFluentImpl.PersistentVolumeClaimNested<A> withNewPersistentVolumeClaimLike(PersistentVolumeClaim item) {
    return new KubeSchemaFluentImpl.PersistentVolumeClaimNestedImpl(item);
  }
  public KubeSchemaFluentImpl.PersistentVolumeClaimNested<A> editPersistentVolumeClaim() {
    return withNewPersistentVolumeClaimLike(getPersistentVolumeClaim());
  }
  public KubeSchemaFluentImpl.PersistentVolumeClaimNested<A> editOrNewPersistentVolumeClaim() {
    return withNewPersistentVolumeClaimLike(getPersistentVolumeClaim() != null ? getPersistentVolumeClaim(): new PersistentVolumeClaimBuilder().build());
  }
  public KubeSchemaFluentImpl.PersistentVolumeClaimNested<A> editOrNewPersistentVolumeClaimLike(PersistentVolumeClaim item) {
    return withNewPersistentVolumeClaimLike(getPersistentVolumeClaim() != null ? getPersistentVolumeClaim(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildPersistentVolumeClaimList instead.
   * @return The buildable object.
   */
  @Deprecated
  public PersistentVolumeClaimList getPersistentVolumeClaimList() {
    return this.persistentVolumeClaimList!=null ?this.persistentVolumeClaimList.build():null;
  }
  public PersistentVolumeClaimList buildPersistentVolumeClaimList() {
    return this.persistentVolumeClaimList!=null ?this.persistentVolumeClaimList.build():null;
  }
  public A withPersistentVolumeClaimList(PersistentVolumeClaimList persistentVolumeClaimList) {
    _visitables.get("persistentVolumeClaimList").remove(this.persistentVolumeClaimList);
    if (persistentVolumeClaimList!=null){ this.persistentVolumeClaimList= new PersistentVolumeClaimListBuilder(persistentVolumeClaimList); _visitables.get("persistentVolumeClaimList").add(this.persistentVolumeClaimList);} else { this.persistentVolumeClaimList = null; _visitables.get("persistentVolumeClaimList").remove(this.persistentVolumeClaimList); } return (A) this;
  }
  public Boolean hasPersistentVolumeClaimList() {
    return this.persistentVolumeClaimList != null;
  }
  public KubeSchemaFluentImpl.PersistentVolumeClaimListNested<A> withNewPersistentVolumeClaimList() {
    return new KubeSchemaFluentImpl.PersistentVolumeClaimListNestedImpl();
  }
  public KubeSchemaFluentImpl.PersistentVolumeClaimListNested<A> withNewPersistentVolumeClaimListLike(PersistentVolumeClaimList item) {
    return new KubeSchemaFluentImpl.PersistentVolumeClaimListNestedImpl(item);
  }
  public KubeSchemaFluentImpl.PersistentVolumeClaimListNested<A> editPersistentVolumeClaimList() {
    return withNewPersistentVolumeClaimListLike(getPersistentVolumeClaimList());
  }
  public KubeSchemaFluentImpl.PersistentVolumeClaimListNested<A> editOrNewPersistentVolumeClaimList() {
    return withNewPersistentVolumeClaimListLike(getPersistentVolumeClaimList() != null ? getPersistentVolumeClaimList(): new PersistentVolumeClaimListBuilder().build());
  }
  public KubeSchemaFluentImpl.PersistentVolumeClaimListNested<A> editOrNewPersistentVolumeClaimListLike(PersistentVolumeClaimList item) {
    return withNewPersistentVolumeClaimListLike(getPersistentVolumeClaimList() != null ? getPersistentVolumeClaimList(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildPersistentVolumeList instead.
   * @return The buildable object.
   */
  @Deprecated
  public PersistentVolumeList getPersistentVolumeList() {
    return this.persistentVolumeList!=null ?this.persistentVolumeList.build():null;
  }
  public PersistentVolumeList buildPersistentVolumeList() {
    return this.persistentVolumeList!=null ?this.persistentVolumeList.build():null;
  }
  public A withPersistentVolumeList(PersistentVolumeList persistentVolumeList) {
    _visitables.get("persistentVolumeList").remove(this.persistentVolumeList);
    if (persistentVolumeList!=null){ this.persistentVolumeList= new PersistentVolumeListBuilder(persistentVolumeList); _visitables.get("persistentVolumeList").add(this.persistentVolumeList);} else { this.persistentVolumeList = null; _visitables.get("persistentVolumeList").remove(this.persistentVolumeList); } return (A) this;
  }
  public Boolean hasPersistentVolumeList() {
    return this.persistentVolumeList != null;
  }
  public KubeSchemaFluentImpl.PersistentVolumeListNested<A> withNewPersistentVolumeList() {
    return new KubeSchemaFluentImpl.PersistentVolumeListNestedImpl();
  }
  public KubeSchemaFluentImpl.PersistentVolumeListNested<A> withNewPersistentVolumeListLike(PersistentVolumeList item) {
    return new KubeSchemaFluentImpl.PersistentVolumeListNestedImpl(item);
  }
  public KubeSchemaFluentImpl.PersistentVolumeListNested<A> editPersistentVolumeList() {
    return withNewPersistentVolumeListLike(getPersistentVolumeList());
  }
  public KubeSchemaFluentImpl.PersistentVolumeListNested<A> editOrNewPersistentVolumeList() {
    return withNewPersistentVolumeListLike(getPersistentVolumeList() != null ? getPersistentVolumeList(): new PersistentVolumeListBuilder().build());
  }
  public KubeSchemaFluentImpl.PersistentVolumeListNested<A> editOrNewPersistentVolumeListLike(PersistentVolumeList item) {
    return withNewPersistentVolumeListLike(getPersistentVolumeList() != null ? getPersistentVolumeList(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildPodExecOptions instead.
   * @return The buildable object.
   */
  @Deprecated
  public PodExecOptions getPodExecOptions() {
    return this.podExecOptions!=null ?this.podExecOptions.build():null;
  }
  public PodExecOptions buildPodExecOptions() {
    return this.podExecOptions!=null ?this.podExecOptions.build():null;
  }
  public A withPodExecOptions(PodExecOptions podExecOptions) {
    _visitables.get("podExecOptions").remove(this.podExecOptions);
    if (podExecOptions!=null){ this.podExecOptions= new PodExecOptionsBuilder(podExecOptions); _visitables.get("podExecOptions").add(this.podExecOptions);} else { this.podExecOptions = null; _visitables.get("podExecOptions").remove(this.podExecOptions); } return (A) this;
  }
  public Boolean hasPodExecOptions() {
    return this.podExecOptions != null;
  }
  public KubeSchemaFluentImpl.PodExecOptionsNested<A> withNewPodExecOptions() {
    return new KubeSchemaFluentImpl.PodExecOptionsNestedImpl();
  }
  public KubeSchemaFluentImpl.PodExecOptionsNested<A> withNewPodExecOptionsLike(PodExecOptions item) {
    return new KubeSchemaFluentImpl.PodExecOptionsNestedImpl(item);
  }
  public KubeSchemaFluentImpl.PodExecOptionsNested<A> editPodExecOptions() {
    return withNewPodExecOptionsLike(getPodExecOptions());
  }
  public KubeSchemaFluentImpl.PodExecOptionsNested<A> editOrNewPodExecOptions() {
    return withNewPodExecOptionsLike(getPodExecOptions() != null ? getPodExecOptions(): new PodExecOptionsBuilder().build());
  }
  public KubeSchemaFluentImpl.PodExecOptionsNested<A> editOrNewPodExecOptionsLike(PodExecOptions item) {
    return withNewPodExecOptionsLike(getPodExecOptions() != null ? getPodExecOptions(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildPodList instead.
   * @return The buildable object.
   */
  @Deprecated
  public PodList getPodList() {
    return this.podList!=null ?this.podList.build():null;
  }
  public PodList buildPodList() {
    return this.podList!=null ?this.podList.build():null;
  }
  public A withPodList(PodList podList) {
    _visitables.get("podList").remove(this.podList);
    if (podList!=null){ this.podList= new PodListBuilder(podList); _visitables.get("podList").add(this.podList);} else { this.podList = null; _visitables.get("podList").remove(this.podList); } return (A) this;
  }
  public Boolean hasPodList() {
    return this.podList != null;
  }
  public KubeSchemaFluentImpl.PodListNested<A> withNewPodList() {
    return new KubeSchemaFluentImpl.PodListNestedImpl();
  }
  public KubeSchemaFluentImpl.PodListNested<A> withNewPodListLike(PodList item) {
    return new KubeSchemaFluentImpl.PodListNestedImpl(item);
  }
  public KubeSchemaFluentImpl.PodListNested<A> editPodList() {
    return withNewPodListLike(getPodList());
  }
  public KubeSchemaFluentImpl.PodListNested<A> editOrNewPodList() {
    return withNewPodListLike(getPodList() != null ? getPodList(): new PodListBuilder().build());
  }
  public KubeSchemaFluentImpl.PodListNested<A> editOrNewPodListLike(PodList item) {
    return withNewPodListLike(getPodList() != null ? getPodList(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildPodTemplateList instead.
   * @return The buildable object.
   */
  @Deprecated
  public PodTemplateList getPodTemplateList() {
    return this.podTemplateList!=null ?this.podTemplateList.build():null;
  }
  public PodTemplateList buildPodTemplateList() {
    return this.podTemplateList!=null ?this.podTemplateList.build():null;
  }
  public A withPodTemplateList(PodTemplateList podTemplateList) {
    _visitables.get("podTemplateList").remove(this.podTemplateList);
    if (podTemplateList!=null){ this.podTemplateList= new PodTemplateListBuilder(podTemplateList); _visitables.get("podTemplateList").add(this.podTemplateList);} else { this.podTemplateList = null; _visitables.get("podTemplateList").remove(this.podTemplateList); } return (A) this;
  }
  public Boolean hasPodTemplateList() {
    return this.podTemplateList != null;
  }
  public KubeSchemaFluentImpl.PodTemplateListNested<A> withNewPodTemplateList() {
    return new KubeSchemaFluentImpl.PodTemplateListNestedImpl();
  }
  public KubeSchemaFluentImpl.PodTemplateListNested<A> withNewPodTemplateListLike(PodTemplateList item) {
    return new KubeSchemaFluentImpl.PodTemplateListNestedImpl(item);
  }
  public KubeSchemaFluentImpl.PodTemplateListNested<A> editPodTemplateList() {
    return withNewPodTemplateListLike(getPodTemplateList());
  }
  public KubeSchemaFluentImpl.PodTemplateListNested<A> editOrNewPodTemplateList() {
    return withNewPodTemplateListLike(getPodTemplateList() != null ? getPodTemplateList(): new PodTemplateListBuilder().build());
  }
  public KubeSchemaFluentImpl.PodTemplateListNested<A> editOrNewPodTemplateListLike(PodTemplateList item) {
    return withNewPodTemplateListLike(getPodTemplateList() != null ? getPodTemplateList(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildQuantity instead.
   * @return The buildable object.
   */
  @Deprecated
  public Quantity getQuantity() {
    return this.quantity!=null ?this.quantity.build():null;
  }
  public Quantity buildQuantity() {
    return this.quantity!=null ?this.quantity.build():null;
  }
  public A withQuantity(Quantity quantity) {
    _visitables.get("quantity").remove(this.quantity);
    if (quantity!=null){ this.quantity= new QuantityBuilder(quantity); _visitables.get("quantity").add(this.quantity);} else { this.quantity = null; _visitables.get("quantity").remove(this.quantity); } return (A) this;
  }
  public Boolean hasQuantity() {
    return this.quantity != null;
  }
  public A withNewQuantity(String amount,String format) {
    return (A)withQuantity(new Quantity(amount, format));
  }
  public A withNewQuantity(String amount) {
    return (A)withQuantity(new Quantity(amount));
  }
  public KubeSchemaFluentImpl.QuantityNested<A> withNewQuantity() {
    return new KubeSchemaFluentImpl.QuantityNestedImpl();
  }
  public KubeSchemaFluentImpl.QuantityNested<A> withNewQuantityLike(Quantity item) {
    return new KubeSchemaFluentImpl.QuantityNestedImpl(item);
  }
  public KubeSchemaFluentImpl.QuantityNested<A> editQuantity() {
    return withNewQuantityLike(getQuantity());
  }
  public KubeSchemaFluentImpl.QuantityNested<A> editOrNewQuantity() {
    return withNewQuantityLike(getQuantity() != null ? getQuantity(): new QuantityBuilder().build());
  }
  public KubeSchemaFluentImpl.QuantityNested<A> editOrNewQuantityLike(Quantity item) {
    return withNewQuantityLike(getQuantity() != null ? getQuantity(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildReplicationControllerList instead.
   * @return The buildable object.
   */
  @Deprecated
  public ReplicationControllerList getReplicationControllerList() {
    return this.replicationControllerList!=null ?this.replicationControllerList.build():null;
  }
  public ReplicationControllerList buildReplicationControllerList() {
    return this.replicationControllerList!=null ?this.replicationControllerList.build():null;
  }
  public A withReplicationControllerList(ReplicationControllerList replicationControllerList) {
    _visitables.get("replicationControllerList").remove(this.replicationControllerList);
    if (replicationControllerList!=null){ this.replicationControllerList= new ReplicationControllerListBuilder(replicationControllerList); _visitables.get("replicationControllerList").add(this.replicationControllerList);} else { this.replicationControllerList = null; _visitables.get("replicationControllerList").remove(this.replicationControllerList); } return (A) this;
  }
  public Boolean hasReplicationControllerList() {
    return this.replicationControllerList != null;
  }
  public KubeSchemaFluentImpl.ReplicationControllerListNested<A> withNewReplicationControllerList() {
    return new KubeSchemaFluentImpl.ReplicationControllerListNestedImpl();
  }
  public KubeSchemaFluentImpl.ReplicationControllerListNested<A> withNewReplicationControllerListLike(ReplicationControllerList item) {
    return new KubeSchemaFluentImpl.ReplicationControllerListNestedImpl(item);
  }
  public KubeSchemaFluentImpl.ReplicationControllerListNested<A> editReplicationControllerList() {
    return withNewReplicationControllerListLike(getReplicationControllerList());
  }
  public KubeSchemaFluentImpl.ReplicationControllerListNested<A> editOrNewReplicationControllerList() {
    return withNewReplicationControllerListLike(getReplicationControllerList() != null ? getReplicationControllerList(): new ReplicationControllerListBuilder().build());
  }
  public KubeSchemaFluentImpl.ReplicationControllerListNested<A> editOrNewReplicationControllerListLike(ReplicationControllerList item) {
    return withNewReplicationControllerListLike(getReplicationControllerList() != null ? getReplicationControllerList(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildResourceQuota instead.
   * @return The buildable object.
   */
  @Deprecated
  public ResourceQuota getResourceQuota() {
    return this.resourceQuota!=null ?this.resourceQuota.build():null;
  }
  public ResourceQuota buildResourceQuota() {
    return this.resourceQuota!=null ?this.resourceQuota.build():null;
  }
  public A withResourceQuota(ResourceQuota resourceQuota) {
    _visitables.get("resourceQuota").remove(this.resourceQuota);
    if (resourceQuota!=null){ this.resourceQuota= new ResourceQuotaBuilder(resourceQuota); _visitables.get("resourceQuota").add(this.resourceQuota);} else { this.resourceQuota = null; _visitables.get("resourceQuota").remove(this.resourceQuota); } return (A) this;
  }
  public Boolean hasResourceQuota() {
    return this.resourceQuota != null;
  }
  public KubeSchemaFluentImpl.ResourceQuotaNested<A> withNewResourceQuota() {
    return new KubeSchemaFluentImpl.ResourceQuotaNestedImpl();
  }
  public KubeSchemaFluentImpl.ResourceQuotaNested<A> withNewResourceQuotaLike(ResourceQuota item) {
    return new KubeSchemaFluentImpl.ResourceQuotaNestedImpl(item);
  }
  public KubeSchemaFluentImpl.ResourceQuotaNested<A> editResourceQuota() {
    return withNewResourceQuotaLike(getResourceQuota());
  }
  public KubeSchemaFluentImpl.ResourceQuotaNested<A> editOrNewResourceQuota() {
    return withNewResourceQuotaLike(getResourceQuota() != null ? getResourceQuota(): new ResourceQuotaBuilder().build());
  }
  public KubeSchemaFluentImpl.ResourceQuotaNested<A> editOrNewResourceQuotaLike(ResourceQuota item) {
    return withNewResourceQuotaLike(getResourceQuota() != null ? getResourceQuota(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildResourceQuotaList instead.
   * @return The buildable object.
   */
  @Deprecated
  public ResourceQuotaList getResourceQuotaList() {
    return this.resourceQuotaList!=null ?this.resourceQuotaList.build():null;
  }
  public ResourceQuotaList buildResourceQuotaList() {
    return this.resourceQuotaList!=null ?this.resourceQuotaList.build():null;
  }
  public A withResourceQuotaList(ResourceQuotaList resourceQuotaList) {
    _visitables.get("resourceQuotaList").remove(this.resourceQuotaList);
    if (resourceQuotaList!=null){ this.resourceQuotaList= new ResourceQuotaListBuilder(resourceQuotaList); _visitables.get("resourceQuotaList").add(this.resourceQuotaList);} else { this.resourceQuotaList = null; _visitables.get("resourceQuotaList").remove(this.resourceQuotaList); } return (A) this;
  }
  public Boolean hasResourceQuotaList() {
    return this.resourceQuotaList != null;
  }
  public KubeSchemaFluentImpl.ResourceQuotaListNested<A> withNewResourceQuotaList() {
    return new KubeSchemaFluentImpl.ResourceQuotaListNestedImpl();
  }
  public KubeSchemaFluentImpl.ResourceQuotaListNested<A> withNewResourceQuotaListLike(ResourceQuotaList item) {
    return new KubeSchemaFluentImpl.ResourceQuotaListNestedImpl(item);
  }
  public KubeSchemaFluentImpl.ResourceQuotaListNested<A> editResourceQuotaList() {
    return withNewResourceQuotaListLike(getResourceQuotaList());
  }
  public KubeSchemaFluentImpl.ResourceQuotaListNested<A> editOrNewResourceQuotaList() {
    return withNewResourceQuotaListLike(getResourceQuotaList() != null ? getResourceQuotaList(): new ResourceQuotaListBuilder().build());
  }
  public KubeSchemaFluentImpl.ResourceQuotaListNested<A> editOrNewResourceQuotaListLike(ResourceQuotaList item) {
    return withNewResourceQuotaListLike(getResourceQuotaList() != null ? getResourceQuotaList(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildRootPaths instead.
   * @return The buildable object.
   */
  @Deprecated
  public RootPaths getRootPaths() {
    return this.rootPaths!=null ?this.rootPaths.build():null;
  }
  public RootPaths buildRootPaths() {
    return this.rootPaths!=null ?this.rootPaths.build():null;
  }
  public A withRootPaths(RootPaths rootPaths) {
    _visitables.get("rootPaths").remove(this.rootPaths);
    if (rootPaths!=null){ this.rootPaths= new RootPathsBuilder(rootPaths); _visitables.get("rootPaths").add(this.rootPaths);} else { this.rootPaths = null; _visitables.get("rootPaths").remove(this.rootPaths); } return (A) this;
  }
  public Boolean hasRootPaths() {
    return this.rootPaths != null;
  }
  public KubeSchemaFluentImpl.RootPathsNested<A> withNewRootPaths() {
    return new KubeSchemaFluentImpl.RootPathsNestedImpl();
  }
  public KubeSchemaFluentImpl.RootPathsNested<A> withNewRootPathsLike(RootPaths item) {
    return new KubeSchemaFluentImpl.RootPathsNestedImpl(item);
  }
  public KubeSchemaFluentImpl.RootPathsNested<A> editRootPaths() {
    return withNewRootPathsLike(getRootPaths());
  }
  public KubeSchemaFluentImpl.RootPathsNested<A> editOrNewRootPaths() {
    return withNewRootPathsLike(getRootPaths() != null ? getRootPaths(): new RootPathsBuilder().build());
  }
  public KubeSchemaFluentImpl.RootPathsNested<A> editOrNewRootPathsLike(RootPaths item) {
    return withNewRootPathsLike(getRootPaths() != null ? getRootPaths(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildSecret instead.
   * @return The buildable object.
   */
  @Deprecated
  public Secret getSecret() {
    return this.secret!=null ?this.secret.build():null;
  }
  public Secret buildSecret() {
    return this.secret!=null ?this.secret.build():null;
  }
  public A withSecret(Secret secret) {
    _visitables.get("secret").remove(this.secret);
    if (secret!=null){ this.secret= new SecretBuilder(secret); _visitables.get("secret").add(this.secret);} else { this.secret = null; _visitables.get("secret").remove(this.secret); } return (A) this;
  }
  public Boolean hasSecret() {
    return this.secret != null;
  }
  public KubeSchemaFluentImpl.SecretNested<A> withNewSecret() {
    return new KubeSchemaFluentImpl.SecretNestedImpl();
  }
  public KubeSchemaFluentImpl.SecretNested<A> withNewSecretLike(Secret item) {
    return new KubeSchemaFluentImpl.SecretNestedImpl(item);
  }
  public KubeSchemaFluentImpl.SecretNested<A> editSecret() {
    return withNewSecretLike(getSecret());
  }
  public KubeSchemaFluentImpl.SecretNested<A> editOrNewSecret() {
    return withNewSecretLike(getSecret() != null ? getSecret(): new SecretBuilder().build());
  }
  public KubeSchemaFluentImpl.SecretNested<A> editOrNewSecretLike(Secret item) {
    return withNewSecretLike(getSecret() != null ? getSecret(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildSecretList instead.
   * @return The buildable object.
   */
  @Deprecated
  public SecretList getSecretList() {
    return this.secretList!=null ?this.secretList.build():null;
  }
  public SecretList buildSecretList() {
    return this.secretList!=null ?this.secretList.build():null;
  }
  public A withSecretList(SecretList secretList) {
    _visitables.get("secretList").remove(this.secretList);
    if (secretList!=null){ this.secretList= new SecretListBuilder(secretList); _visitables.get("secretList").add(this.secretList);} else { this.secretList = null; _visitables.get("secretList").remove(this.secretList); } return (A) this;
  }
  public Boolean hasSecretList() {
    return this.secretList != null;
  }
  public KubeSchemaFluentImpl.SecretListNested<A> withNewSecretList() {
    return new KubeSchemaFluentImpl.SecretListNestedImpl();
  }
  public KubeSchemaFluentImpl.SecretListNested<A> withNewSecretListLike(SecretList item) {
    return new KubeSchemaFluentImpl.SecretListNestedImpl(item);
  }
  public KubeSchemaFluentImpl.SecretListNested<A> editSecretList() {
    return withNewSecretListLike(getSecretList());
  }
  public KubeSchemaFluentImpl.SecretListNested<A> editOrNewSecretList() {
    return withNewSecretListLike(getSecretList() != null ? getSecretList(): new SecretListBuilder().build());
  }
  public KubeSchemaFluentImpl.SecretListNested<A> editOrNewSecretListLike(SecretList item) {
    return withNewSecretListLike(getSecretList() != null ? getSecretList(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildServiceAccount instead.
   * @return The buildable object.
   */
  @Deprecated
  public ServiceAccount getServiceAccount() {
    return this.serviceAccount!=null ?this.serviceAccount.build():null;
  }
  public ServiceAccount buildServiceAccount() {
    return this.serviceAccount!=null ?this.serviceAccount.build():null;
  }
  public A withServiceAccount(ServiceAccount serviceAccount) {
    _visitables.get("serviceAccount").remove(this.serviceAccount);
    if (serviceAccount!=null){ this.serviceAccount= new ServiceAccountBuilder(serviceAccount); _visitables.get("serviceAccount").add(this.serviceAccount);} else { this.serviceAccount = null; _visitables.get("serviceAccount").remove(this.serviceAccount); } return (A) this;
  }
  public Boolean hasServiceAccount() {
    return this.serviceAccount != null;
  }
  public KubeSchemaFluentImpl.ServiceAccountNested<A> withNewServiceAccount() {
    return new KubeSchemaFluentImpl.ServiceAccountNestedImpl();
  }
  public KubeSchemaFluentImpl.ServiceAccountNested<A> withNewServiceAccountLike(ServiceAccount item) {
    return new KubeSchemaFluentImpl.ServiceAccountNestedImpl(item);
  }
  public KubeSchemaFluentImpl.ServiceAccountNested<A> editServiceAccount() {
    return withNewServiceAccountLike(getServiceAccount());
  }
  public KubeSchemaFluentImpl.ServiceAccountNested<A> editOrNewServiceAccount() {
    return withNewServiceAccountLike(getServiceAccount() != null ? getServiceAccount(): new ServiceAccountBuilder().build());
  }
  public KubeSchemaFluentImpl.ServiceAccountNested<A> editOrNewServiceAccountLike(ServiceAccount item) {
    return withNewServiceAccountLike(getServiceAccount() != null ? getServiceAccount(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildServiceAccountList instead.
   * @return The buildable object.
   */
  @Deprecated
  public ServiceAccountList getServiceAccountList() {
    return this.serviceAccountList!=null ?this.serviceAccountList.build():null;
  }
  public ServiceAccountList buildServiceAccountList() {
    return this.serviceAccountList!=null ?this.serviceAccountList.build():null;
  }
  public A withServiceAccountList(ServiceAccountList serviceAccountList) {
    _visitables.get("serviceAccountList").remove(this.serviceAccountList);
    if (serviceAccountList!=null){ this.serviceAccountList= new ServiceAccountListBuilder(serviceAccountList); _visitables.get("serviceAccountList").add(this.serviceAccountList);} else { this.serviceAccountList = null; _visitables.get("serviceAccountList").remove(this.serviceAccountList); } return (A) this;
  }
  public Boolean hasServiceAccountList() {
    return this.serviceAccountList != null;
  }
  public KubeSchemaFluentImpl.ServiceAccountListNested<A> withNewServiceAccountList() {
    return new KubeSchemaFluentImpl.ServiceAccountListNestedImpl();
  }
  public KubeSchemaFluentImpl.ServiceAccountListNested<A> withNewServiceAccountListLike(ServiceAccountList item) {
    return new KubeSchemaFluentImpl.ServiceAccountListNestedImpl(item);
  }
  public KubeSchemaFluentImpl.ServiceAccountListNested<A> editServiceAccountList() {
    return withNewServiceAccountListLike(getServiceAccountList());
  }
  public KubeSchemaFluentImpl.ServiceAccountListNested<A> editOrNewServiceAccountList() {
    return withNewServiceAccountListLike(getServiceAccountList() != null ? getServiceAccountList(): new ServiceAccountListBuilder().build());
  }
  public KubeSchemaFluentImpl.ServiceAccountListNested<A> editOrNewServiceAccountListLike(ServiceAccountList item) {
    return withNewServiceAccountListLike(getServiceAccountList() != null ? getServiceAccountList(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildServiceList instead.
   * @return The buildable object.
   */
  @Deprecated
  public ServiceList getServiceList() {
    return this.serviceList!=null ?this.serviceList.build():null;
  }
  public ServiceList buildServiceList() {
    return this.serviceList!=null ?this.serviceList.build():null;
  }
  public A withServiceList(ServiceList serviceList) {
    _visitables.get("serviceList").remove(this.serviceList);
    if (serviceList!=null){ this.serviceList= new ServiceListBuilder(serviceList); _visitables.get("serviceList").add(this.serviceList);} else { this.serviceList = null; _visitables.get("serviceList").remove(this.serviceList); } return (A) this;
  }
  public Boolean hasServiceList() {
    return this.serviceList != null;
  }
  public KubeSchemaFluentImpl.ServiceListNested<A> withNewServiceList() {
    return new KubeSchemaFluentImpl.ServiceListNestedImpl();
  }
  public KubeSchemaFluentImpl.ServiceListNested<A> withNewServiceListLike(ServiceList item) {
    return new KubeSchemaFluentImpl.ServiceListNestedImpl(item);
  }
  public KubeSchemaFluentImpl.ServiceListNested<A> editServiceList() {
    return withNewServiceListLike(getServiceList());
  }
  public KubeSchemaFluentImpl.ServiceListNested<A> editOrNewServiceList() {
    return withNewServiceListLike(getServiceList() != null ? getServiceList(): new ServiceListBuilder().build());
  }
  public KubeSchemaFluentImpl.ServiceListNested<A> editOrNewServiceListLike(ServiceList item) {
    return withNewServiceListLike(getServiceList() != null ? getServiceList(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildStatus instead.
   * @return The buildable object.
   */
  @Deprecated
  public Status getStatus() {
    return this.status!=null ?this.status.build():null;
  }
  public Status buildStatus() {
    return this.status!=null ?this.status.build():null;
  }
  public A withStatus(Status status) {
    _visitables.get("status").remove(this.status);
    if (status!=null){ this.status= new StatusBuilder(status); _visitables.get("status").add(this.status);} else { this.status = null; _visitables.get("status").remove(this.status); } return (A) this;
  }
  public Boolean hasStatus() {
    return this.status != null;
  }
  public KubeSchemaFluentImpl.StatusNested<A> withNewStatus() {
    return new KubeSchemaFluentImpl.StatusNestedImpl();
  }
  public KubeSchemaFluentImpl.StatusNested<A> withNewStatusLike(Status item) {
    return new KubeSchemaFluentImpl.StatusNestedImpl(item);
  }
  public KubeSchemaFluentImpl.StatusNested<A> editStatus() {
    return withNewStatusLike(getStatus());
  }
  public KubeSchemaFluentImpl.StatusNested<A> editOrNewStatus() {
    return withNewStatusLike(getStatus() != null ? getStatus(): new StatusBuilder().build());
  }
  public KubeSchemaFluentImpl.StatusNested<A> editOrNewStatusLike(Status item) {
    return withNewStatusLike(getStatus() != null ? getStatus(): item);
  }
  public String getTime() {
    return this.time;
  }
  public A withTime(String time) {
    this.time=time; return (A) this;
  }
  public Boolean hasTime() {
    return this.time != null;
  }
  
  /**
   * This method has been deprecated, please use method buildToleration instead.
   * @return The buildable object.
   */
  @Deprecated
  public Toleration getToleration() {
    return this.toleration!=null ?this.toleration.build():null;
  }
  public Toleration buildToleration() {
    return this.toleration!=null ?this.toleration.build():null;
  }
  public A withToleration(Toleration toleration) {
    _visitables.get("toleration").remove(this.toleration);
    if (toleration!=null){ this.toleration= new TolerationBuilder(toleration); _visitables.get("toleration").add(this.toleration);} else { this.toleration = null; _visitables.get("toleration").remove(this.toleration); } return (A) this;
  }
  public Boolean hasToleration() {
    return this.toleration != null;
  }
  public A withNewToleration(String effect,String key,String operator,Long tolerationSeconds,String value) {
    return (A)withToleration(new Toleration(effect, key, operator, tolerationSeconds, value));
  }
  public KubeSchemaFluentImpl.TolerationNested<A> withNewToleration() {
    return new KubeSchemaFluentImpl.TolerationNestedImpl();
  }
  public KubeSchemaFluentImpl.TolerationNested<A> withNewTolerationLike(Toleration item) {
    return new KubeSchemaFluentImpl.TolerationNestedImpl(item);
  }
  public KubeSchemaFluentImpl.TolerationNested<A> editToleration() {
    return withNewTolerationLike(getToleration());
  }
  public KubeSchemaFluentImpl.TolerationNested<A> editOrNewToleration() {
    return withNewTolerationLike(getToleration() != null ? getToleration(): new TolerationBuilder().build());
  }
  public KubeSchemaFluentImpl.TolerationNested<A> editOrNewTolerationLike(Toleration item) {
    return withNewTolerationLike(getToleration() != null ? getToleration(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildTopologySelectorTerm instead.
   * @return The buildable object.
   */
  @Deprecated
  public TopologySelectorTerm getTopologySelectorTerm() {
    return this.topologySelectorTerm!=null ?this.topologySelectorTerm.build():null;
  }
  public TopologySelectorTerm buildTopologySelectorTerm() {
    return this.topologySelectorTerm!=null ?this.topologySelectorTerm.build():null;
  }
  public A withTopologySelectorTerm(TopologySelectorTerm topologySelectorTerm) {
    _visitables.get("topologySelectorTerm").remove(this.topologySelectorTerm);
    if (topologySelectorTerm!=null){ this.topologySelectorTerm= new TopologySelectorTermBuilder(topologySelectorTerm); _visitables.get("topologySelectorTerm").add(this.topologySelectorTerm);} else { this.topologySelectorTerm = null; _visitables.get("topologySelectorTerm").remove(this.topologySelectorTerm); } return (A) this;
  }
  public Boolean hasTopologySelectorTerm() {
    return this.topologySelectorTerm != null;
  }
  public KubeSchemaFluentImpl.TopologySelectorTermNested<A> withNewTopologySelectorTerm() {
    return new KubeSchemaFluentImpl.TopologySelectorTermNestedImpl();
  }
  public KubeSchemaFluentImpl.TopologySelectorTermNested<A> withNewTopologySelectorTermLike(TopologySelectorTerm item) {
    return new KubeSchemaFluentImpl.TopologySelectorTermNestedImpl(item);
  }
  public KubeSchemaFluentImpl.TopologySelectorTermNested<A> editTopologySelectorTerm() {
    return withNewTopologySelectorTermLike(getTopologySelectorTerm());
  }
  public KubeSchemaFluentImpl.TopologySelectorTermNested<A> editOrNewTopologySelectorTerm() {
    return withNewTopologySelectorTermLike(getTopologySelectorTerm() != null ? getTopologySelectorTerm(): new TopologySelectorTermBuilder().build());
  }
  public KubeSchemaFluentImpl.TopologySelectorTermNested<A> editOrNewTopologySelectorTermLike(TopologySelectorTerm item) {
    return withNewTopologySelectorTermLike(getTopologySelectorTerm() != null ? getTopologySelectorTerm(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildTypeMeta instead.
   * @return The buildable object.
   */
  @Deprecated
  public TypeMeta getTypeMeta() {
    return this.typeMeta!=null ?this.typeMeta.build():null;
  }
  public TypeMeta buildTypeMeta() {
    return this.typeMeta!=null ?this.typeMeta.build():null;
  }
  public A withTypeMeta(TypeMeta typeMeta) {
    _visitables.get("typeMeta").remove(this.typeMeta);
    if (typeMeta!=null){ this.typeMeta= new TypeMetaBuilder(typeMeta); _visitables.get("typeMeta").add(this.typeMeta);} else { this.typeMeta = null; _visitables.get("typeMeta").remove(this.typeMeta); } return (A) this;
  }
  public Boolean hasTypeMeta() {
    return this.typeMeta != null;
  }
  public A withNewTypeMeta(String apiVersion,String kind) {
    return (A)withTypeMeta(new TypeMeta(apiVersion, kind));
  }
  public KubeSchemaFluentImpl.TypeMetaNested<A> withNewTypeMeta() {
    return new KubeSchemaFluentImpl.TypeMetaNestedImpl();
  }
  public KubeSchemaFluentImpl.TypeMetaNested<A> withNewTypeMetaLike(TypeMeta item) {
    return new KubeSchemaFluentImpl.TypeMetaNestedImpl(item);
  }
  public KubeSchemaFluentImpl.TypeMetaNested<A> editTypeMeta() {
    return withNewTypeMetaLike(getTypeMeta());
  }
  public KubeSchemaFluentImpl.TypeMetaNested<A> editOrNewTypeMeta() {
    return withNewTypeMetaLike(getTypeMeta() != null ? getTypeMeta(): new TypeMetaBuilder().build());
  }
  public KubeSchemaFluentImpl.TypeMetaNested<A> editOrNewTypeMetaLike(TypeMeta item) {
    return withNewTypeMetaLike(getTypeMeta() != null ? getTypeMeta(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildUpdateOptions instead.
   * @return The buildable object.
   */
  @Deprecated
  public UpdateOptions getUpdateOptions() {
    return this.updateOptions!=null ?this.updateOptions.build():null;
  }
  public UpdateOptions buildUpdateOptions() {
    return this.updateOptions!=null ?this.updateOptions.build():null;
  }
  public A withUpdateOptions(UpdateOptions updateOptions) {
    _visitables.get("updateOptions").remove(this.updateOptions);
    if (updateOptions!=null){ this.updateOptions= new UpdateOptionsBuilder(updateOptions); _visitables.get("updateOptions").add(this.updateOptions);} else { this.updateOptions = null; _visitables.get("updateOptions").remove(this.updateOptions); } return (A) this;
  }
  public Boolean hasUpdateOptions() {
    return this.updateOptions != null;
  }
  public KubeSchemaFluentImpl.UpdateOptionsNested<A> withNewUpdateOptions() {
    return new KubeSchemaFluentImpl.UpdateOptionsNestedImpl();
  }
  public KubeSchemaFluentImpl.UpdateOptionsNested<A> withNewUpdateOptionsLike(UpdateOptions item) {
    return new KubeSchemaFluentImpl.UpdateOptionsNestedImpl(item);
  }
  public KubeSchemaFluentImpl.UpdateOptionsNested<A> editUpdateOptions() {
    return withNewUpdateOptionsLike(getUpdateOptions());
  }
  public KubeSchemaFluentImpl.UpdateOptionsNested<A> editOrNewUpdateOptions() {
    return withNewUpdateOptionsLike(getUpdateOptions() != null ? getUpdateOptions(): new UpdateOptionsBuilder().build());
  }
  public KubeSchemaFluentImpl.UpdateOptionsNested<A> editOrNewUpdateOptionsLike(UpdateOptions item) {
    return withNewUpdateOptionsLike(getUpdateOptions() != null ? getUpdateOptions(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildWatchEvent instead.
   * @return The buildable object.
   */
  @Deprecated
  public WatchEvent getWatchEvent() {
    return this.watchEvent!=null ?this.watchEvent.build():null;
  }
  public WatchEvent buildWatchEvent() {
    return this.watchEvent!=null ?this.watchEvent.build():null;
  }
  public A withWatchEvent(WatchEvent watchEvent) {
    _visitables.get("watchEvent").remove(this.watchEvent);
    if (watchEvent!=null){ this.watchEvent= new WatchEventBuilder(watchEvent); _visitables.get("watchEvent").add(this.watchEvent);} else { this.watchEvent = null; _visitables.get("watchEvent").remove(this.watchEvent); } return (A) this;
  }
  public Boolean hasWatchEvent() {
    return this.watchEvent != null;
  }
  public KubeSchemaFluentImpl.WatchEventNested<A> withNewWatchEvent() {
    return new KubeSchemaFluentImpl.WatchEventNestedImpl();
  }
  public KubeSchemaFluentImpl.WatchEventNested<A> withNewWatchEventLike(WatchEvent item) {
    return new KubeSchemaFluentImpl.WatchEventNestedImpl(item);
  }
  public KubeSchemaFluentImpl.WatchEventNested<A> editWatchEvent() {
    return withNewWatchEventLike(getWatchEvent());
  }
  public KubeSchemaFluentImpl.WatchEventNested<A> editOrNewWatchEvent() {
    return withNewWatchEventLike(getWatchEvent() != null ? getWatchEvent(): new WatchEventBuilder().build());
  }
  public KubeSchemaFluentImpl.WatchEventNested<A> editOrNewWatchEventLike(WatchEvent item) {
    return withNewWatchEventLike(getWatchEvent() != null ? getWatchEvent(): item);
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    KubeSchemaFluentImpl that = (KubeSchemaFluentImpl) o;
    if (!java.util.Objects.equals(aPIGroup, that.aPIGroup)) return false;

    if (!java.util.Objects.equals(aPIGroupList, that.aPIGroupList)) return false;

    if (!java.util.Objects.equals(aPIResource, that.aPIResource)) return false;

    if (!java.util.Objects.equals(aPIResourceList, that.aPIResourceList)) return false;

    if (!java.util.Objects.equals(aPIService, that.aPIService)) return false;

    if (!java.util.Objects.equals(aPIServiceList, that.aPIServiceList)) return false;

    if (!java.util.Objects.equals(binding, that.binding)) return false;

    if (!java.util.Objects.equals(componentStatus, that.componentStatus)) return false;

    if (!java.util.Objects.equals(componentStatusList, that.componentStatusList)) return false;

    if (!java.util.Objects.equals(condition, that.condition)) return false;

    if (!java.util.Objects.equals(config, that.config)) return false;

    if (!java.util.Objects.equals(configMap, that.configMap)) return false;

    if (!java.util.Objects.equals(configMapList, that.configMapList)) return false;

    if (!java.util.Objects.equals(containerStatus, that.containerStatus)) return false;

    if (!java.util.Objects.equals(createOptions, that.createOptions)) return false;

    if (!java.util.Objects.equals(deleteOptions, that.deleteOptions)) return false;

    if (!java.util.Objects.equals(endpointPort, that.endpointPort)) return false;

    if (!java.util.Objects.equals(endpoints, that.endpoints)) return false;

    if (!java.util.Objects.equals(endpointsList, that.endpointsList)) return false;

    if (!java.util.Objects.equals(envVar, that.envVar)) return false;

    if (!java.util.Objects.equals(event, that.event)) return false;

    if (!java.util.Objects.equals(eventList, that.eventList)) return false;

    if (!java.util.Objects.equals(eventSeries, that.eventSeries)) return false;

    if (!java.util.Objects.equals(eventSource, that.eventSource)) return false;

    if (!java.util.Objects.equals(getOptions, that.getOptions)) return false;

    if (!java.util.Objects.equals(groupKind, that.groupKind)) return false;

    if (!java.util.Objects.equals(groupVersionKind, that.groupVersionKind)) return false;

    if (!java.util.Objects.equals(groupVersionResource, that.groupVersionResource)) return false;

    if (!java.util.Objects.equals(info, that.info)) return false;

    if (!java.util.Objects.equals(kubernetesList, that.kubernetesList)) return false;

    if (!java.util.Objects.equals(limitRangeList, that.limitRangeList)) return false;

    if (!java.util.Objects.equals(listOptions, that.listOptions)) return false;

    if (!java.util.Objects.equals(microTime, that.microTime)) return false;

    if (!java.util.Objects.equals(namespace, that.namespace)) return false;

    if (!java.util.Objects.equals(namespaceList, that.namespaceList)) return false;

    if (!java.util.Objects.equals(node, that.node)) return false;

    if (!java.util.Objects.equals(nodeList, that.nodeList)) return false;

    if (!java.util.Objects.equals(objectMeta, that.objectMeta)) return false;

    if (!java.util.Objects.equals(patch, that.patch)) return false;

    if (!java.util.Objects.equals(patchOptions, that.patchOptions)) return false;

    if (!java.util.Objects.equals(persistentVolume, that.persistentVolume)) return false;

    if (!java.util.Objects.equals(persistentVolumeClaim, that.persistentVolumeClaim)) return false;

    if (!java.util.Objects.equals(persistentVolumeClaimList, that.persistentVolumeClaimList)) return false;

    if (!java.util.Objects.equals(persistentVolumeList, that.persistentVolumeList)) return false;

    if (!java.util.Objects.equals(podExecOptions, that.podExecOptions)) return false;

    if (!java.util.Objects.equals(podList, that.podList)) return false;

    if (!java.util.Objects.equals(podTemplateList, that.podTemplateList)) return false;

    if (!java.util.Objects.equals(quantity, that.quantity)) return false;

    if (!java.util.Objects.equals(replicationControllerList, that.replicationControllerList)) return false;

    if (!java.util.Objects.equals(resourceQuota, that.resourceQuota)) return false;

    if (!java.util.Objects.equals(resourceQuotaList, that.resourceQuotaList)) return false;

    if (!java.util.Objects.equals(rootPaths, that.rootPaths)) return false;

    if (!java.util.Objects.equals(secret, that.secret)) return false;

    if (!java.util.Objects.equals(secretList, that.secretList)) return false;

    if (!java.util.Objects.equals(serviceAccount, that.serviceAccount)) return false;

    if (!java.util.Objects.equals(serviceAccountList, that.serviceAccountList)) return false;

    if (!java.util.Objects.equals(serviceList, that.serviceList)) return false;

    if (!java.util.Objects.equals(status, that.status)) return false;

    if (!java.util.Objects.equals(time, that.time)) return false;

    if (!java.util.Objects.equals(toleration, that.toleration)) return false;

    if (!java.util.Objects.equals(topologySelectorTerm, that.topologySelectorTerm)) return false;

    if (!java.util.Objects.equals(typeMeta, that.typeMeta)) return false;

    if (!java.util.Objects.equals(updateOptions, that.updateOptions)) return false;

    if (!java.util.Objects.equals(watchEvent, that.watchEvent)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(aPIGroup,  aPIGroupList,  aPIResource,  aPIResourceList,  aPIService,  aPIServiceList,  binding,  componentStatus,  componentStatusList,  condition,  config,  configMap,  configMapList,  containerStatus,  createOptions,  deleteOptions,  endpointPort,  endpoints,  endpointsList,  envVar,  event,  eventList,  eventSeries,  eventSource,  getOptions,  groupKind,  groupVersionKind,  groupVersionResource,  info,  kubernetesList,  limitRangeList,  listOptions,  microTime,  namespace,  namespaceList,  node,  nodeList,  objectMeta,  patch,  patchOptions,  persistentVolume,  persistentVolumeClaim,  persistentVolumeClaimList,  persistentVolumeList,  podExecOptions,  podList,  podTemplateList,  quantity,  replicationControllerList,  resourceQuota,  resourceQuotaList,  rootPaths,  secret,  secretList,  serviceAccount,  serviceAccountList,  serviceList,  status,  time,  toleration,  topologySelectorTerm,  typeMeta,  updateOptions,  watchEvent,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (aPIGroup != null) { sb.append("aPIGroup:"); sb.append(aPIGroup + ","); }
    if (aPIGroupList != null) { sb.append("aPIGroupList:"); sb.append(aPIGroupList + ","); }
    if (aPIResource != null) { sb.append("aPIResource:"); sb.append(aPIResource + ","); }
    if (aPIResourceList != null) { sb.append("aPIResourceList:"); sb.append(aPIResourceList + ","); }
    if (aPIService != null) { sb.append("aPIService:"); sb.append(aPIService + ","); }
    if (aPIServiceList != null) { sb.append("aPIServiceList:"); sb.append(aPIServiceList + ","); }
    if (binding != null) { sb.append("binding:"); sb.append(binding + ","); }
    if (componentStatus != null) { sb.append("componentStatus:"); sb.append(componentStatus + ","); }
    if (componentStatusList != null) { sb.append("componentStatusList:"); sb.append(componentStatusList + ","); }
    if (condition != null) { sb.append("condition:"); sb.append(condition + ","); }
    if (config != null) { sb.append("config:"); sb.append(config + ","); }
    if (configMap != null) { sb.append("configMap:"); sb.append(configMap + ","); }
    if (configMapList != null) { sb.append("configMapList:"); sb.append(configMapList + ","); }
    if (containerStatus != null) { sb.append("containerStatus:"); sb.append(containerStatus + ","); }
    if (createOptions != null) { sb.append("createOptions:"); sb.append(createOptions + ","); }
    if (deleteOptions != null) { sb.append("deleteOptions:"); sb.append(deleteOptions + ","); }
    if (endpointPort != null) { sb.append("endpointPort:"); sb.append(endpointPort + ","); }
    if (endpoints != null) { sb.append("endpoints:"); sb.append(endpoints + ","); }
    if (endpointsList != null) { sb.append("endpointsList:"); sb.append(endpointsList + ","); }
    if (envVar != null) { sb.append("envVar:"); sb.append(envVar + ","); }
    if (event != null) { sb.append("event:"); sb.append(event + ","); }
    if (eventList != null) { sb.append("eventList:"); sb.append(eventList + ","); }
    if (eventSeries != null) { sb.append("eventSeries:"); sb.append(eventSeries + ","); }
    if (eventSource != null) { sb.append("eventSource:"); sb.append(eventSource + ","); }
    if (getOptions != null) { sb.append("getOptions:"); sb.append(getOptions + ","); }
    if (groupKind != null) { sb.append("groupKind:"); sb.append(groupKind + ","); }
    if (groupVersionKind != null) { sb.append("groupVersionKind:"); sb.append(groupVersionKind + ","); }
    if (groupVersionResource != null) { sb.append("groupVersionResource:"); sb.append(groupVersionResource + ","); }
    if (info != null) { sb.append("info:"); sb.append(info + ","); }
    if (kubernetesList != null) { sb.append("kubernetesList:"); sb.append(kubernetesList + ","); }
    if (limitRangeList != null) { sb.append("limitRangeList:"); sb.append(limitRangeList + ","); }
    if (listOptions != null) { sb.append("listOptions:"); sb.append(listOptions + ","); }
    if (microTime != null) { sb.append("microTime:"); sb.append(microTime + ","); }
    if (namespace != null) { sb.append("namespace:"); sb.append(namespace + ","); }
    if (namespaceList != null) { sb.append("namespaceList:"); sb.append(namespaceList + ","); }
    if (node != null) { sb.append("node:"); sb.append(node + ","); }
    if (nodeList != null) { sb.append("nodeList:"); sb.append(nodeList + ","); }
    if (objectMeta != null) { sb.append("objectMeta:"); sb.append(objectMeta + ","); }
    if (patch != null) { sb.append("patch:"); sb.append(patch + ","); }
    if (patchOptions != null) { sb.append("patchOptions:"); sb.append(patchOptions + ","); }
    if (persistentVolume != null) { sb.append("persistentVolume:"); sb.append(persistentVolume + ","); }
    if (persistentVolumeClaim != null) { sb.append("persistentVolumeClaim:"); sb.append(persistentVolumeClaim + ","); }
    if (persistentVolumeClaimList != null) { sb.append("persistentVolumeClaimList:"); sb.append(persistentVolumeClaimList + ","); }
    if (persistentVolumeList != null) { sb.append("persistentVolumeList:"); sb.append(persistentVolumeList + ","); }
    if (podExecOptions != null) { sb.append("podExecOptions:"); sb.append(podExecOptions + ","); }
    if (podList != null) { sb.append("podList:"); sb.append(podList + ","); }
    if (podTemplateList != null) { sb.append("podTemplateList:"); sb.append(podTemplateList + ","); }
    if (quantity != null) { sb.append("quantity:"); sb.append(quantity + ","); }
    if (replicationControllerList != null) { sb.append("replicationControllerList:"); sb.append(replicationControllerList + ","); }
    if (resourceQuota != null) { sb.append("resourceQuota:"); sb.append(resourceQuota + ","); }
    if (resourceQuotaList != null) { sb.append("resourceQuotaList:"); sb.append(resourceQuotaList + ","); }
    if (rootPaths != null) { sb.append("rootPaths:"); sb.append(rootPaths + ","); }
    if (secret != null) { sb.append("secret:"); sb.append(secret + ","); }
    if (secretList != null) { sb.append("secretList:"); sb.append(secretList + ","); }
    if (serviceAccount != null) { sb.append("serviceAccount:"); sb.append(serviceAccount + ","); }
    if (serviceAccountList != null) { sb.append("serviceAccountList:"); sb.append(serviceAccountList + ","); }
    if (serviceList != null) { sb.append("serviceList:"); sb.append(serviceList + ","); }
    if (status != null) { sb.append("status:"); sb.append(status + ","); }
    if (time != null) { sb.append("time:"); sb.append(time + ","); }
    if (toleration != null) { sb.append("toleration:"); sb.append(toleration + ","); }
    if (topologySelectorTerm != null) { sb.append("topologySelectorTerm:"); sb.append(topologySelectorTerm + ","); }
    if (typeMeta != null) { sb.append("typeMeta:"); sb.append(typeMeta + ","); }
    if (updateOptions != null) { sb.append("updateOptions:"); sb.append(updateOptions + ","); }
    if (watchEvent != null) { sb.append("watchEvent:"); sb.append(watchEvent + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class APIGroupNestedImpl<N> extends APIGroupFluentImpl<KubeSchemaFluentImpl.APIGroupNested<N>> implements KubeSchemaFluentImpl.APIGroupNested<N>,Nested<N>{
    APIGroupNestedImpl(APIGroup item) {
      this.builder = new APIGroupBuilder(this, item);
    }
    APIGroupNestedImpl() {
      this.builder = new APIGroupBuilder(this);
    }
    APIGroupBuilder builder;
    public N and() {
      return (N) KubeSchemaFluentImpl.this.withAPIGroup(builder.build());
    }
    public N endAPIGroup() {
      return and();
    }
    
  }
  class APIGroupListNestedImpl<N> extends APIGroupListFluentImpl<KubeSchemaFluentImpl.APIGroupListNested<N>> implements KubeSchemaFluentImpl.APIGroupListNested<N>,Nested<N>{
    APIGroupListNestedImpl(APIGroupList item) {
      this.builder = new APIGroupListBuilder(this, item);
    }
    APIGroupListNestedImpl() {
      this.builder = new APIGroupListBuilder(this);
    }
    APIGroupListBuilder builder;
    public N and() {
      return (N) KubeSchemaFluentImpl.this.withAPIGroupList(builder.build());
    }
    public N endAPIGroupList() {
      return and();
    }
    
  }
  class APIResourceNestedImpl<N> extends APIResourceFluentImpl<KubeSchemaFluentImpl.APIResourceNested<N>> implements KubeSchemaFluentImpl.APIResourceNested<N>,Nested<N>{
    APIResourceNestedImpl(APIResource item) {
      this.builder = new APIResourceBuilder(this, item);
    }
    APIResourceNestedImpl() {
      this.builder = new APIResourceBuilder(this);
    }
    APIResourceBuilder builder;
    public N and() {
      return (N) KubeSchemaFluentImpl.this.withAPIResource(builder.build());
    }
    public N endAPIResource() {
      return and();
    }
    
  }
  class APIResourceListNestedImpl<N> extends APIResourceListFluentImpl<KubeSchemaFluentImpl.APIResourceListNested<N>> implements KubeSchemaFluentImpl.APIResourceListNested<N>,Nested<N>{
    APIResourceListNestedImpl(APIResourceList item) {
      this.builder = new APIResourceListBuilder(this, item);
    }
    APIResourceListNestedImpl() {
      this.builder = new APIResourceListBuilder(this);
    }
    APIResourceListBuilder builder;
    public N and() {
      return (N) KubeSchemaFluentImpl.this.withAPIResourceList(builder.build());
    }
    public N endAPIResourceList() {
      return and();
    }
    
  }
  class APIServiceNestedImpl<N> extends APIServiceFluentImpl<KubeSchemaFluentImpl.APIServiceNested<N>> implements KubeSchemaFluentImpl.APIServiceNested<N>,Nested<N>{
    APIServiceNestedImpl(APIService item) {
      this.builder = new APIServiceBuilder(this, item);
    }
    APIServiceNestedImpl() {
      this.builder = new APIServiceBuilder(this);
    }
    APIServiceBuilder builder;
    public N and() {
      return (N) KubeSchemaFluentImpl.this.withAPIService(builder.build());
    }
    public N endAPIService() {
      return and();
    }
    
  }
  class APIServiceListNestedImpl<N> extends APIServiceListFluentImpl<KubeSchemaFluentImpl.APIServiceListNested<N>> implements KubeSchemaFluentImpl.APIServiceListNested<N>,Nested<N>{
    APIServiceListNestedImpl(APIServiceList item) {
      this.builder = new APIServiceListBuilder(this, item);
    }
    APIServiceListNestedImpl() {
      this.builder = new APIServiceListBuilder(this);
    }
    APIServiceListBuilder builder;
    public N and() {
      return (N) KubeSchemaFluentImpl.this.withAPIServiceList(builder.build());
    }
    public N endAPIServiceList() {
      return and();
    }
    
  }
  class BindingNestedImpl<N> extends BindingFluentImpl<KubeSchemaFluentImpl.BindingNested<N>> implements KubeSchemaFluentImpl.BindingNested<N>,Nested<N>{
    BindingNestedImpl(Binding item) {
      this.builder = new BindingBuilder(this, item);
    }
    BindingNestedImpl() {
      this.builder = new BindingBuilder(this);
    }
    BindingBuilder builder;
    public N and() {
      return (N) KubeSchemaFluentImpl.this.withBinding(builder.build());
    }
    public N endBinding() {
      return and();
    }
    
  }
  class ComponentStatusNestedImpl<N> extends ComponentStatusFluentImpl<KubeSchemaFluentImpl.ComponentStatusNested<N>> implements KubeSchemaFluentImpl.ComponentStatusNested<N>,Nested<N>{
    ComponentStatusNestedImpl(ComponentStatus item) {
      this.builder = new ComponentStatusBuilder(this, item);
    }
    ComponentStatusNestedImpl() {
      this.builder = new ComponentStatusBuilder(this);
    }
    ComponentStatusBuilder builder;
    public N and() {
      return (N) KubeSchemaFluentImpl.this.withComponentStatus(builder.build());
    }
    public N endComponentStatus() {
      return and();
    }
    
  }
  class ComponentStatusListNestedImpl<N> extends ComponentStatusListFluentImpl<KubeSchemaFluentImpl.ComponentStatusListNested<N>> implements KubeSchemaFluentImpl.ComponentStatusListNested<N>,Nested<N>{
    ComponentStatusListNestedImpl(ComponentStatusList item) {
      this.builder = new ComponentStatusListBuilder(this, item);
    }
    ComponentStatusListNestedImpl() {
      this.builder = new ComponentStatusListBuilder(this);
    }
    ComponentStatusListBuilder builder;
    public N and() {
      return (N) KubeSchemaFluentImpl.this.withComponentStatusList(builder.build());
    }
    public N endComponentStatusList() {
      return and();
    }
    
  }
  class ConditionNestedImpl<N> extends ConditionFluentImpl<KubeSchemaFluentImpl.ConditionNested<N>> implements KubeSchemaFluentImpl.ConditionNested<N>,Nested<N>{
    ConditionNestedImpl(Condition item) {
      this.builder = new ConditionBuilder(this, item);
    }
    ConditionNestedImpl() {
      this.builder = new ConditionBuilder(this);
    }
    ConditionBuilder builder;
    public N and() {
      return (N) KubeSchemaFluentImpl.this.withCondition(builder.build());
    }
    public N endCondition() {
      return and();
    }
    
  }
  class ConfigNestedImpl<N> extends ConfigFluentImpl<KubeSchemaFluentImpl.ConfigNested<N>> implements KubeSchemaFluentImpl.ConfigNested<N>,Nested<N>{
    ConfigNestedImpl(Config item) {
      this.builder = new ConfigBuilder(this, item);
    }
    ConfigNestedImpl() {
      this.builder = new ConfigBuilder(this);
    }
    ConfigBuilder builder;
    public N and() {
      return (N) KubeSchemaFluentImpl.this.withConfig(builder.build());
    }
    public N endConfig() {
      return and();
    }
    
  }
  class ConfigMapNestedImpl<N> extends ConfigMapFluentImpl<KubeSchemaFluentImpl.ConfigMapNested<N>> implements KubeSchemaFluentImpl.ConfigMapNested<N>,Nested<N>{
    ConfigMapNestedImpl(ConfigMap item) {
      this.builder = new ConfigMapBuilder(this, item);
    }
    ConfigMapNestedImpl() {
      this.builder = new ConfigMapBuilder(this);
    }
    ConfigMapBuilder builder;
    public N and() {
      return (N) KubeSchemaFluentImpl.this.withConfigMap(builder.build());
    }
    public N endConfigMap() {
      return and();
    }
    
  }
  class ConfigMapListNestedImpl<N> extends ConfigMapListFluentImpl<KubeSchemaFluentImpl.ConfigMapListNested<N>> implements KubeSchemaFluentImpl.ConfigMapListNested<N>,Nested<N>{
    ConfigMapListNestedImpl(ConfigMapList item) {
      this.builder = new ConfigMapListBuilder(this, item);
    }
    ConfigMapListNestedImpl() {
      this.builder = new ConfigMapListBuilder(this);
    }
    ConfigMapListBuilder builder;
    public N and() {
      return (N) KubeSchemaFluentImpl.this.withConfigMapList(builder.build());
    }
    public N endConfigMapList() {
      return and();
    }
    
  }
  class ContainerStatusNestedImpl<N> extends ContainerStatusFluentImpl<KubeSchemaFluentImpl.ContainerStatusNested<N>> implements KubeSchemaFluentImpl.ContainerStatusNested<N>,Nested<N>{
    ContainerStatusNestedImpl(ContainerStatus item) {
      this.builder = new ContainerStatusBuilder(this, item);
    }
    ContainerStatusNestedImpl() {
      this.builder = new ContainerStatusBuilder(this);
    }
    ContainerStatusBuilder builder;
    public N and() {
      return (N) KubeSchemaFluentImpl.this.withContainerStatus(builder.build());
    }
    public N endContainerStatus() {
      return and();
    }
    
  }
  class CreateOptionsNestedImpl<N> extends CreateOptionsFluentImpl<KubeSchemaFluentImpl.CreateOptionsNested<N>> implements KubeSchemaFluentImpl.CreateOptionsNested<N>,Nested<N>{
    CreateOptionsNestedImpl(CreateOptions item) {
      this.builder = new CreateOptionsBuilder(this, item);
    }
    CreateOptionsNestedImpl() {
      this.builder = new CreateOptionsBuilder(this);
    }
    CreateOptionsBuilder builder;
    public N and() {
      return (N) KubeSchemaFluentImpl.this.withCreateOptions(builder.build());
    }
    public N endCreateOptions() {
      return and();
    }
    
  }
  class DeleteOptionsNestedImpl<N> extends DeleteOptionsFluentImpl<KubeSchemaFluentImpl.DeleteOptionsNested<N>> implements KubeSchemaFluentImpl.DeleteOptionsNested<N>,Nested<N>{
    DeleteOptionsNestedImpl(DeleteOptions item) {
      this.builder = new DeleteOptionsBuilder(this, item);
    }
    DeleteOptionsNestedImpl() {
      this.builder = new DeleteOptionsBuilder(this);
    }
    DeleteOptionsBuilder builder;
    public N and() {
      return (N) KubeSchemaFluentImpl.this.withDeleteOptions(builder.build());
    }
    public N endDeleteOptions() {
      return and();
    }
    
  }
  class EndpointPortNestedImpl<N> extends EndpointPortFluentImpl<KubeSchemaFluentImpl.EndpointPortNested<N>> implements KubeSchemaFluentImpl.EndpointPortNested<N>,Nested<N>{
    EndpointPortNestedImpl(EndpointPort item) {
      this.builder = new EndpointPortBuilder(this, item);
    }
    EndpointPortNestedImpl() {
      this.builder = new EndpointPortBuilder(this);
    }
    EndpointPortBuilder builder;
    public N and() {
      return (N) KubeSchemaFluentImpl.this.withEndpointPort(builder.build());
    }
    public N endEndpointPort() {
      return and();
    }
    
  }
  class EndpointsNestedImpl<N> extends EndpointsFluentImpl<KubeSchemaFluentImpl.EndpointsNested<N>> implements KubeSchemaFluentImpl.EndpointsNested<N>,Nested<N>{
    EndpointsNestedImpl(Endpoints item) {
      this.builder = new EndpointsBuilder(this, item);
    }
    EndpointsNestedImpl() {
      this.builder = new EndpointsBuilder(this);
    }
    EndpointsBuilder builder;
    public N and() {
      return (N) KubeSchemaFluentImpl.this.withEndpoints(builder.build());
    }
    public N endEndpoints() {
      return and();
    }
    
  }
  class EndpointsListNestedImpl<N> extends EndpointsListFluentImpl<KubeSchemaFluentImpl.EndpointsListNested<N>> implements KubeSchemaFluentImpl.EndpointsListNested<N>,Nested<N>{
    EndpointsListNestedImpl(EndpointsList item) {
      this.builder = new EndpointsListBuilder(this, item);
    }
    EndpointsListNestedImpl() {
      this.builder = new EndpointsListBuilder(this);
    }
    EndpointsListBuilder builder;
    public N and() {
      return (N) KubeSchemaFluentImpl.this.withEndpointsList(builder.build());
    }
    public N endEndpointsList() {
      return and();
    }
    
  }
  class EnvVarNestedImpl<N> extends EnvVarFluentImpl<KubeSchemaFluentImpl.EnvVarNested<N>> implements KubeSchemaFluentImpl.EnvVarNested<N>,Nested<N>{
    EnvVarNestedImpl(EnvVar item) {
      this.builder = new EnvVarBuilder(this, item);
    }
    EnvVarNestedImpl() {
      this.builder = new EnvVarBuilder(this);
    }
    EnvVarBuilder builder;
    public N and() {
      return (N) KubeSchemaFluentImpl.this.withEnvVar(builder.build());
    }
    public N endEnvVar() {
      return and();
    }
    
  }
  class EventNestedImpl<N> extends EventFluentImpl<KubeSchemaFluentImpl.EventNested<N>> implements KubeSchemaFluentImpl.EventNested<N>,Nested<N>{
    EventNestedImpl(Event item) {
      this.builder = new EventBuilder(this, item);
    }
    EventNestedImpl() {
      this.builder = new EventBuilder(this);
    }
    EventBuilder builder;
    public N and() {
      return (N) KubeSchemaFluentImpl.this.withEvent(builder.build());
    }
    public N endEvent() {
      return and();
    }
    
  }
  class EventListNestedImpl<N> extends EventListFluentImpl<KubeSchemaFluentImpl.EventListNested<N>> implements KubeSchemaFluentImpl.EventListNested<N>,Nested<N>{
    EventListNestedImpl(EventList item) {
      this.builder = new EventListBuilder(this, item);
    }
    EventListNestedImpl() {
      this.builder = new EventListBuilder(this);
    }
    EventListBuilder builder;
    public N and() {
      return (N) KubeSchemaFluentImpl.this.withEventList(builder.build());
    }
    public N endEventList() {
      return and();
    }
    
  }
  class EventSeriesNestedImpl<N> extends EventSeriesFluentImpl<KubeSchemaFluentImpl.EventSeriesNested<N>> implements KubeSchemaFluentImpl.EventSeriesNested<N>,Nested<N>{
    EventSeriesNestedImpl(EventSeries item) {
      this.builder = new EventSeriesBuilder(this, item);
    }
    EventSeriesNestedImpl() {
      this.builder = new EventSeriesBuilder(this);
    }
    EventSeriesBuilder builder;
    public N and() {
      return (N) KubeSchemaFluentImpl.this.withEventSeries(builder.build());
    }
    public N endEventSeries() {
      return and();
    }
    
  }
  class EventSourceNestedImpl<N> extends EventSourceFluentImpl<KubeSchemaFluentImpl.EventSourceNested<N>> implements KubeSchemaFluentImpl.EventSourceNested<N>,Nested<N>{
    EventSourceNestedImpl(EventSource item) {
      this.builder = new EventSourceBuilder(this, item);
    }
    EventSourceNestedImpl() {
      this.builder = new EventSourceBuilder(this);
    }
    EventSourceBuilder builder;
    public N and() {
      return (N) KubeSchemaFluentImpl.this.withEventSource(builder.build());
    }
    public N endEventSource() {
      return and();
    }
    
  }
  class GetOptionsNestedImpl<N> extends GetOptionsFluentImpl<KubeSchemaFluentImpl.GetOptionsNested<N>> implements KubeSchemaFluentImpl.GetOptionsNested<N>,Nested<N>{
    GetOptionsNestedImpl(GetOptions item) {
      this.builder = new GetOptionsBuilder(this, item);
    }
    GetOptionsNestedImpl() {
      this.builder = new GetOptionsBuilder(this);
    }
    GetOptionsBuilder builder;
    public N and() {
      return (N) KubeSchemaFluentImpl.this.withGetOptions(builder.build());
    }
    public N endGetOptions() {
      return and();
    }
    
  }
  class GroupKindNestedImpl<N> extends GroupKindFluentImpl<KubeSchemaFluentImpl.GroupKindNested<N>> implements KubeSchemaFluentImpl.GroupKindNested<N>,Nested<N>{
    GroupKindNestedImpl(GroupKind item) {
      this.builder = new GroupKindBuilder(this, item);
    }
    GroupKindNestedImpl() {
      this.builder = new GroupKindBuilder(this);
    }
    GroupKindBuilder builder;
    public N and() {
      return (N) KubeSchemaFluentImpl.this.withGroupKind(builder.build());
    }
    public N endGroupKind() {
      return and();
    }
    
  }
  class GroupVersionKindNestedImpl<N> extends GroupVersionKindFluentImpl<KubeSchemaFluentImpl.GroupVersionKindNested<N>> implements KubeSchemaFluentImpl.GroupVersionKindNested<N>,Nested<N>{
    GroupVersionKindNestedImpl(GroupVersionKind item) {
      this.builder = new GroupVersionKindBuilder(this, item);
    }
    GroupVersionKindNestedImpl() {
      this.builder = new GroupVersionKindBuilder(this);
    }
    GroupVersionKindBuilder builder;
    public N and() {
      return (N) KubeSchemaFluentImpl.this.withGroupVersionKind(builder.build());
    }
    public N endGroupVersionKind() {
      return and();
    }
    
  }
  class GroupVersionResourceNestedImpl<N> extends GroupVersionResourceFluentImpl<KubeSchemaFluentImpl.GroupVersionResourceNested<N>> implements KubeSchemaFluentImpl.GroupVersionResourceNested<N>,Nested<N>{
    GroupVersionResourceNestedImpl(GroupVersionResource item) {
      this.builder = new GroupVersionResourceBuilder(this, item);
    }
    GroupVersionResourceNestedImpl() {
      this.builder = new GroupVersionResourceBuilder(this);
    }
    GroupVersionResourceBuilder builder;
    public N and() {
      return (N) KubeSchemaFluentImpl.this.withGroupVersionResource(builder.build());
    }
    public N endGroupVersionResource() {
      return and();
    }
    
  }
  class InfoNestedImpl<N> extends InfoFluentImpl<KubeSchemaFluentImpl.InfoNested<N>> implements KubeSchemaFluentImpl.InfoNested<N>,Nested<N>{
    InfoNestedImpl(Info item) {
      this.builder = new InfoBuilder(this, item);
    }
    InfoNestedImpl() {
      this.builder = new InfoBuilder(this);
    }
    InfoBuilder builder;
    public N and() {
      return (N) KubeSchemaFluentImpl.this.withInfo(builder.build());
    }
    public N endInfo() {
      return and();
    }
    
  }
  class KubernetesListNestedImpl<N> extends KubernetesListFluentImpl<KubeSchemaFluentImpl.KubernetesListNested<N>> implements KubeSchemaFluentImpl.KubernetesListNested<N>,Nested<N>{
    KubernetesListNestedImpl(KubernetesList item) {
      this.builder = new KubernetesListBuilder(this, item);
    }
    KubernetesListNestedImpl() {
      this.builder = new KubernetesListBuilder(this);
    }
    KubernetesListBuilder builder;
    public N and() {
      return (N) KubeSchemaFluentImpl.this.withKubernetesList(builder.build());
    }
    public N endKubernetesList() {
      return and();
    }
    
  }
  class LimitRangeListNestedImpl<N> extends LimitRangeListFluentImpl<KubeSchemaFluentImpl.LimitRangeListNested<N>> implements KubeSchemaFluentImpl.LimitRangeListNested<N>,Nested<N>{
    LimitRangeListNestedImpl(LimitRangeList item) {
      this.builder = new LimitRangeListBuilder(this, item);
    }
    LimitRangeListNestedImpl() {
      this.builder = new LimitRangeListBuilder(this);
    }
    LimitRangeListBuilder builder;
    public N and() {
      return (N) KubeSchemaFluentImpl.this.withLimitRangeList(builder.build());
    }
    public N endLimitRangeList() {
      return and();
    }
    
  }
  class ListOptionsNestedImpl<N> extends ListOptionsFluentImpl<KubeSchemaFluentImpl.ListOptionsNested<N>> implements KubeSchemaFluentImpl.ListOptionsNested<N>,Nested<N>{
    ListOptionsNestedImpl(ListOptions item) {
      this.builder = new ListOptionsBuilder(this, item);
    }
    ListOptionsNestedImpl() {
      this.builder = new ListOptionsBuilder(this);
    }
    ListOptionsBuilder builder;
    public N and() {
      return (N) KubeSchemaFluentImpl.this.withListOptions(builder.build());
    }
    public N endListOptions() {
      return and();
    }
    
  }
  class MicroTimeNestedImpl<N> extends MicroTimeFluentImpl<KubeSchemaFluentImpl.MicroTimeNested<N>> implements KubeSchemaFluentImpl.MicroTimeNested<N>,Nested<N>{
    MicroTimeNestedImpl(MicroTime item) {
      this.builder = new MicroTimeBuilder(this, item);
    }
    MicroTimeNestedImpl() {
      this.builder = new MicroTimeBuilder(this);
    }
    MicroTimeBuilder builder;
    public N and() {
      return (N) KubeSchemaFluentImpl.this.withMicroTime(builder.build());
    }
    public N endMicroTime() {
      return and();
    }
    
  }
  class NamespaceNestedImpl<N> extends NamespaceFluentImpl<KubeSchemaFluentImpl.NamespaceNested<N>> implements KubeSchemaFluentImpl.NamespaceNested<N>,Nested<N>{
    NamespaceNestedImpl(Namespace item) {
      this.builder = new NamespaceBuilder(this, item);
    }
    NamespaceNestedImpl() {
      this.builder = new NamespaceBuilder(this);
    }
    NamespaceBuilder builder;
    public N and() {
      return (N) KubeSchemaFluentImpl.this.withNamespace(builder.build());
    }
    public N endNamespace() {
      return and();
    }
    
  }
  class NamespaceListNestedImpl<N> extends NamespaceListFluentImpl<KubeSchemaFluentImpl.NamespaceListNested<N>> implements KubeSchemaFluentImpl.NamespaceListNested<N>,Nested<N>{
    NamespaceListNestedImpl(NamespaceList item) {
      this.builder = new NamespaceListBuilder(this, item);
    }
    NamespaceListNestedImpl() {
      this.builder = new NamespaceListBuilder(this);
    }
    NamespaceListBuilder builder;
    public N and() {
      return (N) KubeSchemaFluentImpl.this.withNamespaceList(builder.build());
    }
    public N endNamespaceList() {
      return and();
    }
    
  }
  class NodeNestedImpl<N> extends NodeFluentImpl<KubeSchemaFluentImpl.NodeNested<N>> implements KubeSchemaFluentImpl.NodeNested<N>,Nested<N>{
    NodeNestedImpl(Node item) {
      this.builder = new NodeBuilder(this, item);
    }
    NodeNestedImpl() {
      this.builder = new NodeBuilder(this);
    }
    NodeBuilder builder;
    public N and() {
      return (N) KubeSchemaFluentImpl.this.withNode(builder.build());
    }
    public N endNode() {
      return and();
    }
    
  }
  class NodeListNestedImpl<N> extends NodeListFluentImpl<KubeSchemaFluentImpl.NodeListNested<N>> implements KubeSchemaFluentImpl.NodeListNested<N>,Nested<N>{
    NodeListNestedImpl(NodeList item) {
      this.builder = new NodeListBuilder(this, item);
    }
    NodeListNestedImpl() {
      this.builder = new NodeListBuilder(this);
    }
    NodeListBuilder builder;
    public N and() {
      return (N) KubeSchemaFluentImpl.this.withNodeList(builder.build());
    }
    public N endNodeList() {
      return and();
    }
    
  }
  class ObjectMetaNestedImpl<N> extends ObjectMetaFluentImpl<KubeSchemaFluentImpl.ObjectMetaNested<N>> implements KubeSchemaFluentImpl.ObjectMetaNested<N>,Nested<N>{
    ObjectMetaNestedImpl(ObjectMeta item) {
      this.builder = new ObjectMetaBuilder(this, item);
    }
    ObjectMetaNestedImpl() {
      this.builder = new ObjectMetaBuilder(this);
    }
    ObjectMetaBuilder builder;
    public N and() {
      return (N) KubeSchemaFluentImpl.this.withObjectMeta(builder.build());
    }
    public N endObjectMeta() {
      return and();
    }
    
  }
  class PatchNestedImpl<N> extends PatchFluentImpl<KubeSchemaFluentImpl.PatchNested<N>> implements KubeSchemaFluentImpl.PatchNested<N>,Nested<N>{
    PatchNestedImpl(Patch item) {
      this.builder = new PatchBuilder(this, item);
    }
    PatchNestedImpl() {
      this.builder = new PatchBuilder(this);
    }
    PatchBuilder builder;
    public N and() {
      return (N) KubeSchemaFluentImpl.this.withPatch(builder.build());
    }
    public N endPatch() {
      return and();
    }
    
  }
  class PatchOptionsNestedImpl<N> extends PatchOptionsFluentImpl<KubeSchemaFluentImpl.PatchOptionsNested<N>> implements KubeSchemaFluentImpl.PatchOptionsNested<N>,Nested<N>{
    PatchOptionsNestedImpl(PatchOptions item) {
      this.builder = new PatchOptionsBuilder(this, item);
    }
    PatchOptionsNestedImpl() {
      this.builder = new PatchOptionsBuilder(this);
    }
    PatchOptionsBuilder builder;
    public N and() {
      return (N) KubeSchemaFluentImpl.this.withPatchOptions(builder.build());
    }
    public N endPatchOptions() {
      return and();
    }
    
  }
  class PersistentVolumeNestedImpl<N> extends PersistentVolumeFluentImpl<KubeSchemaFluentImpl.PersistentVolumeNested<N>> implements KubeSchemaFluentImpl.PersistentVolumeNested<N>,Nested<N>{
    PersistentVolumeNestedImpl(PersistentVolume item) {
      this.builder = new PersistentVolumeBuilder(this, item);
    }
    PersistentVolumeNestedImpl() {
      this.builder = new PersistentVolumeBuilder(this);
    }
    PersistentVolumeBuilder builder;
    public N and() {
      return (N) KubeSchemaFluentImpl.this.withPersistentVolume(builder.build());
    }
    public N endPersistentVolume() {
      return and();
    }
    
  }
  class PersistentVolumeClaimNestedImpl<N> extends PersistentVolumeClaimFluentImpl<KubeSchemaFluentImpl.PersistentVolumeClaimNested<N>> implements KubeSchemaFluentImpl.PersistentVolumeClaimNested<N>,Nested<N>{
    PersistentVolumeClaimNestedImpl(PersistentVolumeClaim item) {
      this.builder = new PersistentVolumeClaimBuilder(this, item);
    }
    PersistentVolumeClaimNestedImpl() {
      this.builder = new PersistentVolumeClaimBuilder(this);
    }
    PersistentVolumeClaimBuilder builder;
    public N and() {
      return (N) KubeSchemaFluentImpl.this.withPersistentVolumeClaim(builder.build());
    }
    public N endPersistentVolumeClaim() {
      return and();
    }
    
  }
  class PersistentVolumeClaimListNestedImpl<N> extends PersistentVolumeClaimListFluentImpl<KubeSchemaFluentImpl.PersistentVolumeClaimListNested<N>> implements KubeSchemaFluentImpl.PersistentVolumeClaimListNested<N>,Nested<N>{
    PersistentVolumeClaimListNestedImpl(PersistentVolumeClaimList item) {
      this.builder = new PersistentVolumeClaimListBuilder(this, item);
    }
    PersistentVolumeClaimListNestedImpl() {
      this.builder = new PersistentVolumeClaimListBuilder(this);
    }
    PersistentVolumeClaimListBuilder builder;
    public N and() {
      return (N) KubeSchemaFluentImpl.this.withPersistentVolumeClaimList(builder.build());
    }
    public N endPersistentVolumeClaimList() {
      return and();
    }
    
  }
  class PersistentVolumeListNestedImpl<N> extends PersistentVolumeListFluentImpl<KubeSchemaFluentImpl.PersistentVolumeListNested<N>> implements KubeSchemaFluentImpl.PersistentVolumeListNested<N>,Nested<N>{
    PersistentVolumeListNestedImpl(PersistentVolumeList item) {
      this.builder = new PersistentVolumeListBuilder(this, item);
    }
    PersistentVolumeListNestedImpl() {
      this.builder = new PersistentVolumeListBuilder(this);
    }
    PersistentVolumeListBuilder builder;
    public N and() {
      return (N) KubeSchemaFluentImpl.this.withPersistentVolumeList(builder.build());
    }
    public N endPersistentVolumeList() {
      return and();
    }
    
  }
  class PodExecOptionsNestedImpl<N> extends PodExecOptionsFluentImpl<KubeSchemaFluentImpl.PodExecOptionsNested<N>> implements KubeSchemaFluentImpl.PodExecOptionsNested<N>,Nested<N>{
    PodExecOptionsNestedImpl(PodExecOptions item) {
      this.builder = new PodExecOptionsBuilder(this, item);
    }
    PodExecOptionsNestedImpl() {
      this.builder = new PodExecOptionsBuilder(this);
    }
    PodExecOptionsBuilder builder;
    public N and() {
      return (N) KubeSchemaFluentImpl.this.withPodExecOptions(builder.build());
    }
    public N endPodExecOptions() {
      return and();
    }
    
  }
  class PodListNestedImpl<N> extends PodListFluentImpl<KubeSchemaFluentImpl.PodListNested<N>> implements KubeSchemaFluentImpl.PodListNested<N>,Nested<N>{
    PodListNestedImpl(PodList item) {
      this.builder = new PodListBuilder(this, item);
    }
    PodListNestedImpl() {
      this.builder = new PodListBuilder(this);
    }
    PodListBuilder builder;
    public N and() {
      return (N) KubeSchemaFluentImpl.this.withPodList(builder.build());
    }
    public N endPodList() {
      return and();
    }
    
  }
  class PodTemplateListNestedImpl<N> extends PodTemplateListFluentImpl<KubeSchemaFluentImpl.PodTemplateListNested<N>> implements KubeSchemaFluentImpl.PodTemplateListNested<N>,Nested<N>{
    PodTemplateListNestedImpl(PodTemplateList item) {
      this.builder = new PodTemplateListBuilder(this, item);
    }
    PodTemplateListNestedImpl() {
      this.builder = new PodTemplateListBuilder(this);
    }
    PodTemplateListBuilder builder;
    public N and() {
      return (N) KubeSchemaFluentImpl.this.withPodTemplateList(builder.build());
    }
    public N endPodTemplateList() {
      return and();
    }
    
  }
  class QuantityNestedImpl<N> extends QuantityFluentImpl<KubeSchemaFluentImpl.QuantityNested<N>> implements KubeSchemaFluentImpl.QuantityNested<N>,Nested<N>{
    QuantityNestedImpl(Quantity item) {
      this.builder = new QuantityBuilder(this, item);
    }
    QuantityNestedImpl() {
      this.builder = new QuantityBuilder(this);
    }
    QuantityBuilder builder;
    public N and() {
      return (N) KubeSchemaFluentImpl.this.withQuantity(builder.build());
    }
    public N endQuantity() {
      return and();
    }
    
  }
  class ReplicationControllerListNestedImpl<N> extends ReplicationControllerListFluentImpl<KubeSchemaFluentImpl.ReplicationControllerListNested<N>> implements KubeSchemaFluentImpl.ReplicationControllerListNested<N>,Nested<N>{
    ReplicationControllerListNestedImpl(ReplicationControllerList item) {
      this.builder = new ReplicationControllerListBuilder(this, item);
    }
    ReplicationControllerListNestedImpl() {
      this.builder = new ReplicationControllerListBuilder(this);
    }
    ReplicationControllerListBuilder builder;
    public N and() {
      return (N) KubeSchemaFluentImpl.this.withReplicationControllerList(builder.build());
    }
    public N endReplicationControllerList() {
      return and();
    }
    
  }
  class ResourceQuotaNestedImpl<N> extends ResourceQuotaFluentImpl<KubeSchemaFluentImpl.ResourceQuotaNested<N>> implements KubeSchemaFluentImpl.ResourceQuotaNested<N>,Nested<N>{
    ResourceQuotaNestedImpl(ResourceQuota item) {
      this.builder = new ResourceQuotaBuilder(this, item);
    }
    ResourceQuotaNestedImpl() {
      this.builder = new ResourceQuotaBuilder(this);
    }
    ResourceQuotaBuilder builder;
    public N and() {
      return (N) KubeSchemaFluentImpl.this.withResourceQuota(builder.build());
    }
    public N endResourceQuota() {
      return and();
    }
    
  }
  class ResourceQuotaListNestedImpl<N> extends ResourceQuotaListFluentImpl<KubeSchemaFluentImpl.ResourceQuotaListNested<N>> implements KubeSchemaFluentImpl.ResourceQuotaListNested<N>,Nested<N>{
    ResourceQuotaListNestedImpl(ResourceQuotaList item) {
      this.builder = new ResourceQuotaListBuilder(this, item);
    }
    ResourceQuotaListNestedImpl() {
      this.builder = new ResourceQuotaListBuilder(this);
    }
    ResourceQuotaListBuilder builder;
    public N and() {
      return (N) KubeSchemaFluentImpl.this.withResourceQuotaList(builder.build());
    }
    public N endResourceQuotaList() {
      return and();
    }
    
  }
  class RootPathsNestedImpl<N> extends RootPathsFluentImpl<KubeSchemaFluentImpl.RootPathsNested<N>> implements KubeSchemaFluentImpl.RootPathsNested<N>,Nested<N>{
    RootPathsNestedImpl(RootPaths item) {
      this.builder = new RootPathsBuilder(this, item);
    }
    RootPathsNestedImpl() {
      this.builder = new RootPathsBuilder(this);
    }
    RootPathsBuilder builder;
    public N and() {
      return (N) KubeSchemaFluentImpl.this.withRootPaths(builder.build());
    }
    public N endRootPaths() {
      return and();
    }
    
  }
  class SecretNestedImpl<N> extends SecretFluentImpl<KubeSchemaFluentImpl.SecretNested<N>> implements KubeSchemaFluentImpl.SecretNested<N>,Nested<N>{
    SecretNestedImpl(Secret item) {
      this.builder = new SecretBuilder(this, item);
    }
    SecretNestedImpl() {
      this.builder = new SecretBuilder(this);
    }
    SecretBuilder builder;
    public N and() {
      return (N) KubeSchemaFluentImpl.this.withSecret(builder.build());
    }
    public N endSecret() {
      return and();
    }
    
  }
  class SecretListNestedImpl<N> extends SecretListFluentImpl<KubeSchemaFluentImpl.SecretListNested<N>> implements KubeSchemaFluentImpl.SecretListNested<N>,Nested<N>{
    SecretListNestedImpl(SecretList item) {
      this.builder = new SecretListBuilder(this, item);
    }
    SecretListNestedImpl() {
      this.builder = new SecretListBuilder(this);
    }
    SecretListBuilder builder;
    public N and() {
      return (N) KubeSchemaFluentImpl.this.withSecretList(builder.build());
    }
    public N endSecretList() {
      return and();
    }
    
  }
  class ServiceAccountNestedImpl<N> extends ServiceAccountFluentImpl<KubeSchemaFluentImpl.ServiceAccountNested<N>> implements KubeSchemaFluentImpl.ServiceAccountNested<N>,Nested<N>{
    ServiceAccountNestedImpl(ServiceAccount item) {
      this.builder = new ServiceAccountBuilder(this, item);
    }
    ServiceAccountNestedImpl() {
      this.builder = new ServiceAccountBuilder(this);
    }
    ServiceAccountBuilder builder;
    public N and() {
      return (N) KubeSchemaFluentImpl.this.withServiceAccount(builder.build());
    }
    public N endServiceAccount() {
      return and();
    }
    
  }
  class ServiceAccountListNestedImpl<N> extends ServiceAccountListFluentImpl<KubeSchemaFluentImpl.ServiceAccountListNested<N>> implements KubeSchemaFluentImpl.ServiceAccountListNested<N>,Nested<N>{
    ServiceAccountListNestedImpl(ServiceAccountList item) {
      this.builder = new ServiceAccountListBuilder(this, item);
    }
    ServiceAccountListNestedImpl() {
      this.builder = new ServiceAccountListBuilder(this);
    }
    ServiceAccountListBuilder builder;
    public N and() {
      return (N) KubeSchemaFluentImpl.this.withServiceAccountList(builder.build());
    }
    public N endServiceAccountList() {
      return and();
    }
    
  }
  class ServiceListNestedImpl<N> extends ServiceListFluentImpl<KubeSchemaFluentImpl.ServiceListNested<N>> implements KubeSchemaFluentImpl.ServiceListNested<N>,Nested<N>{
    ServiceListNestedImpl(ServiceList item) {
      this.builder = new ServiceListBuilder(this, item);
    }
    ServiceListNestedImpl() {
      this.builder = new ServiceListBuilder(this);
    }
    ServiceListBuilder builder;
    public N and() {
      return (N) KubeSchemaFluentImpl.this.withServiceList(builder.build());
    }
    public N endServiceList() {
      return and();
    }
    
  }
  class StatusNestedImpl<N> extends StatusFluentImpl<KubeSchemaFluentImpl.StatusNested<N>> implements KubeSchemaFluentImpl.StatusNested<N>,Nested<N>{
    StatusNestedImpl(Status item) {
      this.builder = new StatusBuilder(this, item);
    }
    StatusNestedImpl() {
      this.builder = new StatusBuilder(this);
    }
    StatusBuilder builder;
    public N and() {
      return (N) KubeSchemaFluentImpl.this.withStatus(builder.build());
    }
    public N endStatus() {
      return and();
    }
    
  }
  class TolerationNestedImpl<N> extends TolerationFluentImpl<KubeSchemaFluentImpl.TolerationNested<N>> implements KubeSchemaFluentImpl.TolerationNested<N>,Nested<N>{
    TolerationNestedImpl(Toleration item) {
      this.builder = new TolerationBuilder(this, item);
    }
    TolerationNestedImpl() {
      this.builder = new TolerationBuilder(this);
    }
    TolerationBuilder builder;
    public N and() {
      return (N) KubeSchemaFluentImpl.this.withToleration(builder.build());
    }
    public N endToleration() {
      return and();
    }
    
  }
  class TopologySelectorTermNestedImpl<N> extends TopologySelectorTermFluentImpl<KubeSchemaFluentImpl.TopologySelectorTermNested<N>> implements KubeSchemaFluentImpl.TopologySelectorTermNested<N>,Nested<N>{
    TopologySelectorTermNestedImpl(TopologySelectorTerm item) {
      this.builder = new TopologySelectorTermBuilder(this, item);
    }
    TopologySelectorTermNestedImpl() {
      this.builder = new TopologySelectorTermBuilder(this);
    }
    TopologySelectorTermBuilder builder;
    public N and() {
      return (N) KubeSchemaFluentImpl.this.withTopologySelectorTerm(builder.build());
    }
    public N endTopologySelectorTerm() {
      return and();
    }
    
  }
  class TypeMetaNestedImpl<N> extends TypeMetaFluentImpl<KubeSchemaFluentImpl.TypeMetaNested<N>> implements KubeSchemaFluentImpl.TypeMetaNested<N>,Nested<N>{
    TypeMetaNestedImpl(TypeMeta item) {
      this.builder = new TypeMetaBuilder(this, item);
    }
    TypeMetaNestedImpl() {
      this.builder = new TypeMetaBuilder(this);
    }
    TypeMetaBuilder builder;
    public N and() {
      return (N) KubeSchemaFluentImpl.this.withTypeMeta(builder.build());
    }
    public N endTypeMeta() {
      return and();
    }
    
  }
  class UpdateOptionsNestedImpl<N> extends UpdateOptionsFluentImpl<KubeSchemaFluentImpl.UpdateOptionsNested<N>> implements KubeSchemaFluentImpl.UpdateOptionsNested<N>,Nested<N>{
    UpdateOptionsNestedImpl(UpdateOptions item) {
      this.builder = new UpdateOptionsBuilder(this, item);
    }
    UpdateOptionsNestedImpl() {
      this.builder = new UpdateOptionsBuilder(this);
    }
    UpdateOptionsBuilder builder;
    public N and() {
      return (N) KubeSchemaFluentImpl.this.withUpdateOptions(builder.build());
    }
    public N endUpdateOptions() {
      return and();
    }
    
  }
  class WatchEventNestedImpl<N> extends WatchEventFluentImpl<KubeSchemaFluentImpl.WatchEventNested<N>> implements KubeSchemaFluentImpl.WatchEventNested<N>,Nested<N>{
    WatchEventNestedImpl(WatchEvent item) {
      this.builder = new WatchEventBuilder(this, item);
    }
    WatchEventNestedImpl() {
      this.builder = new WatchEventBuilder(this);
    }
    WatchEventBuilder builder;
    public N and() {
      return (N) KubeSchemaFluentImpl.this.withWatchEvent(builder.build());
    }
    public N endWatchEvent() {
      return and();
    }
    
  }
  
}