package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class GroupKindBuilder extends GroupKindFluentImpl<GroupKindBuilder> implements VisitableBuilder<GroupKind,GroupKindBuilder>{
  public GroupKindBuilder() {
    this(false);
  }
  public GroupKindBuilder(Boolean validationEnabled) {
    this(new GroupKind(), validationEnabled);
  }
  public GroupKindBuilder(GroupKindFluent<?> fluent) {
    this(fluent, false);
  }
  public GroupKindBuilder(GroupKindFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new GroupKind(), validationEnabled);
  }
  public GroupKindBuilder(GroupKindFluent<?> fluent,GroupKind instance) {
    this(fluent, instance, false);
  }
  public GroupKindBuilder(GroupKindFluent<?> fluent,GroupKind instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withGroup(instance.getGroup());
      fluent.withKind(instance.getKind());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public GroupKindBuilder(GroupKind instance) {
    this(instance,false);
  }
  public GroupKindBuilder(GroupKind instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withGroup(instance.getGroup());
      this.withKind(instance.getKind());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  GroupKindFluent<?> fluent;
  Boolean validationEnabled;
  public GroupKind build() {
    GroupKind buildable = new GroupKind(fluent.getGroup(),fluent.getKind());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}