package io.fabric8.kubernetes.api.model;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class EventFluentImpl<A extends EventFluent<A>> extends BaseFluent<A> implements EventFluent<A>{
  public EventFluentImpl() {
  }
  public EventFluentImpl(Event instance) {
    if (instance != null) {
      this.withAction(instance.getAction());
      this.withApiVersion(instance.getApiVersion());
      this.withCount(instance.getCount());
      this.withEventTime(instance.getEventTime());
      this.withFirstTimestamp(instance.getFirstTimestamp());
      this.withInvolvedObject(instance.getInvolvedObject());
      this.withKind(instance.getKind());
      this.withLastTimestamp(instance.getLastTimestamp());
      this.withMessage(instance.getMessage());
      this.withMetadata(instance.getMetadata());
      this.withReason(instance.getReason());
      this.withRelated(instance.getRelated());
      this.withReportingComponent(instance.getReportingComponent());
      this.withReportingInstance(instance.getReportingInstance());
      this.withSeries(instance.getSeries());
      this.withSource(instance.getSource());
      this.withType(instance.getType());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private String action;
  private String apiVersion;
  private Integer count;
  private MicroTimeBuilder eventTime;
  private String firstTimestamp;
  private ObjectReferenceBuilder involvedObject;
  private String kind;
  private String lastTimestamp;
  private String message;
  private ObjectMetaBuilder metadata;
  private String reason;
  private ObjectReferenceBuilder related;
  private String reportingComponent;
  private String reportingInstance;
  private EventSeriesBuilder series;
  private EventSourceBuilder source;
  private String type;
  private Map<String,Object> additionalProperties;
  public String getAction() {
    return this.action;
  }
  public A withAction(String action) {
    this.action=action; return (A) this;
  }
  public Boolean hasAction() {
    return this.action != null;
  }
  public String getApiVersion() {
    return this.apiVersion;
  }
  public A withApiVersion(String apiVersion) {
    this.apiVersion=apiVersion; return (A) this;
  }
  public Boolean hasApiVersion() {
    return this.apiVersion != null;
  }
  public Integer getCount() {
    return this.count;
  }
  public A withCount(Integer count) {
    this.count=count; return (A) this;
  }
  public Boolean hasCount() {
    return this.count != null;
  }
  
  /**
   * This method has been deprecated, please use method buildEventTime instead.
   * @return The buildable object.
   */
  @Deprecated
  public MicroTime getEventTime() {
    return this.eventTime!=null ?this.eventTime.build():null;
  }
  public MicroTime buildEventTime() {
    return this.eventTime!=null ?this.eventTime.build():null;
  }
  public A withEventTime(MicroTime eventTime) {
    _visitables.get("eventTime").remove(this.eventTime);
    if (eventTime!=null){ this.eventTime= new MicroTimeBuilder(eventTime); _visitables.get("eventTime").add(this.eventTime);} else { this.eventTime = null; _visitables.get("eventTime").remove(this.eventTime); } return (A) this;
  }
  public Boolean hasEventTime() {
    return this.eventTime != null;
  }
  public A withNewEventTime(String time) {
    return (A)withEventTime(new MicroTime(time));
  }
  public EventFluentImpl.EventTimeNested<A> withNewEventTime() {
    return new EventFluentImpl.EventTimeNestedImpl();
  }
  public EventFluentImpl.EventTimeNested<A> withNewEventTimeLike(MicroTime item) {
    return new EventFluentImpl.EventTimeNestedImpl(item);
  }
  public EventFluentImpl.EventTimeNested<A> editEventTime() {
    return withNewEventTimeLike(getEventTime());
  }
  public EventFluentImpl.EventTimeNested<A> editOrNewEventTime() {
    return withNewEventTimeLike(getEventTime() != null ? getEventTime(): new MicroTimeBuilder().build());
  }
  public EventFluentImpl.EventTimeNested<A> editOrNewEventTimeLike(MicroTime item) {
    return withNewEventTimeLike(getEventTime() != null ? getEventTime(): item);
  }
  public String getFirstTimestamp() {
    return this.firstTimestamp;
  }
  public A withFirstTimestamp(String firstTimestamp) {
    this.firstTimestamp=firstTimestamp; return (A) this;
  }
  public Boolean hasFirstTimestamp() {
    return this.firstTimestamp != null;
  }
  
  /**
   * This method has been deprecated, please use method buildInvolvedObject instead.
   * @return The buildable object.
   */
  @Deprecated
  public ObjectReference getInvolvedObject() {
    return this.involvedObject!=null ?this.involvedObject.build():null;
  }
  public ObjectReference buildInvolvedObject() {
    return this.involvedObject!=null ?this.involvedObject.build():null;
  }
  public A withInvolvedObject(ObjectReference involvedObject) {
    _visitables.get("involvedObject").remove(this.involvedObject);
    if (involvedObject!=null){ this.involvedObject= new ObjectReferenceBuilder(involvedObject); _visitables.get("involvedObject").add(this.involvedObject);} else { this.involvedObject = null; _visitables.get("involvedObject").remove(this.involvedObject); } return (A) this;
  }
  public Boolean hasInvolvedObject() {
    return this.involvedObject != null;
  }
  public EventFluentImpl.InvolvedObjectNested<A> withNewInvolvedObject() {
    return new EventFluentImpl.InvolvedObjectNestedImpl();
  }
  public EventFluentImpl.InvolvedObjectNested<A> withNewInvolvedObjectLike(ObjectReference item) {
    return new EventFluentImpl.InvolvedObjectNestedImpl(item);
  }
  public EventFluentImpl.InvolvedObjectNested<A> editInvolvedObject() {
    return withNewInvolvedObjectLike(getInvolvedObject());
  }
  public EventFluentImpl.InvolvedObjectNested<A> editOrNewInvolvedObject() {
    return withNewInvolvedObjectLike(getInvolvedObject() != null ? getInvolvedObject(): new ObjectReferenceBuilder().build());
  }
  public EventFluentImpl.InvolvedObjectNested<A> editOrNewInvolvedObjectLike(ObjectReference item) {
    return withNewInvolvedObjectLike(getInvolvedObject() != null ? getInvolvedObject(): item);
  }
  public String getKind() {
    return this.kind;
  }
  public A withKind(String kind) {
    this.kind=kind; return (A) this;
  }
  public Boolean hasKind() {
    return this.kind != null;
  }
  public String getLastTimestamp() {
    return this.lastTimestamp;
  }
  public A withLastTimestamp(String lastTimestamp) {
    this.lastTimestamp=lastTimestamp; return (A) this;
  }
  public Boolean hasLastTimestamp() {
    return this.lastTimestamp != null;
  }
  public String getMessage() {
    return this.message;
  }
  public A withMessage(String message) {
    this.message=message; return (A) this;
  }
  public Boolean hasMessage() {
    return this.message != null;
  }
  
  /**
   * This method has been deprecated, please use method buildMetadata instead.
   * @return The buildable object.
   */
  @Deprecated
  public ObjectMeta getMetadata() {
    return this.metadata!=null ?this.metadata.build():null;
  }
  public ObjectMeta buildMetadata() {
    return this.metadata!=null ?this.metadata.build():null;
  }
  public A withMetadata(ObjectMeta metadata) {
    _visitables.get("metadata").remove(this.metadata);
    if (metadata!=null){ this.metadata= new ObjectMetaBuilder(metadata); _visitables.get("metadata").add(this.metadata);} else { this.metadata = null; _visitables.get("metadata").remove(this.metadata); } return (A) this;
  }
  public Boolean hasMetadata() {
    return this.metadata != null;
  }
  public EventFluentImpl.MetadataNested<A> withNewMetadata() {
    return new EventFluentImpl.MetadataNestedImpl();
  }
  public EventFluentImpl.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
    return new EventFluentImpl.MetadataNestedImpl(item);
  }
  public EventFluentImpl.MetadataNested<A> editMetadata() {
    return withNewMetadataLike(getMetadata());
  }
  public EventFluentImpl.MetadataNested<A> editOrNewMetadata() {
    return withNewMetadataLike(getMetadata() != null ? getMetadata(): new ObjectMetaBuilder().build());
  }
  public EventFluentImpl.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
    return withNewMetadataLike(getMetadata() != null ? getMetadata(): item);
  }
  public String getReason() {
    return this.reason;
  }
  public A withReason(String reason) {
    this.reason=reason; return (A) this;
  }
  public Boolean hasReason() {
    return this.reason != null;
  }
  
  /**
   * This method has been deprecated, please use method buildRelated instead.
   * @return The buildable object.
   */
  @Deprecated
  public ObjectReference getRelated() {
    return this.related!=null ?this.related.build():null;
  }
  public ObjectReference buildRelated() {
    return this.related!=null ?this.related.build():null;
  }
  public A withRelated(ObjectReference related) {
    _visitables.get("related").remove(this.related);
    if (related!=null){ this.related= new ObjectReferenceBuilder(related); _visitables.get("related").add(this.related);} else { this.related = null; _visitables.get("related").remove(this.related); } return (A) this;
  }
  public Boolean hasRelated() {
    return this.related != null;
  }
  public EventFluentImpl.RelatedNested<A> withNewRelated() {
    return new EventFluentImpl.RelatedNestedImpl();
  }
  public EventFluentImpl.RelatedNested<A> withNewRelatedLike(ObjectReference item) {
    return new EventFluentImpl.RelatedNestedImpl(item);
  }
  public EventFluentImpl.RelatedNested<A> editRelated() {
    return withNewRelatedLike(getRelated());
  }
  public EventFluentImpl.RelatedNested<A> editOrNewRelated() {
    return withNewRelatedLike(getRelated() != null ? getRelated(): new ObjectReferenceBuilder().build());
  }
  public EventFluentImpl.RelatedNested<A> editOrNewRelatedLike(ObjectReference item) {
    return withNewRelatedLike(getRelated() != null ? getRelated(): item);
  }
  public String getReportingComponent() {
    return this.reportingComponent;
  }
  public A withReportingComponent(String reportingComponent) {
    this.reportingComponent=reportingComponent; return (A) this;
  }
  public Boolean hasReportingComponent() {
    return this.reportingComponent != null;
  }
  public String getReportingInstance() {
    return this.reportingInstance;
  }
  public A withReportingInstance(String reportingInstance) {
    this.reportingInstance=reportingInstance; return (A) this;
  }
  public Boolean hasReportingInstance() {
    return this.reportingInstance != null;
  }
  
  /**
   * This method has been deprecated, please use method buildSeries instead.
   * @return The buildable object.
   */
  @Deprecated
  public EventSeries getSeries() {
    return this.series!=null ?this.series.build():null;
  }
  public EventSeries buildSeries() {
    return this.series!=null ?this.series.build():null;
  }
  public A withSeries(EventSeries series) {
    _visitables.get("series").remove(this.series);
    if (series!=null){ this.series= new EventSeriesBuilder(series); _visitables.get("series").add(this.series);} else { this.series = null; _visitables.get("series").remove(this.series); } return (A) this;
  }
  public Boolean hasSeries() {
    return this.series != null;
  }
  public EventFluentImpl.SeriesNested<A> withNewSeries() {
    return new EventFluentImpl.SeriesNestedImpl();
  }
  public EventFluentImpl.SeriesNested<A> withNewSeriesLike(EventSeries item) {
    return new EventFluentImpl.SeriesNestedImpl(item);
  }
  public EventFluentImpl.SeriesNested<A> editSeries() {
    return withNewSeriesLike(getSeries());
  }
  public EventFluentImpl.SeriesNested<A> editOrNewSeries() {
    return withNewSeriesLike(getSeries() != null ? getSeries(): new EventSeriesBuilder().build());
  }
  public EventFluentImpl.SeriesNested<A> editOrNewSeriesLike(EventSeries item) {
    return withNewSeriesLike(getSeries() != null ? getSeries(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildSource instead.
   * @return The buildable object.
   */
  @Deprecated
  public EventSource getSource() {
    return this.source!=null ?this.source.build():null;
  }
  public EventSource buildSource() {
    return this.source!=null ?this.source.build():null;
  }
  public A withSource(EventSource source) {
    _visitables.get("source").remove(this.source);
    if (source!=null){ this.source= new EventSourceBuilder(source); _visitables.get("source").add(this.source);} else { this.source = null; _visitables.get("source").remove(this.source); } return (A) this;
  }
  public Boolean hasSource() {
    return this.source != null;
  }
  public A withNewSource(String component,String host) {
    return (A)withSource(new EventSource(component, host));
  }
  public EventFluentImpl.SourceNested<A> withNewSource() {
    return new EventFluentImpl.SourceNestedImpl();
  }
  public EventFluentImpl.SourceNested<A> withNewSourceLike(EventSource item) {
    return new EventFluentImpl.SourceNestedImpl(item);
  }
  public EventFluentImpl.SourceNested<A> editSource() {
    return withNewSourceLike(getSource());
  }
  public EventFluentImpl.SourceNested<A> editOrNewSource() {
    return withNewSourceLike(getSource() != null ? getSource(): new EventSourceBuilder().build());
  }
  public EventFluentImpl.SourceNested<A> editOrNewSourceLike(EventSource item) {
    return withNewSourceLike(getSource() != null ? getSource(): item);
  }
  public String getType() {
    return this.type;
  }
  public A withType(String type) {
    this.type=type; return (A) this;
  }
  public Boolean hasType() {
    return this.type != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    EventFluentImpl that = (EventFluentImpl) o;
    if (!java.util.Objects.equals(action, that.action)) return false;

    if (!java.util.Objects.equals(apiVersion, that.apiVersion)) return false;

    if (!java.util.Objects.equals(count, that.count)) return false;

    if (!java.util.Objects.equals(eventTime, that.eventTime)) return false;

    if (!java.util.Objects.equals(firstTimestamp, that.firstTimestamp)) return false;

    if (!java.util.Objects.equals(involvedObject, that.involvedObject)) return false;

    if (!java.util.Objects.equals(kind, that.kind)) return false;

    if (!java.util.Objects.equals(lastTimestamp, that.lastTimestamp)) return false;

    if (!java.util.Objects.equals(message, that.message)) return false;

    if (!java.util.Objects.equals(metadata, that.metadata)) return false;

    if (!java.util.Objects.equals(reason, that.reason)) return false;

    if (!java.util.Objects.equals(related, that.related)) return false;

    if (!java.util.Objects.equals(reportingComponent, that.reportingComponent)) return false;

    if (!java.util.Objects.equals(reportingInstance, that.reportingInstance)) return false;

    if (!java.util.Objects.equals(series, that.series)) return false;

    if (!java.util.Objects.equals(source, that.source)) return false;

    if (!java.util.Objects.equals(type, that.type)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(action,  apiVersion,  count,  eventTime,  firstTimestamp,  involvedObject,  kind,  lastTimestamp,  message,  metadata,  reason,  related,  reportingComponent,  reportingInstance,  series,  source,  type,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (action != null) { sb.append("action:"); sb.append(action + ","); }
    if (apiVersion != null) { sb.append("apiVersion:"); sb.append(apiVersion + ","); }
    if (count != null) { sb.append("count:"); sb.append(count + ","); }
    if (eventTime != null) { sb.append("eventTime:"); sb.append(eventTime + ","); }
    if (firstTimestamp != null) { sb.append("firstTimestamp:"); sb.append(firstTimestamp + ","); }
    if (involvedObject != null) { sb.append("involvedObject:"); sb.append(involvedObject + ","); }
    if (kind != null) { sb.append("kind:"); sb.append(kind + ","); }
    if (lastTimestamp != null) { sb.append("lastTimestamp:"); sb.append(lastTimestamp + ","); }
    if (message != null) { sb.append("message:"); sb.append(message + ","); }
    if (metadata != null) { sb.append("metadata:"); sb.append(metadata + ","); }
    if (reason != null) { sb.append("reason:"); sb.append(reason + ","); }
    if (related != null) { sb.append("related:"); sb.append(related + ","); }
    if (reportingComponent != null) { sb.append("reportingComponent:"); sb.append(reportingComponent + ","); }
    if (reportingInstance != null) { sb.append("reportingInstance:"); sb.append(reportingInstance + ","); }
    if (series != null) { sb.append("series:"); sb.append(series + ","); }
    if (source != null) { sb.append("source:"); sb.append(source + ","); }
    if (type != null) { sb.append("type:"); sb.append(type + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class EventTimeNestedImpl<N> extends MicroTimeFluentImpl<EventFluentImpl.EventTimeNested<N>> implements EventFluentImpl.EventTimeNested<N>,Nested<N>{
    EventTimeNestedImpl(MicroTime item) {
      this.builder = new MicroTimeBuilder(this, item);
    }
    EventTimeNestedImpl() {
      this.builder = new MicroTimeBuilder(this);
    }
    MicroTimeBuilder builder;
    public N and() {
      return (N) EventFluentImpl.this.withEventTime(builder.build());
    }
    public N endEventTime() {
      return and();
    }
    
  }
  class InvolvedObjectNestedImpl<N> extends ObjectReferenceFluentImpl<EventFluentImpl.InvolvedObjectNested<N>> implements EventFluentImpl.InvolvedObjectNested<N>,Nested<N>{
    InvolvedObjectNestedImpl(ObjectReference item) {
      this.builder = new ObjectReferenceBuilder(this, item);
    }
    InvolvedObjectNestedImpl() {
      this.builder = new ObjectReferenceBuilder(this);
    }
    ObjectReferenceBuilder builder;
    public N and() {
      return (N) EventFluentImpl.this.withInvolvedObject(builder.build());
    }
    public N endInvolvedObject() {
      return and();
    }
    
  }
  class MetadataNestedImpl<N> extends ObjectMetaFluentImpl<EventFluentImpl.MetadataNested<N>> implements EventFluentImpl.MetadataNested<N>,Nested<N>{
    MetadataNestedImpl(ObjectMeta item) {
      this.builder = new ObjectMetaBuilder(this, item);
    }
    MetadataNestedImpl() {
      this.builder = new ObjectMetaBuilder(this);
    }
    ObjectMetaBuilder builder;
    public N and() {
      return (N) EventFluentImpl.this.withMetadata(builder.build());
    }
    public N endMetadata() {
      return and();
    }
    
  }
  class RelatedNestedImpl<N> extends ObjectReferenceFluentImpl<EventFluentImpl.RelatedNested<N>> implements EventFluentImpl.RelatedNested<N>,Nested<N>{
    RelatedNestedImpl(ObjectReference item) {
      this.builder = new ObjectReferenceBuilder(this, item);
    }
    RelatedNestedImpl() {
      this.builder = new ObjectReferenceBuilder(this);
    }
    ObjectReferenceBuilder builder;
    public N and() {
      return (N) EventFluentImpl.this.withRelated(builder.build());
    }
    public N endRelated() {
      return and();
    }
    
  }
  class SeriesNestedImpl<N> extends EventSeriesFluentImpl<EventFluentImpl.SeriesNested<N>> implements EventFluentImpl.SeriesNested<N>,Nested<N>{
    SeriesNestedImpl(EventSeries item) {
      this.builder = new EventSeriesBuilder(this, item);
    }
    SeriesNestedImpl() {
      this.builder = new EventSeriesBuilder(this);
    }
    EventSeriesBuilder builder;
    public N and() {
      return (N) EventFluentImpl.this.withSeries(builder.build());
    }
    public N endSeries() {
      return and();
    }
    
  }
  class SourceNestedImpl<N> extends EventSourceFluentImpl<EventFluentImpl.SourceNested<N>> implements EventFluentImpl.SourceNested<N>,Nested<N>{
    SourceNestedImpl(EventSource item) {
      this.builder = new EventSourceBuilder(this, item);
    }
    SourceNestedImpl() {
      this.builder = new EventSourceBuilder(this);
    }
    EventSourceBuilder builder;
    public N and() {
      return (N) EventFluentImpl.this.withSource(builder.build());
    }
    public N endSource() {
      return and();
    }
    
  }
  
}