package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class DownwardAPIVolumeFileBuilder extends DownwardAPIVolumeFileFluentImpl<DownwardAPIVolumeFileBuilder> implements VisitableBuilder<DownwardAPIVolumeFile,DownwardAPIVolumeFileBuilder>{
  public DownwardAPIVolumeFileBuilder() {
    this(false);
  }
  public DownwardAPIVolumeFileBuilder(Boolean validationEnabled) {
    this(new DownwardAPIVolumeFile(), validationEnabled);
  }
  public DownwardAPIVolumeFileBuilder(DownwardAPIVolumeFileFluent<?> fluent) {
    this(fluent, false);
  }
  public DownwardAPIVolumeFileBuilder(DownwardAPIVolumeFileFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new DownwardAPIVolumeFile(), validationEnabled);
  }
  public DownwardAPIVolumeFileBuilder(DownwardAPIVolumeFileFluent<?> fluent,DownwardAPIVolumeFile instance) {
    this(fluent, instance, false);
  }
  public DownwardAPIVolumeFileBuilder(DownwardAPIVolumeFileFluent<?> fluent,DownwardAPIVolumeFile instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withFieldRef(instance.getFieldRef());
      fluent.withMode(instance.getMode());
      fluent.withPath(instance.getPath());
      fluent.withResourceFieldRef(instance.getResourceFieldRef());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public DownwardAPIVolumeFileBuilder(DownwardAPIVolumeFile instance) {
    this(instance,false);
  }
  public DownwardAPIVolumeFileBuilder(DownwardAPIVolumeFile instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withFieldRef(instance.getFieldRef());
      this.withMode(instance.getMode());
      this.withPath(instance.getPath());
      this.withResourceFieldRef(instance.getResourceFieldRef());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  DownwardAPIVolumeFileFluent<?> fluent;
  Boolean validationEnabled;
  public DownwardAPIVolumeFile build() {
    DownwardAPIVolumeFile buildable = new DownwardAPIVolumeFile(fluent.getFieldRef(),fluent.getMode(),fluent.getPath(),fluent.getResourceFieldRef());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}