package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class DownwardAPIProjectionFluentImpl<A extends DownwardAPIProjectionFluent<A>> extends BaseFluent<A> implements DownwardAPIProjectionFluent<A>{
  public DownwardAPIProjectionFluentImpl() {
  }
  public DownwardAPIProjectionFluentImpl(DownwardAPIProjection instance) {
    if (instance != null) {
      this.withItems(instance.getItems());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private ArrayList<DownwardAPIVolumeFileBuilder> items = new ArrayList<DownwardAPIVolumeFileBuilder>();
  private Map<String,Object> additionalProperties;
  public A addToItems(int index,DownwardAPIVolumeFile item) {
    if (this.items == null) {this.items = new ArrayList<DownwardAPIVolumeFileBuilder>();}
    DownwardAPIVolumeFileBuilder builder = new DownwardAPIVolumeFileBuilder(item);
    if (index < 0 || index >= items.size()) { _visitables.get("items").add(builder); items.add(builder); } else { _visitables.get("items").add(index, builder); items.add(index, builder);}
    return (A)this;
  }
  public A setToItems(int index,DownwardAPIVolumeFile item) {
    if (this.items == null) {this.items = new ArrayList<DownwardAPIVolumeFileBuilder>();}
    DownwardAPIVolumeFileBuilder builder = new DownwardAPIVolumeFileBuilder(item);
    if (index < 0 || index >= items.size()) { _visitables.get("items").add(builder); items.add(builder); } else { _visitables.get("items").set(index, builder); items.set(index, builder);}
    return (A)this;
  }
  public A addToItems(io.fabric8.kubernetes.api.model.DownwardAPIVolumeFile... items) {
    if (this.items == null) {this.items = new ArrayList<DownwardAPIVolumeFileBuilder>();}
    for (DownwardAPIVolumeFile item : items) {DownwardAPIVolumeFileBuilder builder = new DownwardAPIVolumeFileBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
  }
  public A addAllToItems(Collection<DownwardAPIVolumeFile> items) {
    if (this.items == null) {this.items = new ArrayList<DownwardAPIVolumeFileBuilder>();}
    for (DownwardAPIVolumeFile item : items) {DownwardAPIVolumeFileBuilder builder = new DownwardAPIVolumeFileBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
  }
  public A removeFromItems(io.fabric8.kubernetes.api.model.DownwardAPIVolumeFile... items) {
    for (DownwardAPIVolumeFile item : items) {DownwardAPIVolumeFileBuilder builder = new DownwardAPIVolumeFileBuilder(item);_visitables.get("items").remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
  }
  public A removeAllFromItems(Collection<DownwardAPIVolumeFile> items) {
    for (DownwardAPIVolumeFile item : items) {DownwardAPIVolumeFileBuilder builder = new DownwardAPIVolumeFileBuilder(item);_visitables.get("items").remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromItems(Predicate<DownwardAPIVolumeFileBuilder> predicate) {
    if (items == null) return (A) this;
    final Iterator<DownwardAPIVolumeFileBuilder> each = items.iterator();
    final List visitables = _visitables.get("items");
    while (each.hasNext()) {
      DownwardAPIVolumeFileBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildItems instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<DownwardAPIVolumeFile> getItems() {
    return items != null ? build(items) : null;
  }
  public List<DownwardAPIVolumeFile> buildItems() {
    return items != null ? build(items) : null;
  }
  public DownwardAPIVolumeFile buildItem(int index) {
    return this.items.get(index).build();
  }
  public DownwardAPIVolumeFile buildFirstItem() {
    return this.items.get(0).build();
  }
  public DownwardAPIVolumeFile buildLastItem() {
    return this.items.get(items.size() - 1).build();
  }
  public DownwardAPIVolumeFile buildMatchingItem(Predicate<DownwardAPIVolumeFileBuilder> predicate) {
    for (DownwardAPIVolumeFileBuilder item: items) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingItem(Predicate<DownwardAPIVolumeFileBuilder> predicate) {
    for (DownwardAPIVolumeFileBuilder item: items) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withItems(List<DownwardAPIVolumeFile> items) {
    if (this.items != null) { _visitables.get("items").clear();}
    if (items != null) {this.items = new ArrayList(); for (DownwardAPIVolumeFile item : items){this.addToItems(item);}} else { this.items = null;} return (A) this;
  }
  public A withItems(io.fabric8.kubernetes.api.model.DownwardAPIVolumeFile... items) {
    if (this.items != null) {this.items.clear(); _visitables.remove("items"); }
    if (items != null) {for (DownwardAPIVolumeFile item :items){ this.addToItems(item);}} return (A) this;
  }
  public Boolean hasItems() {
    return items != null && !items.isEmpty();
  }
  public DownwardAPIProjectionFluentImpl.ItemsNested<A> addNewItem() {
    return new DownwardAPIProjectionFluentImpl.ItemsNestedImpl();
  }
  public DownwardAPIProjectionFluentImpl.ItemsNested<A> addNewItemLike(DownwardAPIVolumeFile item) {
    return new DownwardAPIProjectionFluentImpl.ItemsNestedImpl(-1, item);
  }
  public DownwardAPIProjectionFluentImpl.ItemsNested<A> setNewItemLike(int index,DownwardAPIVolumeFile item) {
    return new DownwardAPIProjectionFluentImpl.ItemsNestedImpl(index, item);
  }
  public DownwardAPIProjectionFluentImpl.ItemsNested<A> editItem(int index) {
    if (items.size() <= index) throw new RuntimeException("Can't edit items. Index exceeds size.");
    return setNewItemLike(index, buildItem(index));
  }
  public DownwardAPIProjectionFluentImpl.ItemsNested<A> editFirstItem() {
    if (items.size() == 0) throw new RuntimeException("Can't edit first items. The list is empty.");
    return setNewItemLike(0, buildItem(0));
  }
  public DownwardAPIProjectionFluentImpl.ItemsNested<A> editLastItem() {
    int index = items.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last items. The list is empty.");
    return setNewItemLike(index, buildItem(index));
  }
  public DownwardAPIProjectionFluentImpl.ItemsNested<A> editMatchingItem(Predicate<DownwardAPIVolumeFileBuilder> predicate) {
    int index = -1;
    for (int i=0;i<items.size();i++) { 
    if (predicate.test(items.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching items. No match found.");
    return setNewItemLike(index, buildItem(index));
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    DownwardAPIProjectionFluentImpl that = (DownwardAPIProjectionFluentImpl) o;
    if (!java.util.Objects.equals(items, that.items)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(items,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (items != null && !items.isEmpty()) { sb.append("items:"); sb.append(items + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class ItemsNestedImpl<N> extends DownwardAPIVolumeFileFluentImpl<DownwardAPIProjectionFluentImpl.ItemsNested<N>> implements DownwardAPIProjectionFluentImpl.ItemsNested<N>,Nested<N>{
    ItemsNestedImpl(int index,DownwardAPIVolumeFile item) {
      this.index = index;
      this.builder = new DownwardAPIVolumeFileBuilder(this, item);
    }
    ItemsNestedImpl() {
      this.index = -1;
      this.builder = new DownwardAPIVolumeFileBuilder(this);
    }
    DownwardAPIVolumeFileBuilder builder;
    int index;
    public N and() {
      return (N) DownwardAPIProjectionFluentImpl.this.setToItems(index,builder.build());
    }
    public N endItem() {
      return and();
    }
    
  }
  
}