package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Fluent;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
public interface ConfigMapVolumeSourceFluent<A extends ConfigMapVolumeSourceFluent<A>> extends Fluent<A>{
  public Integer getDefaultMode();
  public A withDefaultMode(Integer defaultMode);
  public Boolean hasDefaultMode();
  public A addToItems(int index,KeyToPath item);
  public A setToItems(int index,KeyToPath item);
  public A addToItems(io.fabric8.kubernetes.api.model.KeyToPath... items);
  public A addAllToItems(Collection<KeyToPath> items);
  public A removeFromItems(io.fabric8.kubernetes.api.model.KeyToPath... items);
  public A removeAllFromItems(Collection<KeyToPath> items);
  public A removeMatchingFromItems(Predicate<KeyToPathBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildItems instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<KeyToPath> getItems();
  public List<KeyToPath> buildItems();
  public KeyToPath buildItem(int index);
  public KeyToPath buildFirstItem();
  public KeyToPath buildLastItem();
  public KeyToPath buildMatchingItem(Predicate<KeyToPathBuilder> predicate);
  public Boolean hasMatchingItem(Predicate<KeyToPathBuilder> predicate);
  public A withItems(List<KeyToPath> items);
  public A withItems(io.fabric8.kubernetes.api.model.KeyToPath... items);
  public Boolean hasItems();
  public A addNewItem(String key,Integer mode,String path);
  public ConfigMapVolumeSourceFluent.ItemsNested<A> addNewItem();
  public ConfigMapVolumeSourceFluent.ItemsNested<A> addNewItemLike(KeyToPath item);
  public ConfigMapVolumeSourceFluent.ItemsNested<A> setNewItemLike(int index,KeyToPath item);
  public ConfigMapVolumeSourceFluent.ItemsNested<A> editItem(int index);
  public ConfigMapVolumeSourceFluent.ItemsNested<A> editFirstItem();
  public ConfigMapVolumeSourceFluent.ItemsNested<A> editLastItem();
  public ConfigMapVolumeSourceFluent.ItemsNested<A> editMatchingItem(Predicate<KeyToPathBuilder> predicate);
  public String getName();
  public A withName(String name);
  public Boolean hasName();
  public Boolean getOptional();
  public A withOptional(Boolean optional);
  public Boolean hasOptional();
  public A addToAdditionalProperties(String key,Object value);
  public A addToAdditionalProperties(Map<String,Object> map);
  public A removeFromAdditionalProperties(String key);
  public A removeFromAdditionalProperties(Map<String,Object> map);
  public Map<String,Object> getAdditionalProperties();
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties);
  public Boolean hasAdditionalProperties();
  public A withOptional();
  public interface ItemsNested<N> extends Nested<N>,KeyToPathFluent<ConfigMapVolumeSourceFluent.ItemsNested<N>>{
    public N and();
    public N endItem();
    
  }
  
}