package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ConfigMapKeySelectorBuilder extends ConfigMapKeySelectorFluentImpl<ConfigMapKeySelectorBuilder> implements VisitableBuilder<ConfigMapKeySelector,ConfigMapKeySelectorBuilder>{
  public ConfigMapKeySelectorBuilder() {
    this(false);
  }
  public ConfigMapKeySelectorBuilder(Boolean validationEnabled) {
    this(new ConfigMapKeySelector(), validationEnabled);
  }
  public ConfigMapKeySelectorBuilder(ConfigMapKeySelectorFluent<?> fluent) {
    this(fluent, false);
  }
  public ConfigMapKeySelectorBuilder(ConfigMapKeySelectorFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ConfigMapKeySelector(), validationEnabled);
  }
  public ConfigMapKeySelectorBuilder(ConfigMapKeySelectorFluent<?> fluent,ConfigMapKeySelector instance) {
    this(fluent, instance, false);
  }
  public ConfigMapKeySelectorBuilder(ConfigMapKeySelectorFluent<?> fluent,ConfigMapKeySelector instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withKey(instance.getKey());
      fluent.withName(instance.getName());
      fluent.withOptional(instance.getOptional());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ConfigMapKeySelectorBuilder(ConfigMapKeySelector instance) {
    this(instance,false);
  }
  public ConfigMapKeySelectorBuilder(ConfigMapKeySelector instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withKey(instance.getKey());
      this.withName(instance.getName());
      this.withOptional(instance.getOptional());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ConfigMapKeySelectorFluent<?> fluent;
  Boolean validationEnabled;
  public ConfigMapKeySelector build() {
    ConfigMapKeySelector buildable = new ConfigMapKeySelector(fluent.getKey(),fluent.getName(),fluent.getOptional());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}