package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ComponentConditionBuilder extends ComponentConditionFluentImpl<ComponentConditionBuilder> implements VisitableBuilder<ComponentCondition,ComponentConditionBuilder>{
  public ComponentConditionBuilder() {
    this(false);
  }
  public ComponentConditionBuilder(Boolean validationEnabled) {
    this(new ComponentCondition(), validationEnabled);
  }
  public ComponentConditionBuilder(ComponentConditionFluent<?> fluent) {
    this(fluent, false);
  }
  public ComponentConditionBuilder(ComponentConditionFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ComponentCondition(), validationEnabled);
  }
  public ComponentConditionBuilder(ComponentConditionFluent<?> fluent,ComponentCondition instance) {
    this(fluent, instance, false);
  }
  public ComponentConditionBuilder(ComponentConditionFluent<?> fluent,ComponentCondition instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withError(instance.getError());
      fluent.withMessage(instance.getMessage());
      fluent.withStatus(instance.getStatus());
      fluent.withType(instance.getType());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ComponentConditionBuilder(ComponentCondition instance) {
    this(instance,false);
  }
  public ComponentConditionBuilder(ComponentCondition instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withError(instance.getError());
      this.withMessage(instance.getMessage());
      this.withStatus(instance.getStatus());
      this.withType(instance.getType());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ComponentConditionFluent<?> fluent;
  Boolean validationEnabled;
  public ComponentCondition build() {
    ComponentCondition buildable = new ComponentCondition(fluent.getError(),fluent.getMessage(),fluent.getStatus(),fluent.getType());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}