package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Fluent;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
public interface ClusterFluent<A extends ClusterFluent<A>> extends Fluent<A>{
  public String getCertificateAuthority();
  public A withCertificateAuthority(String certificateAuthority);
  public Boolean hasCertificateAuthority();
  public String getCertificateAuthorityData();
  public A withCertificateAuthorityData(String certificateAuthorityData);
  public Boolean hasCertificateAuthorityData();
  public Boolean getDisableCompression();
  public A withDisableCompression(Boolean disableCompression);
  public Boolean hasDisableCompression();
  public A addToExtensions(int index,NamedExtension item);
  public A setToExtensions(int index,NamedExtension item);
  public A addToExtensions(io.fabric8.kubernetes.api.model.NamedExtension... items);
  public A addAllToExtensions(Collection<NamedExtension> items);
  public A removeFromExtensions(io.fabric8.kubernetes.api.model.NamedExtension... items);
  public A removeAllFromExtensions(Collection<NamedExtension> items);
  public A removeMatchingFromExtensions(Predicate<NamedExtensionBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildExtensions instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<NamedExtension> getExtensions();
  public List<NamedExtension> buildExtensions();
  public NamedExtension buildExtension(int index);
  public NamedExtension buildFirstExtension();
  public NamedExtension buildLastExtension();
  public NamedExtension buildMatchingExtension(Predicate<NamedExtensionBuilder> predicate);
  public Boolean hasMatchingExtension(Predicate<NamedExtensionBuilder> predicate);
  public A withExtensions(List<NamedExtension> extensions);
  public A withExtensions(io.fabric8.kubernetes.api.model.NamedExtension... extensions);
  public Boolean hasExtensions();
  public ClusterFluent.ExtensionsNested<A> addNewExtension();
  public ClusterFluent.ExtensionsNested<A> addNewExtensionLike(NamedExtension item);
  public ClusterFluent.ExtensionsNested<A> setNewExtensionLike(int index,NamedExtension item);
  public ClusterFluent.ExtensionsNested<A> editExtension(int index);
  public ClusterFluent.ExtensionsNested<A> editFirstExtension();
  public ClusterFluent.ExtensionsNested<A> editLastExtension();
  public ClusterFluent.ExtensionsNested<A> editMatchingExtension(Predicate<NamedExtensionBuilder> predicate);
  public Boolean getInsecureSkipTlsVerify();
  public A withInsecureSkipTlsVerify(Boolean insecureSkipTlsVerify);
  public Boolean hasInsecureSkipTlsVerify();
  public String getProxyUrl();
  public A withProxyUrl(String proxyUrl);
  public Boolean hasProxyUrl();
  public String getServer();
  public A withServer(String server);
  public Boolean hasServer();
  public String getTlsServerName();
  public A withTlsServerName(String tlsServerName);
  public Boolean hasTlsServerName();
  public A addToAdditionalProperties(String key,Object value);
  public A addToAdditionalProperties(Map<String,Object> map);
  public A removeFromAdditionalProperties(String key);
  public A removeFromAdditionalProperties(Map<String,Object> map);
  public Map<String,Object> getAdditionalProperties();
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties);
  public Boolean hasAdditionalProperties();
  public A withDisableCompression();
  public A withInsecureSkipTlsVerify();
  public interface ExtensionsNested<N> extends Nested<N>,NamedExtensionFluent<ClusterFluent.ExtensionsNested<N>>{
    public N and();
    public N endExtension();
    
  }
  
}