package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class AuthInfoFluentImpl<A extends AuthInfoFluent<A>> extends BaseFluent<A> implements AuthInfoFluent<A>{
  public AuthInfoFluentImpl() {
  }
  public AuthInfoFluentImpl(AuthInfo instance) {
    if (instance != null) {
      this.withAs(instance.getAs());
      this.withAsGroups(instance.getAsGroups());
      this.withAsUid(instance.getAsUid());
      this.withAsUserExtra(instance.getAsUserExtra());
      this.withAuthProvider(instance.getAuthProvider());
      this.withClientCertificate(instance.getClientCertificate());
      this.withClientCertificateData(instance.getClientCertificateData());
      this.withClientKey(instance.getClientKey());
      this.withClientKeyData(instance.getClientKeyData());
      this.withExec(instance.getExec());
      this.withExtensions(instance.getExtensions());
      this.withPassword(instance.getPassword());
      this.withToken(instance.getToken());
      this.withTokenFile(instance.getTokenFile());
      this.withUsername(instance.getUsername());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private String as;
  private List<String> asGroups = new ArrayList<String>();
  private String asUid;
  private Map<String,ArrayList<String>> asUserExtra;
  private AuthProviderConfigBuilder authProvider;
  private String clientCertificate;
  private String clientCertificateData;
  private String clientKey;
  private String clientKeyData;
  private ExecConfigBuilder exec;
  private ArrayList<NamedExtensionBuilder> extensions = new ArrayList<NamedExtensionBuilder>();
  private String password;
  private String token;
  private String tokenFile;
  private String username;
  private Map<String,Object> additionalProperties;
  public String getAs() {
    return this.as;
  }
  public A withAs(String as) {
    this.as=as; return (A) this;
  }
  public Boolean hasAs() {
    return this.as != null;
  }
  public A addToAsGroups(int index,String item) {
    if (this.asGroups == null) {this.asGroups = new ArrayList<String>();}
    this.asGroups.add(index, item);
    return (A)this;
  }
  public A setToAsGroups(int index,String item) {
    if (this.asGroups == null) {this.asGroups = new ArrayList<String>();}
    this.asGroups.set(index, item); return (A)this;
  }
  public A addToAsGroups(java.lang.String... items) {
    if (this.asGroups == null) {this.asGroups = new ArrayList<String>();}
    for (String item : items) {this.asGroups.add(item);} return (A)this;
  }
  public A addAllToAsGroups(Collection<String> items) {
    if (this.asGroups == null) {this.asGroups = new ArrayList<String>();}
    for (String item : items) {this.asGroups.add(item);} return (A)this;
  }
  public A removeFromAsGroups(java.lang.String... items) {
    for (String item : items) {if (this.asGroups!= null){ this.asGroups.remove(item);}} return (A)this;
  }
  public A removeAllFromAsGroups(Collection<String> items) {
    for (String item : items) {if (this.asGroups!= null){ this.asGroups.remove(item);}} return (A)this;
  }
  public List<String> getAsGroups() {
    return this.asGroups;
  }
  public String getAsGroup(int index) {
    return this.asGroups.get(index);
  }
  public String getFirstAsGroup() {
    return this.asGroups.get(0);
  }
  public String getLastAsGroup() {
    return this.asGroups.get(asGroups.size() - 1);
  }
  public String getMatchingAsGroup(Predicate<String> predicate) {
    for (String item: asGroups) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingAsGroup(Predicate<String> predicate) {
    for (String item: asGroups) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withAsGroups(List<String> asGroups) {
    if (asGroups != null) {this.asGroups = new ArrayList(); for (String item : asGroups){this.addToAsGroups(item);}} else { this.asGroups = null;} return (A) this;
  }
  public A withAsGroups(java.lang.String... asGroups) {
    if (this.asGroups != null) {this.asGroups.clear(); _visitables.remove("asGroups"); }
    if (asGroups != null) {for (String item :asGroups){ this.addToAsGroups(item);}} return (A) this;
  }
  public Boolean hasAsGroups() {
    return asGroups != null && !asGroups.isEmpty();
  }
  public String getAsUid() {
    return this.asUid;
  }
  public A withAsUid(String asUid) {
    this.asUid=asUid; return (A) this;
  }
  public Boolean hasAsUid() {
    return this.asUid != null;
  }
  public A addToAsUserExtra(String key,ArrayList<String> value) {
    if(this.asUserExtra == null && key != null && value != null) { this.asUserExtra = new LinkedHashMap(); }
    if(key != null && value != null) {this.asUserExtra.put(key, value);} return (A)this;
  }
  public A addToAsUserExtra(Map<String,ArrayList<String>> map) {
    if(this.asUserExtra == null && map != null) { this.asUserExtra = new LinkedHashMap(); }
    if(map != null) { this.asUserExtra.putAll(map);} return (A)this;
  }
  public A removeFromAsUserExtra(String key) {
    if(this.asUserExtra == null) { return (A) this; }
    if(key != null && this.asUserExtra != null) {this.asUserExtra.remove(key);} return (A)this;
  }
  public A removeFromAsUserExtra(Map<String,ArrayList<String>> map) {
    if(this.asUserExtra == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.asUserExtra != null){this.asUserExtra.remove(key);}}} return (A)this;
  }
  public Map<String,ArrayList<String>> getAsUserExtra() {
    return this.asUserExtra;
  }
  public <K,V>A withAsUserExtra(Map<String,ArrayList<String>> asUserExtra) {
    if (asUserExtra == null) { this.asUserExtra =  null;} else {this.asUserExtra = new LinkedHashMap(asUserExtra);} return (A) this;
  }
  public Boolean hasAsUserExtra() {
    return this.asUserExtra != null;
  }
  
  /**
   * This method has been deprecated, please use method buildAuthProvider instead.
   * @return The buildable object.
   */
  @Deprecated
  public AuthProviderConfig getAuthProvider() {
    return this.authProvider!=null ?this.authProvider.build():null;
  }
  public AuthProviderConfig buildAuthProvider() {
    return this.authProvider!=null ?this.authProvider.build():null;
  }
  public A withAuthProvider(AuthProviderConfig authProvider) {
    _visitables.get("authProvider").remove(this.authProvider);
    if (authProvider!=null){ this.authProvider= new AuthProviderConfigBuilder(authProvider); _visitables.get("authProvider").add(this.authProvider);} else { this.authProvider = null; _visitables.get("authProvider").remove(this.authProvider); } return (A) this;
  }
  public Boolean hasAuthProvider() {
    return this.authProvider != null;
  }
  public AuthInfoFluentImpl.AuthProviderNested<A> withNewAuthProvider() {
    return new AuthInfoFluentImpl.AuthProviderNestedImpl();
  }
  public AuthInfoFluentImpl.AuthProviderNested<A> withNewAuthProviderLike(AuthProviderConfig item) {
    return new AuthInfoFluentImpl.AuthProviderNestedImpl(item);
  }
  public AuthInfoFluentImpl.AuthProviderNested<A> editAuthProvider() {
    return withNewAuthProviderLike(getAuthProvider());
  }
  public AuthInfoFluentImpl.AuthProviderNested<A> editOrNewAuthProvider() {
    return withNewAuthProviderLike(getAuthProvider() != null ? getAuthProvider(): new AuthProviderConfigBuilder().build());
  }
  public AuthInfoFluentImpl.AuthProviderNested<A> editOrNewAuthProviderLike(AuthProviderConfig item) {
    return withNewAuthProviderLike(getAuthProvider() != null ? getAuthProvider(): item);
  }
  public String getClientCertificate() {
    return this.clientCertificate;
  }
  public A withClientCertificate(String clientCertificate) {
    this.clientCertificate=clientCertificate; return (A) this;
  }
  public Boolean hasClientCertificate() {
    return this.clientCertificate != null;
  }
  public String getClientCertificateData() {
    return this.clientCertificateData;
  }
  public A withClientCertificateData(String clientCertificateData) {
    this.clientCertificateData=clientCertificateData; return (A) this;
  }
  public Boolean hasClientCertificateData() {
    return this.clientCertificateData != null;
  }
  public String getClientKey() {
    return this.clientKey;
  }
  public A withClientKey(String clientKey) {
    this.clientKey=clientKey; return (A) this;
  }
  public Boolean hasClientKey() {
    return this.clientKey != null;
  }
  public String getClientKeyData() {
    return this.clientKeyData;
  }
  public A withClientKeyData(String clientKeyData) {
    this.clientKeyData=clientKeyData; return (A) this;
  }
  public Boolean hasClientKeyData() {
    return this.clientKeyData != null;
  }
  
  /**
   * This method has been deprecated, please use method buildExec instead.
   * @return The buildable object.
   */
  @Deprecated
  public ExecConfig getExec() {
    return this.exec!=null ?this.exec.build():null;
  }
  public ExecConfig buildExec() {
    return this.exec!=null ?this.exec.build():null;
  }
  public A withExec(ExecConfig exec) {
    _visitables.get("exec").remove(this.exec);
    if (exec!=null){ this.exec= new ExecConfigBuilder(exec); _visitables.get("exec").add(this.exec);} else { this.exec = null; _visitables.get("exec").remove(this.exec); } return (A) this;
  }
  public Boolean hasExec() {
    return this.exec != null;
  }
  public AuthInfoFluentImpl.ExecNested<A> withNewExec() {
    return new AuthInfoFluentImpl.ExecNestedImpl();
  }
  public AuthInfoFluentImpl.ExecNested<A> withNewExecLike(ExecConfig item) {
    return new AuthInfoFluentImpl.ExecNestedImpl(item);
  }
  public AuthInfoFluentImpl.ExecNested<A> editExec() {
    return withNewExecLike(getExec());
  }
  public AuthInfoFluentImpl.ExecNested<A> editOrNewExec() {
    return withNewExecLike(getExec() != null ? getExec(): new ExecConfigBuilder().build());
  }
  public AuthInfoFluentImpl.ExecNested<A> editOrNewExecLike(ExecConfig item) {
    return withNewExecLike(getExec() != null ? getExec(): item);
  }
  public A addToExtensions(int index,NamedExtension item) {
    if (this.extensions == null) {this.extensions = new ArrayList<NamedExtensionBuilder>();}
    NamedExtensionBuilder builder = new NamedExtensionBuilder(item);
    if (index < 0 || index >= extensions.size()) { _visitables.get("extensions").add(builder); extensions.add(builder); } else { _visitables.get("extensions").add(index, builder); extensions.add(index, builder);}
    return (A)this;
  }
  public A setToExtensions(int index,NamedExtension item) {
    if (this.extensions == null) {this.extensions = new ArrayList<NamedExtensionBuilder>();}
    NamedExtensionBuilder builder = new NamedExtensionBuilder(item);
    if (index < 0 || index >= extensions.size()) { _visitables.get("extensions").add(builder); extensions.add(builder); } else { _visitables.get("extensions").set(index, builder); extensions.set(index, builder);}
    return (A)this;
  }
  public A addToExtensions(io.fabric8.kubernetes.api.model.NamedExtension... items) {
    if (this.extensions == null) {this.extensions = new ArrayList<NamedExtensionBuilder>();}
    for (NamedExtension item : items) {NamedExtensionBuilder builder = new NamedExtensionBuilder(item);_visitables.get("extensions").add(builder);this.extensions.add(builder);} return (A)this;
  }
  public A addAllToExtensions(Collection<NamedExtension> items) {
    if (this.extensions == null) {this.extensions = new ArrayList<NamedExtensionBuilder>();}
    for (NamedExtension item : items) {NamedExtensionBuilder builder = new NamedExtensionBuilder(item);_visitables.get("extensions").add(builder);this.extensions.add(builder);} return (A)this;
  }
  public A removeFromExtensions(io.fabric8.kubernetes.api.model.NamedExtension... items) {
    for (NamedExtension item : items) {NamedExtensionBuilder builder = new NamedExtensionBuilder(item);_visitables.get("extensions").remove(builder);if (this.extensions != null) {this.extensions.remove(builder);}} return (A)this;
  }
  public A removeAllFromExtensions(Collection<NamedExtension> items) {
    for (NamedExtension item : items) {NamedExtensionBuilder builder = new NamedExtensionBuilder(item);_visitables.get("extensions").remove(builder);if (this.extensions != null) {this.extensions.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromExtensions(Predicate<NamedExtensionBuilder> predicate) {
    if (extensions == null) return (A) this;
    final Iterator<NamedExtensionBuilder> each = extensions.iterator();
    final List visitables = _visitables.get("extensions");
    while (each.hasNext()) {
      NamedExtensionBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildExtensions instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<NamedExtension> getExtensions() {
    return extensions != null ? build(extensions) : null;
  }
  public List<NamedExtension> buildExtensions() {
    return extensions != null ? build(extensions) : null;
  }
  public NamedExtension buildExtension(int index) {
    return this.extensions.get(index).build();
  }
  public NamedExtension buildFirstExtension() {
    return this.extensions.get(0).build();
  }
  public NamedExtension buildLastExtension() {
    return this.extensions.get(extensions.size() - 1).build();
  }
  public NamedExtension buildMatchingExtension(Predicate<NamedExtensionBuilder> predicate) {
    for (NamedExtensionBuilder item: extensions) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingExtension(Predicate<NamedExtensionBuilder> predicate) {
    for (NamedExtensionBuilder item: extensions) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withExtensions(List<NamedExtension> extensions) {
    if (this.extensions != null) { _visitables.get("extensions").clear();}
    if (extensions != null) {this.extensions = new ArrayList(); for (NamedExtension item : extensions){this.addToExtensions(item);}} else { this.extensions = null;} return (A) this;
  }
  public A withExtensions(io.fabric8.kubernetes.api.model.NamedExtension... extensions) {
    if (this.extensions != null) {this.extensions.clear(); _visitables.remove("extensions"); }
    if (extensions != null) {for (NamedExtension item :extensions){ this.addToExtensions(item);}} return (A) this;
  }
  public Boolean hasExtensions() {
    return extensions != null && !extensions.isEmpty();
  }
  public AuthInfoFluentImpl.ExtensionsNested<A> addNewExtension() {
    return new AuthInfoFluentImpl.ExtensionsNestedImpl();
  }
  public AuthInfoFluentImpl.ExtensionsNested<A> addNewExtensionLike(NamedExtension item) {
    return new AuthInfoFluentImpl.ExtensionsNestedImpl(-1, item);
  }
  public AuthInfoFluentImpl.ExtensionsNested<A> setNewExtensionLike(int index,NamedExtension item) {
    return new AuthInfoFluentImpl.ExtensionsNestedImpl(index, item);
  }
  public AuthInfoFluentImpl.ExtensionsNested<A> editExtension(int index) {
    if (extensions.size() <= index) throw new RuntimeException("Can't edit extensions. Index exceeds size.");
    return setNewExtensionLike(index, buildExtension(index));
  }
  public AuthInfoFluentImpl.ExtensionsNested<A> editFirstExtension() {
    if (extensions.size() == 0) throw new RuntimeException("Can't edit first extensions. The list is empty.");
    return setNewExtensionLike(0, buildExtension(0));
  }
  public AuthInfoFluentImpl.ExtensionsNested<A> editLastExtension() {
    int index = extensions.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last extensions. The list is empty.");
    return setNewExtensionLike(index, buildExtension(index));
  }
  public AuthInfoFluentImpl.ExtensionsNested<A> editMatchingExtension(Predicate<NamedExtensionBuilder> predicate) {
    int index = -1;
    for (int i=0;i<extensions.size();i++) { 
    if (predicate.test(extensions.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching extensions. No match found.");
    return setNewExtensionLike(index, buildExtension(index));
  }
  public String getPassword() {
    return this.password;
  }
  public A withPassword(String password) {
    this.password=password; return (A) this;
  }
  public Boolean hasPassword() {
    return this.password != null;
  }
  public String getToken() {
    return this.token;
  }
  public A withToken(String token) {
    this.token=token; return (A) this;
  }
  public Boolean hasToken() {
    return this.token != null;
  }
  public String getTokenFile() {
    return this.tokenFile;
  }
  public A withTokenFile(String tokenFile) {
    this.tokenFile=tokenFile; return (A) this;
  }
  public Boolean hasTokenFile() {
    return this.tokenFile != null;
  }
  public String getUsername() {
    return this.username;
  }
  public A withUsername(String username) {
    this.username=username; return (A) this;
  }
  public Boolean hasUsername() {
    return this.username != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    AuthInfoFluentImpl that = (AuthInfoFluentImpl) o;
    if (!java.util.Objects.equals(as, that.as)) return false;

    if (!java.util.Objects.equals(asGroups, that.asGroups)) return false;

    if (!java.util.Objects.equals(asUid, that.asUid)) return false;

    if (!java.util.Objects.equals(asUserExtra, that.asUserExtra)) return false;

    if (!java.util.Objects.equals(authProvider, that.authProvider)) return false;

    if (!java.util.Objects.equals(clientCertificate, that.clientCertificate)) return false;

    if (!java.util.Objects.equals(clientCertificateData, that.clientCertificateData)) return false;

    if (!java.util.Objects.equals(clientKey, that.clientKey)) return false;

    if (!java.util.Objects.equals(clientKeyData, that.clientKeyData)) return false;

    if (!java.util.Objects.equals(exec, that.exec)) return false;

    if (!java.util.Objects.equals(extensions, that.extensions)) return false;

    if (!java.util.Objects.equals(password, that.password)) return false;

    if (!java.util.Objects.equals(token, that.token)) return false;

    if (!java.util.Objects.equals(tokenFile, that.tokenFile)) return false;

    if (!java.util.Objects.equals(username, that.username)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(as,  asGroups,  asUid,  asUserExtra,  authProvider,  clientCertificate,  clientCertificateData,  clientKey,  clientKeyData,  exec,  extensions,  password,  token,  tokenFile,  username,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (as != null) { sb.append("as:"); sb.append(as + ","); }
    if (asGroups != null && !asGroups.isEmpty()) { sb.append("asGroups:"); sb.append(asGroups + ","); }
    if (asUid != null) { sb.append("asUid:"); sb.append(asUid + ","); }
    if (asUserExtra != null && !asUserExtra.isEmpty()) { sb.append("asUserExtra:"); sb.append(asUserExtra + ","); }
    if (authProvider != null) { sb.append("authProvider:"); sb.append(authProvider + ","); }
    if (clientCertificate != null) { sb.append("clientCertificate:"); sb.append(clientCertificate + ","); }
    if (clientCertificateData != null) { sb.append("clientCertificateData:"); sb.append(clientCertificateData + ","); }
    if (clientKey != null) { sb.append("clientKey:"); sb.append(clientKey + ","); }
    if (clientKeyData != null) { sb.append("clientKeyData:"); sb.append(clientKeyData + ","); }
    if (exec != null) { sb.append("exec:"); sb.append(exec + ","); }
    if (extensions != null && !extensions.isEmpty()) { sb.append("extensions:"); sb.append(extensions + ","); }
    if (password != null) { sb.append("password:"); sb.append(password + ","); }
    if (token != null) { sb.append("token:"); sb.append(token + ","); }
    if (tokenFile != null) { sb.append("tokenFile:"); sb.append(tokenFile + ","); }
    if (username != null) { sb.append("username:"); sb.append(username + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class AuthProviderNestedImpl<N> extends AuthProviderConfigFluentImpl<AuthInfoFluentImpl.AuthProviderNested<N>> implements AuthInfoFluentImpl.AuthProviderNested<N>,Nested<N>{
    AuthProviderNestedImpl(AuthProviderConfig item) {
      this.builder = new AuthProviderConfigBuilder(this, item);
    }
    AuthProviderNestedImpl() {
      this.builder = new AuthProviderConfigBuilder(this);
    }
    AuthProviderConfigBuilder builder;
    public N and() {
      return (N) AuthInfoFluentImpl.this.withAuthProvider(builder.build());
    }
    public N endAuthProvider() {
      return and();
    }
    
  }
  class ExecNestedImpl<N> extends ExecConfigFluentImpl<AuthInfoFluentImpl.ExecNested<N>> implements AuthInfoFluentImpl.ExecNested<N>,Nested<N>{
    ExecNestedImpl(ExecConfig item) {
      this.builder = new ExecConfigBuilder(this, item);
    }
    ExecNestedImpl() {
      this.builder = new ExecConfigBuilder(this);
    }
    ExecConfigBuilder builder;
    public N and() {
      return (N) AuthInfoFluentImpl.this.withExec(builder.build());
    }
    public N endExec() {
      return and();
    }
    
  }
  class ExtensionsNestedImpl<N> extends NamedExtensionFluentImpl<AuthInfoFluentImpl.ExtensionsNested<N>> implements AuthInfoFluentImpl.ExtensionsNested<N>,Nested<N>{
    ExtensionsNestedImpl(int index,NamedExtension item) {
      this.index = index;
      this.builder = new NamedExtensionBuilder(this, item);
    }
    ExtensionsNestedImpl() {
      this.index = -1;
      this.builder = new NamedExtensionBuilder(this);
    }
    NamedExtensionBuilder builder;
    int index;
    public N and() {
      return (N) AuthInfoFluentImpl.this.setToExtensions(index,builder.build());
    }
    public N endExtension() {
      return and();
    }
    
  }
  
}