package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class AuthInfoBuilder extends AuthInfoFluentImpl<AuthInfoBuilder> implements VisitableBuilder<AuthInfo,AuthInfoBuilder>{
  public AuthInfoBuilder() {
    this(false);
  }
  public AuthInfoBuilder(Boolean validationEnabled) {
    this(new AuthInfo(), validationEnabled);
  }
  public AuthInfoBuilder(AuthInfoFluent<?> fluent) {
    this(fluent, false);
  }
  public AuthInfoBuilder(AuthInfoFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new AuthInfo(), validationEnabled);
  }
  public AuthInfoBuilder(AuthInfoFluent<?> fluent,AuthInfo instance) {
    this(fluent, instance, false);
  }
  public AuthInfoBuilder(AuthInfoFluent<?> fluent,AuthInfo instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withAs(instance.getAs());
      fluent.withAsGroups(instance.getAsGroups());
      fluent.withAsUid(instance.getAsUid());
      fluent.withAsUserExtra(instance.getAsUserExtra());
      fluent.withAuthProvider(instance.getAuthProvider());
      fluent.withClientCertificate(instance.getClientCertificate());
      fluent.withClientCertificateData(instance.getClientCertificateData());
      fluent.withClientKey(instance.getClientKey());
      fluent.withClientKeyData(instance.getClientKeyData());
      fluent.withExec(instance.getExec());
      fluent.withExtensions(instance.getExtensions());
      fluent.withPassword(instance.getPassword());
      fluent.withToken(instance.getToken());
      fluent.withTokenFile(instance.getTokenFile());
      fluent.withUsername(instance.getUsername());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public AuthInfoBuilder(AuthInfo instance) {
    this(instance,false);
  }
  public AuthInfoBuilder(AuthInfo instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withAs(instance.getAs());
      this.withAsGroups(instance.getAsGroups());
      this.withAsUid(instance.getAsUid());
      this.withAsUserExtra(instance.getAsUserExtra());
      this.withAuthProvider(instance.getAuthProvider());
      this.withClientCertificate(instance.getClientCertificate());
      this.withClientCertificateData(instance.getClientCertificateData());
      this.withClientKey(instance.getClientKey());
      this.withClientKeyData(instance.getClientKeyData());
      this.withExec(instance.getExec());
      this.withExtensions(instance.getExtensions());
      this.withPassword(instance.getPassword());
      this.withToken(instance.getToken());
      this.withTokenFile(instance.getTokenFile());
      this.withUsername(instance.getUsername());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  AuthInfoFluent<?> fluent;
  Boolean validationEnabled;
  public AuthInfo build() {
    AuthInfo buildable = new AuthInfo(fluent.getAs(),fluent.getAsGroups(),fluent.getAsUid(),fluent.getAsUserExtra(),fluent.getAuthProvider(),fluent.getClientCertificate(),fluent.getClientCertificateData(),fluent.getClientKey(),fluent.getClientKeyData(),fluent.getExec(),fluent.getExtensions(),fluent.getPassword(),fluent.getToken(),fluent.getTokenFile(),fluent.getUsername());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}