package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class APIServiceSpecBuilder extends APIServiceSpecFluentImpl<APIServiceSpecBuilder> implements VisitableBuilder<APIServiceSpec,APIServiceSpecBuilder>{
  public APIServiceSpecBuilder() {
    this(false);
  }
  public APIServiceSpecBuilder(Boolean validationEnabled) {
    this(new APIServiceSpec(), validationEnabled);
  }
  public APIServiceSpecBuilder(APIServiceSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public APIServiceSpecBuilder(APIServiceSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new APIServiceSpec(), validationEnabled);
  }
  public APIServiceSpecBuilder(APIServiceSpecFluent<?> fluent,APIServiceSpec instance) {
    this(fluent, instance, false);
  }
  public APIServiceSpecBuilder(APIServiceSpecFluent<?> fluent,APIServiceSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withCaBundle(instance.getCaBundle());
      fluent.withGroup(instance.getGroup());
      fluent.withGroupPriorityMinimum(instance.getGroupPriorityMinimum());
      fluent.withInsecureSkipTLSVerify(instance.getInsecureSkipTLSVerify());
      fluent.withService(instance.getService());
      fluent.withVersion(instance.getVersion());
      fluent.withVersionPriority(instance.getVersionPriority());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public APIServiceSpecBuilder(APIServiceSpec instance) {
    this(instance,false);
  }
  public APIServiceSpecBuilder(APIServiceSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withCaBundle(instance.getCaBundle());
      this.withGroup(instance.getGroup());
      this.withGroupPriorityMinimum(instance.getGroupPriorityMinimum());
      this.withInsecureSkipTLSVerify(instance.getInsecureSkipTLSVerify());
      this.withService(instance.getService());
      this.withVersion(instance.getVersion());
      this.withVersionPriority(instance.getVersionPriority());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  APIServiceSpecFluent<?> fluent;
  Boolean validationEnabled;
  public APIServiceSpec build() {
    APIServiceSpec buildable = new APIServiceSpec(fluent.getCaBundle(),fluent.getGroup(),fluent.getGroupPriorityMinimum(),fluent.getInsecureSkipTLSVerify(),fluent.getService(),fluent.getVersion(),fluent.getVersionPriority());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}