package io.fabric8.kubernetes.api.model;

import java.lang.String;
import java.lang.Deprecated;
import java.lang.Long;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.model.version.Info;
import java.lang.Integer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import java.lang.Object;
import java.util.Map;
import io.fabric8.kubernetes.api.model.version.InfoBuilder;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.model.version.InfoFluentImpl;
import io.fabric8.kubernetes.api.builder.Nested;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ValidationSchemaFluentImpl<A extends ValidationSchemaFluent<A>> extends BaseFluent<A> implements ValidationSchemaFluent<A>{
  public ValidationSchemaFluentImpl() {
  }
  public ValidationSchemaFluentImpl(ValidationSchema instance) {
    if (instance != null) {
      this.withAPIGroup(instance.getAPIGroup());
      this.withAPIGroupList(instance.getAPIGroupList());
      this.withAPIResource(instance.getAPIResource());
      this.withAPIResourceList(instance.getAPIResourceList());
      this.withAPIService(instance.getAPIService());
      this.withAPIServiceList(instance.getAPIServiceList());
      this.withBinding(instance.getBinding());
      this.withComponentStatus(instance.getComponentStatus());
      this.withComponentStatusList(instance.getComponentStatusList());
      this.withCondition(instance.getCondition());
      this.withConfig(instance.getConfig());
      this.withConfigMap(instance.getConfigMap());
      this.withConfigMapList(instance.getConfigMapList());
      this.withContainerStatus(instance.getContainerStatus());
      this.withCreateOptions(instance.getCreateOptions());
      this.withDeleteOptions(instance.getDeleteOptions());
      this.withEndpointPort(instance.getEndpointPort());
      this.withEndpoints(instance.getEndpoints());
      this.withEndpointsList(instance.getEndpointsList());
      this.withEnvVar(instance.getEnvVar());
      this.withEvent(instance.getEvent());
      this.withEventList(instance.getEventList());
      this.withEventSeries(instance.getEventSeries());
      this.withEventSource(instance.getEventSource());
      this.withGetOptions(instance.getGetOptions());
      this.withGroupKind(instance.getGroupKind());
      this.withGroupVersionKind(instance.getGroupVersionKind());
      this.withGroupVersionResource(instance.getGroupVersionResource());
      this.withInfo(instance.getInfo());
      this.withKubernetesList(instance.getKubernetesList());
      this.withLimitRangeList(instance.getLimitRangeList());
      this.withListOptions(instance.getListOptions());
      this.withMicroTime(instance.getMicroTime());
      this.withNamespace(instance.getNamespace());
      this.withNamespaceList(instance.getNamespaceList());
      this.withNode(instance.getNode());
      this.withNodeList(instance.getNodeList());
      this.withObjectMeta(instance.getObjectMeta());
      this.withPatch(instance.getPatch());
      this.withPatchOptions(instance.getPatchOptions());
      this.withPersistentVolume(instance.getPersistentVolume());
      this.withPersistentVolumeClaim(instance.getPersistentVolumeClaim());
      this.withPersistentVolumeClaimList(instance.getPersistentVolumeClaimList());
      this.withPersistentVolumeList(instance.getPersistentVolumeList());
      this.withPodExecOptions(instance.getPodExecOptions());
      this.withPodList(instance.getPodList());
      this.withPodTemplateList(instance.getPodTemplateList());
      this.withQuantity(instance.getQuantity());
      this.withReplicationControllerList(instance.getReplicationControllerList());
      this.withResourceQuota(instance.getResourceQuota());
      this.withResourceQuotaList(instance.getResourceQuotaList());
      this.withRootPaths(instance.getRootPaths());
      this.withSecret(instance.getSecret());
      this.withSecretList(instance.getSecretList());
      this.withServiceAccount(instance.getServiceAccount());
      this.withServiceAccountList(instance.getServiceAccountList());
      this.withServiceList(instance.getServiceList());
      this.withStatus(instance.getStatus());
      this.withTime(instance.getTime());
      this.withToleration(instance.getToleration());
      this.withTopologySelectorTerm(instance.getTopologySelectorTerm());
      this.withTypeMeta(instance.getTypeMeta());
      this.withUpdateOptions(instance.getUpdateOptions());
      this.withWatchEvent(instance.getWatchEvent());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private APIGroupBuilder aPIGroup;
  private APIGroupListBuilder aPIGroupList;
  private APIResourceBuilder aPIResource;
  private APIResourceListBuilder aPIResourceList;
  private APIServiceBuilder aPIService;
  private APIServiceListBuilder aPIServiceList;
  private BindingBuilder binding;
  private ComponentStatusBuilder componentStatus;
  private ComponentStatusListBuilder componentStatusList;
  private ConditionBuilder condition;
  private ConfigBuilder config;
  private ConfigMapBuilder configMap;
  private ConfigMapListBuilder configMapList;
  private ContainerStatusBuilder containerStatus;
  private CreateOptionsBuilder createOptions;
  private DeleteOptionsBuilder deleteOptions;
  private EndpointPortBuilder endpointPort;
  private EndpointsBuilder endpoints;
  private EndpointsListBuilder endpointsList;
  private EnvVarBuilder envVar;
  private EventBuilder event;
  private EventListBuilder eventList;
  private EventSeriesBuilder eventSeries;
  private EventSourceBuilder eventSource;
  private GetOptionsBuilder getOptions;
  private GroupKindBuilder groupKind;
  private GroupVersionKindBuilder groupVersionKind;
  private GroupVersionResourceBuilder groupVersionResource;
  private InfoBuilder info;
  private KubernetesListBuilder kubernetesList;
  private LimitRangeListBuilder limitRangeList;
  private ListOptionsBuilder listOptions;
  private MicroTimeBuilder microTime;
  private NamespaceBuilder namespace;
  private NamespaceListBuilder namespaceList;
  private NodeBuilder node;
  private NodeListBuilder nodeList;
  private ObjectMetaBuilder objectMeta;
  private PatchBuilder patch;
  private PatchOptionsBuilder patchOptions;
  private PersistentVolumeBuilder persistentVolume;
  private PersistentVolumeClaimBuilder persistentVolumeClaim;
  private PersistentVolumeClaimListBuilder persistentVolumeClaimList;
  private PersistentVolumeListBuilder persistentVolumeList;
  private PodExecOptionsBuilder podExecOptions;
  private PodListBuilder podList;
  private PodTemplateListBuilder podTemplateList;
  private QuantityBuilder quantity;
  private ReplicationControllerListBuilder replicationControllerList;
  private ResourceQuotaBuilder resourceQuota;
  private ResourceQuotaListBuilder resourceQuotaList;
  private RootPathsBuilder rootPaths;
  private SecretBuilder secret;
  private SecretListBuilder secretList;
  private ServiceAccountBuilder serviceAccount;
  private ServiceAccountListBuilder serviceAccountList;
  private ServiceListBuilder serviceList;
  private StatusBuilder status;
  private String time;
  private TolerationBuilder toleration;
  private TopologySelectorTermBuilder topologySelectorTerm;
  private TypeMetaBuilder typeMeta;
  private UpdateOptionsBuilder updateOptions;
  private WatchEventBuilder watchEvent;
  private Map<String,Object> additionalProperties;
  
  /**
   * This method has been deprecated, please use method buildAPIGroup instead.
   * @return The buildable object.
   */
  @Deprecated
  public APIGroup getAPIGroup() {
    return this.aPIGroup!=null ?this.aPIGroup.build():null;
  }
  public APIGroup buildAPIGroup() {
    return this.aPIGroup!=null ?this.aPIGroup.build():null;
  }
  public A withAPIGroup(APIGroup aPIGroup) {
    _visitables.get("aPIGroup").remove(this.aPIGroup);
    if (aPIGroup!=null){ this.aPIGroup= new APIGroupBuilder(aPIGroup); _visitables.get("aPIGroup").add(this.aPIGroup);} else { this.aPIGroup = null; _visitables.get("aPIGroup").remove(this.aPIGroup); } return (A) this;
  }
  public Boolean hasAPIGroup() {
    return this.aPIGroup != null;
  }
  public ValidationSchemaFluentImpl.APIGroupNested<A> withNewAPIGroup() {
    return new ValidationSchemaFluentImpl.APIGroupNestedImpl();
  }
  public ValidationSchemaFluentImpl.APIGroupNested<A> withNewAPIGroupLike(APIGroup item) {
    return new ValidationSchemaFluentImpl.APIGroupNestedImpl(item);
  }
  public ValidationSchemaFluentImpl.APIGroupNested<A> editAPIGroup() {
    return withNewAPIGroupLike(getAPIGroup());
  }
  public ValidationSchemaFluentImpl.APIGroupNested<A> editOrNewAPIGroup() {
    return withNewAPIGroupLike(getAPIGroup() != null ? getAPIGroup(): new APIGroupBuilder().build());
  }
  public ValidationSchemaFluentImpl.APIGroupNested<A> editOrNewAPIGroupLike(APIGroup item) {
    return withNewAPIGroupLike(getAPIGroup() != null ? getAPIGroup(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildAPIGroupList instead.
   * @return The buildable object.
   */
  @Deprecated
  public APIGroupList getAPIGroupList() {
    return this.aPIGroupList!=null ?this.aPIGroupList.build():null;
  }
  public APIGroupList buildAPIGroupList() {
    return this.aPIGroupList!=null ?this.aPIGroupList.build():null;
  }
  public A withAPIGroupList(APIGroupList aPIGroupList) {
    _visitables.get("aPIGroupList").remove(this.aPIGroupList);
    if (aPIGroupList!=null){ this.aPIGroupList= new APIGroupListBuilder(aPIGroupList); _visitables.get("aPIGroupList").add(this.aPIGroupList);} else { this.aPIGroupList = null; _visitables.get("aPIGroupList").remove(this.aPIGroupList); } return (A) this;
  }
  public Boolean hasAPIGroupList() {
    return this.aPIGroupList != null;
  }
  public ValidationSchemaFluentImpl.APIGroupListNested<A> withNewAPIGroupList() {
    return new ValidationSchemaFluentImpl.APIGroupListNestedImpl();
  }
  public ValidationSchemaFluentImpl.APIGroupListNested<A> withNewAPIGroupListLike(APIGroupList item) {
    return new ValidationSchemaFluentImpl.APIGroupListNestedImpl(item);
  }
  public ValidationSchemaFluentImpl.APIGroupListNested<A> editAPIGroupList() {
    return withNewAPIGroupListLike(getAPIGroupList());
  }
  public ValidationSchemaFluentImpl.APIGroupListNested<A> editOrNewAPIGroupList() {
    return withNewAPIGroupListLike(getAPIGroupList() != null ? getAPIGroupList(): new APIGroupListBuilder().build());
  }
  public ValidationSchemaFluentImpl.APIGroupListNested<A> editOrNewAPIGroupListLike(APIGroupList item) {
    return withNewAPIGroupListLike(getAPIGroupList() != null ? getAPIGroupList(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildAPIResource instead.
   * @return The buildable object.
   */
  @Deprecated
  public APIResource getAPIResource() {
    return this.aPIResource!=null ?this.aPIResource.build():null;
  }
  public APIResource buildAPIResource() {
    return this.aPIResource!=null ?this.aPIResource.build():null;
  }
  public A withAPIResource(APIResource aPIResource) {
    _visitables.get("aPIResource").remove(this.aPIResource);
    if (aPIResource!=null){ this.aPIResource= new APIResourceBuilder(aPIResource); _visitables.get("aPIResource").add(this.aPIResource);} else { this.aPIResource = null; _visitables.get("aPIResource").remove(this.aPIResource); } return (A) this;
  }
  public Boolean hasAPIResource() {
    return this.aPIResource != null;
  }
  public ValidationSchemaFluentImpl.APIResourceNested<A> withNewAPIResource() {
    return new ValidationSchemaFluentImpl.APIResourceNestedImpl();
  }
  public ValidationSchemaFluentImpl.APIResourceNested<A> withNewAPIResourceLike(APIResource item) {
    return new ValidationSchemaFluentImpl.APIResourceNestedImpl(item);
  }
  public ValidationSchemaFluentImpl.APIResourceNested<A> editAPIResource() {
    return withNewAPIResourceLike(getAPIResource());
  }
  public ValidationSchemaFluentImpl.APIResourceNested<A> editOrNewAPIResource() {
    return withNewAPIResourceLike(getAPIResource() != null ? getAPIResource(): new APIResourceBuilder().build());
  }
  public ValidationSchemaFluentImpl.APIResourceNested<A> editOrNewAPIResourceLike(APIResource item) {
    return withNewAPIResourceLike(getAPIResource() != null ? getAPIResource(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildAPIResourceList instead.
   * @return The buildable object.
   */
  @Deprecated
  public APIResourceList getAPIResourceList() {
    return this.aPIResourceList!=null ?this.aPIResourceList.build():null;
  }
  public APIResourceList buildAPIResourceList() {
    return this.aPIResourceList!=null ?this.aPIResourceList.build():null;
  }
  public A withAPIResourceList(APIResourceList aPIResourceList) {
    _visitables.get("aPIResourceList").remove(this.aPIResourceList);
    if (aPIResourceList!=null){ this.aPIResourceList= new APIResourceListBuilder(aPIResourceList); _visitables.get("aPIResourceList").add(this.aPIResourceList);} else { this.aPIResourceList = null; _visitables.get("aPIResourceList").remove(this.aPIResourceList); } return (A) this;
  }
  public Boolean hasAPIResourceList() {
    return this.aPIResourceList != null;
  }
  public ValidationSchemaFluentImpl.APIResourceListNested<A> withNewAPIResourceList() {
    return new ValidationSchemaFluentImpl.APIResourceListNestedImpl();
  }
  public ValidationSchemaFluentImpl.APIResourceListNested<A> withNewAPIResourceListLike(APIResourceList item) {
    return new ValidationSchemaFluentImpl.APIResourceListNestedImpl(item);
  }
  public ValidationSchemaFluentImpl.APIResourceListNested<A> editAPIResourceList() {
    return withNewAPIResourceListLike(getAPIResourceList());
  }
  public ValidationSchemaFluentImpl.APIResourceListNested<A> editOrNewAPIResourceList() {
    return withNewAPIResourceListLike(getAPIResourceList() != null ? getAPIResourceList(): new APIResourceListBuilder().build());
  }
  public ValidationSchemaFluentImpl.APIResourceListNested<A> editOrNewAPIResourceListLike(APIResourceList item) {
    return withNewAPIResourceListLike(getAPIResourceList() != null ? getAPIResourceList(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildAPIService instead.
   * @return The buildable object.
   */
  @Deprecated
  public APIService getAPIService() {
    return this.aPIService!=null ?this.aPIService.build():null;
  }
  public APIService buildAPIService() {
    return this.aPIService!=null ?this.aPIService.build():null;
  }
  public A withAPIService(APIService aPIService) {
    _visitables.get("aPIService").remove(this.aPIService);
    if (aPIService!=null){ this.aPIService= new APIServiceBuilder(aPIService); _visitables.get("aPIService").add(this.aPIService);} else { this.aPIService = null; _visitables.get("aPIService").remove(this.aPIService); } return (A) this;
  }
  public Boolean hasAPIService() {
    return this.aPIService != null;
  }
  public ValidationSchemaFluentImpl.APIServiceNested<A> withNewAPIService() {
    return new ValidationSchemaFluentImpl.APIServiceNestedImpl();
  }
  public ValidationSchemaFluentImpl.APIServiceNested<A> withNewAPIServiceLike(APIService item) {
    return new ValidationSchemaFluentImpl.APIServiceNestedImpl(item);
  }
  public ValidationSchemaFluentImpl.APIServiceNested<A> editAPIService() {
    return withNewAPIServiceLike(getAPIService());
  }
  public ValidationSchemaFluentImpl.APIServiceNested<A> editOrNewAPIService() {
    return withNewAPIServiceLike(getAPIService() != null ? getAPIService(): new APIServiceBuilder().build());
  }
  public ValidationSchemaFluentImpl.APIServiceNested<A> editOrNewAPIServiceLike(APIService item) {
    return withNewAPIServiceLike(getAPIService() != null ? getAPIService(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildAPIServiceList instead.
   * @return The buildable object.
   */
  @Deprecated
  public APIServiceList getAPIServiceList() {
    return this.aPIServiceList!=null ?this.aPIServiceList.build():null;
  }
  public APIServiceList buildAPIServiceList() {
    return this.aPIServiceList!=null ?this.aPIServiceList.build():null;
  }
  public A withAPIServiceList(APIServiceList aPIServiceList) {
    _visitables.get("aPIServiceList").remove(this.aPIServiceList);
    if (aPIServiceList!=null){ this.aPIServiceList= new APIServiceListBuilder(aPIServiceList); _visitables.get("aPIServiceList").add(this.aPIServiceList);} else { this.aPIServiceList = null; _visitables.get("aPIServiceList").remove(this.aPIServiceList); } return (A) this;
  }
  public Boolean hasAPIServiceList() {
    return this.aPIServiceList != null;
  }
  public ValidationSchemaFluentImpl.APIServiceListNested<A> withNewAPIServiceList() {
    return new ValidationSchemaFluentImpl.APIServiceListNestedImpl();
  }
  public ValidationSchemaFluentImpl.APIServiceListNested<A> withNewAPIServiceListLike(APIServiceList item) {
    return new ValidationSchemaFluentImpl.APIServiceListNestedImpl(item);
  }
  public ValidationSchemaFluentImpl.APIServiceListNested<A> editAPIServiceList() {
    return withNewAPIServiceListLike(getAPIServiceList());
  }
  public ValidationSchemaFluentImpl.APIServiceListNested<A> editOrNewAPIServiceList() {
    return withNewAPIServiceListLike(getAPIServiceList() != null ? getAPIServiceList(): new APIServiceListBuilder().build());
  }
  public ValidationSchemaFluentImpl.APIServiceListNested<A> editOrNewAPIServiceListLike(APIServiceList item) {
    return withNewAPIServiceListLike(getAPIServiceList() != null ? getAPIServiceList(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildBinding instead.
   * @return The buildable object.
   */
  @Deprecated
  public Binding getBinding() {
    return this.binding!=null ?this.binding.build():null;
  }
  public Binding buildBinding() {
    return this.binding!=null ?this.binding.build():null;
  }
  public A withBinding(Binding binding) {
    _visitables.get("binding").remove(this.binding);
    if (binding!=null){ this.binding= new BindingBuilder(binding); _visitables.get("binding").add(this.binding);} else { this.binding = null; _visitables.get("binding").remove(this.binding); } return (A) this;
  }
  public Boolean hasBinding() {
    return this.binding != null;
  }
  public ValidationSchemaFluentImpl.BindingNested<A> withNewBinding() {
    return new ValidationSchemaFluentImpl.BindingNestedImpl();
  }
  public ValidationSchemaFluentImpl.BindingNested<A> withNewBindingLike(Binding item) {
    return new ValidationSchemaFluentImpl.BindingNestedImpl(item);
  }
  public ValidationSchemaFluentImpl.BindingNested<A> editBinding() {
    return withNewBindingLike(getBinding());
  }
  public ValidationSchemaFluentImpl.BindingNested<A> editOrNewBinding() {
    return withNewBindingLike(getBinding() != null ? getBinding(): new BindingBuilder().build());
  }
  public ValidationSchemaFluentImpl.BindingNested<A> editOrNewBindingLike(Binding item) {
    return withNewBindingLike(getBinding() != null ? getBinding(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildComponentStatus instead.
   * @return The buildable object.
   */
  @Deprecated
  public ComponentStatus getComponentStatus() {
    return this.componentStatus!=null ?this.componentStatus.build():null;
  }
  public ComponentStatus buildComponentStatus() {
    return this.componentStatus!=null ?this.componentStatus.build():null;
  }
  public A withComponentStatus(ComponentStatus componentStatus) {
    _visitables.get("componentStatus").remove(this.componentStatus);
    if (componentStatus!=null){ this.componentStatus= new ComponentStatusBuilder(componentStatus); _visitables.get("componentStatus").add(this.componentStatus);} else { this.componentStatus = null; _visitables.get("componentStatus").remove(this.componentStatus); } return (A) this;
  }
  public Boolean hasComponentStatus() {
    return this.componentStatus != null;
  }
  public ValidationSchemaFluentImpl.ComponentStatusNested<A> withNewComponentStatus() {
    return new ValidationSchemaFluentImpl.ComponentStatusNestedImpl();
  }
  public ValidationSchemaFluentImpl.ComponentStatusNested<A> withNewComponentStatusLike(ComponentStatus item) {
    return new ValidationSchemaFluentImpl.ComponentStatusNestedImpl(item);
  }
  public ValidationSchemaFluentImpl.ComponentStatusNested<A> editComponentStatus() {
    return withNewComponentStatusLike(getComponentStatus());
  }
  public ValidationSchemaFluentImpl.ComponentStatusNested<A> editOrNewComponentStatus() {
    return withNewComponentStatusLike(getComponentStatus() != null ? getComponentStatus(): new ComponentStatusBuilder().build());
  }
  public ValidationSchemaFluentImpl.ComponentStatusNested<A> editOrNewComponentStatusLike(ComponentStatus item) {
    return withNewComponentStatusLike(getComponentStatus() != null ? getComponentStatus(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildComponentStatusList instead.
   * @return The buildable object.
   */
  @Deprecated
  public ComponentStatusList getComponentStatusList() {
    return this.componentStatusList!=null ?this.componentStatusList.build():null;
  }
  public ComponentStatusList buildComponentStatusList() {
    return this.componentStatusList!=null ?this.componentStatusList.build():null;
  }
  public A withComponentStatusList(ComponentStatusList componentStatusList) {
    _visitables.get("componentStatusList").remove(this.componentStatusList);
    if (componentStatusList!=null){ this.componentStatusList= new ComponentStatusListBuilder(componentStatusList); _visitables.get("componentStatusList").add(this.componentStatusList);} else { this.componentStatusList = null; _visitables.get("componentStatusList").remove(this.componentStatusList); } return (A) this;
  }
  public Boolean hasComponentStatusList() {
    return this.componentStatusList != null;
  }
  public ValidationSchemaFluentImpl.ComponentStatusListNested<A> withNewComponentStatusList() {
    return new ValidationSchemaFluentImpl.ComponentStatusListNestedImpl();
  }
  public ValidationSchemaFluentImpl.ComponentStatusListNested<A> withNewComponentStatusListLike(ComponentStatusList item) {
    return new ValidationSchemaFluentImpl.ComponentStatusListNestedImpl(item);
  }
  public ValidationSchemaFluentImpl.ComponentStatusListNested<A> editComponentStatusList() {
    return withNewComponentStatusListLike(getComponentStatusList());
  }
  public ValidationSchemaFluentImpl.ComponentStatusListNested<A> editOrNewComponentStatusList() {
    return withNewComponentStatusListLike(getComponentStatusList() != null ? getComponentStatusList(): new ComponentStatusListBuilder().build());
  }
  public ValidationSchemaFluentImpl.ComponentStatusListNested<A> editOrNewComponentStatusListLike(ComponentStatusList item) {
    return withNewComponentStatusListLike(getComponentStatusList() != null ? getComponentStatusList(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildCondition instead.
   * @return The buildable object.
   */
  @Deprecated
  public Condition getCondition() {
    return this.condition!=null ?this.condition.build():null;
  }
  public Condition buildCondition() {
    return this.condition!=null ?this.condition.build():null;
  }
  public A withCondition(Condition condition) {
    _visitables.get("condition").remove(this.condition);
    if (condition!=null){ this.condition= new ConditionBuilder(condition); _visitables.get("condition").add(this.condition);} else { this.condition = null; _visitables.get("condition").remove(this.condition); } return (A) this;
  }
  public Boolean hasCondition() {
    return this.condition != null;
  }
  public ValidationSchemaFluentImpl.ConditionNested<A> withNewCondition() {
    return new ValidationSchemaFluentImpl.ConditionNestedImpl();
  }
  public ValidationSchemaFluentImpl.ConditionNested<A> withNewConditionLike(Condition item) {
    return new ValidationSchemaFluentImpl.ConditionNestedImpl(item);
  }
  public ValidationSchemaFluentImpl.ConditionNested<A> editCondition() {
    return withNewConditionLike(getCondition());
  }
  public ValidationSchemaFluentImpl.ConditionNested<A> editOrNewCondition() {
    return withNewConditionLike(getCondition() != null ? getCondition(): new ConditionBuilder().build());
  }
  public ValidationSchemaFluentImpl.ConditionNested<A> editOrNewConditionLike(Condition item) {
    return withNewConditionLike(getCondition() != null ? getCondition(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildConfig instead.
   * @return The buildable object.
   */
  @Deprecated
  public Config getConfig() {
    return this.config!=null ?this.config.build():null;
  }
  public Config buildConfig() {
    return this.config!=null ?this.config.build():null;
  }
  public A withConfig(Config config) {
    _visitables.get("config").remove(this.config);
    if (config!=null){ this.config= new ConfigBuilder(config); _visitables.get("config").add(this.config);} else { this.config = null; _visitables.get("config").remove(this.config); } return (A) this;
  }
  public Boolean hasConfig() {
    return this.config != null;
  }
  public ValidationSchemaFluentImpl.ConfigNested<A> withNewConfig() {
    return new ValidationSchemaFluentImpl.ConfigNestedImpl();
  }
  public ValidationSchemaFluentImpl.ConfigNested<A> withNewConfigLike(Config item) {
    return new ValidationSchemaFluentImpl.ConfigNestedImpl(item);
  }
  public ValidationSchemaFluentImpl.ConfigNested<A> editConfig() {
    return withNewConfigLike(getConfig());
  }
  public ValidationSchemaFluentImpl.ConfigNested<A> editOrNewConfig() {
    return withNewConfigLike(getConfig() != null ? getConfig(): new ConfigBuilder().build());
  }
  public ValidationSchemaFluentImpl.ConfigNested<A> editOrNewConfigLike(Config item) {
    return withNewConfigLike(getConfig() != null ? getConfig(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildConfigMap instead.
   * @return The buildable object.
   */
  @Deprecated
  public ConfigMap getConfigMap() {
    return this.configMap!=null ?this.configMap.build():null;
  }
  public ConfigMap buildConfigMap() {
    return this.configMap!=null ?this.configMap.build():null;
  }
  public A withConfigMap(ConfigMap configMap) {
    _visitables.get("configMap").remove(this.configMap);
    if (configMap!=null){ this.configMap= new ConfigMapBuilder(configMap); _visitables.get("configMap").add(this.configMap);} else { this.configMap = null; _visitables.get("configMap").remove(this.configMap); } return (A) this;
  }
  public Boolean hasConfigMap() {
    return this.configMap != null;
  }
  public ValidationSchemaFluentImpl.ConfigMapNested<A> withNewConfigMap() {
    return new ValidationSchemaFluentImpl.ConfigMapNestedImpl();
  }
  public ValidationSchemaFluentImpl.ConfigMapNested<A> withNewConfigMapLike(ConfigMap item) {
    return new ValidationSchemaFluentImpl.ConfigMapNestedImpl(item);
  }
  public ValidationSchemaFluentImpl.ConfigMapNested<A> editConfigMap() {
    return withNewConfigMapLike(getConfigMap());
  }
  public ValidationSchemaFluentImpl.ConfigMapNested<A> editOrNewConfigMap() {
    return withNewConfigMapLike(getConfigMap() != null ? getConfigMap(): new ConfigMapBuilder().build());
  }
  public ValidationSchemaFluentImpl.ConfigMapNested<A> editOrNewConfigMapLike(ConfigMap item) {
    return withNewConfigMapLike(getConfigMap() != null ? getConfigMap(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildConfigMapList instead.
   * @return The buildable object.
   */
  @Deprecated
  public ConfigMapList getConfigMapList() {
    return this.configMapList!=null ?this.configMapList.build():null;
  }
  public ConfigMapList buildConfigMapList() {
    return this.configMapList!=null ?this.configMapList.build():null;
  }
  public A withConfigMapList(ConfigMapList configMapList) {
    _visitables.get("configMapList").remove(this.configMapList);
    if (configMapList!=null){ this.configMapList= new ConfigMapListBuilder(configMapList); _visitables.get("configMapList").add(this.configMapList);} else { this.configMapList = null; _visitables.get("configMapList").remove(this.configMapList); } return (A) this;
  }
  public Boolean hasConfigMapList() {
    return this.configMapList != null;
  }
  public ValidationSchemaFluentImpl.ConfigMapListNested<A> withNewConfigMapList() {
    return new ValidationSchemaFluentImpl.ConfigMapListNestedImpl();
  }
  public ValidationSchemaFluentImpl.ConfigMapListNested<A> withNewConfigMapListLike(ConfigMapList item) {
    return new ValidationSchemaFluentImpl.ConfigMapListNestedImpl(item);
  }
  public ValidationSchemaFluentImpl.ConfigMapListNested<A> editConfigMapList() {
    return withNewConfigMapListLike(getConfigMapList());
  }
  public ValidationSchemaFluentImpl.ConfigMapListNested<A> editOrNewConfigMapList() {
    return withNewConfigMapListLike(getConfigMapList() != null ? getConfigMapList(): new ConfigMapListBuilder().build());
  }
  public ValidationSchemaFluentImpl.ConfigMapListNested<A> editOrNewConfigMapListLike(ConfigMapList item) {
    return withNewConfigMapListLike(getConfigMapList() != null ? getConfigMapList(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildContainerStatus instead.
   * @return The buildable object.
   */
  @Deprecated
  public ContainerStatus getContainerStatus() {
    return this.containerStatus!=null ?this.containerStatus.build():null;
  }
  public ContainerStatus buildContainerStatus() {
    return this.containerStatus!=null ?this.containerStatus.build():null;
  }
  public A withContainerStatus(ContainerStatus containerStatus) {
    _visitables.get("containerStatus").remove(this.containerStatus);
    if (containerStatus!=null){ this.containerStatus= new ContainerStatusBuilder(containerStatus); _visitables.get("containerStatus").add(this.containerStatus);} else { this.containerStatus = null; _visitables.get("containerStatus").remove(this.containerStatus); } return (A) this;
  }
  public Boolean hasContainerStatus() {
    return this.containerStatus != null;
  }
  public ValidationSchemaFluentImpl.ContainerStatusNested<A> withNewContainerStatus() {
    return new ValidationSchemaFluentImpl.ContainerStatusNestedImpl();
  }
  public ValidationSchemaFluentImpl.ContainerStatusNested<A> withNewContainerStatusLike(ContainerStatus item) {
    return new ValidationSchemaFluentImpl.ContainerStatusNestedImpl(item);
  }
  public ValidationSchemaFluentImpl.ContainerStatusNested<A> editContainerStatus() {
    return withNewContainerStatusLike(getContainerStatus());
  }
  public ValidationSchemaFluentImpl.ContainerStatusNested<A> editOrNewContainerStatus() {
    return withNewContainerStatusLike(getContainerStatus() != null ? getContainerStatus(): new ContainerStatusBuilder().build());
  }
  public ValidationSchemaFluentImpl.ContainerStatusNested<A> editOrNewContainerStatusLike(ContainerStatus item) {
    return withNewContainerStatusLike(getContainerStatus() != null ? getContainerStatus(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildCreateOptions instead.
   * @return The buildable object.
   */
  @Deprecated
  public CreateOptions getCreateOptions() {
    return this.createOptions!=null ?this.createOptions.build():null;
  }
  public CreateOptions buildCreateOptions() {
    return this.createOptions!=null ?this.createOptions.build():null;
  }
  public A withCreateOptions(CreateOptions createOptions) {
    _visitables.get("createOptions").remove(this.createOptions);
    if (createOptions!=null){ this.createOptions= new CreateOptionsBuilder(createOptions); _visitables.get("createOptions").add(this.createOptions);} else { this.createOptions = null; _visitables.get("createOptions").remove(this.createOptions); } return (A) this;
  }
  public Boolean hasCreateOptions() {
    return this.createOptions != null;
  }
  public ValidationSchemaFluentImpl.CreateOptionsNested<A> withNewCreateOptions() {
    return new ValidationSchemaFluentImpl.CreateOptionsNestedImpl();
  }
  public ValidationSchemaFluentImpl.CreateOptionsNested<A> withNewCreateOptionsLike(CreateOptions item) {
    return new ValidationSchemaFluentImpl.CreateOptionsNestedImpl(item);
  }
  public ValidationSchemaFluentImpl.CreateOptionsNested<A> editCreateOptions() {
    return withNewCreateOptionsLike(getCreateOptions());
  }
  public ValidationSchemaFluentImpl.CreateOptionsNested<A> editOrNewCreateOptions() {
    return withNewCreateOptionsLike(getCreateOptions() != null ? getCreateOptions(): new CreateOptionsBuilder().build());
  }
  public ValidationSchemaFluentImpl.CreateOptionsNested<A> editOrNewCreateOptionsLike(CreateOptions item) {
    return withNewCreateOptionsLike(getCreateOptions() != null ? getCreateOptions(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildDeleteOptions instead.
   * @return The buildable object.
   */
  @Deprecated
  public DeleteOptions getDeleteOptions() {
    return this.deleteOptions!=null ?this.deleteOptions.build():null;
  }
  public DeleteOptions buildDeleteOptions() {
    return this.deleteOptions!=null ?this.deleteOptions.build():null;
  }
  public A withDeleteOptions(DeleteOptions deleteOptions) {
    _visitables.get("deleteOptions").remove(this.deleteOptions);
    if (deleteOptions!=null){ this.deleteOptions= new DeleteOptionsBuilder(deleteOptions); _visitables.get("deleteOptions").add(this.deleteOptions);} else { this.deleteOptions = null; _visitables.get("deleteOptions").remove(this.deleteOptions); } return (A) this;
  }
  public Boolean hasDeleteOptions() {
    return this.deleteOptions != null;
  }
  public ValidationSchemaFluentImpl.DeleteOptionsNested<A> withNewDeleteOptions() {
    return new ValidationSchemaFluentImpl.DeleteOptionsNestedImpl();
  }
  public ValidationSchemaFluentImpl.DeleteOptionsNested<A> withNewDeleteOptionsLike(DeleteOptions item) {
    return new ValidationSchemaFluentImpl.DeleteOptionsNestedImpl(item);
  }
  public ValidationSchemaFluentImpl.DeleteOptionsNested<A> editDeleteOptions() {
    return withNewDeleteOptionsLike(getDeleteOptions());
  }
  public ValidationSchemaFluentImpl.DeleteOptionsNested<A> editOrNewDeleteOptions() {
    return withNewDeleteOptionsLike(getDeleteOptions() != null ? getDeleteOptions(): new DeleteOptionsBuilder().build());
  }
  public ValidationSchemaFluentImpl.DeleteOptionsNested<A> editOrNewDeleteOptionsLike(DeleteOptions item) {
    return withNewDeleteOptionsLike(getDeleteOptions() != null ? getDeleteOptions(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildEndpointPort instead.
   * @return The buildable object.
   */
  @Deprecated
  public EndpointPort getEndpointPort() {
    return this.endpointPort!=null ?this.endpointPort.build():null;
  }
  public EndpointPort buildEndpointPort() {
    return this.endpointPort!=null ?this.endpointPort.build():null;
  }
  public A withEndpointPort(EndpointPort endpointPort) {
    _visitables.get("endpointPort").remove(this.endpointPort);
    if (endpointPort!=null){ this.endpointPort= new EndpointPortBuilder(endpointPort); _visitables.get("endpointPort").add(this.endpointPort);} else { this.endpointPort = null; _visitables.get("endpointPort").remove(this.endpointPort); } return (A) this;
  }
  public Boolean hasEndpointPort() {
    return this.endpointPort != null;
  }
  public A withNewEndpointPort(String appProtocol,String name,Integer port,String protocol) {
    return (A)withEndpointPort(new EndpointPort(appProtocol, name, port, protocol));
  }
  public ValidationSchemaFluentImpl.EndpointPortNested<A> withNewEndpointPort() {
    return new ValidationSchemaFluentImpl.EndpointPortNestedImpl();
  }
  public ValidationSchemaFluentImpl.EndpointPortNested<A> withNewEndpointPortLike(EndpointPort item) {
    return new ValidationSchemaFluentImpl.EndpointPortNestedImpl(item);
  }
  public ValidationSchemaFluentImpl.EndpointPortNested<A> editEndpointPort() {
    return withNewEndpointPortLike(getEndpointPort());
  }
  public ValidationSchemaFluentImpl.EndpointPortNested<A> editOrNewEndpointPort() {
    return withNewEndpointPortLike(getEndpointPort() != null ? getEndpointPort(): new EndpointPortBuilder().build());
  }
  public ValidationSchemaFluentImpl.EndpointPortNested<A> editOrNewEndpointPortLike(EndpointPort item) {
    return withNewEndpointPortLike(getEndpointPort() != null ? getEndpointPort(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildEndpoints instead.
   * @return The buildable object.
   */
  @Deprecated
  public Endpoints getEndpoints() {
    return this.endpoints!=null ?this.endpoints.build():null;
  }
  public Endpoints buildEndpoints() {
    return this.endpoints!=null ?this.endpoints.build():null;
  }
  public A withEndpoints(Endpoints endpoints) {
    _visitables.get("endpoints").remove(this.endpoints);
    if (endpoints!=null){ this.endpoints= new EndpointsBuilder(endpoints); _visitables.get("endpoints").add(this.endpoints);} else { this.endpoints = null; _visitables.get("endpoints").remove(this.endpoints); } return (A) this;
  }
  public Boolean hasEndpoints() {
    return this.endpoints != null;
  }
  public ValidationSchemaFluentImpl.EndpointsNested<A> withNewEndpoints() {
    return new ValidationSchemaFluentImpl.EndpointsNestedImpl();
  }
  public ValidationSchemaFluentImpl.EndpointsNested<A> withNewEndpointsLike(Endpoints item) {
    return new ValidationSchemaFluentImpl.EndpointsNestedImpl(item);
  }
  public ValidationSchemaFluentImpl.EndpointsNested<A> editEndpoints() {
    return withNewEndpointsLike(getEndpoints());
  }
  public ValidationSchemaFluentImpl.EndpointsNested<A> editOrNewEndpoints() {
    return withNewEndpointsLike(getEndpoints() != null ? getEndpoints(): new EndpointsBuilder().build());
  }
  public ValidationSchemaFluentImpl.EndpointsNested<A> editOrNewEndpointsLike(Endpoints item) {
    return withNewEndpointsLike(getEndpoints() != null ? getEndpoints(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildEndpointsList instead.
   * @return The buildable object.
   */
  @Deprecated
  public EndpointsList getEndpointsList() {
    return this.endpointsList!=null ?this.endpointsList.build():null;
  }
  public EndpointsList buildEndpointsList() {
    return this.endpointsList!=null ?this.endpointsList.build():null;
  }
  public A withEndpointsList(EndpointsList endpointsList) {
    _visitables.get("endpointsList").remove(this.endpointsList);
    if (endpointsList!=null){ this.endpointsList= new EndpointsListBuilder(endpointsList); _visitables.get("endpointsList").add(this.endpointsList);} else { this.endpointsList = null; _visitables.get("endpointsList").remove(this.endpointsList); } return (A) this;
  }
  public Boolean hasEndpointsList() {
    return this.endpointsList != null;
  }
  public ValidationSchemaFluentImpl.EndpointsListNested<A> withNewEndpointsList() {
    return new ValidationSchemaFluentImpl.EndpointsListNestedImpl();
  }
  public ValidationSchemaFluentImpl.EndpointsListNested<A> withNewEndpointsListLike(EndpointsList item) {
    return new ValidationSchemaFluentImpl.EndpointsListNestedImpl(item);
  }
  public ValidationSchemaFluentImpl.EndpointsListNested<A> editEndpointsList() {
    return withNewEndpointsListLike(getEndpointsList());
  }
  public ValidationSchemaFluentImpl.EndpointsListNested<A> editOrNewEndpointsList() {
    return withNewEndpointsListLike(getEndpointsList() != null ? getEndpointsList(): new EndpointsListBuilder().build());
  }
  public ValidationSchemaFluentImpl.EndpointsListNested<A> editOrNewEndpointsListLike(EndpointsList item) {
    return withNewEndpointsListLike(getEndpointsList() != null ? getEndpointsList(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildEnvVar instead.
   * @return The buildable object.
   */
  @Deprecated
  public EnvVar getEnvVar() {
    return this.envVar!=null ?this.envVar.build():null;
  }
  public EnvVar buildEnvVar() {
    return this.envVar!=null ?this.envVar.build():null;
  }
  public A withEnvVar(EnvVar envVar) {
    _visitables.get("envVar").remove(this.envVar);
    if (envVar!=null){ this.envVar= new EnvVarBuilder(envVar); _visitables.get("envVar").add(this.envVar);} else { this.envVar = null; _visitables.get("envVar").remove(this.envVar); } return (A) this;
  }
  public Boolean hasEnvVar() {
    return this.envVar != null;
  }
  public ValidationSchemaFluentImpl.EnvVarNested<A> withNewEnvVar() {
    return new ValidationSchemaFluentImpl.EnvVarNestedImpl();
  }
  public ValidationSchemaFluentImpl.EnvVarNested<A> withNewEnvVarLike(EnvVar item) {
    return new ValidationSchemaFluentImpl.EnvVarNestedImpl(item);
  }
  public ValidationSchemaFluentImpl.EnvVarNested<A> editEnvVar() {
    return withNewEnvVarLike(getEnvVar());
  }
  public ValidationSchemaFluentImpl.EnvVarNested<A> editOrNewEnvVar() {
    return withNewEnvVarLike(getEnvVar() != null ? getEnvVar(): new EnvVarBuilder().build());
  }
  public ValidationSchemaFluentImpl.EnvVarNested<A> editOrNewEnvVarLike(EnvVar item) {
    return withNewEnvVarLike(getEnvVar() != null ? getEnvVar(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildEvent instead.
   * @return The buildable object.
   */
  @Deprecated
  public Event getEvent() {
    return this.event!=null ?this.event.build():null;
  }
  public Event buildEvent() {
    return this.event!=null ?this.event.build():null;
  }
  public A withEvent(Event event) {
    _visitables.get("event").remove(this.event);
    if (event!=null){ this.event= new EventBuilder(event); _visitables.get("event").add(this.event);} else { this.event = null; _visitables.get("event").remove(this.event); } return (A) this;
  }
  public Boolean hasEvent() {
    return this.event != null;
  }
  public ValidationSchemaFluentImpl.EventNested<A> withNewEvent() {
    return new ValidationSchemaFluentImpl.EventNestedImpl();
  }
  public ValidationSchemaFluentImpl.EventNested<A> withNewEventLike(Event item) {
    return new ValidationSchemaFluentImpl.EventNestedImpl(item);
  }
  public ValidationSchemaFluentImpl.EventNested<A> editEvent() {
    return withNewEventLike(getEvent());
  }
  public ValidationSchemaFluentImpl.EventNested<A> editOrNewEvent() {
    return withNewEventLike(getEvent() != null ? getEvent(): new EventBuilder().build());
  }
  public ValidationSchemaFluentImpl.EventNested<A> editOrNewEventLike(Event item) {
    return withNewEventLike(getEvent() != null ? getEvent(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildEventList instead.
   * @return The buildable object.
   */
  @Deprecated
  public EventList getEventList() {
    return this.eventList!=null ?this.eventList.build():null;
  }
  public EventList buildEventList() {
    return this.eventList!=null ?this.eventList.build():null;
  }
  public A withEventList(EventList eventList) {
    _visitables.get("eventList").remove(this.eventList);
    if (eventList!=null){ this.eventList= new EventListBuilder(eventList); _visitables.get("eventList").add(this.eventList);} else { this.eventList = null; _visitables.get("eventList").remove(this.eventList); } return (A) this;
  }
  public Boolean hasEventList() {
    return this.eventList != null;
  }
  public ValidationSchemaFluentImpl.EventListNested<A> withNewEventList() {
    return new ValidationSchemaFluentImpl.EventListNestedImpl();
  }
  public ValidationSchemaFluentImpl.EventListNested<A> withNewEventListLike(EventList item) {
    return new ValidationSchemaFluentImpl.EventListNestedImpl(item);
  }
  public ValidationSchemaFluentImpl.EventListNested<A> editEventList() {
    return withNewEventListLike(getEventList());
  }
  public ValidationSchemaFluentImpl.EventListNested<A> editOrNewEventList() {
    return withNewEventListLike(getEventList() != null ? getEventList(): new EventListBuilder().build());
  }
  public ValidationSchemaFluentImpl.EventListNested<A> editOrNewEventListLike(EventList item) {
    return withNewEventListLike(getEventList() != null ? getEventList(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildEventSeries instead.
   * @return The buildable object.
   */
  @Deprecated
  public EventSeries getEventSeries() {
    return this.eventSeries!=null ?this.eventSeries.build():null;
  }
  public EventSeries buildEventSeries() {
    return this.eventSeries!=null ?this.eventSeries.build():null;
  }
  public A withEventSeries(EventSeries eventSeries) {
    _visitables.get("eventSeries").remove(this.eventSeries);
    if (eventSeries!=null){ this.eventSeries= new EventSeriesBuilder(eventSeries); _visitables.get("eventSeries").add(this.eventSeries);} else { this.eventSeries = null; _visitables.get("eventSeries").remove(this.eventSeries); } return (A) this;
  }
  public Boolean hasEventSeries() {
    return this.eventSeries != null;
  }
  public ValidationSchemaFluentImpl.EventSeriesNested<A> withNewEventSeries() {
    return new ValidationSchemaFluentImpl.EventSeriesNestedImpl();
  }
  public ValidationSchemaFluentImpl.EventSeriesNested<A> withNewEventSeriesLike(EventSeries item) {
    return new ValidationSchemaFluentImpl.EventSeriesNestedImpl(item);
  }
  public ValidationSchemaFluentImpl.EventSeriesNested<A> editEventSeries() {
    return withNewEventSeriesLike(getEventSeries());
  }
  public ValidationSchemaFluentImpl.EventSeriesNested<A> editOrNewEventSeries() {
    return withNewEventSeriesLike(getEventSeries() != null ? getEventSeries(): new EventSeriesBuilder().build());
  }
  public ValidationSchemaFluentImpl.EventSeriesNested<A> editOrNewEventSeriesLike(EventSeries item) {
    return withNewEventSeriesLike(getEventSeries() != null ? getEventSeries(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildEventSource instead.
   * @return The buildable object.
   */
  @Deprecated
  public EventSource getEventSource() {
    return this.eventSource!=null ?this.eventSource.build():null;
  }
  public EventSource buildEventSource() {
    return this.eventSource!=null ?this.eventSource.build():null;
  }
  public A withEventSource(EventSource eventSource) {
    _visitables.get("eventSource").remove(this.eventSource);
    if (eventSource!=null){ this.eventSource= new EventSourceBuilder(eventSource); _visitables.get("eventSource").add(this.eventSource);} else { this.eventSource = null; _visitables.get("eventSource").remove(this.eventSource); } return (A) this;
  }
  public Boolean hasEventSource() {
    return this.eventSource != null;
  }
  public A withNewEventSource(String component,String host) {
    return (A)withEventSource(new EventSource(component, host));
  }
  public ValidationSchemaFluentImpl.EventSourceNested<A> withNewEventSource() {
    return new ValidationSchemaFluentImpl.EventSourceNestedImpl();
  }
  public ValidationSchemaFluentImpl.EventSourceNested<A> withNewEventSourceLike(EventSource item) {
    return new ValidationSchemaFluentImpl.EventSourceNestedImpl(item);
  }
  public ValidationSchemaFluentImpl.EventSourceNested<A> editEventSource() {
    return withNewEventSourceLike(getEventSource());
  }
  public ValidationSchemaFluentImpl.EventSourceNested<A> editOrNewEventSource() {
    return withNewEventSourceLike(getEventSource() != null ? getEventSource(): new EventSourceBuilder().build());
  }
  public ValidationSchemaFluentImpl.EventSourceNested<A> editOrNewEventSourceLike(EventSource item) {
    return withNewEventSourceLike(getEventSource() != null ? getEventSource(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildGetOptions instead.
   * @return The buildable object.
   */
  @Deprecated
  public GetOptions getGetOptions() {
    return this.getOptions!=null ?this.getOptions.build():null;
  }
  public GetOptions buildGetOptions() {
    return this.getOptions!=null ?this.getOptions.build():null;
  }
  public A withGetOptions(GetOptions getOptions) {
    _visitables.get("getOptions").remove(this.getOptions);
    if (getOptions!=null){ this.getOptions= new GetOptionsBuilder(getOptions); _visitables.get("getOptions").add(this.getOptions);} else { this.getOptions = null; _visitables.get("getOptions").remove(this.getOptions); } return (A) this;
  }
  public Boolean hasGetOptions() {
    return this.getOptions != null;
  }
  public A withNewGetOptions(String apiVersion,String kind,String resourceVersion) {
    return (A)withGetOptions(new GetOptions(apiVersion, kind, resourceVersion));
  }
  public ValidationSchemaFluentImpl.GetOptionsNested<A> withNewGetOptions() {
    return new ValidationSchemaFluentImpl.GetOptionsNestedImpl();
  }
  public ValidationSchemaFluentImpl.GetOptionsNested<A> withNewGetOptionsLike(GetOptions item) {
    return new ValidationSchemaFluentImpl.GetOptionsNestedImpl(item);
  }
  public ValidationSchemaFluentImpl.GetOptionsNested<A> editGetOptions() {
    return withNewGetOptionsLike(getGetOptions());
  }
  public ValidationSchemaFluentImpl.GetOptionsNested<A> editOrNewGetOptions() {
    return withNewGetOptionsLike(getGetOptions() != null ? getGetOptions(): new GetOptionsBuilder().build());
  }
  public ValidationSchemaFluentImpl.GetOptionsNested<A> editOrNewGetOptionsLike(GetOptions item) {
    return withNewGetOptionsLike(getGetOptions() != null ? getGetOptions(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildGroupKind instead.
   * @return The buildable object.
   */
  @Deprecated
  public GroupKind getGroupKind() {
    return this.groupKind!=null ?this.groupKind.build():null;
  }
  public GroupKind buildGroupKind() {
    return this.groupKind!=null ?this.groupKind.build():null;
  }
  public A withGroupKind(GroupKind groupKind) {
    _visitables.get("groupKind").remove(this.groupKind);
    if (groupKind!=null){ this.groupKind= new GroupKindBuilder(groupKind); _visitables.get("groupKind").add(this.groupKind);} else { this.groupKind = null; _visitables.get("groupKind").remove(this.groupKind); } return (A) this;
  }
  public Boolean hasGroupKind() {
    return this.groupKind != null;
  }
  public A withNewGroupKind(String group,String kind) {
    return (A)withGroupKind(new GroupKind(group, kind));
  }
  public ValidationSchemaFluentImpl.GroupKindNested<A> withNewGroupKind() {
    return new ValidationSchemaFluentImpl.GroupKindNestedImpl();
  }
  public ValidationSchemaFluentImpl.GroupKindNested<A> withNewGroupKindLike(GroupKind item) {
    return new ValidationSchemaFluentImpl.GroupKindNestedImpl(item);
  }
  public ValidationSchemaFluentImpl.GroupKindNested<A> editGroupKind() {
    return withNewGroupKindLike(getGroupKind());
  }
  public ValidationSchemaFluentImpl.GroupKindNested<A> editOrNewGroupKind() {
    return withNewGroupKindLike(getGroupKind() != null ? getGroupKind(): new GroupKindBuilder().build());
  }
  public ValidationSchemaFluentImpl.GroupKindNested<A> editOrNewGroupKindLike(GroupKind item) {
    return withNewGroupKindLike(getGroupKind() != null ? getGroupKind(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildGroupVersionKind instead.
   * @return The buildable object.
   */
  @Deprecated
  public GroupVersionKind getGroupVersionKind() {
    return this.groupVersionKind!=null ?this.groupVersionKind.build():null;
  }
  public GroupVersionKind buildGroupVersionKind() {
    return this.groupVersionKind!=null ?this.groupVersionKind.build():null;
  }
  public A withGroupVersionKind(GroupVersionKind groupVersionKind) {
    _visitables.get("groupVersionKind").remove(this.groupVersionKind);
    if (groupVersionKind!=null){ this.groupVersionKind= new GroupVersionKindBuilder(groupVersionKind); _visitables.get("groupVersionKind").add(this.groupVersionKind);} else { this.groupVersionKind = null; _visitables.get("groupVersionKind").remove(this.groupVersionKind); } return (A) this;
  }
  public Boolean hasGroupVersionKind() {
    return this.groupVersionKind != null;
  }
  public A withNewGroupVersionKind(String group,String kind,String version) {
    return (A)withGroupVersionKind(new GroupVersionKind(group, kind, version));
  }
  public ValidationSchemaFluentImpl.GroupVersionKindNested<A> withNewGroupVersionKind() {
    return new ValidationSchemaFluentImpl.GroupVersionKindNestedImpl();
  }
  public ValidationSchemaFluentImpl.GroupVersionKindNested<A> withNewGroupVersionKindLike(GroupVersionKind item) {
    return new ValidationSchemaFluentImpl.GroupVersionKindNestedImpl(item);
  }
  public ValidationSchemaFluentImpl.GroupVersionKindNested<A> editGroupVersionKind() {
    return withNewGroupVersionKindLike(getGroupVersionKind());
  }
  public ValidationSchemaFluentImpl.GroupVersionKindNested<A> editOrNewGroupVersionKind() {
    return withNewGroupVersionKindLike(getGroupVersionKind() != null ? getGroupVersionKind(): new GroupVersionKindBuilder().build());
  }
  public ValidationSchemaFluentImpl.GroupVersionKindNested<A> editOrNewGroupVersionKindLike(GroupVersionKind item) {
    return withNewGroupVersionKindLike(getGroupVersionKind() != null ? getGroupVersionKind(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildGroupVersionResource instead.
   * @return The buildable object.
   */
  @Deprecated
  public GroupVersionResource getGroupVersionResource() {
    return this.groupVersionResource!=null ?this.groupVersionResource.build():null;
  }
  public GroupVersionResource buildGroupVersionResource() {
    return this.groupVersionResource!=null ?this.groupVersionResource.build():null;
  }
  public A withGroupVersionResource(GroupVersionResource groupVersionResource) {
    _visitables.get("groupVersionResource").remove(this.groupVersionResource);
    if (groupVersionResource!=null){ this.groupVersionResource= new GroupVersionResourceBuilder(groupVersionResource); _visitables.get("groupVersionResource").add(this.groupVersionResource);} else { this.groupVersionResource = null; _visitables.get("groupVersionResource").remove(this.groupVersionResource); } return (A) this;
  }
  public Boolean hasGroupVersionResource() {
    return this.groupVersionResource != null;
  }
  public A withNewGroupVersionResource(String group,String resource,String version) {
    return (A)withGroupVersionResource(new GroupVersionResource(group, resource, version));
  }
  public ValidationSchemaFluentImpl.GroupVersionResourceNested<A> withNewGroupVersionResource() {
    return new ValidationSchemaFluentImpl.GroupVersionResourceNestedImpl();
  }
  public ValidationSchemaFluentImpl.GroupVersionResourceNested<A> withNewGroupVersionResourceLike(GroupVersionResource item) {
    return new ValidationSchemaFluentImpl.GroupVersionResourceNestedImpl(item);
  }
  public ValidationSchemaFluentImpl.GroupVersionResourceNested<A> editGroupVersionResource() {
    return withNewGroupVersionResourceLike(getGroupVersionResource());
  }
  public ValidationSchemaFluentImpl.GroupVersionResourceNested<A> editOrNewGroupVersionResource() {
    return withNewGroupVersionResourceLike(getGroupVersionResource() != null ? getGroupVersionResource(): new GroupVersionResourceBuilder().build());
  }
  public ValidationSchemaFluentImpl.GroupVersionResourceNested<A> editOrNewGroupVersionResourceLike(GroupVersionResource item) {
    return withNewGroupVersionResourceLike(getGroupVersionResource() != null ? getGroupVersionResource(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildInfo instead.
   * @return The buildable object.
   */
  @Deprecated
  public Info getInfo() {
    return this.info!=null ?this.info.build():null;
  }
  public Info buildInfo() {
    return this.info!=null ?this.info.build():null;
  }
  public A withInfo(Info info) {
    _visitables.get("info").remove(this.info);
    if (info!=null){ this.info= new InfoBuilder(info); _visitables.get("info").add(this.info);} else { this.info = null; _visitables.get("info").remove(this.info); } return (A) this;
  }
  public Boolean hasInfo() {
    return this.info != null;
  }
  public ValidationSchemaFluentImpl.InfoNested<A> withNewInfo() {
    return new ValidationSchemaFluentImpl.InfoNestedImpl();
  }
  public ValidationSchemaFluentImpl.InfoNested<A> withNewInfoLike(Info item) {
    return new ValidationSchemaFluentImpl.InfoNestedImpl(item);
  }
  public ValidationSchemaFluentImpl.InfoNested<A> editInfo() {
    return withNewInfoLike(getInfo());
  }
  public ValidationSchemaFluentImpl.InfoNested<A> editOrNewInfo() {
    return withNewInfoLike(getInfo() != null ? getInfo(): new InfoBuilder().build());
  }
  public ValidationSchemaFluentImpl.InfoNested<A> editOrNewInfoLike(Info item) {
    return withNewInfoLike(getInfo() != null ? getInfo(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildKubernetesList instead.
   * @return The buildable object.
   */
  @Deprecated
  public KubernetesList getKubernetesList() {
    return this.kubernetesList!=null ?this.kubernetesList.build():null;
  }
  public KubernetesList buildKubernetesList() {
    return this.kubernetesList!=null ?this.kubernetesList.build():null;
  }
  public A withKubernetesList(KubernetesList kubernetesList) {
    _visitables.get("kubernetesList").remove(this.kubernetesList);
    if (kubernetesList!=null){ this.kubernetesList= new KubernetesListBuilder(kubernetesList); _visitables.get("kubernetesList").add(this.kubernetesList);} else { this.kubernetesList = null; _visitables.get("kubernetesList").remove(this.kubernetesList); } return (A) this;
  }
  public Boolean hasKubernetesList() {
    return this.kubernetesList != null;
  }
  public ValidationSchemaFluentImpl.KubernetesListNested<A> withNewKubernetesList() {
    return new ValidationSchemaFluentImpl.KubernetesListNestedImpl();
  }
  public ValidationSchemaFluentImpl.KubernetesListNested<A> withNewKubernetesListLike(KubernetesList item) {
    return new ValidationSchemaFluentImpl.KubernetesListNestedImpl(item);
  }
  public ValidationSchemaFluentImpl.KubernetesListNested<A> editKubernetesList() {
    return withNewKubernetesListLike(getKubernetesList());
  }
  public ValidationSchemaFluentImpl.KubernetesListNested<A> editOrNewKubernetesList() {
    return withNewKubernetesListLike(getKubernetesList() != null ? getKubernetesList(): new KubernetesListBuilder().build());
  }
  public ValidationSchemaFluentImpl.KubernetesListNested<A> editOrNewKubernetesListLike(KubernetesList item) {
    return withNewKubernetesListLike(getKubernetesList() != null ? getKubernetesList(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildLimitRangeList instead.
   * @return The buildable object.
   */
  @Deprecated
  public LimitRangeList getLimitRangeList() {
    return this.limitRangeList!=null ?this.limitRangeList.build():null;
  }
  public LimitRangeList buildLimitRangeList() {
    return this.limitRangeList!=null ?this.limitRangeList.build():null;
  }
  public A withLimitRangeList(LimitRangeList limitRangeList) {
    _visitables.get("limitRangeList").remove(this.limitRangeList);
    if (limitRangeList!=null){ this.limitRangeList= new LimitRangeListBuilder(limitRangeList); _visitables.get("limitRangeList").add(this.limitRangeList);} else { this.limitRangeList = null; _visitables.get("limitRangeList").remove(this.limitRangeList); } return (A) this;
  }
  public Boolean hasLimitRangeList() {
    return this.limitRangeList != null;
  }
  public ValidationSchemaFluentImpl.LimitRangeListNested<A> withNewLimitRangeList() {
    return new ValidationSchemaFluentImpl.LimitRangeListNestedImpl();
  }
  public ValidationSchemaFluentImpl.LimitRangeListNested<A> withNewLimitRangeListLike(LimitRangeList item) {
    return new ValidationSchemaFluentImpl.LimitRangeListNestedImpl(item);
  }
  public ValidationSchemaFluentImpl.LimitRangeListNested<A> editLimitRangeList() {
    return withNewLimitRangeListLike(getLimitRangeList());
  }
  public ValidationSchemaFluentImpl.LimitRangeListNested<A> editOrNewLimitRangeList() {
    return withNewLimitRangeListLike(getLimitRangeList() != null ? getLimitRangeList(): new LimitRangeListBuilder().build());
  }
  public ValidationSchemaFluentImpl.LimitRangeListNested<A> editOrNewLimitRangeListLike(LimitRangeList item) {
    return withNewLimitRangeListLike(getLimitRangeList() != null ? getLimitRangeList(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildListOptions instead.
   * @return The buildable object.
   */
  @Deprecated
  public ListOptions getListOptions() {
    return this.listOptions!=null ?this.listOptions.build():null;
  }
  public ListOptions buildListOptions() {
    return this.listOptions!=null ?this.listOptions.build():null;
  }
  public A withListOptions(ListOptions listOptions) {
    _visitables.get("listOptions").remove(this.listOptions);
    if (listOptions!=null){ this.listOptions= new ListOptionsBuilder(listOptions); _visitables.get("listOptions").add(this.listOptions);} else { this.listOptions = null; _visitables.get("listOptions").remove(this.listOptions); } return (A) this;
  }
  public Boolean hasListOptions() {
    return this.listOptions != null;
  }
  public ValidationSchemaFluentImpl.ListOptionsNested<A> withNewListOptions() {
    return new ValidationSchemaFluentImpl.ListOptionsNestedImpl();
  }
  public ValidationSchemaFluentImpl.ListOptionsNested<A> withNewListOptionsLike(ListOptions item) {
    return new ValidationSchemaFluentImpl.ListOptionsNestedImpl(item);
  }
  public ValidationSchemaFluentImpl.ListOptionsNested<A> editListOptions() {
    return withNewListOptionsLike(getListOptions());
  }
  public ValidationSchemaFluentImpl.ListOptionsNested<A> editOrNewListOptions() {
    return withNewListOptionsLike(getListOptions() != null ? getListOptions(): new ListOptionsBuilder().build());
  }
  public ValidationSchemaFluentImpl.ListOptionsNested<A> editOrNewListOptionsLike(ListOptions item) {
    return withNewListOptionsLike(getListOptions() != null ? getListOptions(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildMicroTime instead.
   * @return The buildable object.
   */
  @Deprecated
  public MicroTime getMicroTime() {
    return this.microTime!=null ?this.microTime.build():null;
  }
  public MicroTime buildMicroTime() {
    return this.microTime!=null ?this.microTime.build():null;
  }
  public A withMicroTime(MicroTime microTime) {
    _visitables.get("microTime").remove(this.microTime);
    if (microTime!=null){ this.microTime= new MicroTimeBuilder(microTime); _visitables.get("microTime").add(this.microTime);} else { this.microTime = null; _visitables.get("microTime").remove(this.microTime); } return (A) this;
  }
  public Boolean hasMicroTime() {
    return this.microTime != null;
  }
  public A withNewMicroTime(String time) {
    return (A)withMicroTime(new MicroTime(time));
  }
  public ValidationSchemaFluentImpl.MicroTimeNested<A> withNewMicroTime() {
    return new ValidationSchemaFluentImpl.MicroTimeNestedImpl();
  }
  public ValidationSchemaFluentImpl.MicroTimeNested<A> withNewMicroTimeLike(MicroTime item) {
    return new ValidationSchemaFluentImpl.MicroTimeNestedImpl(item);
  }
  public ValidationSchemaFluentImpl.MicroTimeNested<A> editMicroTime() {
    return withNewMicroTimeLike(getMicroTime());
  }
  public ValidationSchemaFluentImpl.MicroTimeNested<A> editOrNewMicroTime() {
    return withNewMicroTimeLike(getMicroTime() != null ? getMicroTime(): new MicroTimeBuilder().build());
  }
  public ValidationSchemaFluentImpl.MicroTimeNested<A> editOrNewMicroTimeLike(MicroTime item) {
    return withNewMicroTimeLike(getMicroTime() != null ? getMicroTime(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildNamespace instead.
   * @return The buildable object.
   */
  @Deprecated
  public Namespace getNamespace() {
    return this.namespace!=null ?this.namespace.build():null;
  }
  public Namespace buildNamespace() {
    return this.namespace!=null ?this.namespace.build():null;
  }
  public A withNamespace(Namespace namespace) {
    _visitables.get("namespace").remove(this.namespace);
    if (namespace!=null){ this.namespace= new NamespaceBuilder(namespace); _visitables.get("namespace").add(this.namespace);} else { this.namespace = null; _visitables.get("namespace").remove(this.namespace); } return (A) this;
  }
  public Boolean hasNamespace() {
    return this.namespace != null;
  }
  public ValidationSchemaFluentImpl.NamespaceNested<A> withNewNamespace() {
    return new ValidationSchemaFluentImpl.NamespaceNestedImpl();
  }
  public ValidationSchemaFluentImpl.NamespaceNested<A> withNewNamespaceLike(Namespace item) {
    return new ValidationSchemaFluentImpl.NamespaceNestedImpl(item);
  }
  public ValidationSchemaFluentImpl.NamespaceNested<A> editNamespace() {
    return withNewNamespaceLike(getNamespace());
  }
  public ValidationSchemaFluentImpl.NamespaceNested<A> editOrNewNamespace() {
    return withNewNamespaceLike(getNamespace() != null ? getNamespace(): new NamespaceBuilder().build());
  }
  public ValidationSchemaFluentImpl.NamespaceNested<A> editOrNewNamespaceLike(Namespace item) {
    return withNewNamespaceLike(getNamespace() != null ? getNamespace(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildNamespaceList instead.
   * @return The buildable object.
   */
  @Deprecated
  public NamespaceList getNamespaceList() {
    return this.namespaceList!=null ?this.namespaceList.build():null;
  }
  public NamespaceList buildNamespaceList() {
    return this.namespaceList!=null ?this.namespaceList.build():null;
  }
  public A withNamespaceList(NamespaceList namespaceList) {
    _visitables.get("namespaceList").remove(this.namespaceList);
    if (namespaceList!=null){ this.namespaceList= new NamespaceListBuilder(namespaceList); _visitables.get("namespaceList").add(this.namespaceList);} else { this.namespaceList = null; _visitables.get("namespaceList").remove(this.namespaceList); } return (A) this;
  }
  public Boolean hasNamespaceList() {
    return this.namespaceList != null;
  }
  public ValidationSchemaFluentImpl.NamespaceListNested<A> withNewNamespaceList() {
    return new ValidationSchemaFluentImpl.NamespaceListNestedImpl();
  }
  public ValidationSchemaFluentImpl.NamespaceListNested<A> withNewNamespaceListLike(NamespaceList item) {
    return new ValidationSchemaFluentImpl.NamespaceListNestedImpl(item);
  }
  public ValidationSchemaFluentImpl.NamespaceListNested<A> editNamespaceList() {
    return withNewNamespaceListLike(getNamespaceList());
  }
  public ValidationSchemaFluentImpl.NamespaceListNested<A> editOrNewNamespaceList() {
    return withNewNamespaceListLike(getNamespaceList() != null ? getNamespaceList(): new NamespaceListBuilder().build());
  }
  public ValidationSchemaFluentImpl.NamespaceListNested<A> editOrNewNamespaceListLike(NamespaceList item) {
    return withNewNamespaceListLike(getNamespaceList() != null ? getNamespaceList(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildNode instead.
   * @return The buildable object.
   */
  @Deprecated
  public Node getNode() {
    return this.node!=null ?this.node.build():null;
  }
  public Node buildNode() {
    return this.node!=null ?this.node.build():null;
  }
  public A withNode(Node node) {
    _visitables.get("node").remove(this.node);
    if (node!=null){ this.node= new NodeBuilder(node); _visitables.get("node").add(this.node);} else { this.node = null; _visitables.get("node").remove(this.node); } return (A) this;
  }
  public Boolean hasNode() {
    return this.node != null;
  }
  public ValidationSchemaFluentImpl.NodeNested<A> withNewNode() {
    return new ValidationSchemaFluentImpl.NodeNestedImpl();
  }
  public ValidationSchemaFluentImpl.NodeNested<A> withNewNodeLike(Node item) {
    return new ValidationSchemaFluentImpl.NodeNestedImpl(item);
  }
  public ValidationSchemaFluentImpl.NodeNested<A> editNode() {
    return withNewNodeLike(getNode());
  }
  public ValidationSchemaFluentImpl.NodeNested<A> editOrNewNode() {
    return withNewNodeLike(getNode() != null ? getNode(): new NodeBuilder().build());
  }
  public ValidationSchemaFluentImpl.NodeNested<A> editOrNewNodeLike(Node item) {
    return withNewNodeLike(getNode() != null ? getNode(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildNodeList instead.
   * @return The buildable object.
   */
  @Deprecated
  public NodeList getNodeList() {
    return this.nodeList!=null ?this.nodeList.build():null;
  }
  public NodeList buildNodeList() {
    return this.nodeList!=null ?this.nodeList.build():null;
  }
  public A withNodeList(NodeList nodeList) {
    _visitables.get("nodeList").remove(this.nodeList);
    if (nodeList!=null){ this.nodeList= new NodeListBuilder(nodeList); _visitables.get("nodeList").add(this.nodeList);} else { this.nodeList = null; _visitables.get("nodeList").remove(this.nodeList); } return (A) this;
  }
  public Boolean hasNodeList() {
    return this.nodeList != null;
  }
  public ValidationSchemaFluentImpl.NodeListNested<A> withNewNodeList() {
    return new ValidationSchemaFluentImpl.NodeListNestedImpl();
  }
  public ValidationSchemaFluentImpl.NodeListNested<A> withNewNodeListLike(NodeList item) {
    return new ValidationSchemaFluentImpl.NodeListNestedImpl(item);
  }
  public ValidationSchemaFluentImpl.NodeListNested<A> editNodeList() {
    return withNewNodeListLike(getNodeList());
  }
  public ValidationSchemaFluentImpl.NodeListNested<A> editOrNewNodeList() {
    return withNewNodeListLike(getNodeList() != null ? getNodeList(): new NodeListBuilder().build());
  }
  public ValidationSchemaFluentImpl.NodeListNested<A> editOrNewNodeListLike(NodeList item) {
    return withNewNodeListLike(getNodeList() != null ? getNodeList(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildObjectMeta instead.
   * @return The buildable object.
   */
  @Deprecated
  public ObjectMeta getObjectMeta() {
    return this.objectMeta!=null ?this.objectMeta.build():null;
  }
  public ObjectMeta buildObjectMeta() {
    return this.objectMeta!=null ?this.objectMeta.build():null;
  }
  public A withObjectMeta(ObjectMeta objectMeta) {
    _visitables.get("objectMeta").remove(this.objectMeta);
    if (objectMeta!=null){ this.objectMeta= new ObjectMetaBuilder(objectMeta); _visitables.get("objectMeta").add(this.objectMeta);} else { this.objectMeta = null; _visitables.get("objectMeta").remove(this.objectMeta); } return (A) this;
  }
  public Boolean hasObjectMeta() {
    return this.objectMeta != null;
  }
  public ValidationSchemaFluentImpl.ObjectMetaNested<A> withNewObjectMeta() {
    return new ValidationSchemaFluentImpl.ObjectMetaNestedImpl();
  }
  public ValidationSchemaFluentImpl.ObjectMetaNested<A> withNewObjectMetaLike(ObjectMeta item) {
    return new ValidationSchemaFluentImpl.ObjectMetaNestedImpl(item);
  }
  public ValidationSchemaFluentImpl.ObjectMetaNested<A> editObjectMeta() {
    return withNewObjectMetaLike(getObjectMeta());
  }
  public ValidationSchemaFluentImpl.ObjectMetaNested<A> editOrNewObjectMeta() {
    return withNewObjectMetaLike(getObjectMeta() != null ? getObjectMeta(): new ObjectMetaBuilder().build());
  }
  public ValidationSchemaFluentImpl.ObjectMetaNested<A> editOrNewObjectMetaLike(ObjectMeta item) {
    return withNewObjectMetaLike(getObjectMeta() != null ? getObjectMeta(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildPatch instead.
   * @return The buildable object.
   */
  @Deprecated
  public Patch getPatch() {
    return this.patch!=null ?this.patch.build():null;
  }
  public Patch buildPatch() {
    return this.patch!=null ?this.patch.build():null;
  }
  public A withPatch(Patch patch) {
    _visitables.get("patch").remove(this.patch);
    if (patch!=null){ this.patch= new PatchBuilder(patch); _visitables.get("patch").add(this.patch);} else { this.patch = null; _visitables.get("patch").remove(this.patch); } return (A) this;
  }
  public Boolean hasPatch() {
    return this.patch != null;
  }
  public ValidationSchemaFluentImpl.PatchNested<A> withNewPatch() {
    return new ValidationSchemaFluentImpl.PatchNestedImpl();
  }
  public ValidationSchemaFluentImpl.PatchNested<A> withNewPatchLike(Patch item) {
    return new ValidationSchemaFluentImpl.PatchNestedImpl(item);
  }
  public ValidationSchemaFluentImpl.PatchNested<A> editPatch() {
    return withNewPatchLike(getPatch());
  }
  public ValidationSchemaFluentImpl.PatchNested<A> editOrNewPatch() {
    return withNewPatchLike(getPatch() != null ? getPatch(): new PatchBuilder().build());
  }
  public ValidationSchemaFluentImpl.PatchNested<A> editOrNewPatchLike(Patch item) {
    return withNewPatchLike(getPatch() != null ? getPatch(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildPatchOptions instead.
   * @return The buildable object.
   */
  @Deprecated
  public PatchOptions getPatchOptions() {
    return this.patchOptions!=null ?this.patchOptions.build():null;
  }
  public PatchOptions buildPatchOptions() {
    return this.patchOptions!=null ?this.patchOptions.build():null;
  }
  public A withPatchOptions(PatchOptions patchOptions) {
    _visitables.get("patchOptions").remove(this.patchOptions);
    if (patchOptions!=null){ this.patchOptions= new PatchOptionsBuilder(patchOptions); _visitables.get("patchOptions").add(this.patchOptions);} else { this.patchOptions = null; _visitables.get("patchOptions").remove(this.patchOptions); } return (A) this;
  }
  public Boolean hasPatchOptions() {
    return this.patchOptions != null;
  }
  public ValidationSchemaFluentImpl.PatchOptionsNested<A> withNewPatchOptions() {
    return new ValidationSchemaFluentImpl.PatchOptionsNestedImpl();
  }
  public ValidationSchemaFluentImpl.PatchOptionsNested<A> withNewPatchOptionsLike(PatchOptions item) {
    return new ValidationSchemaFluentImpl.PatchOptionsNestedImpl(item);
  }
  public ValidationSchemaFluentImpl.PatchOptionsNested<A> editPatchOptions() {
    return withNewPatchOptionsLike(getPatchOptions());
  }
  public ValidationSchemaFluentImpl.PatchOptionsNested<A> editOrNewPatchOptions() {
    return withNewPatchOptionsLike(getPatchOptions() != null ? getPatchOptions(): new PatchOptionsBuilder().build());
  }
  public ValidationSchemaFluentImpl.PatchOptionsNested<A> editOrNewPatchOptionsLike(PatchOptions item) {
    return withNewPatchOptionsLike(getPatchOptions() != null ? getPatchOptions(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildPersistentVolume instead.
   * @return The buildable object.
   */
  @Deprecated
  public PersistentVolume getPersistentVolume() {
    return this.persistentVolume!=null ?this.persistentVolume.build():null;
  }
  public PersistentVolume buildPersistentVolume() {
    return this.persistentVolume!=null ?this.persistentVolume.build():null;
  }
  public A withPersistentVolume(PersistentVolume persistentVolume) {
    _visitables.get("persistentVolume").remove(this.persistentVolume);
    if (persistentVolume!=null){ this.persistentVolume= new PersistentVolumeBuilder(persistentVolume); _visitables.get("persistentVolume").add(this.persistentVolume);} else { this.persistentVolume = null; _visitables.get("persistentVolume").remove(this.persistentVolume); } return (A) this;
  }
  public Boolean hasPersistentVolume() {
    return this.persistentVolume != null;
  }
  public ValidationSchemaFluentImpl.PersistentVolumeNested<A> withNewPersistentVolume() {
    return new ValidationSchemaFluentImpl.PersistentVolumeNestedImpl();
  }
  public ValidationSchemaFluentImpl.PersistentVolumeNested<A> withNewPersistentVolumeLike(PersistentVolume item) {
    return new ValidationSchemaFluentImpl.PersistentVolumeNestedImpl(item);
  }
  public ValidationSchemaFluentImpl.PersistentVolumeNested<A> editPersistentVolume() {
    return withNewPersistentVolumeLike(getPersistentVolume());
  }
  public ValidationSchemaFluentImpl.PersistentVolumeNested<A> editOrNewPersistentVolume() {
    return withNewPersistentVolumeLike(getPersistentVolume() != null ? getPersistentVolume(): new PersistentVolumeBuilder().build());
  }
  public ValidationSchemaFluentImpl.PersistentVolumeNested<A> editOrNewPersistentVolumeLike(PersistentVolume item) {
    return withNewPersistentVolumeLike(getPersistentVolume() != null ? getPersistentVolume(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildPersistentVolumeClaim instead.
   * @return The buildable object.
   */
  @Deprecated
  public PersistentVolumeClaim getPersistentVolumeClaim() {
    return this.persistentVolumeClaim!=null ?this.persistentVolumeClaim.build():null;
  }
  public PersistentVolumeClaim buildPersistentVolumeClaim() {
    return this.persistentVolumeClaim!=null ?this.persistentVolumeClaim.build():null;
  }
  public A withPersistentVolumeClaim(PersistentVolumeClaim persistentVolumeClaim) {
    _visitables.get("persistentVolumeClaim").remove(this.persistentVolumeClaim);
    if (persistentVolumeClaim!=null){ this.persistentVolumeClaim= new PersistentVolumeClaimBuilder(persistentVolumeClaim); _visitables.get("persistentVolumeClaim").add(this.persistentVolumeClaim);} else { this.persistentVolumeClaim = null; _visitables.get("persistentVolumeClaim").remove(this.persistentVolumeClaim); } return (A) this;
  }
  public Boolean hasPersistentVolumeClaim() {
    return this.persistentVolumeClaim != null;
  }
  public ValidationSchemaFluentImpl.PersistentVolumeClaimNested<A> withNewPersistentVolumeClaim() {
    return new ValidationSchemaFluentImpl.PersistentVolumeClaimNestedImpl();
  }
  public ValidationSchemaFluentImpl.PersistentVolumeClaimNested<A> withNewPersistentVolumeClaimLike(PersistentVolumeClaim item) {
    return new ValidationSchemaFluentImpl.PersistentVolumeClaimNestedImpl(item);
  }
  public ValidationSchemaFluentImpl.PersistentVolumeClaimNested<A> editPersistentVolumeClaim() {
    return withNewPersistentVolumeClaimLike(getPersistentVolumeClaim());
  }
  public ValidationSchemaFluentImpl.PersistentVolumeClaimNested<A> editOrNewPersistentVolumeClaim() {
    return withNewPersistentVolumeClaimLike(getPersistentVolumeClaim() != null ? getPersistentVolumeClaim(): new PersistentVolumeClaimBuilder().build());
  }
  public ValidationSchemaFluentImpl.PersistentVolumeClaimNested<A> editOrNewPersistentVolumeClaimLike(PersistentVolumeClaim item) {
    return withNewPersistentVolumeClaimLike(getPersistentVolumeClaim() != null ? getPersistentVolumeClaim(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildPersistentVolumeClaimList instead.
   * @return The buildable object.
   */
  @Deprecated
  public PersistentVolumeClaimList getPersistentVolumeClaimList() {
    return this.persistentVolumeClaimList!=null ?this.persistentVolumeClaimList.build():null;
  }
  public PersistentVolumeClaimList buildPersistentVolumeClaimList() {
    return this.persistentVolumeClaimList!=null ?this.persistentVolumeClaimList.build():null;
  }
  public A withPersistentVolumeClaimList(PersistentVolumeClaimList persistentVolumeClaimList) {
    _visitables.get("persistentVolumeClaimList").remove(this.persistentVolumeClaimList);
    if (persistentVolumeClaimList!=null){ this.persistentVolumeClaimList= new PersistentVolumeClaimListBuilder(persistentVolumeClaimList); _visitables.get("persistentVolumeClaimList").add(this.persistentVolumeClaimList);} else { this.persistentVolumeClaimList = null; _visitables.get("persistentVolumeClaimList").remove(this.persistentVolumeClaimList); } return (A) this;
  }
  public Boolean hasPersistentVolumeClaimList() {
    return this.persistentVolumeClaimList != null;
  }
  public ValidationSchemaFluentImpl.PersistentVolumeClaimListNested<A> withNewPersistentVolumeClaimList() {
    return new ValidationSchemaFluentImpl.PersistentVolumeClaimListNestedImpl();
  }
  public ValidationSchemaFluentImpl.PersistentVolumeClaimListNested<A> withNewPersistentVolumeClaimListLike(PersistentVolumeClaimList item) {
    return new ValidationSchemaFluentImpl.PersistentVolumeClaimListNestedImpl(item);
  }
  public ValidationSchemaFluentImpl.PersistentVolumeClaimListNested<A> editPersistentVolumeClaimList() {
    return withNewPersistentVolumeClaimListLike(getPersistentVolumeClaimList());
  }
  public ValidationSchemaFluentImpl.PersistentVolumeClaimListNested<A> editOrNewPersistentVolumeClaimList() {
    return withNewPersistentVolumeClaimListLike(getPersistentVolumeClaimList() != null ? getPersistentVolumeClaimList(): new PersistentVolumeClaimListBuilder().build());
  }
  public ValidationSchemaFluentImpl.PersistentVolumeClaimListNested<A> editOrNewPersistentVolumeClaimListLike(PersistentVolumeClaimList item) {
    return withNewPersistentVolumeClaimListLike(getPersistentVolumeClaimList() != null ? getPersistentVolumeClaimList(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildPersistentVolumeList instead.
   * @return The buildable object.
   */
  @Deprecated
  public PersistentVolumeList getPersistentVolumeList() {
    return this.persistentVolumeList!=null ?this.persistentVolumeList.build():null;
  }
  public PersistentVolumeList buildPersistentVolumeList() {
    return this.persistentVolumeList!=null ?this.persistentVolumeList.build():null;
  }
  public A withPersistentVolumeList(PersistentVolumeList persistentVolumeList) {
    _visitables.get("persistentVolumeList").remove(this.persistentVolumeList);
    if (persistentVolumeList!=null){ this.persistentVolumeList= new PersistentVolumeListBuilder(persistentVolumeList); _visitables.get("persistentVolumeList").add(this.persistentVolumeList);} else { this.persistentVolumeList = null; _visitables.get("persistentVolumeList").remove(this.persistentVolumeList); } return (A) this;
  }
  public Boolean hasPersistentVolumeList() {
    return this.persistentVolumeList != null;
  }
  public ValidationSchemaFluentImpl.PersistentVolumeListNested<A> withNewPersistentVolumeList() {
    return new ValidationSchemaFluentImpl.PersistentVolumeListNestedImpl();
  }
  public ValidationSchemaFluentImpl.PersistentVolumeListNested<A> withNewPersistentVolumeListLike(PersistentVolumeList item) {
    return new ValidationSchemaFluentImpl.PersistentVolumeListNestedImpl(item);
  }
  public ValidationSchemaFluentImpl.PersistentVolumeListNested<A> editPersistentVolumeList() {
    return withNewPersistentVolumeListLike(getPersistentVolumeList());
  }
  public ValidationSchemaFluentImpl.PersistentVolumeListNested<A> editOrNewPersistentVolumeList() {
    return withNewPersistentVolumeListLike(getPersistentVolumeList() != null ? getPersistentVolumeList(): new PersistentVolumeListBuilder().build());
  }
  public ValidationSchemaFluentImpl.PersistentVolumeListNested<A> editOrNewPersistentVolumeListLike(PersistentVolumeList item) {
    return withNewPersistentVolumeListLike(getPersistentVolumeList() != null ? getPersistentVolumeList(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildPodExecOptions instead.
   * @return The buildable object.
   */
  @Deprecated
  public PodExecOptions getPodExecOptions() {
    return this.podExecOptions!=null ?this.podExecOptions.build():null;
  }
  public PodExecOptions buildPodExecOptions() {
    return this.podExecOptions!=null ?this.podExecOptions.build():null;
  }
  public A withPodExecOptions(PodExecOptions podExecOptions) {
    _visitables.get("podExecOptions").remove(this.podExecOptions);
    if (podExecOptions!=null){ this.podExecOptions= new PodExecOptionsBuilder(podExecOptions); _visitables.get("podExecOptions").add(this.podExecOptions);} else { this.podExecOptions = null; _visitables.get("podExecOptions").remove(this.podExecOptions); } return (A) this;
  }
  public Boolean hasPodExecOptions() {
    return this.podExecOptions != null;
  }
  public ValidationSchemaFluentImpl.PodExecOptionsNested<A> withNewPodExecOptions() {
    return new ValidationSchemaFluentImpl.PodExecOptionsNestedImpl();
  }
  public ValidationSchemaFluentImpl.PodExecOptionsNested<A> withNewPodExecOptionsLike(PodExecOptions item) {
    return new ValidationSchemaFluentImpl.PodExecOptionsNestedImpl(item);
  }
  public ValidationSchemaFluentImpl.PodExecOptionsNested<A> editPodExecOptions() {
    return withNewPodExecOptionsLike(getPodExecOptions());
  }
  public ValidationSchemaFluentImpl.PodExecOptionsNested<A> editOrNewPodExecOptions() {
    return withNewPodExecOptionsLike(getPodExecOptions() != null ? getPodExecOptions(): new PodExecOptionsBuilder().build());
  }
  public ValidationSchemaFluentImpl.PodExecOptionsNested<A> editOrNewPodExecOptionsLike(PodExecOptions item) {
    return withNewPodExecOptionsLike(getPodExecOptions() != null ? getPodExecOptions(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildPodList instead.
   * @return The buildable object.
   */
  @Deprecated
  public PodList getPodList() {
    return this.podList!=null ?this.podList.build():null;
  }
  public PodList buildPodList() {
    return this.podList!=null ?this.podList.build():null;
  }
  public A withPodList(PodList podList) {
    _visitables.get("podList").remove(this.podList);
    if (podList!=null){ this.podList= new PodListBuilder(podList); _visitables.get("podList").add(this.podList);} else { this.podList = null; _visitables.get("podList").remove(this.podList); } return (A) this;
  }
  public Boolean hasPodList() {
    return this.podList != null;
  }
  public ValidationSchemaFluentImpl.PodListNested<A> withNewPodList() {
    return new ValidationSchemaFluentImpl.PodListNestedImpl();
  }
  public ValidationSchemaFluentImpl.PodListNested<A> withNewPodListLike(PodList item) {
    return new ValidationSchemaFluentImpl.PodListNestedImpl(item);
  }
  public ValidationSchemaFluentImpl.PodListNested<A> editPodList() {
    return withNewPodListLike(getPodList());
  }
  public ValidationSchemaFluentImpl.PodListNested<A> editOrNewPodList() {
    return withNewPodListLike(getPodList() != null ? getPodList(): new PodListBuilder().build());
  }
  public ValidationSchemaFluentImpl.PodListNested<A> editOrNewPodListLike(PodList item) {
    return withNewPodListLike(getPodList() != null ? getPodList(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildPodTemplateList instead.
   * @return The buildable object.
   */
  @Deprecated
  public PodTemplateList getPodTemplateList() {
    return this.podTemplateList!=null ?this.podTemplateList.build():null;
  }
  public PodTemplateList buildPodTemplateList() {
    return this.podTemplateList!=null ?this.podTemplateList.build():null;
  }
  public A withPodTemplateList(PodTemplateList podTemplateList) {
    _visitables.get("podTemplateList").remove(this.podTemplateList);
    if (podTemplateList!=null){ this.podTemplateList= new PodTemplateListBuilder(podTemplateList); _visitables.get("podTemplateList").add(this.podTemplateList);} else { this.podTemplateList = null; _visitables.get("podTemplateList").remove(this.podTemplateList); } return (A) this;
  }
  public Boolean hasPodTemplateList() {
    return this.podTemplateList != null;
  }
  public ValidationSchemaFluentImpl.PodTemplateListNested<A> withNewPodTemplateList() {
    return new ValidationSchemaFluentImpl.PodTemplateListNestedImpl();
  }
  public ValidationSchemaFluentImpl.PodTemplateListNested<A> withNewPodTemplateListLike(PodTemplateList item) {
    return new ValidationSchemaFluentImpl.PodTemplateListNestedImpl(item);
  }
  public ValidationSchemaFluentImpl.PodTemplateListNested<A> editPodTemplateList() {
    return withNewPodTemplateListLike(getPodTemplateList());
  }
  public ValidationSchemaFluentImpl.PodTemplateListNested<A> editOrNewPodTemplateList() {
    return withNewPodTemplateListLike(getPodTemplateList() != null ? getPodTemplateList(): new PodTemplateListBuilder().build());
  }
  public ValidationSchemaFluentImpl.PodTemplateListNested<A> editOrNewPodTemplateListLike(PodTemplateList item) {
    return withNewPodTemplateListLike(getPodTemplateList() != null ? getPodTemplateList(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildQuantity instead.
   * @return The buildable object.
   */
  @Deprecated
  public Quantity getQuantity() {
    return this.quantity!=null ?this.quantity.build():null;
  }
  public Quantity buildQuantity() {
    return this.quantity!=null ?this.quantity.build():null;
  }
  public A withQuantity(Quantity quantity) {
    _visitables.get("quantity").remove(this.quantity);
    if (quantity!=null){ this.quantity= new QuantityBuilder(quantity); _visitables.get("quantity").add(this.quantity);} else { this.quantity = null; _visitables.get("quantity").remove(this.quantity); } return (A) this;
  }
  public Boolean hasQuantity() {
    return this.quantity != null;
  }
  public A withNewQuantity(String amount,String format) {
    return (A)withQuantity(new Quantity(amount, format));
  }
  public A withNewQuantity(String amount) {
    return (A)withQuantity(new Quantity(amount));
  }
  public ValidationSchemaFluentImpl.QuantityNested<A> withNewQuantity() {
    return new ValidationSchemaFluentImpl.QuantityNestedImpl();
  }
  public ValidationSchemaFluentImpl.QuantityNested<A> withNewQuantityLike(Quantity item) {
    return new ValidationSchemaFluentImpl.QuantityNestedImpl(item);
  }
  public ValidationSchemaFluentImpl.QuantityNested<A> editQuantity() {
    return withNewQuantityLike(getQuantity());
  }
  public ValidationSchemaFluentImpl.QuantityNested<A> editOrNewQuantity() {
    return withNewQuantityLike(getQuantity() != null ? getQuantity(): new QuantityBuilder().build());
  }
  public ValidationSchemaFluentImpl.QuantityNested<A> editOrNewQuantityLike(Quantity item) {
    return withNewQuantityLike(getQuantity() != null ? getQuantity(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildReplicationControllerList instead.
   * @return The buildable object.
   */
  @Deprecated
  public ReplicationControllerList getReplicationControllerList() {
    return this.replicationControllerList!=null ?this.replicationControllerList.build():null;
  }
  public ReplicationControllerList buildReplicationControllerList() {
    return this.replicationControllerList!=null ?this.replicationControllerList.build():null;
  }
  public A withReplicationControllerList(ReplicationControllerList replicationControllerList) {
    _visitables.get("replicationControllerList").remove(this.replicationControllerList);
    if (replicationControllerList!=null){ this.replicationControllerList= new ReplicationControllerListBuilder(replicationControllerList); _visitables.get("replicationControllerList").add(this.replicationControllerList);} else { this.replicationControllerList = null; _visitables.get("replicationControllerList").remove(this.replicationControllerList); } return (A) this;
  }
  public Boolean hasReplicationControllerList() {
    return this.replicationControllerList != null;
  }
  public ValidationSchemaFluentImpl.ReplicationControllerListNested<A> withNewReplicationControllerList() {
    return new ValidationSchemaFluentImpl.ReplicationControllerListNestedImpl();
  }
  public ValidationSchemaFluentImpl.ReplicationControllerListNested<A> withNewReplicationControllerListLike(ReplicationControllerList item) {
    return new ValidationSchemaFluentImpl.ReplicationControllerListNestedImpl(item);
  }
  public ValidationSchemaFluentImpl.ReplicationControllerListNested<A> editReplicationControllerList() {
    return withNewReplicationControllerListLike(getReplicationControllerList());
  }
  public ValidationSchemaFluentImpl.ReplicationControllerListNested<A> editOrNewReplicationControllerList() {
    return withNewReplicationControllerListLike(getReplicationControllerList() != null ? getReplicationControllerList(): new ReplicationControllerListBuilder().build());
  }
  public ValidationSchemaFluentImpl.ReplicationControllerListNested<A> editOrNewReplicationControllerListLike(ReplicationControllerList item) {
    return withNewReplicationControllerListLike(getReplicationControllerList() != null ? getReplicationControllerList(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildResourceQuota instead.
   * @return The buildable object.
   */
  @Deprecated
  public ResourceQuota getResourceQuota() {
    return this.resourceQuota!=null ?this.resourceQuota.build():null;
  }
  public ResourceQuota buildResourceQuota() {
    return this.resourceQuota!=null ?this.resourceQuota.build():null;
  }
  public A withResourceQuota(ResourceQuota resourceQuota) {
    _visitables.get("resourceQuota").remove(this.resourceQuota);
    if (resourceQuota!=null){ this.resourceQuota= new ResourceQuotaBuilder(resourceQuota); _visitables.get("resourceQuota").add(this.resourceQuota);} else { this.resourceQuota = null; _visitables.get("resourceQuota").remove(this.resourceQuota); } return (A) this;
  }
  public Boolean hasResourceQuota() {
    return this.resourceQuota != null;
  }
  public ValidationSchemaFluentImpl.ResourceQuotaNested<A> withNewResourceQuota() {
    return new ValidationSchemaFluentImpl.ResourceQuotaNestedImpl();
  }
  public ValidationSchemaFluentImpl.ResourceQuotaNested<A> withNewResourceQuotaLike(ResourceQuota item) {
    return new ValidationSchemaFluentImpl.ResourceQuotaNestedImpl(item);
  }
  public ValidationSchemaFluentImpl.ResourceQuotaNested<A> editResourceQuota() {
    return withNewResourceQuotaLike(getResourceQuota());
  }
  public ValidationSchemaFluentImpl.ResourceQuotaNested<A> editOrNewResourceQuota() {
    return withNewResourceQuotaLike(getResourceQuota() != null ? getResourceQuota(): new ResourceQuotaBuilder().build());
  }
  public ValidationSchemaFluentImpl.ResourceQuotaNested<A> editOrNewResourceQuotaLike(ResourceQuota item) {
    return withNewResourceQuotaLike(getResourceQuota() != null ? getResourceQuota(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildResourceQuotaList instead.
   * @return The buildable object.
   */
  @Deprecated
  public ResourceQuotaList getResourceQuotaList() {
    return this.resourceQuotaList!=null ?this.resourceQuotaList.build():null;
  }
  public ResourceQuotaList buildResourceQuotaList() {
    return this.resourceQuotaList!=null ?this.resourceQuotaList.build():null;
  }
  public A withResourceQuotaList(ResourceQuotaList resourceQuotaList) {
    _visitables.get("resourceQuotaList").remove(this.resourceQuotaList);
    if (resourceQuotaList!=null){ this.resourceQuotaList= new ResourceQuotaListBuilder(resourceQuotaList); _visitables.get("resourceQuotaList").add(this.resourceQuotaList);} else { this.resourceQuotaList = null; _visitables.get("resourceQuotaList").remove(this.resourceQuotaList); } return (A) this;
  }
  public Boolean hasResourceQuotaList() {
    return this.resourceQuotaList != null;
  }
  public ValidationSchemaFluentImpl.ResourceQuotaListNested<A> withNewResourceQuotaList() {
    return new ValidationSchemaFluentImpl.ResourceQuotaListNestedImpl();
  }
  public ValidationSchemaFluentImpl.ResourceQuotaListNested<A> withNewResourceQuotaListLike(ResourceQuotaList item) {
    return new ValidationSchemaFluentImpl.ResourceQuotaListNestedImpl(item);
  }
  public ValidationSchemaFluentImpl.ResourceQuotaListNested<A> editResourceQuotaList() {
    return withNewResourceQuotaListLike(getResourceQuotaList());
  }
  public ValidationSchemaFluentImpl.ResourceQuotaListNested<A> editOrNewResourceQuotaList() {
    return withNewResourceQuotaListLike(getResourceQuotaList() != null ? getResourceQuotaList(): new ResourceQuotaListBuilder().build());
  }
  public ValidationSchemaFluentImpl.ResourceQuotaListNested<A> editOrNewResourceQuotaListLike(ResourceQuotaList item) {
    return withNewResourceQuotaListLike(getResourceQuotaList() != null ? getResourceQuotaList(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildRootPaths instead.
   * @return The buildable object.
   */
  @Deprecated
  public RootPaths getRootPaths() {
    return this.rootPaths!=null ?this.rootPaths.build():null;
  }
  public RootPaths buildRootPaths() {
    return this.rootPaths!=null ?this.rootPaths.build():null;
  }
  public A withRootPaths(RootPaths rootPaths) {
    _visitables.get("rootPaths").remove(this.rootPaths);
    if (rootPaths!=null){ this.rootPaths= new RootPathsBuilder(rootPaths); _visitables.get("rootPaths").add(this.rootPaths);} else { this.rootPaths = null; _visitables.get("rootPaths").remove(this.rootPaths); } return (A) this;
  }
  public Boolean hasRootPaths() {
    return this.rootPaths != null;
  }
  public ValidationSchemaFluentImpl.RootPathsNested<A> withNewRootPaths() {
    return new ValidationSchemaFluentImpl.RootPathsNestedImpl();
  }
  public ValidationSchemaFluentImpl.RootPathsNested<A> withNewRootPathsLike(RootPaths item) {
    return new ValidationSchemaFluentImpl.RootPathsNestedImpl(item);
  }
  public ValidationSchemaFluentImpl.RootPathsNested<A> editRootPaths() {
    return withNewRootPathsLike(getRootPaths());
  }
  public ValidationSchemaFluentImpl.RootPathsNested<A> editOrNewRootPaths() {
    return withNewRootPathsLike(getRootPaths() != null ? getRootPaths(): new RootPathsBuilder().build());
  }
  public ValidationSchemaFluentImpl.RootPathsNested<A> editOrNewRootPathsLike(RootPaths item) {
    return withNewRootPathsLike(getRootPaths() != null ? getRootPaths(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildSecret instead.
   * @return The buildable object.
   */
  @Deprecated
  public Secret getSecret() {
    return this.secret!=null ?this.secret.build():null;
  }
  public Secret buildSecret() {
    return this.secret!=null ?this.secret.build():null;
  }
  public A withSecret(Secret secret) {
    _visitables.get("secret").remove(this.secret);
    if (secret!=null){ this.secret= new SecretBuilder(secret); _visitables.get("secret").add(this.secret);} else { this.secret = null; _visitables.get("secret").remove(this.secret); } return (A) this;
  }
  public Boolean hasSecret() {
    return this.secret != null;
  }
  public ValidationSchemaFluentImpl.SecretNested<A> withNewSecret() {
    return new ValidationSchemaFluentImpl.SecretNestedImpl();
  }
  public ValidationSchemaFluentImpl.SecretNested<A> withNewSecretLike(Secret item) {
    return new ValidationSchemaFluentImpl.SecretNestedImpl(item);
  }
  public ValidationSchemaFluentImpl.SecretNested<A> editSecret() {
    return withNewSecretLike(getSecret());
  }
  public ValidationSchemaFluentImpl.SecretNested<A> editOrNewSecret() {
    return withNewSecretLike(getSecret() != null ? getSecret(): new SecretBuilder().build());
  }
  public ValidationSchemaFluentImpl.SecretNested<A> editOrNewSecretLike(Secret item) {
    return withNewSecretLike(getSecret() != null ? getSecret(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildSecretList instead.
   * @return The buildable object.
   */
  @Deprecated
  public SecretList getSecretList() {
    return this.secretList!=null ?this.secretList.build():null;
  }
  public SecretList buildSecretList() {
    return this.secretList!=null ?this.secretList.build():null;
  }
  public A withSecretList(SecretList secretList) {
    _visitables.get("secretList").remove(this.secretList);
    if (secretList!=null){ this.secretList= new SecretListBuilder(secretList); _visitables.get("secretList").add(this.secretList);} else { this.secretList = null; _visitables.get("secretList").remove(this.secretList); } return (A) this;
  }
  public Boolean hasSecretList() {
    return this.secretList != null;
  }
  public ValidationSchemaFluentImpl.SecretListNested<A> withNewSecretList() {
    return new ValidationSchemaFluentImpl.SecretListNestedImpl();
  }
  public ValidationSchemaFluentImpl.SecretListNested<A> withNewSecretListLike(SecretList item) {
    return new ValidationSchemaFluentImpl.SecretListNestedImpl(item);
  }
  public ValidationSchemaFluentImpl.SecretListNested<A> editSecretList() {
    return withNewSecretListLike(getSecretList());
  }
  public ValidationSchemaFluentImpl.SecretListNested<A> editOrNewSecretList() {
    return withNewSecretListLike(getSecretList() != null ? getSecretList(): new SecretListBuilder().build());
  }
  public ValidationSchemaFluentImpl.SecretListNested<A> editOrNewSecretListLike(SecretList item) {
    return withNewSecretListLike(getSecretList() != null ? getSecretList(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildServiceAccount instead.
   * @return The buildable object.
   */
  @Deprecated
  public ServiceAccount getServiceAccount() {
    return this.serviceAccount!=null ?this.serviceAccount.build():null;
  }
  public ServiceAccount buildServiceAccount() {
    return this.serviceAccount!=null ?this.serviceAccount.build():null;
  }
  public A withServiceAccount(ServiceAccount serviceAccount) {
    _visitables.get("serviceAccount").remove(this.serviceAccount);
    if (serviceAccount!=null){ this.serviceAccount= new ServiceAccountBuilder(serviceAccount); _visitables.get("serviceAccount").add(this.serviceAccount);} else { this.serviceAccount = null; _visitables.get("serviceAccount").remove(this.serviceAccount); } return (A) this;
  }
  public Boolean hasServiceAccount() {
    return this.serviceAccount != null;
  }
  public ValidationSchemaFluentImpl.ServiceAccountNested<A> withNewServiceAccount() {
    return new ValidationSchemaFluentImpl.ServiceAccountNestedImpl();
  }
  public ValidationSchemaFluentImpl.ServiceAccountNested<A> withNewServiceAccountLike(ServiceAccount item) {
    return new ValidationSchemaFluentImpl.ServiceAccountNestedImpl(item);
  }
  public ValidationSchemaFluentImpl.ServiceAccountNested<A> editServiceAccount() {
    return withNewServiceAccountLike(getServiceAccount());
  }
  public ValidationSchemaFluentImpl.ServiceAccountNested<A> editOrNewServiceAccount() {
    return withNewServiceAccountLike(getServiceAccount() != null ? getServiceAccount(): new ServiceAccountBuilder().build());
  }
  public ValidationSchemaFluentImpl.ServiceAccountNested<A> editOrNewServiceAccountLike(ServiceAccount item) {
    return withNewServiceAccountLike(getServiceAccount() != null ? getServiceAccount(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildServiceAccountList instead.
   * @return The buildable object.
   */
  @Deprecated
  public ServiceAccountList getServiceAccountList() {
    return this.serviceAccountList!=null ?this.serviceAccountList.build():null;
  }
  public ServiceAccountList buildServiceAccountList() {
    return this.serviceAccountList!=null ?this.serviceAccountList.build():null;
  }
  public A withServiceAccountList(ServiceAccountList serviceAccountList) {
    _visitables.get("serviceAccountList").remove(this.serviceAccountList);
    if (serviceAccountList!=null){ this.serviceAccountList= new ServiceAccountListBuilder(serviceAccountList); _visitables.get("serviceAccountList").add(this.serviceAccountList);} else { this.serviceAccountList = null; _visitables.get("serviceAccountList").remove(this.serviceAccountList); } return (A) this;
  }
  public Boolean hasServiceAccountList() {
    return this.serviceAccountList != null;
  }
  public ValidationSchemaFluentImpl.ServiceAccountListNested<A> withNewServiceAccountList() {
    return new ValidationSchemaFluentImpl.ServiceAccountListNestedImpl();
  }
  public ValidationSchemaFluentImpl.ServiceAccountListNested<A> withNewServiceAccountListLike(ServiceAccountList item) {
    return new ValidationSchemaFluentImpl.ServiceAccountListNestedImpl(item);
  }
  public ValidationSchemaFluentImpl.ServiceAccountListNested<A> editServiceAccountList() {
    return withNewServiceAccountListLike(getServiceAccountList());
  }
  public ValidationSchemaFluentImpl.ServiceAccountListNested<A> editOrNewServiceAccountList() {
    return withNewServiceAccountListLike(getServiceAccountList() != null ? getServiceAccountList(): new ServiceAccountListBuilder().build());
  }
  public ValidationSchemaFluentImpl.ServiceAccountListNested<A> editOrNewServiceAccountListLike(ServiceAccountList item) {
    return withNewServiceAccountListLike(getServiceAccountList() != null ? getServiceAccountList(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildServiceList instead.
   * @return The buildable object.
   */
  @Deprecated
  public ServiceList getServiceList() {
    return this.serviceList!=null ?this.serviceList.build():null;
  }
  public ServiceList buildServiceList() {
    return this.serviceList!=null ?this.serviceList.build():null;
  }
  public A withServiceList(ServiceList serviceList) {
    _visitables.get("serviceList").remove(this.serviceList);
    if (serviceList!=null){ this.serviceList= new ServiceListBuilder(serviceList); _visitables.get("serviceList").add(this.serviceList);} else { this.serviceList = null; _visitables.get("serviceList").remove(this.serviceList); } return (A) this;
  }
  public Boolean hasServiceList() {
    return this.serviceList != null;
  }
  public ValidationSchemaFluentImpl.ServiceListNested<A> withNewServiceList() {
    return new ValidationSchemaFluentImpl.ServiceListNestedImpl();
  }
  public ValidationSchemaFluentImpl.ServiceListNested<A> withNewServiceListLike(ServiceList item) {
    return new ValidationSchemaFluentImpl.ServiceListNestedImpl(item);
  }
  public ValidationSchemaFluentImpl.ServiceListNested<A> editServiceList() {
    return withNewServiceListLike(getServiceList());
  }
  public ValidationSchemaFluentImpl.ServiceListNested<A> editOrNewServiceList() {
    return withNewServiceListLike(getServiceList() != null ? getServiceList(): new ServiceListBuilder().build());
  }
  public ValidationSchemaFluentImpl.ServiceListNested<A> editOrNewServiceListLike(ServiceList item) {
    return withNewServiceListLike(getServiceList() != null ? getServiceList(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildStatus instead.
   * @return The buildable object.
   */
  @Deprecated
  public Status getStatus() {
    return this.status!=null ?this.status.build():null;
  }
  public Status buildStatus() {
    return this.status!=null ?this.status.build():null;
  }
  public A withStatus(Status status) {
    _visitables.get("status").remove(this.status);
    if (status!=null){ this.status= new StatusBuilder(status); _visitables.get("status").add(this.status);} else { this.status = null; _visitables.get("status").remove(this.status); } return (A) this;
  }
  public Boolean hasStatus() {
    return this.status != null;
  }
  public ValidationSchemaFluentImpl.StatusNested<A> withNewStatus() {
    return new ValidationSchemaFluentImpl.StatusNestedImpl();
  }
  public ValidationSchemaFluentImpl.StatusNested<A> withNewStatusLike(Status item) {
    return new ValidationSchemaFluentImpl.StatusNestedImpl(item);
  }
  public ValidationSchemaFluentImpl.StatusNested<A> editStatus() {
    return withNewStatusLike(getStatus());
  }
  public ValidationSchemaFluentImpl.StatusNested<A> editOrNewStatus() {
    return withNewStatusLike(getStatus() != null ? getStatus(): new StatusBuilder().build());
  }
  public ValidationSchemaFluentImpl.StatusNested<A> editOrNewStatusLike(Status item) {
    return withNewStatusLike(getStatus() != null ? getStatus(): item);
  }
  public String getTime() {
    return this.time;
  }
  public A withTime(String time) {
    this.time=time; return (A) this;
  }
  public Boolean hasTime() {
    return this.time != null;
  }
  
  /**
   * This method has been deprecated, please use method buildToleration instead.
   * @return The buildable object.
   */
  @Deprecated
  public Toleration getToleration() {
    return this.toleration!=null ?this.toleration.build():null;
  }
  public Toleration buildToleration() {
    return this.toleration!=null ?this.toleration.build():null;
  }
  public A withToleration(Toleration toleration) {
    _visitables.get("toleration").remove(this.toleration);
    if (toleration!=null){ this.toleration= new TolerationBuilder(toleration); _visitables.get("toleration").add(this.toleration);} else { this.toleration = null; _visitables.get("toleration").remove(this.toleration); } return (A) this;
  }
  public Boolean hasToleration() {
    return this.toleration != null;
  }
  public A withNewToleration(String effect,String key,String operator,Long tolerationSeconds,String value) {
    return (A)withToleration(new Toleration(effect, key, operator, tolerationSeconds, value));
  }
  public ValidationSchemaFluentImpl.TolerationNested<A> withNewToleration() {
    return new ValidationSchemaFluentImpl.TolerationNestedImpl();
  }
  public ValidationSchemaFluentImpl.TolerationNested<A> withNewTolerationLike(Toleration item) {
    return new ValidationSchemaFluentImpl.TolerationNestedImpl(item);
  }
  public ValidationSchemaFluentImpl.TolerationNested<A> editToleration() {
    return withNewTolerationLike(getToleration());
  }
  public ValidationSchemaFluentImpl.TolerationNested<A> editOrNewToleration() {
    return withNewTolerationLike(getToleration() != null ? getToleration(): new TolerationBuilder().build());
  }
  public ValidationSchemaFluentImpl.TolerationNested<A> editOrNewTolerationLike(Toleration item) {
    return withNewTolerationLike(getToleration() != null ? getToleration(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildTopologySelectorTerm instead.
   * @return The buildable object.
   */
  @Deprecated
  public TopologySelectorTerm getTopologySelectorTerm() {
    return this.topologySelectorTerm!=null ?this.topologySelectorTerm.build():null;
  }
  public TopologySelectorTerm buildTopologySelectorTerm() {
    return this.topologySelectorTerm!=null ?this.topologySelectorTerm.build():null;
  }
  public A withTopologySelectorTerm(TopologySelectorTerm topologySelectorTerm) {
    _visitables.get("topologySelectorTerm").remove(this.topologySelectorTerm);
    if (topologySelectorTerm!=null){ this.topologySelectorTerm= new TopologySelectorTermBuilder(topologySelectorTerm); _visitables.get("topologySelectorTerm").add(this.topologySelectorTerm);} else { this.topologySelectorTerm = null; _visitables.get("topologySelectorTerm").remove(this.topologySelectorTerm); } return (A) this;
  }
  public Boolean hasTopologySelectorTerm() {
    return this.topologySelectorTerm != null;
  }
  public ValidationSchemaFluentImpl.TopologySelectorTermNested<A> withNewTopologySelectorTerm() {
    return new ValidationSchemaFluentImpl.TopologySelectorTermNestedImpl();
  }
  public ValidationSchemaFluentImpl.TopologySelectorTermNested<A> withNewTopologySelectorTermLike(TopologySelectorTerm item) {
    return new ValidationSchemaFluentImpl.TopologySelectorTermNestedImpl(item);
  }
  public ValidationSchemaFluentImpl.TopologySelectorTermNested<A> editTopologySelectorTerm() {
    return withNewTopologySelectorTermLike(getTopologySelectorTerm());
  }
  public ValidationSchemaFluentImpl.TopologySelectorTermNested<A> editOrNewTopologySelectorTerm() {
    return withNewTopologySelectorTermLike(getTopologySelectorTerm() != null ? getTopologySelectorTerm(): new TopologySelectorTermBuilder().build());
  }
  public ValidationSchemaFluentImpl.TopologySelectorTermNested<A> editOrNewTopologySelectorTermLike(TopologySelectorTerm item) {
    return withNewTopologySelectorTermLike(getTopologySelectorTerm() != null ? getTopologySelectorTerm(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildTypeMeta instead.
   * @return The buildable object.
   */
  @Deprecated
  public TypeMeta getTypeMeta() {
    return this.typeMeta!=null ?this.typeMeta.build():null;
  }
  public TypeMeta buildTypeMeta() {
    return this.typeMeta!=null ?this.typeMeta.build():null;
  }
  public A withTypeMeta(TypeMeta typeMeta) {
    _visitables.get("typeMeta").remove(this.typeMeta);
    if (typeMeta!=null){ this.typeMeta= new TypeMetaBuilder(typeMeta); _visitables.get("typeMeta").add(this.typeMeta);} else { this.typeMeta = null; _visitables.get("typeMeta").remove(this.typeMeta); } return (A) this;
  }
  public Boolean hasTypeMeta() {
    return this.typeMeta != null;
  }
  public A withNewTypeMeta(String apiVersion,String kind) {
    return (A)withTypeMeta(new TypeMeta(apiVersion, kind));
  }
  public ValidationSchemaFluentImpl.TypeMetaNested<A> withNewTypeMeta() {
    return new ValidationSchemaFluentImpl.TypeMetaNestedImpl();
  }
  public ValidationSchemaFluentImpl.TypeMetaNested<A> withNewTypeMetaLike(TypeMeta item) {
    return new ValidationSchemaFluentImpl.TypeMetaNestedImpl(item);
  }
  public ValidationSchemaFluentImpl.TypeMetaNested<A> editTypeMeta() {
    return withNewTypeMetaLike(getTypeMeta());
  }
  public ValidationSchemaFluentImpl.TypeMetaNested<A> editOrNewTypeMeta() {
    return withNewTypeMetaLike(getTypeMeta() != null ? getTypeMeta(): new TypeMetaBuilder().build());
  }
  public ValidationSchemaFluentImpl.TypeMetaNested<A> editOrNewTypeMetaLike(TypeMeta item) {
    return withNewTypeMetaLike(getTypeMeta() != null ? getTypeMeta(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildUpdateOptions instead.
   * @return The buildable object.
   */
  @Deprecated
  public UpdateOptions getUpdateOptions() {
    return this.updateOptions!=null ?this.updateOptions.build():null;
  }
  public UpdateOptions buildUpdateOptions() {
    return this.updateOptions!=null ?this.updateOptions.build():null;
  }
  public A withUpdateOptions(UpdateOptions updateOptions) {
    _visitables.get("updateOptions").remove(this.updateOptions);
    if (updateOptions!=null){ this.updateOptions= new UpdateOptionsBuilder(updateOptions); _visitables.get("updateOptions").add(this.updateOptions);} else { this.updateOptions = null; _visitables.get("updateOptions").remove(this.updateOptions); } return (A) this;
  }
  public Boolean hasUpdateOptions() {
    return this.updateOptions != null;
  }
  public ValidationSchemaFluentImpl.UpdateOptionsNested<A> withNewUpdateOptions() {
    return new ValidationSchemaFluentImpl.UpdateOptionsNestedImpl();
  }
  public ValidationSchemaFluentImpl.UpdateOptionsNested<A> withNewUpdateOptionsLike(UpdateOptions item) {
    return new ValidationSchemaFluentImpl.UpdateOptionsNestedImpl(item);
  }
  public ValidationSchemaFluentImpl.UpdateOptionsNested<A> editUpdateOptions() {
    return withNewUpdateOptionsLike(getUpdateOptions());
  }
  public ValidationSchemaFluentImpl.UpdateOptionsNested<A> editOrNewUpdateOptions() {
    return withNewUpdateOptionsLike(getUpdateOptions() != null ? getUpdateOptions(): new UpdateOptionsBuilder().build());
  }
  public ValidationSchemaFluentImpl.UpdateOptionsNested<A> editOrNewUpdateOptionsLike(UpdateOptions item) {
    return withNewUpdateOptionsLike(getUpdateOptions() != null ? getUpdateOptions(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildWatchEvent instead.
   * @return The buildable object.
   */
  @Deprecated
  public WatchEvent getWatchEvent() {
    return this.watchEvent!=null ?this.watchEvent.build():null;
  }
  public WatchEvent buildWatchEvent() {
    return this.watchEvent!=null ?this.watchEvent.build():null;
  }
  public A withWatchEvent(WatchEvent watchEvent) {
    _visitables.get("watchEvent").remove(this.watchEvent);
    if (watchEvent!=null){ this.watchEvent= new WatchEventBuilder(watchEvent); _visitables.get("watchEvent").add(this.watchEvent);} else { this.watchEvent = null; _visitables.get("watchEvent").remove(this.watchEvent); } return (A) this;
  }
  public Boolean hasWatchEvent() {
    return this.watchEvent != null;
  }
  public ValidationSchemaFluentImpl.WatchEventNested<A> withNewWatchEvent() {
    return new ValidationSchemaFluentImpl.WatchEventNestedImpl();
  }
  public ValidationSchemaFluentImpl.WatchEventNested<A> withNewWatchEventLike(WatchEvent item) {
    return new ValidationSchemaFluentImpl.WatchEventNestedImpl(item);
  }
  public ValidationSchemaFluentImpl.WatchEventNested<A> editWatchEvent() {
    return withNewWatchEventLike(getWatchEvent());
  }
  public ValidationSchemaFluentImpl.WatchEventNested<A> editOrNewWatchEvent() {
    return withNewWatchEventLike(getWatchEvent() != null ? getWatchEvent(): new WatchEventBuilder().build());
  }
  public ValidationSchemaFluentImpl.WatchEventNested<A> editOrNewWatchEventLike(WatchEvent item) {
    return withNewWatchEventLike(getWatchEvent() != null ? getWatchEvent(): item);
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ValidationSchemaFluentImpl that = (ValidationSchemaFluentImpl) o;
    if (!java.util.Objects.equals(aPIGroup, that.aPIGroup)) return false;

    if (!java.util.Objects.equals(aPIGroupList, that.aPIGroupList)) return false;

    if (!java.util.Objects.equals(aPIResource, that.aPIResource)) return false;

    if (!java.util.Objects.equals(aPIResourceList, that.aPIResourceList)) return false;

    if (!java.util.Objects.equals(aPIService, that.aPIService)) return false;

    if (!java.util.Objects.equals(aPIServiceList, that.aPIServiceList)) return false;

    if (!java.util.Objects.equals(binding, that.binding)) return false;

    if (!java.util.Objects.equals(componentStatus, that.componentStatus)) return false;

    if (!java.util.Objects.equals(componentStatusList, that.componentStatusList)) return false;

    if (!java.util.Objects.equals(condition, that.condition)) return false;

    if (!java.util.Objects.equals(config, that.config)) return false;

    if (!java.util.Objects.equals(configMap, that.configMap)) return false;

    if (!java.util.Objects.equals(configMapList, that.configMapList)) return false;

    if (!java.util.Objects.equals(containerStatus, that.containerStatus)) return false;

    if (!java.util.Objects.equals(createOptions, that.createOptions)) return false;

    if (!java.util.Objects.equals(deleteOptions, that.deleteOptions)) return false;

    if (!java.util.Objects.equals(endpointPort, that.endpointPort)) return false;

    if (!java.util.Objects.equals(endpoints, that.endpoints)) return false;

    if (!java.util.Objects.equals(endpointsList, that.endpointsList)) return false;

    if (!java.util.Objects.equals(envVar, that.envVar)) return false;

    if (!java.util.Objects.equals(event, that.event)) return false;

    if (!java.util.Objects.equals(eventList, that.eventList)) return false;

    if (!java.util.Objects.equals(eventSeries, that.eventSeries)) return false;

    if (!java.util.Objects.equals(eventSource, that.eventSource)) return false;

    if (!java.util.Objects.equals(getOptions, that.getOptions)) return false;

    if (!java.util.Objects.equals(groupKind, that.groupKind)) return false;

    if (!java.util.Objects.equals(groupVersionKind, that.groupVersionKind)) return false;

    if (!java.util.Objects.equals(groupVersionResource, that.groupVersionResource)) return false;

    if (!java.util.Objects.equals(info, that.info)) return false;

    if (!java.util.Objects.equals(kubernetesList, that.kubernetesList)) return false;

    if (!java.util.Objects.equals(limitRangeList, that.limitRangeList)) return false;

    if (!java.util.Objects.equals(listOptions, that.listOptions)) return false;

    if (!java.util.Objects.equals(microTime, that.microTime)) return false;

    if (!java.util.Objects.equals(namespace, that.namespace)) return false;

    if (!java.util.Objects.equals(namespaceList, that.namespaceList)) return false;

    if (!java.util.Objects.equals(node, that.node)) return false;

    if (!java.util.Objects.equals(nodeList, that.nodeList)) return false;

    if (!java.util.Objects.equals(objectMeta, that.objectMeta)) return false;

    if (!java.util.Objects.equals(patch, that.patch)) return false;

    if (!java.util.Objects.equals(patchOptions, that.patchOptions)) return false;

    if (!java.util.Objects.equals(persistentVolume, that.persistentVolume)) return false;

    if (!java.util.Objects.equals(persistentVolumeClaim, that.persistentVolumeClaim)) return false;

    if (!java.util.Objects.equals(persistentVolumeClaimList, that.persistentVolumeClaimList)) return false;

    if (!java.util.Objects.equals(persistentVolumeList, that.persistentVolumeList)) return false;

    if (!java.util.Objects.equals(podExecOptions, that.podExecOptions)) return false;

    if (!java.util.Objects.equals(podList, that.podList)) return false;

    if (!java.util.Objects.equals(podTemplateList, that.podTemplateList)) return false;

    if (!java.util.Objects.equals(quantity, that.quantity)) return false;

    if (!java.util.Objects.equals(replicationControllerList, that.replicationControllerList)) return false;

    if (!java.util.Objects.equals(resourceQuota, that.resourceQuota)) return false;

    if (!java.util.Objects.equals(resourceQuotaList, that.resourceQuotaList)) return false;

    if (!java.util.Objects.equals(rootPaths, that.rootPaths)) return false;

    if (!java.util.Objects.equals(secret, that.secret)) return false;

    if (!java.util.Objects.equals(secretList, that.secretList)) return false;

    if (!java.util.Objects.equals(serviceAccount, that.serviceAccount)) return false;

    if (!java.util.Objects.equals(serviceAccountList, that.serviceAccountList)) return false;

    if (!java.util.Objects.equals(serviceList, that.serviceList)) return false;

    if (!java.util.Objects.equals(status, that.status)) return false;

    if (!java.util.Objects.equals(time, that.time)) return false;

    if (!java.util.Objects.equals(toleration, that.toleration)) return false;

    if (!java.util.Objects.equals(topologySelectorTerm, that.topologySelectorTerm)) return false;

    if (!java.util.Objects.equals(typeMeta, that.typeMeta)) return false;

    if (!java.util.Objects.equals(updateOptions, that.updateOptions)) return false;

    if (!java.util.Objects.equals(watchEvent, that.watchEvent)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(aPIGroup,  aPIGroupList,  aPIResource,  aPIResourceList,  aPIService,  aPIServiceList,  binding,  componentStatus,  componentStatusList,  condition,  config,  configMap,  configMapList,  containerStatus,  createOptions,  deleteOptions,  endpointPort,  endpoints,  endpointsList,  envVar,  event,  eventList,  eventSeries,  eventSource,  getOptions,  groupKind,  groupVersionKind,  groupVersionResource,  info,  kubernetesList,  limitRangeList,  listOptions,  microTime,  namespace,  namespaceList,  node,  nodeList,  objectMeta,  patch,  patchOptions,  persistentVolume,  persistentVolumeClaim,  persistentVolumeClaimList,  persistentVolumeList,  podExecOptions,  podList,  podTemplateList,  quantity,  replicationControllerList,  resourceQuota,  resourceQuotaList,  rootPaths,  secret,  secretList,  serviceAccount,  serviceAccountList,  serviceList,  status,  time,  toleration,  topologySelectorTerm,  typeMeta,  updateOptions,  watchEvent,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (aPIGroup != null) { sb.append("aPIGroup:"); sb.append(aPIGroup + ","); }
    if (aPIGroupList != null) { sb.append("aPIGroupList:"); sb.append(aPIGroupList + ","); }
    if (aPIResource != null) { sb.append("aPIResource:"); sb.append(aPIResource + ","); }
    if (aPIResourceList != null) { sb.append("aPIResourceList:"); sb.append(aPIResourceList + ","); }
    if (aPIService != null) { sb.append("aPIService:"); sb.append(aPIService + ","); }
    if (aPIServiceList != null) { sb.append("aPIServiceList:"); sb.append(aPIServiceList + ","); }
    if (binding != null) { sb.append("binding:"); sb.append(binding + ","); }
    if (componentStatus != null) { sb.append("componentStatus:"); sb.append(componentStatus + ","); }
    if (componentStatusList != null) { sb.append("componentStatusList:"); sb.append(componentStatusList + ","); }
    if (condition != null) { sb.append("condition:"); sb.append(condition + ","); }
    if (config != null) { sb.append("config:"); sb.append(config + ","); }
    if (configMap != null) { sb.append("configMap:"); sb.append(configMap + ","); }
    if (configMapList != null) { sb.append("configMapList:"); sb.append(configMapList + ","); }
    if (containerStatus != null) { sb.append("containerStatus:"); sb.append(containerStatus + ","); }
    if (createOptions != null) { sb.append("createOptions:"); sb.append(createOptions + ","); }
    if (deleteOptions != null) { sb.append("deleteOptions:"); sb.append(deleteOptions + ","); }
    if (endpointPort != null) { sb.append("endpointPort:"); sb.append(endpointPort + ","); }
    if (endpoints != null) { sb.append("endpoints:"); sb.append(endpoints + ","); }
    if (endpointsList != null) { sb.append("endpointsList:"); sb.append(endpointsList + ","); }
    if (envVar != null) { sb.append("envVar:"); sb.append(envVar + ","); }
    if (event != null) { sb.append("event:"); sb.append(event + ","); }
    if (eventList != null) { sb.append("eventList:"); sb.append(eventList + ","); }
    if (eventSeries != null) { sb.append("eventSeries:"); sb.append(eventSeries + ","); }
    if (eventSource != null) { sb.append("eventSource:"); sb.append(eventSource + ","); }
    if (getOptions != null) { sb.append("getOptions:"); sb.append(getOptions + ","); }
    if (groupKind != null) { sb.append("groupKind:"); sb.append(groupKind + ","); }
    if (groupVersionKind != null) { sb.append("groupVersionKind:"); sb.append(groupVersionKind + ","); }
    if (groupVersionResource != null) { sb.append("groupVersionResource:"); sb.append(groupVersionResource + ","); }
    if (info != null) { sb.append("info:"); sb.append(info + ","); }
    if (kubernetesList != null) { sb.append("kubernetesList:"); sb.append(kubernetesList + ","); }
    if (limitRangeList != null) { sb.append("limitRangeList:"); sb.append(limitRangeList + ","); }
    if (listOptions != null) { sb.append("listOptions:"); sb.append(listOptions + ","); }
    if (microTime != null) { sb.append("microTime:"); sb.append(microTime + ","); }
    if (namespace != null) { sb.append("namespace:"); sb.append(namespace + ","); }
    if (namespaceList != null) { sb.append("namespaceList:"); sb.append(namespaceList + ","); }
    if (node != null) { sb.append("node:"); sb.append(node + ","); }
    if (nodeList != null) { sb.append("nodeList:"); sb.append(nodeList + ","); }
    if (objectMeta != null) { sb.append("objectMeta:"); sb.append(objectMeta + ","); }
    if (patch != null) { sb.append("patch:"); sb.append(patch + ","); }
    if (patchOptions != null) { sb.append("patchOptions:"); sb.append(patchOptions + ","); }
    if (persistentVolume != null) { sb.append("persistentVolume:"); sb.append(persistentVolume + ","); }
    if (persistentVolumeClaim != null) { sb.append("persistentVolumeClaim:"); sb.append(persistentVolumeClaim + ","); }
    if (persistentVolumeClaimList != null) { sb.append("persistentVolumeClaimList:"); sb.append(persistentVolumeClaimList + ","); }
    if (persistentVolumeList != null) { sb.append("persistentVolumeList:"); sb.append(persistentVolumeList + ","); }
    if (podExecOptions != null) { sb.append("podExecOptions:"); sb.append(podExecOptions + ","); }
    if (podList != null) { sb.append("podList:"); sb.append(podList + ","); }
    if (podTemplateList != null) { sb.append("podTemplateList:"); sb.append(podTemplateList + ","); }
    if (quantity != null) { sb.append("quantity:"); sb.append(quantity + ","); }
    if (replicationControllerList != null) { sb.append("replicationControllerList:"); sb.append(replicationControllerList + ","); }
    if (resourceQuota != null) { sb.append("resourceQuota:"); sb.append(resourceQuota + ","); }
    if (resourceQuotaList != null) { sb.append("resourceQuotaList:"); sb.append(resourceQuotaList + ","); }
    if (rootPaths != null) { sb.append("rootPaths:"); sb.append(rootPaths + ","); }
    if (secret != null) { sb.append("secret:"); sb.append(secret + ","); }
    if (secretList != null) { sb.append("secretList:"); sb.append(secretList + ","); }
    if (serviceAccount != null) { sb.append("serviceAccount:"); sb.append(serviceAccount + ","); }
    if (serviceAccountList != null) { sb.append("serviceAccountList:"); sb.append(serviceAccountList + ","); }
    if (serviceList != null) { sb.append("serviceList:"); sb.append(serviceList + ","); }
    if (status != null) { sb.append("status:"); sb.append(status + ","); }
    if (time != null) { sb.append("time:"); sb.append(time + ","); }
    if (toleration != null) { sb.append("toleration:"); sb.append(toleration + ","); }
    if (topologySelectorTerm != null) { sb.append("topologySelectorTerm:"); sb.append(topologySelectorTerm + ","); }
    if (typeMeta != null) { sb.append("typeMeta:"); sb.append(typeMeta + ","); }
    if (updateOptions != null) { sb.append("updateOptions:"); sb.append(updateOptions + ","); }
    if (watchEvent != null) { sb.append("watchEvent:"); sb.append(watchEvent + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class APIGroupNestedImpl<N> extends APIGroupFluentImpl<ValidationSchemaFluentImpl.APIGroupNested<N>> implements ValidationSchemaFluentImpl.APIGroupNested<N>,Nested<N>{
    APIGroupNestedImpl(APIGroup item) {
      this.builder = new APIGroupBuilder(this, item);
    }
    APIGroupNestedImpl() {
      this.builder = new APIGroupBuilder(this);
    }
    APIGroupBuilder builder;
    public N and() {
      return (N) ValidationSchemaFluentImpl.this.withAPIGroup(builder.build());
    }
    public N endAPIGroup() {
      return and();
    }
    
  }
  class APIGroupListNestedImpl<N> extends APIGroupListFluentImpl<ValidationSchemaFluentImpl.APIGroupListNested<N>> implements ValidationSchemaFluentImpl.APIGroupListNested<N>,Nested<N>{
    APIGroupListNestedImpl(APIGroupList item) {
      this.builder = new APIGroupListBuilder(this, item);
    }
    APIGroupListNestedImpl() {
      this.builder = new APIGroupListBuilder(this);
    }
    APIGroupListBuilder builder;
    public N and() {
      return (N) ValidationSchemaFluentImpl.this.withAPIGroupList(builder.build());
    }
    public N endAPIGroupList() {
      return and();
    }
    
  }
  class APIResourceNestedImpl<N> extends APIResourceFluentImpl<ValidationSchemaFluentImpl.APIResourceNested<N>> implements ValidationSchemaFluentImpl.APIResourceNested<N>,Nested<N>{
    APIResourceNestedImpl(APIResource item) {
      this.builder = new APIResourceBuilder(this, item);
    }
    APIResourceNestedImpl() {
      this.builder = new APIResourceBuilder(this);
    }
    APIResourceBuilder builder;
    public N and() {
      return (N) ValidationSchemaFluentImpl.this.withAPIResource(builder.build());
    }
    public N endAPIResource() {
      return and();
    }
    
  }
  class APIResourceListNestedImpl<N> extends APIResourceListFluentImpl<ValidationSchemaFluentImpl.APIResourceListNested<N>> implements ValidationSchemaFluentImpl.APIResourceListNested<N>,Nested<N>{
    APIResourceListNestedImpl(APIResourceList item) {
      this.builder = new APIResourceListBuilder(this, item);
    }
    APIResourceListNestedImpl() {
      this.builder = new APIResourceListBuilder(this);
    }
    APIResourceListBuilder builder;
    public N and() {
      return (N) ValidationSchemaFluentImpl.this.withAPIResourceList(builder.build());
    }
    public N endAPIResourceList() {
      return and();
    }
    
  }
  class APIServiceNestedImpl<N> extends APIServiceFluentImpl<ValidationSchemaFluentImpl.APIServiceNested<N>> implements ValidationSchemaFluentImpl.APIServiceNested<N>,Nested<N>{
    APIServiceNestedImpl(APIService item) {
      this.builder = new APIServiceBuilder(this, item);
    }
    APIServiceNestedImpl() {
      this.builder = new APIServiceBuilder(this);
    }
    APIServiceBuilder builder;
    public N and() {
      return (N) ValidationSchemaFluentImpl.this.withAPIService(builder.build());
    }
    public N endAPIService() {
      return and();
    }
    
  }
  class APIServiceListNestedImpl<N> extends APIServiceListFluentImpl<ValidationSchemaFluentImpl.APIServiceListNested<N>> implements ValidationSchemaFluentImpl.APIServiceListNested<N>,Nested<N>{
    APIServiceListNestedImpl(APIServiceList item) {
      this.builder = new APIServiceListBuilder(this, item);
    }
    APIServiceListNestedImpl() {
      this.builder = new APIServiceListBuilder(this);
    }
    APIServiceListBuilder builder;
    public N and() {
      return (N) ValidationSchemaFluentImpl.this.withAPIServiceList(builder.build());
    }
    public N endAPIServiceList() {
      return and();
    }
    
  }
  class BindingNestedImpl<N> extends BindingFluentImpl<ValidationSchemaFluentImpl.BindingNested<N>> implements ValidationSchemaFluentImpl.BindingNested<N>,Nested<N>{
    BindingNestedImpl(Binding item) {
      this.builder = new BindingBuilder(this, item);
    }
    BindingNestedImpl() {
      this.builder = new BindingBuilder(this);
    }
    BindingBuilder builder;
    public N and() {
      return (N) ValidationSchemaFluentImpl.this.withBinding(builder.build());
    }
    public N endBinding() {
      return and();
    }
    
  }
  class ComponentStatusNestedImpl<N> extends ComponentStatusFluentImpl<ValidationSchemaFluentImpl.ComponentStatusNested<N>> implements ValidationSchemaFluentImpl.ComponentStatusNested<N>,Nested<N>{
    ComponentStatusNestedImpl(ComponentStatus item) {
      this.builder = new ComponentStatusBuilder(this, item);
    }
    ComponentStatusNestedImpl() {
      this.builder = new ComponentStatusBuilder(this);
    }
    ComponentStatusBuilder builder;
    public N and() {
      return (N) ValidationSchemaFluentImpl.this.withComponentStatus(builder.build());
    }
    public N endComponentStatus() {
      return and();
    }
    
  }
  class ComponentStatusListNestedImpl<N> extends ComponentStatusListFluentImpl<ValidationSchemaFluentImpl.ComponentStatusListNested<N>> implements ValidationSchemaFluentImpl.ComponentStatusListNested<N>,Nested<N>{
    ComponentStatusListNestedImpl(ComponentStatusList item) {
      this.builder = new ComponentStatusListBuilder(this, item);
    }
    ComponentStatusListNestedImpl() {
      this.builder = new ComponentStatusListBuilder(this);
    }
    ComponentStatusListBuilder builder;
    public N and() {
      return (N) ValidationSchemaFluentImpl.this.withComponentStatusList(builder.build());
    }
    public N endComponentStatusList() {
      return and();
    }
    
  }
  class ConditionNestedImpl<N> extends ConditionFluentImpl<ValidationSchemaFluentImpl.ConditionNested<N>> implements ValidationSchemaFluentImpl.ConditionNested<N>,Nested<N>{
    ConditionNestedImpl(Condition item) {
      this.builder = new ConditionBuilder(this, item);
    }
    ConditionNestedImpl() {
      this.builder = new ConditionBuilder(this);
    }
    ConditionBuilder builder;
    public N and() {
      return (N) ValidationSchemaFluentImpl.this.withCondition(builder.build());
    }
    public N endCondition() {
      return and();
    }
    
  }
  class ConfigNestedImpl<N> extends ConfigFluentImpl<ValidationSchemaFluentImpl.ConfigNested<N>> implements ValidationSchemaFluentImpl.ConfigNested<N>,Nested<N>{
    ConfigNestedImpl(Config item) {
      this.builder = new ConfigBuilder(this, item);
    }
    ConfigNestedImpl() {
      this.builder = new ConfigBuilder(this);
    }
    ConfigBuilder builder;
    public N and() {
      return (N) ValidationSchemaFluentImpl.this.withConfig(builder.build());
    }
    public N endConfig() {
      return and();
    }
    
  }
  class ConfigMapNestedImpl<N> extends ConfigMapFluentImpl<ValidationSchemaFluentImpl.ConfigMapNested<N>> implements ValidationSchemaFluentImpl.ConfigMapNested<N>,Nested<N>{
    ConfigMapNestedImpl(ConfigMap item) {
      this.builder = new ConfigMapBuilder(this, item);
    }
    ConfigMapNestedImpl() {
      this.builder = new ConfigMapBuilder(this);
    }
    ConfigMapBuilder builder;
    public N and() {
      return (N) ValidationSchemaFluentImpl.this.withConfigMap(builder.build());
    }
    public N endConfigMap() {
      return and();
    }
    
  }
  class ConfigMapListNestedImpl<N> extends ConfigMapListFluentImpl<ValidationSchemaFluentImpl.ConfigMapListNested<N>> implements ValidationSchemaFluentImpl.ConfigMapListNested<N>,Nested<N>{
    ConfigMapListNestedImpl(ConfigMapList item) {
      this.builder = new ConfigMapListBuilder(this, item);
    }
    ConfigMapListNestedImpl() {
      this.builder = new ConfigMapListBuilder(this);
    }
    ConfigMapListBuilder builder;
    public N and() {
      return (N) ValidationSchemaFluentImpl.this.withConfigMapList(builder.build());
    }
    public N endConfigMapList() {
      return and();
    }
    
  }
  class ContainerStatusNestedImpl<N> extends ContainerStatusFluentImpl<ValidationSchemaFluentImpl.ContainerStatusNested<N>> implements ValidationSchemaFluentImpl.ContainerStatusNested<N>,Nested<N>{
    ContainerStatusNestedImpl(ContainerStatus item) {
      this.builder = new ContainerStatusBuilder(this, item);
    }
    ContainerStatusNestedImpl() {
      this.builder = new ContainerStatusBuilder(this);
    }
    ContainerStatusBuilder builder;
    public N and() {
      return (N) ValidationSchemaFluentImpl.this.withContainerStatus(builder.build());
    }
    public N endContainerStatus() {
      return and();
    }
    
  }
  class CreateOptionsNestedImpl<N> extends CreateOptionsFluentImpl<ValidationSchemaFluentImpl.CreateOptionsNested<N>> implements ValidationSchemaFluentImpl.CreateOptionsNested<N>,Nested<N>{
    CreateOptionsNestedImpl(CreateOptions item) {
      this.builder = new CreateOptionsBuilder(this, item);
    }
    CreateOptionsNestedImpl() {
      this.builder = new CreateOptionsBuilder(this);
    }
    CreateOptionsBuilder builder;
    public N and() {
      return (N) ValidationSchemaFluentImpl.this.withCreateOptions(builder.build());
    }
    public N endCreateOptions() {
      return and();
    }
    
  }
  class DeleteOptionsNestedImpl<N> extends DeleteOptionsFluentImpl<ValidationSchemaFluentImpl.DeleteOptionsNested<N>> implements ValidationSchemaFluentImpl.DeleteOptionsNested<N>,Nested<N>{
    DeleteOptionsNestedImpl(DeleteOptions item) {
      this.builder = new DeleteOptionsBuilder(this, item);
    }
    DeleteOptionsNestedImpl() {
      this.builder = new DeleteOptionsBuilder(this);
    }
    DeleteOptionsBuilder builder;
    public N and() {
      return (N) ValidationSchemaFluentImpl.this.withDeleteOptions(builder.build());
    }
    public N endDeleteOptions() {
      return and();
    }
    
  }
  class EndpointPortNestedImpl<N> extends EndpointPortFluentImpl<ValidationSchemaFluentImpl.EndpointPortNested<N>> implements ValidationSchemaFluentImpl.EndpointPortNested<N>,Nested<N>{
    EndpointPortNestedImpl(EndpointPort item) {
      this.builder = new EndpointPortBuilder(this, item);
    }
    EndpointPortNestedImpl() {
      this.builder = new EndpointPortBuilder(this);
    }
    EndpointPortBuilder builder;
    public N and() {
      return (N) ValidationSchemaFluentImpl.this.withEndpointPort(builder.build());
    }
    public N endEndpointPort() {
      return and();
    }
    
  }
  class EndpointsNestedImpl<N> extends EndpointsFluentImpl<ValidationSchemaFluentImpl.EndpointsNested<N>> implements ValidationSchemaFluentImpl.EndpointsNested<N>,Nested<N>{
    EndpointsNestedImpl(Endpoints item) {
      this.builder = new EndpointsBuilder(this, item);
    }
    EndpointsNestedImpl() {
      this.builder = new EndpointsBuilder(this);
    }
    EndpointsBuilder builder;
    public N and() {
      return (N) ValidationSchemaFluentImpl.this.withEndpoints(builder.build());
    }
    public N endEndpoints() {
      return and();
    }
    
  }
  class EndpointsListNestedImpl<N> extends EndpointsListFluentImpl<ValidationSchemaFluentImpl.EndpointsListNested<N>> implements ValidationSchemaFluentImpl.EndpointsListNested<N>,Nested<N>{
    EndpointsListNestedImpl(EndpointsList item) {
      this.builder = new EndpointsListBuilder(this, item);
    }
    EndpointsListNestedImpl() {
      this.builder = new EndpointsListBuilder(this);
    }
    EndpointsListBuilder builder;
    public N and() {
      return (N) ValidationSchemaFluentImpl.this.withEndpointsList(builder.build());
    }
    public N endEndpointsList() {
      return and();
    }
    
  }
  class EnvVarNestedImpl<N> extends EnvVarFluentImpl<ValidationSchemaFluentImpl.EnvVarNested<N>> implements ValidationSchemaFluentImpl.EnvVarNested<N>,Nested<N>{
    EnvVarNestedImpl(EnvVar item) {
      this.builder = new EnvVarBuilder(this, item);
    }
    EnvVarNestedImpl() {
      this.builder = new EnvVarBuilder(this);
    }
    EnvVarBuilder builder;
    public N and() {
      return (N) ValidationSchemaFluentImpl.this.withEnvVar(builder.build());
    }
    public N endEnvVar() {
      return and();
    }
    
  }
  class EventNestedImpl<N> extends EventFluentImpl<ValidationSchemaFluentImpl.EventNested<N>> implements ValidationSchemaFluentImpl.EventNested<N>,Nested<N>{
    EventNestedImpl(Event item) {
      this.builder = new EventBuilder(this, item);
    }
    EventNestedImpl() {
      this.builder = new EventBuilder(this);
    }
    EventBuilder builder;
    public N and() {
      return (N) ValidationSchemaFluentImpl.this.withEvent(builder.build());
    }
    public N endEvent() {
      return and();
    }
    
  }
  class EventListNestedImpl<N> extends EventListFluentImpl<ValidationSchemaFluentImpl.EventListNested<N>> implements ValidationSchemaFluentImpl.EventListNested<N>,Nested<N>{
    EventListNestedImpl(EventList item) {
      this.builder = new EventListBuilder(this, item);
    }
    EventListNestedImpl() {
      this.builder = new EventListBuilder(this);
    }
    EventListBuilder builder;
    public N and() {
      return (N) ValidationSchemaFluentImpl.this.withEventList(builder.build());
    }
    public N endEventList() {
      return and();
    }
    
  }
  class EventSeriesNestedImpl<N> extends EventSeriesFluentImpl<ValidationSchemaFluentImpl.EventSeriesNested<N>> implements ValidationSchemaFluentImpl.EventSeriesNested<N>,Nested<N>{
    EventSeriesNestedImpl(EventSeries item) {
      this.builder = new EventSeriesBuilder(this, item);
    }
    EventSeriesNestedImpl() {
      this.builder = new EventSeriesBuilder(this);
    }
    EventSeriesBuilder builder;
    public N and() {
      return (N) ValidationSchemaFluentImpl.this.withEventSeries(builder.build());
    }
    public N endEventSeries() {
      return and();
    }
    
  }
  class EventSourceNestedImpl<N> extends EventSourceFluentImpl<ValidationSchemaFluentImpl.EventSourceNested<N>> implements ValidationSchemaFluentImpl.EventSourceNested<N>,Nested<N>{
    EventSourceNestedImpl(EventSource item) {
      this.builder = new EventSourceBuilder(this, item);
    }
    EventSourceNestedImpl() {
      this.builder = new EventSourceBuilder(this);
    }
    EventSourceBuilder builder;
    public N and() {
      return (N) ValidationSchemaFluentImpl.this.withEventSource(builder.build());
    }
    public N endEventSource() {
      return and();
    }
    
  }
  class GetOptionsNestedImpl<N> extends GetOptionsFluentImpl<ValidationSchemaFluentImpl.GetOptionsNested<N>> implements ValidationSchemaFluentImpl.GetOptionsNested<N>,Nested<N>{
    GetOptionsNestedImpl(GetOptions item) {
      this.builder = new GetOptionsBuilder(this, item);
    }
    GetOptionsNestedImpl() {
      this.builder = new GetOptionsBuilder(this);
    }
    GetOptionsBuilder builder;
    public N and() {
      return (N) ValidationSchemaFluentImpl.this.withGetOptions(builder.build());
    }
    public N endGetOptions() {
      return and();
    }
    
  }
  class GroupKindNestedImpl<N> extends GroupKindFluentImpl<ValidationSchemaFluentImpl.GroupKindNested<N>> implements ValidationSchemaFluentImpl.GroupKindNested<N>,Nested<N>{
    GroupKindNestedImpl(GroupKind item) {
      this.builder = new GroupKindBuilder(this, item);
    }
    GroupKindNestedImpl() {
      this.builder = new GroupKindBuilder(this);
    }
    GroupKindBuilder builder;
    public N and() {
      return (N) ValidationSchemaFluentImpl.this.withGroupKind(builder.build());
    }
    public N endGroupKind() {
      return and();
    }
    
  }
  class GroupVersionKindNestedImpl<N> extends GroupVersionKindFluentImpl<ValidationSchemaFluentImpl.GroupVersionKindNested<N>> implements ValidationSchemaFluentImpl.GroupVersionKindNested<N>,Nested<N>{
    GroupVersionKindNestedImpl(GroupVersionKind item) {
      this.builder = new GroupVersionKindBuilder(this, item);
    }
    GroupVersionKindNestedImpl() {
      this.builder = new GroupVersionKindBuilder(this);
    }
    GroupVersionKindBuilder builder;
    public N and() {
      return (N) ValidationSchemaFluentImpl.this.withGroupVersionKind(builder.build());
    }
    public N endGroupVersionKind() {
      return and();
    }
    
  }
  class GroupVersionResourceNestedImpl<N> extends GroupVersionResourceFluentImpl<ValidationSchemaFluentImpl.GroupVersionResourceNested<N>> implements ValidationSchemaFluentImpl.GroupVersionResourceNested<N>,Nested<N>{
    GroupVersionResourceNestedImpl(GroupVersionResource item) {
      this.builder = new GroupVersionResourceBuilder(this, item);
    }
    GroupVersionResourceNestedImpl() {
      this.builder = new GroupVersionResourceBuilder(this);
    }
    GroupVersionResourceBuilder builder;
    public N and() {
      return (N) ValidationSchemaFluentImpl.this.withGroupVersionResource(builder.build());
    }
    public N endGroupVersionResource() {
      return and();
    }
    
  }
  class InfoNestedImpl<N> extends InfoFluentImpl<ValidationSchemaFluentImpl.InfoNested<N>> implements ValidationSchemaFluentImpl.InfoNested<N>,Nested<N>{
    InfoNestedImpl(Info item) {
      this.builder = new InfoBuilder(this, item);
    }
    InfoNestedImpl() {
      this.builder = new InfoBuilder(this);
    }
    InfoBuilder builder;
    public N and() {
      return (N) ValidationSchemaFluentImpl.this.withInfo(builder.build());
    }
    public N endInfo() {
      return and();
    }
    
  }
  class KubernetesListNestedImpl<N> extends KubernetesListFluentImpl<ValidationSchemaFluentImpl.KubernetesListNested<N>> implements ValidationSchemaFluentImpl.KubernetesListNested<N>,Nested<N>{
    KubernetesListNestedImpl(KubernetesList item) {
      this.builder = new KubernetesListBuilder(this, item);
    }
    KubernetesListNestedImpl() {
      this.builder = new KubernetesListBuilder(this);
    }
    KubernetesListBuilder builder;
    public N and() {
      return (N) ValidationSchemaFluentImpl.this.withKubernetesList(builder.build());
    }
    public N endKubernetesList() {
      return and();
    }
    
  }
  class LimitRangeListNestedImpl<N> extends LimitRangeListFluentImpl<ValidationSchemaFluentImpl.LimitRangeListNested<N>> implements ValidationSchemaFluentImpl.LimitRangeListNested<N>,Nested<N>{
    LimitRangeListNestedImpl(LimitRangeList item) {
      this.builder = new LimitRangeListBuilder(this, item);
    }
    LimitRangeListNestedImpl() {
      this.builder = new LimitRangeListBuilder(this);
    }
    LimitRangeListBuilder builder;
    public N and() {
      return (N) ValidationSchemaFluentImpl.this.withLimitRangeList(builder.build());
    }
    public N endLimitRangeList() {
      return and();
    }
    
  }
  class ListOptionsNestedImpl<N> extends ListOptionsFluentImpl<ValidationSchemaFluentImpl.ListOptionsNested<N>> implements ValidationSchemaFluentImpl.ListOptionsNested<N>,Nested<N>{
    ListOptionsNestedImpl(ListOptions item) {
      this.builder = new ListOptionsBuilder(this, item);
    }
    ListOptionsNestedImpl() {
      this.builder = new ListOptionsBuilder(this);
    }
    ListOptionsBuilder builder;
    public N and() {
      return (N) ValidationSchemaFluentImpl.this.withListOptions(builder.build());
    }
    public N endListOptions() {
      return and();
    }
    
  }
  class MicroTimeNestedImpl<N> extends MicroTimeFluentImpl<ValidationSchemaFluentImpl.MicroTimeNested<N>> implements ValidationSchemaFluentImpl.MicroTimeNested<N>,Nested<N>{
    MicroTimeNestedImpl(MicroTime item) {
      this.builder = new MicroTimeBuilder(this, item);
    }
    MicroTimeNestedImpl() {
      this.builder = new MicroTimeBuilder(this);
    }
    MicroTimeBuilder builder;
    public N and() {
      return (N) ValidationSchemaFluentImpl.this.withMicroTime(builder.build());
    }
    public N endMicroTime() {
      return and();
    }
    
  }
  class NamespaceNestedImpl<N> extends NamespaceFluentImpl<ValidationSchemaFluentImpl.NamespaceNested<N>> implements ValidationSchemaFluentImpl.NamespaceNested<N>,Nested<N>{
    NamespaceNestedImpl(Namespace item) {
      this.builder = new NamespaceBuilder(this, item);
    }
    NamespaceNestedImpl() {
      this.builder = new NamespaceBuilder(this);
    }
    NamespaceBuilder builder;
    public N and() {
      return (N) ValidationSchemaFluentImpl.this.withNamespace(builder.build());
    }
    public N endNamespace() {
      return and();
    }
    
  }
  class NamespaceListNestedImpl<N> extends NamespaceListFluentImpl<ValidationSchemaFluentImpl.NamespaceListNested<N>> implements ValidationSchemaFluentImpl.NamespaceListNested<N>,Nested<N>{
    NamespaceListNestedImpl(NamespaceList item) {
      this.builder = new NamespaceListBuilder(this, item);
    }
    NamespaceListNestedImpl() {
      this.builder = new NamespaceListBuilder(this);
    }
    NamespaceListBuilder builder;
    public N and() {
      return (N) ValidationSchemaFluentImpl.this.withNamespaceList(builder.build());
    }
    public N endNamespaceList() {
      return and();
    }
    
  }
  class NodeNestedImpl<N> extends NodeFluentImpl<ValidationSchemaFluentImpl.NodeNested<N>> implements ValidationSchemaFluentImpl.NodeNested<N>,Nested<N>{
    NodeNestedImpl(Node item) {
      this.builder = new NodeBuilder(this, item);
    }
    NodeNestedImpl() {
      this.builder = new NodeBuilder(this);
    }
    NodeBuilder builder;
    public N and() {
      return (N) ValidationSchemaFluentImpl.this.withNode(builder.build());
    }
    public N endNode() {
      return and();
    }
    
  }
  class NodeListNestedImpl<N> extends NodeListFluentImpl<ValidationSchemaFluentImpl.NodeListNested<N>> implements ValidationSchemaFluentImpl.NodeListNested<N>,Nested<N>{
    NodeListNestedImpl(NodeList item) {
      this.builder = new NodeListBuilder(this, item);
    }
    NodeListNestedImpl() {
      this.builder = new NodeListBuilder(this);
    }
    NodeListBuilder builder;
    public N and() {
      return (N) ValidationSchemaFluentImpl.this.withNodeList(builder.build());
    }
    public N endNodeList() {
      return and();
    }
    
  }
  class ObjectMetaNestedImpl<N> extends ObjectMetaFluentImpl<ValidationSchemaFluentImpl.ObjectMetaNested<N>> implements ValidationSchemaFluentImpl.ObjectMetaNested<N>,Nested<N>{
    ObjectMetaNestedImpl(ObjectMeta item) {
      this.builder = new ObjectMetaBuilder(this, item);
    }
    ObjectMetaNestedImpl() {
      this.builder = new ObjectMetaBuilder(this);
    }
    ObjectMetaBuilder builder;
    public N and() {
      return (N) ValidationSchemaFluentImpl.this.withObjectMeta(builder.build());
    }
    public N endObjectMeta() {
      return and();
    }
    
  }
  class PatchNestedImpl<N> extends PatchFluentImpl<ValidationSchemaFluentImpl.PatchNested<N>> implements ValidationSchemaFluentImpl.PatchNested<N>,Nested<N>{
    PatchNestedImpl(Patch item) {
      this.builder = new PatchBuilder(this, item);
    }
    PatchNestedImpl() {
      this.builder = new PatchBuilder(this);
    }
    PatchBuilder builder;
    public N and() {
      return (N) ValidationSchemaFluentImpl.this.withPatch(builder.build());
    }
    public N endPatch() {
      return and();
    }
    
  }
  class PatchOptionsNestedImpl<N> extends PatchOptionsFluentImpl<ValidationSchemaFluentImpl.PatchOptionsNested<N>> implements ValidationSchemaFluentImpl.PatchOptionsNested<N>,Nested<N>{
    PatchOptionsNestedImpl(PatchOptions item) {
      this.builder = new PatchOptionsBuilder(this, item);
    }
    PatchOptionsNestedImpl() {
      this.builder = new PatchOptionsBuilder(this);
    }
    PatchOptionsBuilder builder;
    public N and() {
      return (N) ValidationSchemaFluentImpl.this.withPatchOptions(builder.build());
    }
    public N endPatchOptions() {
      return and();
    }
    
  }
  class PersistentVolumeNestedImpl<N> extends PersistentVolumeFluentImpl<ValidationSchemaFluentImpl.PersistentVolumeNested<N>> implements ValidationSchemaFluentImpl.PersistentVolumeNested<N>,Nested<N>{
    PersistentVolumeNestedImpl(PersistentVolume item) {
      this.builder = new PersistentVolumeBuilder(this, item);
    }
    PersistentVolumeNestedImpl() {
      this.builder = new PersistentVolumeBuilder(this);
    }
    PersistentVolumeBuilder builder;
    public N and() {
      return (N) ValidationSchemaFluentImpl.this.withPersistentVolume(builder.build());
    }
    public N endPersistentVolume() {
      return and();
    }
    
  }
  class PersistentVolumeClaimNestedImpl<N> extends PersistentVolumeClaimFluentImpl<ValidationSchemaFluentImpl.PersistentVolumeClaimNested<N>> implements ValidationSchemaFluentImpl.PersistentVolumeClaimNested<N>,Nested<N>{
    PersistentVolumeClaimNestedImpl(PersistentVolumeClaim item) {
      this.builder = new PersistentVolumeClaimBuilder(this, item);
    }
    PersistentVolumeClaimNestedImpl() {
      this.builder = new PersistentVolumeClaimBuilder(this);
    }
    PersistentVolumeClaimBuilder builder;
    public N and() {
      return (N) ValidationSchemaFluentImpl.this.withPersistentVolumeClaim(builder.build());
    }
    public N endPersistentVolumeClaim() {
      return and();
    }
    
  }
  class PersistentVolumeClaimListNestedImpl<N> extends PersistentVolumeClaimListFluentImpl<ValidationSchemaFluentImpl.PersistentVolumeClaimListNested<N>> implements ValidationSchemaFluentImpl.PersistentVolumeClaimListNested<N>,Nested<N>{
    PersistentVolumeClaimListNestedImpl(PersistentVolumeClaimList item) {
      this.builder = new PersistentVolumeClaimListBuilder(this, item);
    }
    PersistentVolumeClaimListNestedImpl() {
      this.builder = new PersistentVolumeClaimListBuilder(this);
    }
    PersistentVolumeClaimListBuilder builder;
    public N and() {
      return (N) ValidationSchemaFluentImpl.this.withPersistentVolumeClaimList(builder.build());
    }
    public N endPersistentVolumeClaimList() {
      return and();
    }
    
  }
  class PersistentVolumeListNestedImpl<N> extends PersistentVolumeListFluentImpl<ValidationSchemaFluentImpl.PersistentVolumeListNested<N>> implements ValidationSchemaFluentImpl.PersistentVolumeListNested<N>,Nested<N>{
    PersistentVolumeListNestedImpl(PersistentVolumeList item) {
      this.builder = new PersistentVolumeListBuilder(this, item);
    }
    PersistentVolumeListNestedImpl() {
      this.builder = new PersistentVolumeListBuilder(this);
    }
    PersistentVolumeListBuilder builder;
    public N and() {
      return (N) ValidationSchemaFluentImpl.this.withPersistentVolumeList(builder.build());
    }
    public N endPersistentVolumeList() {
      return and();
    }
    
  }
  class PodExecOptionsNestedImpl<N> extends PodExecOptionsFluentImpl<ValidationSchemaFluentImpl.PodExecOptionsNested<N>> implements ValidationSchemaFluentImpl.PodExecOptionsNested<N>,Nested<N>{
    PodExecOptionsNestedImpl(PodExecOptions item) {
      this.builder = new PodExecOptionsBuilder(this, item);
    }
    PodExecOptionsNestedImpl() {
      this.builder = new PodExecOptionsBuilder(this);
    }
    PodExecOptionsBuilder builder;
    public N and() {
      return (N) ValidationSchemaFluentImpl.this.withPodExecOptions(builder.build());
    }
    public N endPodExecOptions() {
      return and();
    }
    
  }
  class PodListNestedImpl<N> extends PodListFluentImpl<ValidationSchemaFluentImpl.PodListNested<N>> implements ValidationSchemaFluentImpl.PodListNested<N>,Nested<N>{
    PodListNestedImpl(PodList item) {
      this.builder = new PodListBuilder(this, item);
    }
    PodListNestedImpl() {
      this.builder = new PodListBuilder(this);
    }
    PodListBuilder builder;
    public N and() {
      return (N) ValidationSchemaFluentImpl.this.withPodList(builder.build());
    }
    public N endPodList() {
      return and();
    }
    
  }
  class PodTemplateListNestedImpl<N> extends PodTemplateListFluentImpl<ValidationSchemaFluentImpl.PodTemplateListNested<N>> implements ValidationSchemaFluentImpl.PodTemplateListNested<N>,Nested<N>{
    PodTemplateListNestedImpl(PodTemplateList item) {
      this.builder = new PodTemplateListBuilder(this, item);
    }
    PodTemplateListNestedImpl() {
      this.builder = new PodTemplateListBuilder(this);
    }
    PodTemplateListBuilder builder;
    public N and() {
      return (N) ValidationSchemaFluentImpl.this.withPodTemplateList(builder.build());
    }
    public N endPodTemplateList() {
      return and();
    }
    
  }
  class QuantityNestedImpl<N> extends QuantityFluentImpl<ValidationSchemaFluentImpl.QuantityNested<N>> implements ValidationSchemaFluentImpl.QuantityNested<N>,Nested<N>{
    QuantityNestedImpl(Quantity item) {
      this.builder = new QuantityBuilder(this, item);
    }
    QuantityNestedImpl() {
      this.builder = new QuantityBuilder(this);
    }
    QuantityBuilder builder;
    public N and() {
      return (N) ValidationSchemaFluentImpl.this.withQuantity(builder.build());
    }
    public N endQuantity() {
      return and();
    }
    
  }
  class ReplicationControllerListNestedImpl<N> extends ReplicationControllerListFluentImpl<ValidationSchemaFluentImpl.ReplicationControllerListNested<N>> implements ValidationSchemaFluentImpl.ReplicationControllerListNested<N>,Nested<N>{
    ReplicationControllerListNestedImpl(ReplicationControllerList item) {
      this.builder = new ReplicationControllerListBuilder(this, item);
    }
    ReplicationControllerListNestedImpl() {
      this.builder = new ReplicationControllerListBuilder(this);
    }
    ReplicationControllerListBuilder builder;
    public N and() {
      return (N) ValidationSchemaFluentImpl.this.withReplicationControllerList(builder.build());
    }
    public N endReplicationControllerList() {
      return and();
    }
    
  }
  class ResourceQuotaNestedImpl<N> extends ResourceQuotaFluentImpl<ValidationSchemaFluentImpl.ResourceQuotaNested<N>> implements ValidationSchemaFluentImpl.ResourceQuotaNested<N>,Nested<N>{
    ResourceQuotaNestedImpl(ResourceQuota item) {
      this.builder = new ResourceQuotaBuilder(this, item);
    }
    ResourceQuotaNestedImpl() {
      this.builder = new ResourceQuotaBuilder(this);
    }
    ResourceQuotaBuilder builder;
    public N and() {
      return (N) ValidationSchemaFluentImpl.this.withResourceQuota(builder.build());
    }
    public N endResourceQuota() {
      return and();
    }
    
  }
  class ResourceQuotaListNestedImpl<N> extends ResourceQuotaListFluentImpl<ValidationSchemaFluentImpl.ResourceQuotaListNested<N>> implements ValidationSchemaFluentImpl.ResourceQuotaListNested<N>,Nested<N>{
    ResourceQuotaListNestedImpl(ResourceQuotaList item) {
      this.builder = new ResourceQuotaListBuilder(this, item);
    }
    ResourceQuotaListNestedImpl() {
      this.builder = new ResourceQuotaListBuilder(this);
    }
    ResourceQuotaListBuilder builder;
    public N and() {
      return (N) ValidationSchemaFluentImpl.this.withResourceQuotaList(builder.build());
    }
    public N endResourceQuotaList() {
      return and();
    }
    
  }
  class RootPathsNestedImpl<N> extends RootPathsFluentImpl<ValidationSchemaFluentImpl.RootPathsNested<N>> implements ValidationSchemaFluentImpl.RootPathsNested<N>,Nested<N>{
    RootPathsNestedImpl(RootPaths item) {
      this.builder = new RootPathsBuilder(this, item);
    }
    RootPathsNestedImpl() {
      this.builder = new RootPathsBuilder(this);
    }
    RootPathsBuilder builder;
    public N and() {
      return (N) ValidationSchemaFluentImpl.this.withRootPaths(builder.build());
    }
    public N endRootPaths() {
      return and();
    }
    
  }
  class SecretNestedImpl<N> extends SecretFluentImpl<ValidationSchemaFluentImpl.SecretNested<N>> implements ValidationSchemaFluentImpl.SecretNested<N>,Nested<N>{
    SecretNestedImpl(Secret item) {
      this.builder = new SecretBuilder(this, item);
    }
    SecretNestedImpl() {
      this.builder = new SecretBuilder(this);
    }
    SecretBuilder builder;
    public N and() {
      return (N) ValidationSchemaFluentImpl.this.withSecret(builder.build());
    }
    public N endSecret() {
      return and();
    }
    
  }
  class SecretListNestedImpl<N> extends SecretListFluentImpl<ValidationSchemaFluentImpl.SecretListNested<N>> implements ValidationSchemaFluentImpl.SecretListNested<N>,Nested<N>{
    SecretListNestedImpl(SecretList item) {
      this.builder = new SecretListBuilder(this, item);
    }
    SecretListNestedImpl() {
      this.builder = new SecretListBuilder(this);
    }
    SecretListBuilder builder;
    public N and() {
      return (N) ValidationSchemaFluentImpl.this.withSecretList(builder.build());
    }
    public N endSecretList() {
      return and();
    }
    
  }
  class ServiceAccountNestedImpl<N> extends ServiceAccountFluentImpl<ValidationSchemaFluentImpl.ServiceAccountNested<N>> implements ValidationSchemaFluentImpl.ServiceAccountNested<N>,Nested<N>{
    ServiceAccountNestedImpl(ServiceAccount item) {
      this.builder = new ServiceAccountBuilder(this, item);
    }
    ServiceAccountNestedImpl() {
      this.builder = new ServiceAccountBuilder(this);
    }
    ServiceAccountBuilder builder;
    public N and() {
      return (N) ValidationSchemaFluentImpl.this.withServiceAccount(builder.build());
    }
    public N endServiceAccount() {
      return and();
    }
    
  }
  class ServiceAccountListNestedImpl<N> extends ServiceAccountListFluentImpl<ValidationSchemaFluentImpl.ServiceAccountListNested<N>> implements ValidationSchemaFluentImpl.ServiceAccountListNested<N>,Nested<N>{
    ServiceAccountListNestedImpl(ServiceAccountList item) {
      this.builder = new ServiceAccountListBuilder(this, item);
    }
    ServiceAccountListNestedImpl() {
      this.builder = new ServiceAccountListBuilder(this);
    }
    ServiceAccountListBuilder builder;
    public N and() {
      return (N) ValidationSchemaFluentImpl.this.withServiceAccountList(builder.build());
    }
    public N endServiceAccountList() {
      return and();
    }
    
  }
  class ServiceListNestedImpl<N> extends ServiceListFluentImpl<ValidationSchemaFluentImpl.ServiceListNested<N>> implements ValidationSchemaFluentImpl.ServiceListNested<N>,Nested<N>{
    ServiceListNestedImpl(ServiceList item) {
      this.builder = new ServiceListBuilder(this, item);
    }
    ServiceListNestedImpl() {
      this.builder = new ServiceListBuilder(this);
    }
    ServiceListBuilder builder;
    public N and() {
      return (N) ValidationSchemaFluentImpl.this.withServiceList(builder.build());
    }
    public N endServiceList() {
      return and();
    }
    
  }
  class StatusNestedImpl<N> extends StatusFluentImpl<ValidationSchemaFluentImpl.StatusNested<N>> implements ValidationSchemaFluentImpl.StatusNested<N>,Nested<N>{
    StatusNestedImpl(Status item) {
      this.builder = new StatusBuilder(this, item);
    }
    StatusNestedImpl() {
      this.builder = new StatusBuilder(this);
    }
    StatusBuilder builder;
    public N and() {
      return (N) ValidationSchemaFluentImpl.this.withStatus(builder.build());
    }
    public N endStatus() {
      return and();
    }
    
  }
  class TolerationNestedImpl<N> extends TolerationFluentImpl<ValidationSchemaFluentImpl.TolerationNested<N>> implements ValidationSchemaFluentImpl.TolerationNested<N>,Nested<N>{
    TolerationNestedImpl(Toleration item) {
      this.builder = new TolerationBuilder(this, item);
    }
    TolerationNestedImpl() {
      this.builder = new TolerationBuilder(this);
    }
    TolerationBuilder builder;
    public N and() {
      return (N) ValidationSchemaFluentImpl.this.withToleration(builder.build());
    }
    public N endToleration() {
      return and();
    }
    
  }
  class TopologySelectorTermNestedImpl<N> extends TopologySelectorTermFluentImpl<ValidationSchemaFluentImpl.TopologySelectorTermNested<N>> implements ValidationSchemaFluentImpl.TopologySelectorTermNested<N>,Nested<N>{
    TopologySelectorTermNestedImpl(TopologySelectorTerm item) {
      this.builder = new TopologySelectorTermBuilder(this, item);
    }
    TopologySelectorTermNestedImpl() {
      this.builder = new TopologySelectorTermBuilder(this);
    }
    TopologySelectorTermBuilder builder;
    public N and() {
      return (N) ValidationSchemaFluentImpl.this.withTopologySelectorTerm(builder.build());
    }
    public N endTopologySelectorTerm() {
      return and();
    }
    
  }
  class TypeMetaNestedImpl<N> extends TypeMetaFluentImpl<ValidationSchemaFluentImpl.TypeMetaNested<N>> implements ValidationSchemaFluentImpl.TypeMetaNested<N>,Nested<N>{
    TypeMetaNestedImpl(TypeMeta item) {
      this.builder = new TypeMetaBuilder(this, item);
    }
    TypeMetaNestedImpl() {
      this.builder = new TypeMetaBuilder(this);
    }
    TypeMetaBuilder builder;
    public N and() {
      return (N) ValidationSchemaFluentImpl.this.withTypeMeta(builder.build());
    }
    public N endTypeMeta() {
      return and();
    }
    
  }
  class UpdateOptionsNestedImpl<N> extends UpdateOptionsFluentImpl<ValidationSchemaFluentImpl.UpdateOptionsNested<N>> implements ValidationSchemaFluentImpl.UpdateOptionsNested<N>,Nested<N>{
    UpdateOptionsNestedImpl(UpdateOptions item) {
      this.builder = new UpdateOptionsBuilder(this, item);
    }
    UpdateOptionsNestedImpl() {
      this.builder = new UpdateOptionsBuilder(this);
    }
    UpdateOptionsBuilder builder;
    public N and() {
      return (N) ValidationSchemaFluentImpl.this.withUpdateOptions(builder.build());
    }
    public N endUpdateOptions() {
      return and();
    }
    
  }
  class WatchEventNestedImpl<N> extends WatchEventFluentImpl<ValidationSchemaFluentImpl.WatchEventNested<N>> implements ValidationSchemaFluentImpl.WatchEventNested<N>,Nested<N>{
    WatchEventNestedImpl(WatchEvent item) {
      this.builder = new WatchEventBuilder(this, item);
    }
    WatchEventNestedImpl() {
      this.builder = new WatchEventBuilder(this);
    }
    WatchEventBuilder builder;
    public N and() {
      return (N) ValidationSchemaFluentImpl.this.withWatchEvent(builder.build());
    }
    public N endWatchEvent() {
      return and();
    }
    
  }
  
}