package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class StatusDetailsBuilder extends StatusDetailsFluentImpl<StatusDetailsBuilder> implements VisitableBuilder<StatusDetails,StatusDetailsBuilder>{
  public StatusDetailsBuilder() {
    this(false);
  }
  public StatusDetailsBuilder(Boolean validationEnabled) {
    this(new StatusDetails(), validationEnabled);
  }
  public StatusDetailsBuilder(StatusDetailsFluent<?> fluent) {
    this(fluent, false);
  }
  public StatusDetailsBuilder(StatusDetailsFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new StatusDetails(), validationEnabled);
  }
  public StatusDetailsBuilder(StatusDetailsFluent<?> fluent,StatusDetails instance) {
    this(fluent, instance, false);
  }
  public StatusDetailsBuilder(StatusDetailsFluent<?> fluent,StatusDetails instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withCauses(instance.getCauses());
      fluent.withGroup(instance.getGroup());
      fluent.withKind(instance.getKind());
      fluent.withName(instance.getName());
      fluent.withRetryAfterSeconds(instance.getRetryAfterSeconds());
      fluent.withUid(instance.getUid());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public StatusDetailsBuilder(StatusDetails instance) {
    this(instance,false);
  }
  public StatusDetailsBuilder(StatusDetails instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withCauses(instance.getCauses());
      this.withGroup(instance.getGroup());
      this.withKind(instance.getKind());
      this.withName(instance.getName());
      this.withRetryAfterSeconds(instance.getRetryAfterSeconds());
      this.withUid(instance.getUid());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  StatusDetailsFluent<?> fluent;
  Boolean validationEnabled;
  public StatusDetails build() {
    StatusDetails buildable = new StatusDetails(fluent.getCauses(),fluent.getGroup(),fluent.getKind(),fluent.getName(),fluent.getRetryAfterSeconds(),fluent.getUid());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}