package io.fabric8.kubernetes.api.model;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import java.lang.Long;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class SecurityContextFluentImpl<A extends SecurityContextFluent<A>> extends BaseFluent<A> implements SecurityContextFluent<A>{
  public SecurityContextFluentImpl() {
  }
  public SecurityContextFluentImpl(SecurityContext instance) {
    if (instance != null) {
      this.withAllowPrivilegeEscalation(instance.getAllowPrivilegeEscalation());
      this.withCapabilities(instance.getCapabilities());
      this.withPrivileged(instance.getPrivileged());
      this.withProcMount(instance.getProcMount());
      this.withReadOnlyRootFilesystem(instance.getReadOnlyRootFilesystem());
      this.withRunAsGroup(instance.getRunAsGroup());
      this.withRunAsNonRoot(instance.getRunAsNonRoot());
      this.withRunAsUser(instance.getRunAsUser());
      this.withSeLinuxOptions(instance.getSeLinuxOptions());
      this.withSeccompProfile(instance.getSeccompProfile());
      this.withWindowsOptions(instance.getWindowsOptions());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private Boolean allowPrivilegeEscalation;
  private CapabilitiesBuilder capabilities;
  private Boolean privileged;
  private String procMount;
  private Boolean readOnlyRootFilesystem;
  private Long runAsGroup;
  private Boolean runAsNonRoot;
  private Long runAsUser;
  private SELinuxOptionsBuilder seLinuxOptions;
  private SeccompProfileBuilder seccompProfile;
  private WindowsSecurityContextOptionsBuilder windowsOptions;
  private Map<String,Object> additionalProperties;
  public Boolean getAllowPrivilegeEscalation() {
    return this.allowPrivilegeEscalation;
  }
  public A withAllowPrivilegeEscalation(Boolean allowPrivilegeEscalation) {
    this.allowPrivilegeEscalation=allowPrivilegeEscalation; return (A) this;
  }
  public Boolean hasAllowPrivilegeEscalation() {
    return this.allowPrivilegeEscalation != null;
  }
  
  /**
   * This method has been deprecated, please use method buildCapabilities instead.
   * @return The buildable object.
   */
  @Deprecated
  public Capabilities getCapabilities() {
    return this.capabilities!=null ?this.capabilities.build():null;
  }
  public Capabilities buildCapabilities() {
    return this.capabilities!=null ?this.capabilities.build():null;
  }
  public A withCapabilities(Capabilities capabilities) {
    _visitables.get("capabilities").remove(this.capabilities);
    if (capabilities!=null){ this.capabilities= new CapabilitiesBuilder(capabilities); _visitables.get("capabilities").add(this.capabilities);} else { this.capabilities = null; _visitables.get("capabilities").remove(this.capabilities); } return (A) this;
  }
  public Boolean hasCapabilities() {
    return this.capabilities != null;
  }
  public SecurityContextFluentImpl.CapabilitiesNested<A> withNewCapabilities() {
    return new SecurityContextFluentImpl.CapabilitiesNestedImpl();
  }
  public SecurityContextFluentImpl.CapabilitiesNested<A> withNewCapabilitiesLike(Capabilities item) {
    return new SecurityContextFluentImpl.CapabilitiesNestedImpl(item);
  }
  public SecurityContextFluentImpl.CapabilitiesNested<A> editCapabilities() {
    return withNewCapabilitiesLike(getCapabilities());
  }
  public SecurityContextFluentImpl.CapabilitiesNested<A> editOrNewCapabilities() {
    return withNewCapabilitiesLike(getCapabilities() != null ? getCapabilities(): new CapabilitiesBuilder().build());
  }
  public SecurityContextFluentImpl.CapabilitiesNested<A> editOrNewCapabilitiesLike(Capabilities item) {
    return withNewCapabilitiesLike(getCapabilities() != null ? getCapabilities(): item);
  }
  public Boolean getPrivileged() {
    return this.privileged;
  }
  public A withPrivileged(Boolean privileged) {
    this.privileged=privileged; return (A) this;
  }
  public Boolean hasPrivileged() {
    return this.privileged != null;
  }
  public String getProcMount() {
    return this.procMount;
  }
  public A withProcMount(String procMount) {
    this.procMount=procMount; return (A) this;
  }
  public Boolean hasProcMount() {
    return this.procMount != null;
  }
  public Boolean getReadOnlyRootFilesystem() {
    return this.readOnlyRootFilesystem;
  }
  public A withReadOnlyRootFilesystem(Boolean readOnlyRootFilesystem) {
    this.readOnlyRootFilesystem=readOnlyRootFilesystem; return (A) this;
  }
  public Boolean hasReadOnlyRootFilesystem() {
    return this.readOnlyRootFilesystem != null;
  }
  public Long getRunAsGroup() {
    return this.runAsGroup;
  }
  public A withRunAsGroup(Long runAsGroup) {
    this.runAsGroup=runAsGroup; return (A) this;
  }
  public Boolean hasRunAsGroup() {
    return this.runAsGroup != null;
  }
  public Boolean getRunAsNonRoot() {
    return this.runAsNonRoot;
  }
  public A withRunAsNonRoot(Boolean runAsNonRoot) {
    this.runAsNonRoot=runAsNonRoot; return (A) this;
  }
  public Boolean hasRunAsNonRoot() {
    return this.runAsNonRoot != null;
  }
  public Long getRunAsUser() {
    return this.runAsUser;
  }
  public A withRunAsUser(Long runAsUser) {
    this.runAsUser=runAsUser; return (A) this;
  }
  public Boolean hasRunAsUser() {
    return this.runAsUser != null;
  }
  
  /**
   * This method has been deprecated, please use method buildSeLinuxOptions instead.
   * @return The buildable object.
   */
  @Deprecated
  public SELinuxOptions getSeLinuxOptions() {
    return this.seLinuxOptions!=null ?this.seLinuxOptions.build():null;
  }
  public SELinuxOptions buildSeLinuxOptions() {
    return this.seLinuxOptions!=null ?this.seLinuxOptions.build():null;
  }
  public A withSeLinuxOptions(SELinuxOptions seLinuxOptions) {
    _visitables.get("seLinuxOptions").remove(this.seLinuxOptions);
    if (seLinuxOptions!=null){ this.seLinuxOptions= new SELinuxOptionsBuilder(seLinuxOptions); _visitables.get("seLinuxOptions").add(this.seLinuxOptions);} else { this.seLinuxOptions = null; _visitables.get("seLinuxOptions").remove(this.seLinuxOptions); } return (A) this;
  }
  public Boolean hasSeLinuxOptions() {
    return this.seLinuxOptions != null;
  }
  public A withNewSeLinuxOptions(String level,String role,String type,String user) {
    return (A)withSeLinuxOptions(new SELinuxOptions(level, role, type, user));
  }
  public SecurityContextFluentImpl.SeLinuxOptionsNested<A> withNewSeLinuxOptions() {
    return new SecurityContextFluentImpl.SeLinuxOptionsNestedImpl();
  }
  public SecurityContextFluentImpl.SeLinuxOptionsNested<A> withNewSeLinuxOptionsLike(SELinuxOptions item) {
    return new SecurityContextFluentImpl.SeLinuxOptionsNestedImpl(item);
  }
  public SecurityContextFluentImpl.SeLinuxOptionsNested<A> editSeLinuxOptions() {
    return withNewSeLinuxOptionsLike(getSeLinuxOptions());
  }
  public SecurityContextFluentImpl.SeLinuxOptionsNested<A> editOrNewSeLinuxOptions() {
    return withNewSeLinuxOptionsLike(getSeLinuxOptions() != null ? getSeLinuxOptions(): new SELinuxOptionsBuilder().build());
  }
  public SecurityContextFluentImpl.SeLinuxOptionsNested<A> editOrNewSeLinuxOptionsLike(SELinuxOptions item) {
    return withNewSeLinuxOptionsLike(getSeLinuxOptions() != null ? getSeLinuxOptions(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildSeccompProfile instead.
   * @return The buildable object.
   */
  @Deprecated
  public SeccompProfile getSeccompProfile() {
    return this.seccompProfile!=null ?this.seccompProfile.build():null;
  }
  public SeccompProfile buildSeccompProfile() {
    return this.seccompProfile!=null ?this.seccompProfile.build():null;
  }
  public A withSeccompProfile(SeccompProfile seccompProfile) {
    _visitables.get("seccompProfile").remove(this.seccompProfile);
    if (seccompProfile!=null){ this.seccompProfile= new SeccompProfileBuilder(seccompProfile); _visitables.get("seccompProfile").add(this.seccompProfile);} else { this.seccompProfile = null; _visitables.get("seccompProfile").remove(this.seccompProfile); } return (A) this;
  }
  public Boolean hasSeccompProfile() {
    return this.seccompProfile != null;
  }
  public A withNewSeccompProfile(String localhostProfile,String type) {
    return (A)withSeccompProfile(new SeccompProfile(localhostProfile, type));
  }
  public SecurityContextFluentImpl.SeccompProfileNested<A> withNewSeccompProfile() {
    return new SecurityContextFluentImpl.SeccompProfileNestedImpl();
  }
  public SecurityContextFluentImpl.SeccompProfileNested<A> withNewSeccompProfileLike(SeccompProfile item) {
    return new SecurityContextFluentImpl.SeccompProfileNestedImpl(item);
  }
  public SecurityContextFluentImpl.SeccompProfileNested<A> editSeccompProfile() {
    return withNewSeccompProfileLike(getSeccompProfile());
  }
  public SecurityContextFluentImpl.SeccompProfileNested<A> editOrNewSeccompProfile() {
    return withNewSeccompProfileLike(getSeccompProfile() != null ? getSeccompProfile(): new SeccompProfileBuilder().build());
  }
  public SecurityContextFluentImpl.SeccompProfileNested<A> editOrNewSeccompProfileLike(SeccompProfile item) {
    return withNewSeccompProfileLike(getSeccompProfile() != null ? getSeccompProfile(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildWindowsOptions instead.
   * @return The buildable object.
   */
  @Deprecated
  public WindowsSecurityContextOptions getWindowsOptions() {
    return this.windowsOptions!=null ?this.windowsOptions.build():null;
  }
  public WindowsSecurityContextOptions buildWindowsOptions() {
    return this.windowsOptions!=null ?this.windowsOptions.build():null;
  }
  public A withWindowsOptions(WindowsSecurityContextOptions windowsOptions) {
    _visitables.get("windowsOptions").remove(this.windowsOptions);
    if (windowsOptions!=null){ this.windowsOptions= new WindowsSecurityContextOptionsBuilder(windowsOptions); _visitables.get("windowsOptions").add(this.windowsOptions);} else { this.windowsOptions = null; _visitables.get("windowsOptions").remove(this.windowsOptions); } return (A) this;
  }
  public Boolean hasWindowsOptions() {
    return this.windowsOptions != null;
  }
  public A withNewWindowsOptions(String gmsaCredentialSpec,String gmsaCredentialSpecName,Boolean hostProcess,String runAsUserName) {
    return (A)withWindowsOptions(new WindowsSecurityContextOptions(gmsaCredentialSpec, gmsaCredentialSpecName, hostProcess, runAsUserName));
  }
  public SecurityContextFluentImpl.WindowsOptionsNested<A> withNewWindowsOptions() {
    return new SecurityContextFluentImpl.WindowsOptionsNestedImpl();
  }
  public SecurityContextFluentImpl.WindowsOptionsNested<A> withNewWindowsOptionsLike(WindowsSecurityContextOptions item) {
    return new SecurityContextFluentImpl.WindowsOptionsNestedImpl(item);
  }
  public SecurityContextFluentImpl.WindowsOptionsNested<A> editWindowsOptions() {
    return withNewWindowsOptionsLike(getWindowsOptions());
  }
  public SecurityContextFluentImpl.WindowsOptionsNested<A> editOrNewWindowsOptions() {
    return withNewWindowsOptionsLike(getWindowsOptions() != null ? getWindowsOptions(): new WindowsSecurityContextOptionsBuilder().build());
  }
  public SecurityContextFluentImpl.WindowsOptionsNested<A> editOrNewWindowsOptionsLike(WindowsSecurityContextOptions item) {
    return withNewWindowsOptionsLike(getWindowsOptions() != null ? getWindowsOptions(): item);
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    SecurityContextFluentImpl that = (SecurityContextFluentImpl) o;
    if (!java.util.Objects.equals(allowPrivilegeEscalation, that.allowPrivilegeEscalation)) return false;

    if (!java.util.Objects.equals(capabilities, that.capabilities)) return false;

    if (!java.util.Objects.equals(privileged, that.privileged)) return false;

    if (!java.util.Objects.equals(procMount, that.procMount)) return false;

    if (!java.util.Objects.equals(readOnlyRootFilesystem, that.readOnlyRootFilesystem)) return false;

    if (!java.util.Objects.equals(runAsGroup, that.runAsGroup)) return false;

    if (!java.util.Objects.equals(runAsNonRoot, that.runAsNonRoot)) return false;

    if (!java.util.Objects.equals(runAsUser, that.runAsUser)) return false;

    if (!java.util.Objects.equals(seLinuxOptions, that.seLinuxOptions)) return false;

    if (!java.util.Objects.equals(seccompProfile, that.seccompProfile)) return false;

    if (!java.util.Objects.equals(windowsOptions, that.windowsOptions)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(allowPrivilegeEscalation,  capabilities,  privileged,  procMount,  readOnlyRootFilesystem,  runAsGroup,  runAsNonRoot,  runAsUser,  seLinuxOptions,  seccompProfile,  windowsOptions,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (allowPrivilegeEscalation != null) { sb.append("allowPrivilegeEscalation:"); sb.append(allowPrivilegeEscalation + ","); }
    if (capabilities != null) { sb.append("capabilities:"); sb.append(capabilities + ","); }
    if (privileged != null) { sb.append("privileged:"); sb.append(privileged + ","); }
    if (procMount != null) { sb.append("procMount:"); sb.append(procMount + ","); }
    if (readOnlyRootFilesystem != null) { sb.append("readOnlyRootFilesystem:"); sb.append(readOnlyRootFilesystem + ","); }
    if (runAsGroup != null) { sb.append("runAsGroup:"); sb.append(runAsGroup + ","); }
    if (runAsNonRoot != null) { sb.append("runAsNonRoot:"); sb.append(runAsNonRoot + ","); }
    if (runAsUser != null) { sb.append("runAsUser:"); sb.append(runAsUser + ","); }
    if (seLinuxOptions != null) { sb.append("seLinuxOptions:"); sb.append(seLinuxOptions + ","); }
    if (seccompProfile != null) { sb.append("seccompProfile:"); sb.append(seccompProfile + ","); }
    if (windowsOptions != null) { sb.append("windowsOptions:"); sb.append(windowsOptions + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public A withAllowPrivilegeEscalation() {
    return withAllowPrivilegeEscalation(true);
  }
  public A withPrivileged() {
    return withPrivileged(true);
  }
  public A withReadOnlyRootFilesystem() {
    return withReadOnlyRootFilesystem(true);
  }
  public A withRunAsNonRoot() {
    return withRunAsNonRoot(true);
  }
  class CapabilitiesNestedImpl<N> extends CapabilitiesFluentImpl<SecurityContextFluentImpl.CapabilitiesNested<N>> implements SecurityContextFluentImpl.CapabilitiesNested<N>,Nested<N>{
    CapabilitiesNestedImpl(Capabilities item) {
      this.builder = new CapabilitiesBuilder(this, item);
    }
    CapabilitiesNestedImpl() {
      this.builder = new CapabilitiesBuilder(this);
    }
    CapabilitiesBuilder builder;
    public N and() {
      return (N) SecurityContextFluentImpl.this.withCapabilities(builder.build());
    }
    public N endCapabilities() {
      return and();
    }
    
  }
  class SeLinuxOptionsNestedImpl<N> extends SELinuxOptionsFluentImpl<SecurityContextFluentImpl.SeLinuxOptionsNested<N>> implements SecurityContextFluentImpl.SeLinuxOptionsNested<N>,Nested<N>{
    SeLinuxOptionsNestedImpl(SELinuxOptions item) {
      this.builder = new SELinuxOptionsBuilder(this, item);
    }
    SeLinuxOptionsNestedImpl() {
      this.builder = new SELinuxOptionsBuilder(this);
    }
    SELinuxOptionsBuilder builder;
    public N and() {
      return (N) SecurityContextFluentImpl.this.withSeLinuxOptions(builder.build());
    }
    public N endSeLinuxOptions() {
      return and();
    }
    
  }
  class SeccompProfileNestedImpl<N> extends SeccompProfileFluentImpl<SecurityContextFluentImpl.SeccompProfileNested<N>> implements SecurityContextFluentImpl.SeccompProfileNested<N>,Nested<N>{
    SeccompProfileNestedImpl(SeccompProfile item) {
      this.builder = new SeccompProfileBuilder(this, item);
    }
    SeccompProfileNestedImpl() {
      this.builder = new SeccompProfileBuilder(this);
    }
    SeccompProfileBuilder builder;
    public N and() {
      return (N) SecurityContextFluentImpl.this.withSeccompProfile(builder.build());
    }
    public N endSeccompProfile() {
      return and();
    }
    
  }
  class WindowsOptionsNestedImpl<N> extends WindowsSecurityContextOptionsFluentImpl<SecurityContextFluentImpl.WindowsOptionsNested<N>> implements SecurityContextFluentImpl.WindowsOptionsNested<N>,Nested<N>{
    WindowsOptionsNestedImpl(WindowsSecurityContextOptions item) {
      this.builder = new WindowsSecurityContextOptionsBuilder(this, item);
    }
    WindowsOptionsNestedImpl() {
      this.builder = new WindowsSecurityContextOptionsBuilder(this);
    }
    WindowsSecurityContextOptionsBuilder builder;
    public N and() {
      return (N) SecurityContextFluentImpl.this.withWindowsOptions(builder.build());
    }
    public N endWindowsOptions() {
      return and();
    }
    
  }
  
}