package io.fabric8.kubernetes.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.Deprecated;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
public interface ScaleIOVolumeSourceFluent<A extends ScaleIOVolumeSourceFluent<A>> extends Fluent<A>{
  public String getFsType();
  public A withFsType(String fsType);
  public Boolean hasFsType();
  public String getGateway();
  public A withGateway(String gateway);
  public Boolean hasGateway();
  public String getProtectionDomain();
  public A withProtectionDomain(String protectionDomain);
  public Boolean hasProtectionDomain();
  public Boolean getReadOnly();
  public A withReadOnly(Boolean readOnly);
  public Boolean hasReadOnly();
  
  /**
   * This method has been deprecated, please use method buildSecretRef instead.
   * @return The buildable object.
   */
  @Deprecated
  public LocalObjectReference getSecretRef();
  public LocalObjectReference buildSecretRef();
  public A withSecretRef(LocalObjectReference secretRef);
  public Boolean hasSecretRef();
  public A withNewSecretRef(String name);
  public ScaleIOVolumeSourceFluent.SecretRefNested<A> withNewSecretRef();
  public ScaleIOVolumeSourceFluent.SecretRefNested<A> withNewSecretRefLike(LocalObjectReference item);
  public ScaleIOVolumeSourceFluent.SecretRefNested<A> editSecretRef();
  public ScaleIOVolumeSourceFluent.SecretRefNested<A> editOrNewSecretRef();
  public ScaleIOVolumeSourceFluent.SecretRefNested<A> editOrNewSecretRefLike(LocalObjectReference item);
  public Boolean getSslEnabled();
  public A withSslEnabled(Boolean sslEnabled);
  public Boolean hasSslEnabled();
  public String getStorageMode();
  public A withStorageMode(String storageMode);
  public Boolean hasStorageMode();
  public String getStoragePool();
  public A withStoragePool(String storagePool);
  public Boolean hasStoragePool();
  public String getSystem();
  public A withSystem(String system);
  public Boolean hasSystem();
  public String getVolumeName();
  public A withVolumeName(String volumeName);
  public Boolean hasVolumeName();
  public A addToAdditionalProperties(String key,Object value);
  public A addToAdditionalProperties(Map<String,Object> map);
  public A removeFromAdditionalProperties(String key);
  public A removeFromAdditionalProperties(Map<String,Object> map);
  public Map<String,Object> getAdditionalProperties();
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties);
  public Boolean hasAdditionalProperties();
  public A withReadOnly();
  public A withSslEnabled();
  public interface SecretRefNested<N> extends Nested<N>,LocalObjectReferenceFluent<ScaleIOVolumeSourceFluent.SecretRefNested<N>>{
    public N and();
    public N endSecretRef();
    
  }
  
}