package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ResourceFieldSelectorBuilder extends ResourceFieldSelectorFluentImpl<ResourceFieldSelectorBuilder> implements VisitableBuilder<ResourceFieldSelector,ResourceFieldSelectorBuilder>{
  public ResourceFieldSelectorBuilder() {
    this(false);
  }
  public ResourceFieldSelectorBuilder(Boolean validationEnabled) {
    this(new ResourceFieldSelector(), validationEnabled);
  }
  public ResourceFieldSelectorBuilder(ResourceFieldSelectorFluent<?> fluent) {
    this(fluent, false);
  }
  public ResourceFieldSelectorBuilder(ResourceFieldSelectorFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ResourceFieldSelector(), validationEnabled);
  }
  public ResourceFieldSelectorBuilder(ResourceFieldSelectorFluent<?> fluent,ResourceFieldSelector instance) {
    this(fluent, instance, false);
  }
  public ResourceFieldSelectorBuilder(ResourceFieldSelectorFluent<?> fluent,ResourceFieldSelector instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withContainerName(instance.getContainerName());
      fluent.withDivisor(instance.getDivisor());
      fluent.withResource(instance.getResource());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ResourceFieldSelectorBuilder(ResourceFieldSelector instance) {
    this(instance,false);
  }
  public ResourceFieldSelectorBuilder(ResourceFieldSelector instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withContainerName(instance.getContainerName());
      this.withDivisor(instance.getDivisor());
      this.withResource(instance.getResource());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ResourceFieldSelectorFluent<?> fluent;
  Boolean validationEnabled;
  public ResourceFieldSelector build() {
    ResourceFieldSelector buildable = new ResourceFieldSelector(fluent.getContainerName(),fluent.getDivisor(),fluent.getResource());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}