package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class QuantityBuilder extends QuantityFluentImpl<QuantityBuilder> implements VisitableBuilder<Quantity,QuantityBuilder>{
  public QuantityBuilder() {
    this(false);
  }
  public QuantityBuilder(Boolean validationEnabled) {
    this(new Quantity(), validationEnabled);
  }
  public QuantityBuilder(QuantityFluent<?> fluent) {
    this(fluent, false);
  }
  public QuantityBuilder(QuantityFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Quantity(), validationEnabled);
  }
  public QuantityBuilder(QuantityFluent<?> fluent,Quantity instance) {
    this(fluent, instance, false);
  }
  public QuantityBuilder(QuantityFluent<?> fluent,Quantity instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withAmount(instance.getAmount());
      fluent.withFormat(instance.getFormat());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public QuantityBuilder(Quantity instance) {
    this(instance,false);
  }
  public QuantityBuilder(Quantity instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withAmount(instance.getAmount());
      this.withFormat(instance.getFormat());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  QuantityFluent<?> fluent;
  Boolean validationEnabled;
  public Quantity build() {
    Quantity buildable = new Quantity(fluent.getAmount());
    buildable.setFormat(fluent.getFormat());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}