package io.fabric8.kubernetes.api.model;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ProbeFluentImpl<A extends ProbeFluent<A>> extends BaseFluent<A> implements ProbeFluent<A>{
  public ProbeFluentImpl() {
  }
  public ProbeFluentImpl(Probe instance) {
    if (instance != null) {
      this.withExec(instance.getExec());
      this.withFailureThreshold(instance.getFailureThreshold());
      this.withGrpc(instance.getGrpc());
      this.withHttpGet(instance.getHttpGet());
      this.withInitialDelaySeconds(instance.getInitialDelaySeconds());
      this.withPeriodSeconds(instance.getPeriodSeconds());
      this.withSuccessThreshold(instance.getSuccessThreshold());
      this.withTcpSocket(instance.getTcpSocket());
      this.withTerminationGracePeriodSeconds(instance.getTerminationGracePeriodSeconds());
      this.withTimeoutSeconds(instance.getTimeoutSeconds());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private ExecActionBuilder exec;
  private Integer failureThreshold;
  private GRPCActionBuilder grpc;
  private HTTPGetActionBuilder httpGet;
  private Integer initialDelaySeconds;
  private Integer periodSeconds;
  private Integer successThreshold;
  private TCPSocketActionBuilder tcpSocket;
  private Long terminationGracePeriodSeconds;
  private Integer timeoutSeconds;
  private Map<String,Object> additionalProperties;
  
  /**
   * This method has been deprecated, please use method buildExec instead.
   * @return The buildable object.
   */
  @Deprecated
  public ExecAction getExec() {
    return this.exec!=null ?this.exec.build():null;
  }
  public ExecAction buildExec() {
    return this.exec!=null ?this.exec.build():null;
  }
  public A withExec(ExecAction exec) {
    _visitables.get("exec").remove(this.exec);
    if (exec!=null){ this.exec= new ExecActionBuilder(exec); _visitables.get("exec").add(this.exec);} else { this.exec = null; _visitables.get("exec").remove(this.exec); } return (A) this;
  }
  public Boolean hasExec() {
    return this.exec != null;
  }
  public ProbeFluentImpl.ExecNested<A> withNewExec() {
    return new ProbeFluentImpl.ExecNestedImpl();
  }
  public ProbeFluentImpl.ExecNested<A> withNewExecLike(ExecAction item) {
    return new ProbeFluentImpl.ExecNestedImpl(item);
  }
  public ProbeFluentImpl.ExecNested<A> editExec() {
    return withNewExecLike(getExec());
  }
  public ProbeFluentImpl.ExecNested<A> editOrNewExec() {
    return withNewExecLike(getExec() != null ? getExec(): new ExecActionBuilder().build());
  }
  public ProbeFluentImpl.ExecNested<A> editOrNewExecLike(ExecAction item) {
    return withNewExecLike(getExec() != null ? getExec(): item);
  }
  public Integer getFailureThreshold() {
    return this.failureThreshold;
  }
  public A withFailureThreshold(Integer failureThreshold) {
    this.failureThreshold=failureThreshold; return (A) this;
  }
  public Boolean hasFailureThreshold() {
    return this.failureThreshold != null;
  }
  
  /**
   * This method has been deprecated, please use method buildGrpc instead.
   * @return The buildable object.
   */
  @Deprecated
  public GRPCAction getGrpc() {
    return this.grpc!=null ?this.grpc.build():null;
  }
  public GRPCAction buildGrpc() {
    return this.grpc!=null ?this.grpc.build():null;
  }
  public A withGrpc(GRPCAction grpc) {
    _visitables.get("grpc").remove(this.grpc);
    if (grpc!=null){ this.grpc= new GRPCActionBuilder(grpc); _visitables.get("grpc").add(this.grpc);} else { this.grpc = null; _visitables.get("grpc").remove(this.grpc); } return (A) this;
  }
  public Boolean hasGrpc() {
    return this.grpc != null;
  }
  public A withNewGrpc(Integer port,String service) {
    return (A)withGrpc(new GRPCAction(port, service));
  }
  public ProbeFluentImpl.GrpcNested<A> withNewGrpc() {
    return new ProbeFluentImpl.GrpcNestedImpl();
  }
  public ProbeFluentImpl.GrpcNested<A> withNewGrpcLike(GRPCAction item) {
    return new ProbeFluentImpl.GrpcNestedImpl(item);
  }
  public ProbeFluentImpl.GrpcNested<A> editGrpc() {
    return withNewGrpcLike(getGrpc());
  }
  public ProbeFluentImpl.GrpcNested<A> editOrNewGrpc() {
    return withNewGrpcLike(getGrpc() != null ? getGrpc(): new GRPCActionBuilder().build());
  }
  public ProbeFluentImpl.GrpcNested<A> editOrNewGrpcLike(GRPCAction item) {
    return withNewGrpcLike(getGrpc() != null ? getGrpc(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildHttpGet instead.
   * @return The buildable object.
   */
  @Deprecated
  public HTTPGetAction getHttpGet() {
    return this.httpGet!=null ?this.httpGet.build():null;
  }
  public HTTPGetAction buildHttpGet() {
    return this.httpGet!=null ?this.httpGet.build():null;
  }
  public A withHttpGet(HTTPGetAction httpGet) {
    _visitables.get("httpGet").remove(this.httpGet);
    if (httpGet!=null){ this.httpGet= new HTTPGetActionBuilder(httpGet); _visitables.get("httpGet").add(this.httpGet);} else { this.httpGet = null; _visitables.get("httpGet").remove(this.httpGet); } return (A) this;
  }
  public Boolean hasHttpGet() {
    return this.httpGet != null;
  }
  public ProbeFluentImpl.HttpGetNested<A> withNewHttpGet() {
    return new ProbeFluentImpl.HttpGetNestedImpl();
  }
  public ProbeFluentImpl.HttpGetNested<A> withNewHttpGetLike(HTTPGetAction item) {
    return new ProbeFluentImpl.HttpGetNestedImpl(item);
  }
  public ProbeFluentImpl.HttpGetNested<A> editHttpGet() {
    return withNewHttpGetLike(getHttpGet());
  }
  public ProbeFluentImpl.HttpGetNested<A> editOrNewHttpGet() {
    return withNewHttpGetLike(getHttpGet() != null ? getHttpGet(): new HTTPGetActionBuilder().build());
  }
  public ProbeFluentImpl.HttpGetNested<A> editOrNewHttpGetLike(HTTPGetAction item) {
    return withNewHttpGetLike(getHttpGet() != null ? getHttpGet(): item);
  }
  public Integer getInitialDelaySeconds() {
    return this.initialDelaySeconds;
  }
  public A withInitialDelaySeconds(Integer initialDelaySeconds) {
    this.initialDelaySeconds=initialDelaySeconds; return (A) this;
  }
  public Boolean hasInitialDelaySeconds() {
    return this.initialDelaySeconds != null;
  }
  public Integer getPeriodSeconds() {
    return this.periodSeconds;
  }
  public A withPeriodSeconds(Integer periodSeconds) {
    this.periodSeconds=periodSeconds; return (A) this;
  }
  public Boolean hasPeriodSeconds() {
    return this.periodSeconds != null;
  }
  public Integer getSuccessThreshold() {
    return this.successThreshold;
  }
  public A withSuccessThreshold(Integer successThreshold) {
    this.successThreshold=successThreshold; return (A) this;
  }
  public Boolean hasSuccessThreshold() {
    return this.successThreshold != null;
  }
  
  /**
   * This method has been deprecated, please use method buildTcpSocket instead.
   * @return The buildable object.
   */
  @Deprecated
  public TCPSocketAction getTcpSocket() {
    return this.tcpSocket!=null ?this.tcpSocket.build():null;
  }
  public TCPSocketAction buildTcpSocket() {
    return this.tcpSocket!=null ?this.tcpSocket.build():null;
  }
  public A withTcpSocket(TCPSocketAction tcpSocket) {
    _visitables.get("tcpSocket").remove(this.tcpSocket);
    if (tcpSocket!=null){ this.tcpSocket= new TCPSocketActionBuilder(tcpSocket); _visitables.get("tcpSocket").add(this.tcpSocket);} else { this.tcpSocket = null; _visitables.get("tcpSocket").remove(this.tcpSocket); } return (A) this;
  }
  public Boolean hasTcpSocket() {
    return this.tcpSocket != null;
  }
  public ProbeFluentImpl.TcpSocketNested<A> withNewTcpSocket() {
    return new ProbeFluentImpl.TcpSocketNestedImpl();
  }
  public ProbeFluentImpl.TcpSocketNested<A> withNewTcpSocketLike(TCPSocketAction item) {
    return new ProbeFluentImpl.TcpSocketNestedImpl(item);
  }
  public ProbeFluentImpl.TcpSocketNested<A> editTcpSocket() {
    return withNewTcpSocketLike(getTcpSocket());
  }
  public ProbeFluentImpl.TcpSocketNested<A> editOrNewTcpSocket() {
    return withNewTcpSocketLike(getTcpSocket() != null ? getTcpSocket(): new TCPSocketActionBuilder().build());
  }
  public ProbeFluentImpl.TcpSocketNested<A> editOrNewTcpSocketLike(TCPSocketAction item) {
    return withNewTcpSocketLike(getTcpSocket() != null ? getTcpSocket(): item);
  }
  public Long getTerminationGracePeriodSeconds() {
    return this.terminationGracePeriodSeconds;
  }
  public A withTerminationGracePeriodSeconds(Long terminationGracePeriodSeconds) {
    this.terminationGracePeriodSeconds=terminationGracePeriodSeconds; return (A) this;
  }
  public Boolean hasTerminationGracePeriodSeconds() {
    return this.terminationGracePeriodSeconds != null;
  }
  public Integer getTimeoutSeconds() {
    return this.timeoutSeconds;
  }
  public A withTimeoutSeconds(Integer timeoutSeconds) {
    this.timeoutSeconds=timeoutSeconds; return (A) this;
  }
  public Boolean hasTimeoutSeconds() {
    return this.timeoutSeconds != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ProbeFluentImpl that = (ProbeFluentImpl) o;
    if (!java.util.Objects.equals(exec, that.exec)) return false;

    if (!java.util.Objects.equals(failureThreshold, that.failureThreshold)) return false;

    if (!java.util.Objects.equals(grpc, that.grpc)) return false;

    if (!java.util.Objects.equals(httpGet, that.httpGet)) return false;

    if (!java.util.Objects.equals(initialDelaySeconds, that.initialDelaySeconds)) return false;

    if (!java.util.Objects.equals(periodSeconds, that.periodSeconds)) return false;

    if (!java.util.Objects.equals(successThreshold, that.successThreshold)) return false;

    if (!java.util.Objects.equals(tcpSocket, that.tcpSocket)) return false;

    if (!java.util.Objects.equals(terminationGracePeriodSeconds, that.terminationGracePeriodSeconds)) return false;

    if (!java.util.Objects.equals(timeoutSeconds, that.timeoutSeconds)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(exec,  failureThreshold,  grpc,  httpGet,  initialDelaySeconds,  periodSeconds,  successThreshold,  tcpSocket,  terminationGracePeriodSeconds,  timeoutSeconds,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (exec != null) { sb.append("exec:"); sb.append(exec + ","); }
    if (failureThreshold != null) { sb.append("failureThreshold:"); sb.append(failureThreshold + ","); }
    if (grpc != null) { sb.append("grpc:"); sb.append(grpc + ","); }
    if (httpGet != null) { sb.append("httpGet:"); sb.append(httpGet + ","); }
    if (initialDelaySeconds != null) { sb.append("initialDelaySeconds:"); sb.append(initialDelaySeconds + ","); }
    if (periodSeconds != null) { sb.append("periodSeconds:"); sb.append(periodSeconds + ","); }
    if (successThreshold != null) { sb.append("successThreshold:"); sb.append(successThreshold + ","); }
    if (tcpSocket != null) { sb.append("tcpSocket:"); sb.append(tcpSocket + ","); }
    if (terminationGracePeriodSeconds != null) { sb.append("terminationGracePeriodSeconds:"); sb.append(terminationGracePeriodSeconds + ","); }
    if (timeoutSeconds != null) { sb.append("timeoutSeconds:"); sb.append(timeoutSeconds + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class ExecNestedImpl<N> extends ExecActionFluentImpl<ProbeFluentImpl.ExecNested<N>> implements ProbeFluentImpl.ExecNested<N>,Nested<N>{
    ExecNestedImpl(ExecAction item) {
      this.builder = new ExecActionBuilder(this, item);
    }
    ExecNestedImpl() {
      this.builder = new ExecActionBuilder(this);
    }
    ExecActionBuilder builder;
    public N and() {
      return (N) ProbeFluentImpl.this.withExec(builder.build());
    }
    public N endExec() {
      return and();
    }
    
  }
  class GrpcNestedImpl<N> extends GRPCActionFluentImpl<ProbeFluentImpl.GrpcNested<N>> implements ProbeFluentImpl.GrpcNested<N>,Nested<N>{
    GrpcNestedImpl(GRPCAction item) {
      this.builder = new GRPCActionBuilder(this, item);
    }
    GrpcNestedImpl() {
      this.builder = new GRPCActionBuilder(this);
    }
    GRPCActionBuilder builder;
    public N and() {
      return (N) ProbeFluentImpl.this.withGrpc(builder.build());
    }
    public N endGrpc() {
      return and();
    }
    
  }
  class HttpGetNestedImpl<N> extends HTTPGetActionFluentImpl<ProbeFluentImpl.HttpGetNested<N>> implements ProbeFluentImpl.HttpGetNested<N>,Nested<N>{
    HttpGetNestedImpl(HTTPGetAction item) {
      this.builder = new HTTPGetActionBuilder(this, item);
    }
    HttpGetNestedImpl() {
      this.builder = new HTTPGetActionBuilder(this);
    }
    HTTPGetActionBuilder builder;
    public N and() {
      return (N) ProbeFluentImpl.this.withHttpGet(builder.build());
    }
    public N endHttpGet() {
      return and();
    }
    
  }
  class TcpSocketNestedImpl<N> extends TCPSocketActionFluentImpl<ProbeFluentImpl.TcpSocketNested<N>> implements ProbeFluentImpl.TcpSocketNested<N>,Nested<N>{
    TcpSocketNestedImpl(TCPSocketAction item) {
      this.builder = new TCPSocketActionBuilder(this, item);
    }
    TcpSocketNestedImpl() {
      this.builder = new TCPSocketActionBuilder(this);
    }
    TCPSocketActionBuilder builder;
    public N and() {
      return (N) ProbeFluentImpl.this.withTcpSocket(builder.build());
    }
    public N endTcpSocket() {
      return and();
    }
    
  }
  
}