package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PreferencesBuilder extends PreferencesFluentImpl<PreferencesBuilder> implements VisitableBuilder<Preferences,PreferencesBuilder>{
  public PreferencesBuilder() {
    this(false);
  }
  public PreferencesBuilder(Boolean validationEnabled) {
    this(new Preferences(), validationEnabled);
  }
  public PreferencesBuilder(PreferencesFluent<?> fluent) {
    this(fluent, false);
  }
  public PreferencesBuilder(PreferencesFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Preferences(), validationEnabled);
  }
  public PreferencesBuilder(PreferencesFluent<?> fluent,Preferences instance) {
    this(fluent, instance, false);
  }
  public PreferencesBuilder(PreferencesFluent<?> fluent,Preferences instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withColors(instance.getColors());
      fluent.withExtensions(instance.getExtensions());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public PreferencesBuilder(Preferences instance) {
    this(instance,false);
  }
  public PreferencesBuilder(Preferences instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withColors(instance.getColors());
      this.withExtensions(instance.getExtensions());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  PreferencesFluent<?> fluent;
  Boolean validationEnabled;
  public Preferences build() {
    Preferences buildable = new Preferences(fluent.getColors(),fluent.getExtensions());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}