package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PodExecOptionsBuilder extends PodExecOptionsFluentImpl<PodExecOptionsBuilder> implements VisitableBuilder<PodExecOptions,PodExecOptionsBuilder>{
  public PodExecOptionsBuilder() {
    this(false);
  }
  public PodExecOptionsBuilder(Boolean validationEnabled) {
    this(new PodExecOptions(), validationEnabled);
  }
  public PodExecOptionsBuilder(PodExecOptionsFluent<?> fluent) {
    this(fluent, false);
  }
  public PodExecOptionsBuilder(PodExecOptionsFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new PodExecOptions(), validationEnabled);
  }
  public PodExecOptionsBuilder(PodExecOptionsFluent<?> fluent,PodExecOptions instance) {
    this(fluent, instance, false);
  }
  public PodExecOptionsBuilder(PodExecOptionsFluent<?> fluent,PodExecOptions instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withCommand(instance.getCommand());
      fluent.withContainer(instance.getContainer());
      fluent.withKind(instance.getKind());
      fluent.withStderr(instance.getStderr());
      fluent.withStdin(instance.getStdin());
      fluent.withStdout(instance.getStdout());
      fluent.withTty(instance.getTty());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public PodExecOptionsBuilder(PodExecOptions instance) {
    this(instance,false);
  }
  public PodExecOptionsBuilder(PodExecOptions instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withCommand(instance.getCommand());
      this.withContainer(instance.getContainer());
      this.withKind(instance.getKind());
      this.withStderr(instance.getStderr());
      this.withStdin(instance.getStdin());
      this.withStdout(instance.getStdout());
      this.withTty(instance.getTty());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  PodExecOptionsFluent<?> fluent;
  Boolean validationEnabled;
  public PodExecOptions build() {
    PodExecOptions buildable = new PodExecOptions(fluent.getApiVersion(),fluent.getCommand(),fluent.getContainer(),fluent.getKind(),fluent.getStderr(),fluent.getStdin(),fluent.getStdout(),fluent.getTty());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}