package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PersistentVolumeClaimTemplateBuilder extends PersistentVolumeClaimTemplateFluentImpl<PersistentVolumeClaimTemplateBuilder> implements VisitableBuilder<PersistentVolumeClaimTemplate,PersistentVolumeClaimTemplateBuilder>{
  public PersistentVolumeClaimTemplateBuilder() {
    this(false);
  }
  public PersistentVolumeClaimTemplateBuilder(Boolean validationEnabled) {
    this(new PersistentVolumeClaimTemplate(), validationEnabled);
  }
  public PersistentVolumeClaimTemplateBuilder(PersistentVolumeClaimTemplateFluent<?> fluent) {
    this(fluent, false);
  }
  public PersistentVolumeClaimTemplateBuilder(PersistentVolumeClaimTemplateFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new PersistentVolumeClaimTemplate(), validationEnabled);
  }
  public PersistentVolumeClaimTemplateBuilder(PersistentVolumeClaimTemplateFluent<?> fluent,PersistentVolumeClaimTemplate instance) {
    this(fluent, instance, false);
  }
  public PersistentVolumeClaimTemplateBuilder(PersistentVolumeClaimTemplateFluent<?> fluent,PersistentVolumeClaimTemplate instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public PersistentVolumeClaimTemplateBuilder(PersistentVolumeClaimTemplate instance) {
    this(instance,false);
  }
  public PersistentVolumeClaimTemplateBuilder(PersistentVolumeClaimTemplate instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  PersistentVolumeClaimTemplateFluent<?> fluent;
  Boolean validationEnabled;
  public PersistentVolumeClaimTemplate build() {
    PersistentVolumeClaimTemplate buildable = new PersistentVolumeClaimTemplate(fluent.getMetadata(),fluent.getSpec());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}