package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class NodeSpecBuilder extends NodeSpecFluentImpl<NodeSpecBuilder> implements VisitableBuilder<NodeSpec,NodeSpecBuilder>{
  public NodeSpecBuilder() {
    this(false);
  }
  public NodeSpecBuilder(Boolean validationEnabled) {
    this(new NodeSpec(), validationEnabled);
  }
  public NodeSpecBuilder(NodeSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public NodeSpecBuilder(NodeSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new NodeSpec(), validationEnabled);
  }
  public NodeSpecBuilder(NodeSpecFluent<?> fluent,NodeSpec instance) {
    this(fluent, instance, false);
  }
  public NodeSpecBuilder(NodeSpecFluent<?> fluent,NodeSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withConfigSource(instance.getConfigSource());
      fluent.withExternalID(instance.getExternalID());
      fluent.withPodCIDR(instance.getPodCIDR());
      fluent.withPodCIDRs(instance.getPodCIDRs());
      fluent.withProviderID(instance.getProviderID());
      fluent.withTaints(instance.getTaints());
      fluent.withUnschedulable(instance.getUnschedulable());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public NodeSpecBuilder(NodeSpec instance) {
    this(instance,false);
  }
  public NodeSpecBuilder(NodeSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withConfigSource(instance.getConfigSource());
      this.withExternalID(instance.getExternalID());
      this.withPodCIDR(instance.getPodCIDR());
      this.withPodCIDRs(instance.getPodCIDRs());
      this.withProviderID(instance.getProviderID());
      this.withTaints(instance.getTaints());
      this.withUnschedulable(instance.getUnschedulable());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  NodeSpecFluent<?> fluent;
  Boolean validationEnabled;
  public NodeSpec build() {
    NodeSpec buildable = new NodeSpec(fluent.getConfigSource(),fluent.getExternalID(),fluent.getPodCIDR(),fluent.getPodCIDRs(),fluent.getProviderID(),fluent.getTaints(),fluent.getUnschedulable());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}