package io.fabric8.kubernetes.api.model;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class NodeConfigStatusFluentImpl<A extends NodeConfigStatusFluent<A>> extends BaseFluent<A> implements NodeConfigStatusFluent<A>{
  public NodeConfigStatusFluentImpl() {
  }
  public NodeConfigStatusFluentImpl(NodeConfigStatus instance) {
    if (instance != null) {
      this.withActive(instance.getActive());
      this.withAssigned(instance.getAssigned());
      this.withError(instance.getError());
      this.withLastKnownGood(instance.getLastKnownGood());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private NodeConfigSourceBuilder active;
  private NodeConfigSourceBuilder assigned;
  private String error;
  private NodeConfigSourceBuilder lastKnownGood;
  private Map<String,Object> additionalProperties;
  
  /**
   * This method has been deprecated, please use method buildActive instead.
   * @return The buildable object.
   */
  @Deprecated
  public NodeConfigSource getActive() {
    return this.active!=null ?this.active.build():null;
  }
  public NodeConfigSource buildActive() {
    return this.active!=null ?this.active.build():null;
  }
  public A withActive(NodeConfigSource active) {
    _visitables.get("active").remove(this.active);
    if (active!=null){ this.active= new NodeConfigSourceBuilder(active); _visitables.get("active").add(this.active);} else { this.active = null; _visitables.get("active").remove(this.active); } return (A) this;
  }
  public Boolean hasActive() {
    return this.active != null;
  }
  public NodeConfigStatusFluentImpl.ActiveNested<A> withNewActive() {
    return new NodeConfigStatusFluentImpl.ActiveNestedImpl();
  }
  public NodeConfigStatusFluentImpl.ActiveNested<A> withNewActiveLike(NodeConfigSource item) {
    return new NodeConfigStatusFluentImpl.ActiveNestedImpl(item);
  }
  public NodeConfigStatusFluentImpl.ActiveNested<A> editActive() {
    return withNewActiveLike(getActive());
  }
  public NodeConfigStatusFluentImpl.ActiveNested<A> editOrNewActive() {
    return withNewActiveLike(getActive() != null ? getActive(): new NodeConfigSourceBuilder().build());
  }
  public NodeConfigStatusFluentImpl.ActiveNested<A> editOrNewActiveLike(NodeConfigSource item) {
    return withNewActiveLike(getActive() != null ? getActive(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildAssigned instead.
   * @return The buildable object.
   */
  @Deprecated
  public NodeConfigSource getAssigned() {
    return this.assigned!=null ?this.assigned.build():null;
  }
  public NodeConfigSource buildAssigned() {
    return this.assigned!=null ?this.assigned.build():null;
  }
  public A withAssigned(NodeConfigSource assigned) {
    _visitables.get("assigned").remove(this.assigned);
    if (assigned!=null){ this.assigned= new NodeConfigSourceBuilder(assigned); _visitables.get("assigned").add(this.assigned);} else { this.assigned = null; _visitables.get("assigned").remove(this.assigned); } return (A) this;
  }
  public Boolean hasAssigned() {
    return this.assigned != null;
  }
  public NodeConfigStatusFluentImpl.AssignedNested<A> withNewAssigned() {
    return new NodeConfigStatusFluentImpl.AssignedNestedImpl();
  }
  public NodeConfigStatusFluentImpl.AssignedNested<A> withNewAssignedLike(NodeConfigSource item) {
    return new NodeConfigStatusFluentImpl.AssignedNestedImpl(item);
  }
  public NodeConfigStatusFluentImpl.AssignedNested<A> editAssigned() {
    return withNewAssignedLike(getAssigned());
  }
  public NodeConfigStatusFluentImpl.AssignedNested<A> editOrNewAssigned() {
    return withNewAssignedLike(getAssigned() != null ? getAssigned(): new NodeConfigSourceBuilder().build());
  }
  public NodeConfigStatusFluentImpl.AssignedNested<A> editOrNewAssignedLike(NodeConfigSource item) {
    return withNewAssignedLike(getAssigned() != null ? getAssigned(): item);
  }
  public String getError() {
    return this.error;
  }
  public A withError(String error) {
    this.error=error; return (A) this;
  }
  public Boolean hasError() {
    return this.error != null;
  }
  
  /**
   * This method has been deprecated, please use method buildLastKnownGood instead.
   * @return The buildable object.
   */
  @Deprecated
  public NodeConfigSource getLastKnownGood() {
    return this.lastKnownGood!=null ?this.lastKnownGood.build():null;
  }
  public NodeConfigSource buildLastKnownGood() {
    return this.lastKnownGood!=null ?this.lastKnownGood.build():null;
  }
  public A withLastKnownGood(NodeConfigSource lastKnownGood) {
    _visitables.get("lastKnownGood").remove(this.lastKnownGood);
    if (lastKnownGood!=null){ this.lastKnownGood= new NodeConfigSourceBuilder(lastKnownGood); _visitables.get("lastKnownGood").add(this.lastKnownGood);} else { this.lastKnownGood = null; _visitables.get("lastKnownGood").remove(this.lastKnownGood); } return (A) this;
  }
  public Boolean hasLastKnownGood() {
    return this.lastKnownGood != null;
  }
  public NodeConfigStatusFluentImpl.LastKnownGoodNested<A> withNewLastKnownGood() {
    return new NodeConfigStatusFluentImpl.LastKnownGoodNestedImpl();
  }
  public NodeConfigStatusFluentImpl.LastKnownGoodNested<A> withNewLastKnownGoodLike(NodeConfigSource item) {
    return new NodeConfigStatusFluentImpl.LastKnownGoodNestedImpl(item);
  }
  public NodeConfigStatusFluentImpl.LastKnownGoodNested<A> editLastKnownGood() {
    return withNewLastKnownGoodLike(getLastKnownGood());
  }
  public NodeConfigStatusFluentImpl.LastKnownGoodNested<A> editOrNewLastKnownGood() {
    return withNewLastKnownGoodLike(getLastKnownGood() != null ? getLastKnownGood(): new NodeConfigSourceBuilder().build());
  }
  public NodeConfigStatusFluentImpl.LastKnownGoodNested<A> editOrNewLastKnownGoodLike(NodeConfigSource item) {
    return withNewLastKnownGoodLike(getLastKnownGood() != null ? getLastKnownGood(): item);
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    NodeConfigStatusFluentImpl that = (NodeConfigStatusFluentImpl) o;
    if (!java.util.Objects.equals(active, that.active)) return false;

    if (!java.util.Objects.equals(assigned, that.assigned)) return false;

    if (!java.util.Objects.equals(error, that.error)) return false;

    if (!java.util.Objects.equals(lastKnownGood, that.lastKnownGood)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(active,  assigned,  error,  lastKnownGood,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (active != null) { sb.append("active:"); sb.append(active + ","); }
    if (assigned != null) { sb.append("assigned:"); sb.append(assigned + ","); }
    if (error != null) { sb.append("error:"); sb.append(error + ","); }
    if (lastKnownGood != null) { sb.append("lastKnownGood:"); sb.append(lastKnownGood + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class ActiveNestedImpl<N> extends NodeConfigSourceFluentImpl<NodeConfigStatusFluentImpl.ActiveNested<N>> implements NodeConfigStatusFluentImpl.ActiveNested<N>,Nested<N>{
    ActiveNestedImpl(NodeConfigSource item) {
      this.builder = new NodeConfigSourceBuilder(this, item);
    }
    ActiveNestedImpl() {
      this.builder = new NodeConfigSourceBuilder(this);
    }
    NodeConfigSourceBuilder builder;
    public N and() {
      return (N) NodeConfigStatusFluentImpl.this.withActive(builder.build());
    }
    public N endActive() {
      return and();
    }
    
  }
  class AssignedNestedImpl<N> extends NodeConfigSourceFluentImpl<NodeConfigStatusFluentImpl.AssignedNested<N>> implements NodeConfigStatusFluentImpl.AssignedNested<N>,Nested<N>{
    AssignedNestedImpl(NodeConfigSource item) {
      this.builder = new NodeConfigSourceBuilder(this, item);
    }
    AssignedNestedImpl() {
      this.builder = new NodeConfigSourceBuilder(this);
    }
    NodeConfigSourceBuilder builder;
    public N and() {
      return (N) NodeConfigStatusFluentImpl.this.withAssigned(builder.build());
    }
    public N endAssigned() {
      return and();
    }
    
  }
  class LastKnownGoodNestedImpl<N> extends NodeConfigSourceFluentImpl<NodeConfigStatusFluentImpl.LastKnownGoodNested<N>> implements NodeConfigStatusFluentImpl.LastKnownGoodNested<N>,Nested<N>{
    LastKnownGoodNestedImpl(NodeConfigSource item) {
      this.builder = new NodeConfigSourceBuilder(this, item);
    }
    LastKnownGoodNestedImpl() {
      this.builder = new NodeConfigSourceBuilder(this);
    }
    NodeConfigSourceBuilder builder;
    public N and() {
      return (N) NodeConfigStatusFluentImpl.this.withLastKnownGood(builder.build());
    }
    public N endLastKnownGood() {
      return and();
    }
    
  }
  
}