package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class NamespaceListBuilder extends NamespaceListFluentImpl<NamespaceListBuilder> implements VisitableBuilder<NamespaceList,NamespaceListBuilder>{
  public NamespaceListBuilder() {
    this(false);
  }
  public NamespaceListBuilder(Boolean validationEnabled) {
    this(new NamespaceList(), validationEnabled);
  }
  public NamespaceListBuilder(NamespaceListFluent<?> fluent) {
    this(fluent, false);
  }
  public NamespaceListBuilder(NamespaceListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new NamespaceList(), validationEnabled);
  }
  public NamespaceListBuilder(NamespaceListFluent<?> fluent,NamespaceList instance) {
    this(fluent, instance, false);
  }
  public NamespaceListBuilder(NamespaceListFluent<?> fluent,NamespaceList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public NamespaceListBuilder(NamespaceList instance) {
    this(instance,false);
  }
  public NamespaceListBuilder(NamespaceList instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  NamespaceListFluent<?> fluent;
  Boolean validationEnabled;
  public NamespaceList build() {
    NamespaceList buildable = new NamespaceList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}