package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class NamespaceBuilder extends NamespaceFluentImpl<NamespaceBuilder> implements VisitableBuilder<Namespace,NamespaceBuilder>{
  public NamespaceBuilder() {
    this(false);
  }
  public NamespaceBuilder(Boolean validationEnabled) {
    this(new Namespace(), validationEnabled);
  }
  public NamespaceBuilder(NamespaceFluent<?> fluent) {
    this(fluent, false);
  }
  public NamespaceBuilder(NamespaceFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Namespace(), validationEnabled);
  }
  public NamespaceBuilder(NamespaceFluent<?> fluent,Namespace instance) {
    this(fluent, instance, false);
  }
  public NamespaceBuilder(NamespaceFluent<?> fluent,Namespace instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public NamespaceBuilder(Namespace instance) {
    this(instance,false);
  }
  public NamespaceBuilder(Namespace instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  NamespaceFluent<?> fluent;
  Boolean validationEnabled;
  public Namespace build() {
    Namespace buildable = new Namespace(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}