package io.fabric8.kubernetes.api.model;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class NamedClusterFluentImpl<A extends NamedClusterFluent<A>> extends BaseFluent<A> implements NamedClusterFluent<A>{
  public NamedClusterFluentImpl() {
  }
  public NamedClusterFluentImpl(NamedCluster instance) {
    if (instance != null) {
      this.withCluster(instance.getCluster());
      this.withName(instance.getName());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private ClusterBuilder cluster;
  private String name;
  private Map<String,Object> additionalProperties;
  
  /**
   * This method has been deprecated, please use method buildCluster instead.
   * @return The buildable object.
   */
  @Deprecated
  public Cluster getCluster() {
    return this.cluster!=null ?this.cluster.build():null;
  }
  public Cluster buildCluster() {
    return this.cluster!=null ?this.cluster.build():null;
  }
  public A withCluster(Cluster cluster) {
    _visitables.get("cluster").remove(this.cluster);
    if (cluster!=null){ this.cluster= new ClusterBuilder(cluster); _visitables.get("cluster").add(this.cluster);} else { this.cluster = null; _visitables.get("cluster").remove(this.cluster); } return (A) this;
  }
  public Boolean hasCluster() {
    return this.cluster != null;
  }
  public NamedClusterFluentImpl.ClusterNested<A> withNewCluster() {
    return new NamedClusterFluentImpl.ClusterNestedImpl();
  }
  public NamedClusterFluentImpl.ClusterNested<A> withNewClusterLike(Cluster item) {
    return new NamedClusterFluentImpl.ClusterNestedImpl(item);
  }
  public NamedClusterFluentImpl.ClusterNested<A> editCluster() {
    return withNewClusterLike(getCluster());
  }
  public NamedClusterFluentImpl.ClusterNested<A> editOrNewCluster() {
    return withNewClusterLike(getCluster() != null ? getCluster(): new ClusterBuilder().build());
  }
  public NamedClusterFluentImpl.ClusterNested<A> editOrNewClusterLike(Cluster item) {
    return withNewClusterLike(getCluster() != null ? getCluster(): item);
  }
  public String getName() {
    return this.name;
  }
  public A withName(String name) {
    this.name=name; return (A) this;
  }
  public Boolean hasName() {
    return this.name != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    NamedClusterFluentImpl that = (NamedClusterFluentImpl) o;
    if (!java.util.Objects.equals(cluster, that.cluster)) return false;

    if (!java.util.Objects.equals(name, that.name)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(cluster,  name,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (cluster != null) { sb.append("cluster:"); sb.append(cluster + ","); }
    if (name != null) { sb.append("name:"); sb.append(name + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class ClusterNestedImpl<N> extends ClusterFluentImpl<NamedClusterFluentImpl.ClusterNested<N>> implements NamedClusterFluentImpl.ClusterNested<N>,Nested<N>{
    ClusterNestedImpl(Cluster item) {
      this.builder = new ClusterBuilder(this, item);
    }
    ClusterNestedImpl() {
      this.builder = new ClusterBuilder(this);
    }
    ClusterBuilder builder;
    public N and() {
      return (N) NamedClusterFluentImpl.this.withCluster(builder.build());
    }
    public N endCluster() {
      return and();
    }
    
  }
  
}