package io.fabric8.kubernetes.api.model;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class NamedAuthInfoFluentImpl<A extends NamedAuthInfoFluent<A>> extends BaseFluent<A> implements NamedAuthInfoFluent<A>{
  public NamedAuthInfoFluentImpl() {
  }
  public NamedAuthInfoFluentImpl(NamedAuthInfo instance) {
    if (instance != null) {
      this.withName(instance.getName());
      this.withUser(instance.getUser());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private String name;
  private AuthInfoBuilder user;
  private Map<String,Object> additionalProperties;
  public String getName() {
    return this.name;
  }
  public A withName(String name) {
    this.name=name; return (A) this;
  }
  public Boolean hasName() {
    return this.name != null;
  }
  
  /**
   * This method has been deprecated, please use method buildUser instead.
   * @return The buildable object.
   */
  @Deprecated
  public AuthInfo getUser() {
    return this.user!=null ?this.user.build():null;
  }
  public AuthInfo buildUser() {
    return this.user!=null ?this.user.build():null;
  }
  public A withUser(AuthInfo user) {
    _visitables.get("user").remove(this.user);
    if (user!=null){ this.user= new AuthInfoBuilder(user); _visitables.get("user").add(this.user);} else { this.user = null; _visitables.get("user").remove(this.user); } return (A) this;
  }
  public Boolean hasUser() {
    return this.user != null;
  }
  public NamedAuthInfoFluentImpl.UserNested<A> withNewUser() {
    return new NamedAuthInfoFluentImpl.UserNestedImpl();
  }
  public NamedAuthInfoFluentImpl.UserNested<A> withNewUserLike(AuthInfo item) {
    return new NamedAuthInfoFluentImpl.UserNestedImpl(item);
  }
  public NamedAuthInfoFluentImpl.UserNested<A> editUser() {
    return withNewUserLike(getUser());
  }
  public NamedAuthInfoFluentImpl.UserNested<A> editOrNewUser() {
    return withNewUserLike(getUser() != null ? getUser(): new AuthInfoBuilder().build());
  }
  public NamedAuthInfoFluentImpl.UserNested<A> editOrNewUserLike(AuthInfo item) {
    return withNewUserLike(getUser() != null ? getUser(): item);
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    NamedAuthInfoFluentImpl that = (NamedAuthInfoFluentImpl) o;
    if (!java.util.Objects.equals(name, that.name)) return false;

    if (!java.util.Objects.equals(user, that.user)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(name,  user,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (name != null) { sb.append("name:"); sb.append(name + ","); }
    if (user != null) { sb.append("user:"); sb.append(user + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class UserNestedImpl<N> extends AuthInfoFluentImpl<NamedAuthInfoFluentImpl.UserNested<N>> implements NamedAuthInfoFluentImpl.UserNested<N>,Nested<N>{
    UserNestedImpl(AuthInfo item) {
      this.builder = new AuthInfoBuilder(this, item);
    }
    UserNestedImpl() {
      this.builder = new AuthInfoBuilder(this);
    }
    AuthInfoBuilder builder;
    public N and() {
      return (N) NamedAuthInfoFluentImpl.this.withUser(builder.build());
    }
    public N endUser() {
      return and();
    }
    
  }
  
}