package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ISCSIVolumeSourceBuilder extends ISCSIVolumeSourceFluentImpl<ISCSIVolumeSourceBuilder> implements VisitableBuilder<ISCSIVolumeSource,ISCSIVolumeSourceBuilder>{
  public ISCSIVolumeSourceBuilder() {
    this(false);
  }
  public ISCSIVolumeSourceBuilder(Boolean validationEnabled) {
    this(new ISCSIVolumeSource(), validationEnabled);
  }
  public ISCSIVolumeSourceBuilder(ISCSIVolumeSourceFluent<?> fluent) {
    this(fluent, false);
  }
  public ISCSIVolumeSourceBuilder(ISCSIVolumeSourceFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ISCSIVolumeSource(), validationEnabled);
  }
  public ISCSIVolumeSourceBuilder(ISCSIVolumeSourceFluent<?> fluent,ISCSIVolumeSource instance) {
    this(fluent, instance, false);
  }
  public ISCSIVolumeSourceBuilder(ISCSIVolumeSourceFluent<?> fluent,ISCSIVolumeSource instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withChapAuthDiscovery(instance.getChapAuthDiscovery());
      fluent.withChapAuthSession(instance.getChapAuthSession());
      fluent.withFsType(instance.getFsType());
      fluent.withInitiatorName(instance.getInitiatorName());
      fluent.withIqn(instance.getIqn());
      fluent.withIscsiInterface(instance.getIscsiInterface());
      fluent.withLun(instance.getLun());
      fluent.withPortals(instance.getPortals());
      fluent.withReadOnly(instance.getReadOnly());
      fluent.withSecretRef(instance.getSecretRef());
      fluent.withTargetPortal(instance.getTargetPortal());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ISCSIVolumeSourceBuilder(ISCSIVolumeSource instance) {
    this(instance,false);
  }
  public ISCSIVolumeSourceBuilder(ISCSIVolumeSource instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withChapAuthDiscovery(instance.getChapAuthDiscovery());
      this.withChapAuthSession(instance.getChapAuthSession());
      this.withFsType(instance.getFsType());
      this.withInitiatorName(instance.getInitiatorName());
      this.withIqn(instance.getIqn());
      this.withIscsiInterface(instance.getIscsiInterface());
      this.withLun(instance.getLun());
      this.withPortals(instance.getPortals());
      this.withReadOnly(instance.getReadOnly());
      this.withSecretRef(instance.getSecretRef());
      this.withTargetPortal(instance.getTargetPortal());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ISCSIVolumeSourceFluent<?> fluent;
  Boolean validationEnabled;
  public ISCSIVolumeSource build() {
    ISCSIVolumeSource buildable = new ISCSIVolumeSource(fluent.getChapAuthDiscovery(),fluent.getChapAuthSession(),fluent.getFsType(),fluent.getInitiatorName(),fluent.getIqn(),fluent.getIscsiInterface(),fluent.getLun(),fluent.getPortals(),fluent.getReadOnly(),fluent.getSecretRef(),fluent.getTargetPortal());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}