package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.builder.Fluent;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
public interface HTTPGetActionFluent<A extends HTTPGetActionFluent<A>> extends Fluent<A>{
  public String getHost();
  public A withHost(String host);
  public Boolean hasHost();
  public A addToHttpHeaders(int index,HTTPHeader item);
  public A setToHttpHeaders(int index,HTTPHeader item);
  public A addToHttpHeaders(io.fabric8.kubernetes.api.model.HTTPHeader... items);
  public A addAllToHttpHeaders(Collection<HTTPHeader> items);
  public A removeFromHttpHeaders(io.fabric8.kubernetes.api.model.HTTPHeader... items);
  public A removeAllFromHttpHeaders(Collection<HTTPHeader> items);
  public A removeMatchingFromHttpHeaders(Predicate<HTTPHeaderBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildHttpHeaders instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<HTTPHeader> getHttpHeaders();
  public List<HTTPHeader> buildHttpHeaders();
  public HTTPHeader buildHttpHeader(int index);
  public HTTPHeader buildFirstHttpHeader();
  public HTTPHeader buildLastHttpHeader();
  public HTTPHeader buildMatchingHttpHeader(Predicate<HTTPHeaderBuilder> predicate);
  public Boolean hasMatchingHttpHeader(Predicate<HTTPHeaderBuilder> predicate);
  public A withHttpHeaders(List<HTTPHeader> httpHeaders);
  public A withHttpHeaders(io.fabric8.kubernetes.api.model.HTTPHeader... httpHeaders);
  public Boolean hasHttpHeaders();
  public A addNewHttpHeader(String name,String value);
  public HTTPGetActionFluent.HttpHeadersNested<A> addNewHttpHeader();
  public HTTPGetActionFluent.HttpHeadersNested<A> addNewHttpHeaderLike(HTTPHeader item);
  public HTTPGetActionFluent.HttpHeadersNested<A> setNewHttpHeaderLike(int index,HTTPHeader item);
  public HTTPGetActionFluent.HttpHeadersNested<A> editHttpHeader(int index);
  public HTTPGetActionFluent.HttpHeadersNested<A> editFirstHttpHeader();
  public HTTPGetActionFluent.HttpHeadersNested<A> editLastHttpHeader();
  public HTTPGetActionFluent.HttpHeadersNested<A> editMatchingHttpHeader(Predicate<HTTPHeaderBuilder> predicate);
  public String getPath();
  public A withPath(String path);
  public Boolean hasPath();
  
  /**
   * This method has been deprecated, please use method buildPort instead.
   * @return The buildable object.
   */
  @Deprecated
  public IntOrString getPort();
  public IntOrString buildPort();
  public A withPort(IntOrString port);
  public Boolean hasPort();
  public A withNewPort(Object value);
  public HTTPGetActionFluent.PortNested<A> withNewPort();
  public HTTPGetActionFluent.PortNested<A> withNewPortLike(IntOrString item);
  public HTTPGetActionFluent.PortNested<A> editPort();
  public HTTPGetActionFluent.PortNested<A> editOrNewPort();
  public HTTPGetActionFluent.PortNested<A> editOrNewPortLike(IntOrString item);
  public String getScheme();
  public A withScheme(String scheme);
  public Boolean hasScheme();
  public A addToAdditionalProperties(String key,Object value);
  public A addToAdditionalProperties(Map<String,Object> map);
  public A removeFromAdditionalProperties(String key);
  public A removeFromAdditionalProperties(Map<String,Object> map);
  public Map<String,Object> getAdditionalProperties();
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties);
  public Boolean hasAdditionalProperties();
  public interface HttpHeadersNested<N> extends Nested<N>,HTTPHeaderFluent<HTTPGetActionFluent.HttpHeadersNested<N>>{
    public N and();
    public N endHttpHeader();
    
  }
  public interface PortNested<N> extends Nested<N>,IntOrStringFluent<HTTPGetActionFluent.PortNested<N>>{
    public N and();
    public N endPort();
    
  }
  
}