package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class GRPCActionBuilder extends GRPCActionFluentImpl<GRPCActionBuilder> implements VisitableBuilder<GRPCAction,GRPCActionBuilder>{
  public GRPCActionBuilder() {
    this(false);
  }
  public GRPCActionBuilder(Boolean validationEnabled) {
    this(new GRPCAction(), validationEnabled);
  }
  public GRPCActionBuilder(GRPCActionFluent<?> fluent) {
    this(fluent, false);
  }
  public GRPCActionBuilder(GRPCActionFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new GRPCAction(), validationEnabled);
  }
  public GRPCActionBuilder(GRPCActionFluent<?> fluent,GRPCAction instance) {
    this(fluent, instance, false);
  }
  public GRPCActionBuilder(GRPCActionFluent<?> fluent,GRPCAction instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withPort(instance.getPort());
      fluent.withService(instance.getService());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public GRPCActionBuilder(GRPCAction instance) {
    this(instance,false);
  }
  public GRPCActionBuilder(GRPCAction instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withPort(instance.getPort());
      this.withService(instance.getService());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  GRPCActionFluent<?> fluent;
  Boolean validationEnabled;
  public GRPCAction build() {
    GRPCAction buildable = new GRPCAction(fluent.getPort(),fluent.getService());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}