package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ExecConfigBuilder extends ExecConfigFluentImpl<ExecConfigBuilder> implements VisitableBuilder<ExecConfig,ExecConfigBuilder>{
  public ExecConfigBuilder() {
    this(false);
  }
  public ExecConfigBuilder(Boolean validationEnabled) {
    this(new ExecConfig(), validationEnabled);
  }
  public ExecConfigBuilder(ExecConfigFluent<?> fluent) {
    this(fluent, false);
  }
  public ExecConfigBuilder(ExecConfigFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ExecConfig(), validationEnabled);
  }
  public ExecConfigBuilder(ExecConfigFluent<?> fluent,ExecConfig instance) {
    this(fluent, instance, false);
  }
  public ExecConfigBuilder(ExecConfigFluent<?> fluent,ExecConfig instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withArgs(instance.getArgs());
      fluent.withCommand(instance.getCommand());
      fluent.withEnv(instance.getEnv());
      fluent.withInstallHint(instance.getInstallHint());
      fluent.withInteractiveMode(instance.getInteractiveMode());
      fluent.withProvideClusterInfo(instance.getProvideClusterInfo());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ExecConfigBuilder(ExecConfig instance) {
    this(instance,false);
  }
  public ExecConfigBuilder(ExecConfig instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withArgs(instance.getArgs());
      this.withCommand(instance.getCommand());
      this.withEnv(instance.getEnv());
      this.withInstallHint(instance.getInstallHint());
      this.withInteractiveMode(instance.getInteractiveMode());
      this.withProvideClusterInfo(instance.getProvideClusterInfo());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ExecConfigFluent<?> fluent;
  Boolean validationEnabled;
  public ExecConfig build() {
    ExecConfig buildable = new ExecConfig(fluent.getApiVersion(),fluent.getArgs(),fluent.getCommand(),fluent.getEnv(),fluent.getInstallHint(),fluent.getInteractiveMode(),fluent.getProvideClusterInfo());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}