package io.fabric8.kubernetes.api.model;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class EnvVarSourceFluentImpl<A extends EnvVarSourceFluent<A>> extends BaseFluent<A> implements EnvVarSourceFluent<A>{
  public EnvVarSourceFluentImpl() {
  }
  public EnvVarSourceFluentImpl(EnvVarSource instance) {
    if (instance != null) {
      this.withConfigMapKeyRef(instance.getConfigMapKeyRef());
      this.withFieldRef(instance.getFieldRef());
      this.withResourceFieldRef(instance.getResourceFieldRef());
      this.withSecretKeyRef(instance.getSecretKeyRef());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private ConfigMapKeySelectorBuilder configMapKeyRef;
  private ObjectFieldSelectorBuilder fieldRef;
  private ResourceFieldSelectorBuilder resourceFieldRef;
  private SecretKeySelectorBuilder secretKeyRef;
  private Map<String,Object> additionalProperties;
  
  /**
   * This method has been deprecated, please use method buildConfigMapKeyRef instead.
   * @return The buildable object.
   */
  @Deprecated
  public ConfigMapKeySelector getConfigMapKeyRef() {
    return this.configMapKeyRef!=null ?this.configMapKeyRef.build():null;
  }
  public ConfigMapKeySelector buildConfigMapKeyRef() {
    return this.configMapKeyRef!=null ?this.configMapKeyRef.build():null;
  }
  public A withConfigMapKeyRef(ConfigMapKeySelector configMapKeyRef) {
    _visitables.get("configMapKeyRef").remove(this.configMapKeyRef);
    if (configMapKeyRef!=null){ this.configMapKeyRef= new ConfigMapKeySelectorBuilder(configMapKeyRef); _visitables.get("configMapKeyRef").add(this.configMapKeyRef);} else { this.configMapKeyRef = null; _visitables.get("configMapKeyRef").remove(this.configMapKeyRef); } return (A) this;
  }
  public Boolean hasConfigMapKeyRef() {
    return this.configMapKeyRef != null;
  }
  public A withNewConfigMapKeyRef(String key,String name,Boolean optional) {
    return (A)withConfigMapKeyRef(new ConfigMapKeySelector(key, name, optional));
  }
  public EnvVarSourceFluentImpl.ConfigMapKeyRefNested<A> withNewConfigMapKeyRef() {
    return new EnvVarSourceFluentImpl.ConfigMapKeyRefNestedImpl();
  }
  public EnvVarSourceFluentImpl.ConfigMapKeyRefNested<A> withNewConfigMapKeyRefLike(ConfigMapKeySelector item) {
    return new EnvVarSourceFluentImpl.ConfigMapKeyRefNestedImpl(item);
  }
  public EnvVarSourceFluentImpl.ConfigMapKeyRefNested<A> editConfigMapKeyRef() {
    return withNewConfigMapKeyRefLike(getConfigMapKeyRef());
  }
  public EnvVarSourceFluentImpl.ConfigMapKeyRefNested<A> editOrNewConfigMapKeyRef() {
    return withNewConfigMapKeyRefLike(getConfigMapKeyRef() != null ? getConfigMapKeyRef(): new ConfigMapKeySelectorBuilder().build());
  }
  public EnvVarSourceFluentImpl.ConfigMapKeyRefNested<A> editOrNewConfigMapKeyRefLike(ConfigMapKeySelector item) {
    return withNewConfigMapKeyRefLike(getConfigMapKeyRef() != null ? getConfigMapKeyRef(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildFieldRef instead.
   * @return The buildable object.
   */
  @Deprecated
  public ObjectFieldSelector getFieldRef() {
    return this.fieldRef!=null ?this.fieldRef.build():null;
  }
  public ObjectFieldSelector buildFieldRef() {
    return this.fieldRef!=null ?this.fieldRef.build():null;
  }
  public A withFieldRef(ObjectFieldSelector fieldRef) {
    _visitables.get("fieldRef").remove(this.fieldRef);
    if (fieldRef!=null){ this.fieldRef= new ObjectFieldSelectorBuilder(fieldRef); _visitables.get("fieldRef").add(this.fieldRef);} else { this.fieldRef = null; _visitables.get("fieldRef").remove(this.fieldRef); } return (A) this;
  }
  public Boolean hasFieldRef() {
    return this.fieldRef != null;
  }
  public A withNewFieldRef(String apiVersion,String fieldPath) {
    return (A)withFieldRef(new ObjectFieldSelector(apiVersion, fieldPath));
  }
  public EnvVarSourceFluentImpl.FieldRefNested<A> withNewFieldRef() {
    return new EnvVarSourceFluentImpl.FieldRefNestedImpl();
  }
  public EnvVarSourceFluentImpl.FieldRefNested<A> withNewFieldRefLike(ObjectFieldSelector item) {
    return new EnvVarSourceFluentImpl.FieldRefNestedImpl(item);
  }
  public EnvVarSourceFluentImpl.FieldRefNested<A> editFieldRef() {
    return withNewFieldRefLike(getFieldRef());
  }
  public EnvVarSourceFluentImpl.FieldRefNested<A> editOrNewFieldRef() {
    return withNewFieldRefLike(getFieldRef() != null ? getFieldRef(): new ObjectFieldSelectorBuilder().build());
  }
  public EnvVarSourceFluentImpl.FieldRefNested<A> editOrNewFieldRefLike(ObjectFieldSelector item) {
    return withNewFieldRefLike(getFieldRef() != null ? getFieldRef(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildResourceFieldRef instead.
   * @return The buildable object.
   */
  @Deprecated
  public ResourceFieldSelector getResourceFieldRef() {
    return this.resourceFieldRef!=null ?this.resourceFieldRef.build():null;
  }
  public ResourceFieldSelector buildResourceFieldRef() {
    return this.resourceFieldRef!=null ?this.resourceFieldRef.build():null;
  }
  public A withResourceFieldRef(ResourceFieldSelector resourceFieldRef) {
    _visitables.get("resourceFieldRef").remove(this.resourceFieldRef);
    if (resourceFieldRef!=null){ this.resourceFieldRef= new ResourceFieldSelectorBuilder(resourceFieldRef); _visitables.get("resourceFieldRef").add(this.resourceFieldRef);} else { this.resourceFieldRef = null; _visitables.get("resourceFieldRef").remove(this.resourceFieldRef); } return (A) this;
  }
  public Boolean hasResourceFieldRef() {
    return this.resourceFieldRef != null;
  }
  public EnvVarSourceFluentImpl.ResourceFieldRefNested<A> withNewResourceFieldRef() {
    return new EnvVarSourceFluentImpl.ResourceFieldRefNestedImpl();
  }
  public EnvVarSourceFluentImpl.ResourceFieldRefNested<A> withNewResourceFieldRefLike(ResourceFieldSelector item) {
    return new EnvVarSourceFluentImpl.ResourceFieldRefNestedImpl(item);
  }
  public EnvVarSourceFluentImpl.ResourceFieldRefNested<A> editResourceFieldRef() {
    return withNewResourceFieldRefLike(getResourceFieldRef());
  }
  public EnvVarSourceFluentImpl.ResourceFieldRefNested<A> editOrNewResourceFieldRef() {
    return withNewResourceFieldRefLike(getResourceFieldRef() != null ? getResourceFieldRef(): new ResourceFieldSelectorBuilder().build());
  }
  public EnvVarSourceFluentImpl.ResourceFieldRefNested<A> editOrNewResourceFieldRefLike(ResourceFieldSelector item) {
    return withNewResourceFieldRefLike(getResourceFieldRef() != null ? getResourceFieldRef(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildSecretKeyRef instead.
   * @return The buildable object.
   */
  @Deprecated
  public SecretKeySelector getSecretKeyRef() {
    return this.secretKeyRef!=null ?this.secretKeyRef.build():null;
  }
  public SecretKeySelector buildSecretKeyRef() {
    return this.secretKeyRef!=null ?this.secretKeyRef.build():null;
  }
  public A withSecretKeyRef(SecretKeySelector secretKeyRef) {
    _visitables.get("secretKeyRef").remove(this.secretKeyRef);
    if (secretKeyRef!=null){ this.secretKeyRef= new SecretKeySelectorBuilder(secretKeyRef); _visitables.get("secretKeyRef").add(this.secretKeyRef);} else { this.secretKeyRef = null; _visitables.get("secretKeyRef").remove(this.secretKeyRef); } return (A) this;
  }
  public Boolean hasSecretKeyRef() {
    return this.secretKeyRef != null;
  }
  public A withNewSecretKeyRef(String key,String name,Boolean optional) {
    return (A)withSecretKeyRef(new SecretKeySelector(key, name, optional));
  }
  public EnvVarSourceFluentImpl.SecretKeyRefNested<A> withNewSecretKeyRef() {
    return new EnvVarSourceFluentImpl.SecretKeyRefNestedImpl();
  }
  public EnvVarSourceFluentImpl.SecretKeyRefNested<A> withNewSecretKeyRefLike(SecretKeySelector item) {
    return new EnvVarSourceFluentImpl.SecretKeyRefNestedImpl(item);
  }
  public EnvVarSourceFluentImpl.SecretKeyRefNested<A> editSecretKeyRef() {
    return withNewSecretKeyRefLike(getSecretKeyRef());
  }
  public EnvVarSourceFluentImpl.SecretKeyRefNested<A> editOrNewSecretKeyRef() {
    return withNewSecretKeyRefLike(getSecretKeyRef() != null ? getSecretKeyRef(): new SecretKeySelectorBuilder().build());
  }
  public EnvVarSourceFluentImpl.SecretKeyRefNested<A> editOrNewSecretKeyRefLike(SecretKeySelector item) {
    return withNewSecretKeyRefLike(getSecretKeyRef() != null ? getSecretKeyRef(): item);
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    EnvVarSourceFluentImpl that = (EnvVarSourceFluentImpl) o;
    if (!java.util.Objects.equals(configMapKeyRef, that.configMapKeyRef)) return false;

    if (!java.util.Objects.equals(fieldRef, that.fieldRef)) return false;

    if (!java.util.Objects.equals(resourceFieldRef, that.resourceFieldRef)) return false;

    if (!java.util.Objects.equals(secretKeyRef, that.secretKeyRef)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(configMapKeyRef,  fieldRef,  resourceFieldRef,  secretKeyRef,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (configMapKeyRef != null) { sb.append("configMapKeyRef:"); sb.append(configMapKeyRef + ","); }
    if (fieldRef != null) { sb.append("fieldRef:"); sb.append(fieldRef + ","); }
    if (resourceFieldRef != null) { sb.append("resourceFieldRef:"); sb.append(resourceFieldRef + ","); }
    if (secretKeyRef != null) { sb.append("secretKeyRef:"); sb.append(secretKeyRef + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class ConfigMapKeyRefNestedImpl<N> extends ConfigMapKeySelectorFluentImpl<EnvVarSourceFluentImpl.ConfigMapKeyRefNested<N>> implements EnvVarSourceFluentImpl.ConfigMapKeyRefNested<N>,Nested<N>{
    ConfigMapKeyRefNestedImpl(ConfigMapKeySelector item) {
      this.builder = new ConfigMapKeySelectorBuilder(this, item);
    }
    ConfigMapKeyRefNestedImpl() {
      this.builder = new ConfigMapKeySelectorBuilder(this);
    }
    ConfigMapKeySelectorBuilder builder;
    public N and() {
      return (N) EnvVarSourceFluentImpl.this.withConfigMapKeyRef(builder.build());
    }
    public N endConfigMapKeyRef() {
      return and();
    }
    
  }
  class FieldRefNestedImpl<N> extends ObjectFieldSelectorFluentImpl<EnvVarSourceFluentImpl.FieldRefNested<N>> implements EnvVarSourceFluentImpl.FieldRefNested<N>,Nested<N>{
    FieldRefNestedImpl(ObjectFieldSelector item) {
      this.builder = new ObjectFieldSelectorBuilder(this, item);
    }
    FieldRefNestedImpl() {
      this.builder = new ObjectFieldSelectorBuilder(this);
    }
    ObjectFieldSelectorBuilder builder;
    public N and() {
      return (N) EnvVarSourceFluentImpl.this.withFieldRef(builder.build());
    }
    public N endFieldRef() {
      return and();
    }
    
  }
  class ResourceFieldRefNestedImpl<N> extends ResourceFieldSelectorFluentImpl<EnvVarSourceFluentImpl.ResourceFieldRefNested<N>> implements EnvVarSourceFluentImpl.ResourceFieldRefNested<N>,Nested<N>{
    ResourceFieldRefNestedImpl(ResourceFieldSelector item) {
      this.builder = new ResourceFieldSelectorBuilder(this, item);
    }
    ResourceFieldRefNestedImpl() {
      this.builder = new ResourceFieldSelectorBuilder(this);
    }
    ResourceFieldSelectorBuilder builder;
    public N and() {
      return (N) EnvVarSourceFluentImpl.this.withResourceFieldRef(builder.build());
    }
    public N endResourceFieldRef() {
      return and();
    }
    
  }
  class SecretKeyRefNestedImpl<N> extends SecretKeySelectorFluentImpl<EnvVarSourceFluentImpl.SecretKeyRefNested<N>> implements EnvVarSourceFluentImpl.SecretKeyRefNested<N>,Nested<N>{
    SecretKeyRefNestedImpl(SecretKeySelector item) {
      this.builder = new SecretKeySelectorBuilder(this, item);
    }
    SecretKeyRefNestedImpl() {
      this.builder = new SecretKeySelectorBuilder(this);
    }
    SecretKeySelectorBuilder builder;
    public N and() {
      return (N) EnvVarSourceFluentImpl.this.withSecretKeyRef(builder.build());
    }
    public N endSecretKeyRef() {
      return and();
    }
    
  }
  
}