package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.builder.Fluent;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
public interface EndpointsFluent<A extends EndpointsFluent<A>> extends Fluent<A>{
  public String getApiVersion();
  public A withApiVersion(String apiVersion);
  public Boolean hasApiVersion();
  public String getKind();
  public A withKind(String kind);
  public Boolean hasKind();
  
  /**
   * This method has been deprecated, please use method buildMetadata instead.
   * @return The buildable object.
   */
  @Deprecated
  public ObjectMeta getMetadata();
  public ObjectMeta buildMetadata();
  public A withMetadata(ObjectMeta metadata);
  public Boolean hasMetadata();
  public EndpointsFluent.MetadataNested<A> withNewMetadata();
  public EndpointsFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
  public EndpointsFluent.MetadataNested<A> editMetadata();
  public EndpointsFluent.MetadataNested<A> editOrNewMetadata();
  public EndpointsFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item);
  public A addToSubsets(int index,EndpointSubset item);
  public A setToSubsets(int index,EndpointSubset item);
  public A addToSubsets(io.fabric8.kubernetes.api.model.EndpointSubset... items);
  public A addAllToSubsets(Collection<EndpointSubset> items);
  public A removeFromSubsets(io.fabric8.kubernetes.api.model.EndpointSubset... items);
  public A removeAllFromSubsets(Collection<EndpointSubset> items);
  public A removeMatchingFromSubsets(Predicate<EndpointSubsetBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildSubsets instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<EndpointSubset> getSubsets();
  public List<EndpointSubset> buildSubsets();
  public EndpointSubset buildSubset(int index);
  public EndpointSubset buildFirstSubset();
  public EndpointSubset buildLastSubset();
  public EndpointSubset buildMatchingSubset(Predicate<EndpointSubsetBuilder> predicate);
  public Boolean hasMatchingSubset(Predicate<EndpointSubsetBuilder> predicate);
  public A withSubsets(List<EndpointSubset> subsets);
  public A withSubsets(io.fabric8.kubernetes.api.model.EndpointSubset... subsets);
  public Boolean hasSubsets();
  public EndpointsFluent.SubsetsNested<A> addNewSubset();
  public EndpointsFluent.SubsetsNested<A> addNewSubsetLike(EndpointSubset item);
  public EndpointsFluent.SubsetsNested<A> setNewSubsetLike(int index,EndpointSubset item);
  public EndpointsFluent.SubsetsNested<A> editSubset(int index);
  public EndpointsFluent.SubsetsNested<A> editFirstSubset();
  public EndpointsFluent.SubsetsNested<A> editLastSubset();
  public EndpointsFluent.SubsetsNested<A> editMatchingSubset(Predicate<EndpointSubsetBuilder> predicate);
  public A addToAdditionalProperties(String key,Object value);
  public A addToAdditionalProperties(Map<String,Object> map);
  public A removeFromAdditionalProperties(String key);
  public A removeFromAdditionalProperties(Map<String,Object> map);
  public Map<String,Object> getAdditionalProperties();
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties);
  public Boolean hasAdditionalProperties();
  public interface MetadataNested<N> extends Nested<N>,ObjectMetaFluent<EndpointsFluent.MetadataNested<N>>{
    public N and();
    public N endMetadata();
    
  }
  public interface SubsetsNested<N> extends Nested<N>,EndpointSubsetFluent<EndpointsFluent.SubsetsNested<N>>{
    public N and();
    public N endSubset();
    
  }
  
}