package io.fabric8.kubernetes.api.model;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ContainerStateFluentImpl<A extends ContainerStateFluent<A>> extends BaseFluent<A> implements ContainerStateFluent<A>{
  public ContainerStateFluentImpl() {
  }
  public ContainerStateFluentImpl(ContainerState instance) {
    if (instance != null) {
      this.withRunning(instance.getRunning());
      this.withTerminated(instance.getTerminated());
      this.withWaiting(instance.getWaiting());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private ContainerStateRunningBuilder running;
  private ContainerStateTerminatedBuilder terminated;
  private ContainerStateWaitingBuilder waiting;
  private Map<String,Object> additionalProperties;
  
  /**
   * This method has been deprecated, please use method buildRunning instead.
   * @return The buildable object.
   */
  @Deprecated
  public ContainerStateRunning getRunning() {
    return this.running!=null ?this.running.build():null;
  }
  public ContainerStateRunning buildRunning() {
    return this.running!=null ?this.running.build():null;
  }
  public A withRunning(ContainerStateRunning running) {
    _visitables.get("running").remove(this.running);
    if (running!=null){ this.running= new ContainerStateRunningBuilder(running); _visitables.get("running").add(this.running);} else { this.running = null; _visitables.get("running").remove(this.running); } return (A) this;
  }
  public Boolean hasRunning() {
    return this.running != null;
  }
  public A withNewRunning(String startedAt) {
    return (A)withRunning(new ContainerStateRunning(startedAt));
  }
  public ContainerStateFluentImpl.RunningNested<A> withNewRunning() {
    return new ContainerStateFluentImpl.RunningNestedImpl();
  }
  public ContainerStateFluentImpl.RunningNested<A> withNewRunningLike(ContainerStateRunning item) {
    return new ContainerStateFluentImpl.RunningNestedImpl(item);
  }
  public ContainerStateFluentImpl.RunningNested<A> editRunning() {
    return withNewRunningLike(getRunning());
  }
  public ContainerStateFluentImpl.RunningNested<A> editOrNewRunning() {
    return withNewRunningLike(getRunning() != null ? getRunning(): new ContainerStateRunningBuilder().build());
  }
  public ContainerStateFluentImpl.RunningNested<A> editOrNewRunningLike(ContainerStateRunning item) {
    return withNewRunningLike(getRunning() != null ? getRunning(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildTerminated instead.
   * @return The buildable object.
   */
  @Deprecated
  public ContainerStateTerminated getTerminated() {
    return this.terminated!=null ?this.terminated.build():null;
  }
  public ContainerStateTerminated buildTerminated() {
    return this.terminated!=null ?this.terminated.build():null;
  }
  public A withTerminated(ContainerStateTerminated terminated) {
    _visitables.get("terminated").remove(this.terminated);
    if (terminated!=null){ this.terminated= new ContainerStateTerminatedBuilder(terminated); _visitables.get("terminated").add(this.terminated);} else { this.terminated = null; _visitables.get("terminated").remove(this.terminated); } return (A) this;
  }
  public Boolean hasTerminated() {
    return this.terminated != null;
  }
  public ContainerStateFluentImpl.TerminatedNested<A> withNewTerminated() {
    return new ContainerStateFluentImpl.TerminatedNestedImpl();
  }
  public ContainerStateFluentImpl.TerminatedNested<A> withNewTerminatedLike(ContainerStateTerminated item) {
    return new ContainerStateFluentImpl.TerminatedNestedImpl(item);
  }
  public ContainerStateFluentImpl.TerminatedNested<A> editTerminated() {
    return withNewTerminatedLike(getTerminated());
  }
  public ContainerStateFluentImpl.TerminatedNested<A> editOrNewTerminated() {
    return withNewTerminatedLike(getTerminated() != null ? getTerminated(): new ContainerStateTerminatedBuilder().build());
  }
  public ContainerStateFluentImpl.TerminatedNested<A> editOrNewTerminatedLike(ContainerStateTerminated item) {
    return withNewTerminatedLike(getTerminated() != null ? getTerminated(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildWaiting instead.
   * @return The buildable object.
   */
  @Deprecated
  public ContainerStateWaiting getWaiting() {
    return this.waiting!=null ?this.waiting.build():null;
  }
  public ContainerStateWaiting buildWaiting() {
    return this.waiting!=null ?this.waiting.build():null;
  }
  public A withWaiting(ContainerStateWaiting waiting) {
    _visitables.get("waiting").remove(this.waiting);
    if (waiting!=null){ this.waiting= new ContainerStateWaitingBuilder(waiting); _visitables.get("waiting").add(this.waiting);} else { this.waiting = null; _visitables.get("waiting").remove(this.waiting); } return (A) this;
  }
  public Boolean hasWaiting() {
    return this.waiting != null;
  }
  public A withNewWaiting(String message,String reason) {
    return (A)withWaiting(new ContainerStateWaiting(message, reason));
  }
  public ContainerStateFluentImpl.WaitingNested<A> withNewWaiting() {
    return new ContainerStateFluentImpl.WaitingNestedImpl();
  }
  public ContainerStateFluentImpl.WaitingNested<A> withNewWaitingLike(ContainerStateWaiting item) {
    return new ContainerStateFluentImpl.WaitingNestedImpl(item);
  }
  public ContainerStateFluentImpl.WaitingNested<A> editWaiting() {
    return withNewWaitingLike(getWaiting());
  }
  public ContainerStateFluentImpl.WaitingNested<A> editOrNewWaiting() {
    return withNewWaitingLike(getWaiting() != null ? getWaiting(): new ContainerStateWaitingBuilder().build());
  }
  public ContainerStateFluentImpl.WaitingNested<A> editOrNewWaitingLike(ContainerStateWaiting item) {
    return withNewWaitingLike(getWaiting() != null ? getWaiting(): item);
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ContainerStateFluentImpl that = (ContainerStateFluentImpl) o;
    if (!java.util.Objects.equals(running, that.running)) return false;

    if (!java.util.Objects.equals(terminated, that.terminated)) return false;

    if (!java.util.Objects.equals(waiting, that.waiting)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(running,  terminated,  waiting,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (running != null) { sb.append("running:"); sb.append(running + ","); }
    if (terminated != null) { sb.append("terminated:"); sb.append(terminated + ","); }
    if (waiting != null) { sb.append("waiting:"); sb.append(waiting + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class RunningNestedImpl<N> extends ContainerStateRunningFluentImpl<ContainerStateFluentImpl.RunningNested<N>> implements ContainerStateFluentImpl.RunningNested<N>,Nested<N>{
    RunningNestedImpl(ContainerStateRunning item) {
      this.builder = new ContainerStateRunningBuilder(this, item);
    }
    RunningNestedImpl() {
      this.builder = new ContainerStateRunningBuilder(this);
    }
    ContainerStateRunningBuilder builder;
    public N and() {
      return (N) ContainerStateFluentImpl.this.withRunning(builder.build());
    }
    public N endRunning() {
      return and();
    }
    
  }
  class TerminatedNestedImpl<N> extends ContainerStateTerminatedFluentImpl<ContainerStateFluentImpl.TerminatedNested<N>> implements ContainerStateFluentImpl.TerminatedNested<N>,Nested<N>{
    TerminatedNestedImpl(ContainerStateTerminated item) {
      this.builder = new ContainerStateTerminatedBuilder(this, item);
    }
    TerminatedNestedImpl() {
      this.builder = new ContainerStateTerminatedBuilder(this);
    }
    ContainerStateTerminatedBuilder builder;
    public N and() {
      return (N) ContainerStateFluentImpl.this.withTerminated(builder.build());
    }
    public N endTerminated() {
      return and();
    }
    
  }
  class WaitingNestedImpl<N> extends ContainerStateWaitingFluentImpl<ContainerStateFluentImpl.WaitingNested<N>> implements ContainerStateFluentImpl.WaitingNested<N>,Nested<N>{
    WaitingNestedImpl(ContainerStateWaiting item) {
      this.builder = new ContainerStateWaitingBuilder(this, item);
    }
    WaitingNestedImpl() {
      this.builder = new ContainerStateWaitingBuilder(this);
    }
    ContainerStateWaitingBuilder builder;
    public N and() {
      return (N) ContainerStateFluentImpl.this.withWaiting(builder.build());
    }
    public N endWaiting() {
      return and();
    }
    
  }
  
}