package io.fabric8.kubernetes.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Fluent;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.Deprecated;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
public interface CSIVolumeSourceFluent<A extends CSIVolumeSourceFluent<A>> extends Fluent<A>{
  public String getDriver();
  public A withDriver(String driver);
  public Boolean hasDriver();
  public String getFsType();
  public A withFsType(String fsType);
  public Boolean hasFsType();
  
  /**
   * This method has been deprecated, please use method buildNodePublishSecretRef instead.
   * @return The buildable object.
   */
  @Deprecated
  public LocalObjectReference getNodePublishSecretRef();
  public LocalObjectReference buildNodePublishSecretRef();
  public A withNodePublishSecretRef(LocalObjectReference nodePublishSecretRef);
  public Boolean hasNodePublishSecretRef();
  public A withNewNodePublishSecretRef(String name);
  public CSIVolumeSourceFluent.NodePublishSecretRefNested<A> withNewNodePublishSecretRef();
  public CSIVolumeSourceFluent.NodePublishSecretRefNested<A> withNewNodePublishSecretRefLike(LocalObjectReference item);
  public CSIVolumeSourceFluent.NodePublishSecretRefNested<A> editNodePublishSecretRef();
  public CSIVolumeSourceFluent.NodePublishSecretRefNested<A> editOrNewNodePublishSecretRef();
  public CSIVolumeSourceFluent.NodePublishSecretRefNested<A> editOrNewNodePublishSecretRefLike(LocalObjectReference item);
  public Boolean getReadOnly();
  public A withReadOnly(Boolean readOnly);
  public Boolean hasReadOnly();
  public A addToVolumeAttributes(String key,String value);
  public A addToVolumeAttributes(Map<String,String> map);
  public A removeFromVolumeAttributes(String key);
  public A removeFromVolumeAttributes(Map<String,String> map);
  public Map<String,String> getVolumeAttributes();
  public <K,V>A withVolumeAttributes(Map<String,String> volumeAttributes);
  public Boolean hasVolumeAttributes();
  public A addToAdditionalProperties(String key,Object value);
  public A addToAdditionalProperties(Map<String,Object> map);
  public A removeFromAdditionalProperties(String key);
  public A removeFromAdditionalProperties(Map<String,Object> map);
  public Map<String,Object> getAdditionalProperties();
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties);
  public Boolean hasAdditionalProperties();
  public A withReadOnly();
  public interface NodePublishSecretRefNested<N> extends Nested<N>,LocalObjectReferenceFluent<CSIVolumeSourceFluent.NodePublishSecretRefNested<N>>{
    public N and();
    public N endNodePublishSecretRef();
    
  }
  
}