package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class APIServiceStatusBuilder extends APIServiceStatusFluentImpl<APIServiceStatusBuilder> implements VisitableBuilder<APIServiceStatus,APIServiceStatusBuilder>{
  public APIServiceStatusBuilder() {
    this(false);
  }
  public APIServiceStatusBuilder(Boolean validationEnabled) {
    this(new APIServiceStatus(), validationEnabled);
  }
  public APIServiceStatusBuilder(APIServiceStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public APIServiceStatusBuilder(APIServiceStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new APIServiceStatus(), validationEnabled);
  }
  public APIServiceStatusBuilder(APIServiceStatusFluent<?> fluent,APIServiceStatus instance) {
    this(fluent, instance, false);
  }
  public APIServiceStatusBuilder(APIServiceStatusFluent<?> fluent,APIServiceStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withConditions(instance.getConditions());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public APIServiceStatusBuilder(APIServiceStatus instance) {
    this(instance,false);
  }
  public APIServiceStatusBuilder(APIServiceStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withConditions(instance.getConditions());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  APIServiceStatusFluent<?> fluent;
  Boolean validationEnabled;
  public APIServiceStatus build() {
    APIServiceStatus buildable = new APIServiceStatus(fluent.getConditions());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}