package io.fabric8.kubernetes.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.Integer;
import java.lang.Deprecated;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
public interface APIServiceSpecFluent<A extends APIServiceSpecFluent<A>> extends Fluent<A>{
  public String getCaBundle();
  public A withCaBundle(String caBundle);
  public Boolean hasCaBundle();
  public String getGroup();
  public A withGroup(String group);
  public Boolean hasGroup();
  public Integer getGroupPriorityMinimum();
  public A withGroupPriorityMinimum(Integer groupPriorityMinimum);
  public Boolean hasGroupPriorityMinimum();
  public Boolean getInsecureSkipTLSVerify();
  public A withInsecureSkipTLSVerify(Boolean insecureSkipTLSVerify);
  public Boolean hasInsecureSkipTLSVerify();
  
  /**
   * This method has been deprecated, please use method buildService instead.
   * @return The buildable object.
   */
  @Deprecated
  public ServiceReference getService();
  public ServiceReference buildService();
  public A withService(ServiceReference service);
  public Boolean hasService();
  public A withNewService(String name,String namespace,Integer port);
  public APIServiceSpecFluent.ServiceNested<A> withNewService();
  public APIServiceSpecFluent.ServiceNested<A> withNewServiceLike(ServiceReference item);
  public APIServiceSpecFluent.ServiceNested<A> editService();
  public APIServiceSpecFluent.ServiceNested<A> editOrNewService();
  public APIServiceSpecFluent.ServiceNested<A> editOrNewServiceLike(ServiceReference item);
  public String getVersion();
  public A withVersion(String version);
  public Boolean hasVersion();
  public Integer getVersionPriority();
  public A withVersionPriority(Integer versionPriority);
  public Boolean hasVersionPriority();
  public A addToAdditionalProperties(String key,Object value);
  public A addToAdditionalProperties(Map<String,Object> map);
  public A removeFromAdditionalProperties(String key);
  public A removeFromAdditionalProperties(Map<String,Object> map);
  public Map<String,Object> getAdditionalProperties();
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties);
  public Boolean hasAdditionalProperties();
  public A withInsecureSkipTLSVerify();
  public interface ServiceNested<N> extends Nested<N>,ServiceReferenceFluent<APIServiceSpecFluent.ServiceNested<N>>{
    public N and();
    public N endService();
    
  }
  
}