package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.builder.Fluent;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
public interface APIGroupFluent<A extends APIGroupFluent<A>> extends Fluent<A>{
  public String getApiVersion();
  public A withApiVersion(String apiVersion);
  public Boolean hasApiVersion();
  public String getKind();
  public A withKind(String kind);
  public Boolean hasKind();
  public String getName();
  public A withName(String name);
  public Boolean hasName();
  
  /**
   * This method has been deprecated, please use method buildPreferredVersion instead.
   * @return The buildable object.
   */
  @Deprecated
  public GroupVersionForDiscovery getPreferredVersion();
  public GroupVersionForDiscovery buildPreferredVersion();
  public A withPreferredVersion(GroupVersionForDiscovery preferredVersion);
  public Boolean hasPreferredVersion();
  public A withNewPreferredVersion(String groupVersion,String version);
  public APIGroupFluent.PreferredVersionNested<A> withNewPreferredVersion();
  public APIGroupFluent.PreferredVersionNested<A> withNewPreferredVersionLike(GroupVersionForDiscovery item);
  public APIGroupFluent.PreferredVersionNested<A> editPreferredVersion();
  public APIGroupFluent.PreferredVersionNested<A> editOrNewPreferredVersion();
  public APIGroupFluent.PreferredVersionNested<A> editOrNewPreferredVersionLike(GroupVersionForDiscovery item);
  public A addToServerAddressByClientCIDRs(int index,ServerAddressByClientCIDR item);
  public A setToServerAddressByClientCIDRs(int index,ServerAddressByClientCIDR item);
  public A addToServerAddressByClientCIDRs(io.fabric8.kubernetes.api.model.ServerAddressByClientCIDR... items);
  public A addAllToServerAddressByClientCIDRs(Collection<ServerAddressByClientCIDR> items);
  public A removeFromServerAddressByClientCIDRs(io.fabric8.kubernetes.api.model.ServerAddressByClientCIDR... items);
  public A removeAllFromServerAddressByClientCIDRs(Collection<ServerAddressByClientCIDR> items);
  public A removeMatchingFromServerAddressByClientCIDRs(Predicate<ServerAddressByClientCIDRBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildServerAddressByClientCIDRs instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<ServerAddressByClientCIDR> getServerAddressByClientCIDRs();
  public List<ServerAddressByClientCIDR> buildServerAddressByClientCIDRs();
  public ServerAddressByClientCIDR buildServerAddressByClientCIDR(int index);
  public ServerAddressByClientCIDR buildFirstServerAddressByClientCIDR();
  public ServerAddressByClientCIDR buildLastServerAddressByClientCIDR();
  public ServerAddressByClientCIDR buildMatchingServerAddressByClientCIDR(Predicate<ServerAddressByClientCIDRBuilder> predicate);
  public Boolean hasMatchingServerAddressByClientCIDR(Predicate<ServerAddressByClientCIDRBuilder> predicate);
  public A withServerAddressByClientCIDRs(List<ServerAddressByClientCIDR> serverAddressByClientCIDRs);
  public A withServerAddressByClientCIDRs(io.fabric8.kubernetes.api.model.ServerAddressByClientCIDR... serverAddressByClientCIDRs);
  public Boolean hasServerAddressByClientCIDRs();
  public A addNewServerAddressByClientCIDR(String clientCIDR,String serverAddress);
  public APIGroupFluent.ServerAddressByClientCIDRsNested<A> addNewServerAddressByClientCIDR();
  public APIGroupFluent.ServerAddressByClientCIDRsNested<A> addNewServerAddressByClientCIDRLike(ServerAddressByClientCIDR item);
  public APIGroupFluent.ServerAddressByClientCIDRsNested<A> setNewServerAddressByClientCIDRLike(int index,ServerAddressByClientCIDR item);
  public APIGroupFluent.ServerAddressByClientCIDRsNested<A> editServerAddressByClientCIDR(int index);
  public APIGroupFluent.ServerAddressByClientCIDRsNested<A> editFirstServerAddressByClientCIDR();
  public APIGroupFluent.ServerAddressByClientCIDRsNested<A> editLastServerAddressByClientCIDR();
  public APIGroupFluent.ServerAddressByClientCIDRsNested<A> editMatchingServerAddressByClientCIDR(Predicate<ServerAddressByClientCIDRBuilder> predicate);
  public A addToVersions(int index,GroupVersionForDiscovery item);
  public A setToVersions(int index,GroupVersionForDiscovery item);
  public A addToVersions(io.fabric8.kubernetes.api.model.GroupVersionForDiscovery... items);
  public A addAllToVersions(Collection<GroupVersionForDiscovery> items);
  public A removeFromVersions(io.fabric8.kubernetes.api.model.GroupVersionForDiscovery... items);
  public A removeAllFromVersions(Collection<GroupVersionForDiscovery> items);
  public A removeMatchingFromVersions(Predicate<GroupVersionForDiscoveryBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildVersions instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<GroupVersionForDiscovery> getVersions();
  public List<GroupVersionForDiscovery> buildVersions();
  public GroupVersionForDiscovery buildVersion(int index);
  public GroupVersionForDiscovery buildFirstVersion();
  public GroupVersionForDiscovery buildLastVersion();
  public GroupVersionForDiscovery buildMatchingVersion(Predicate<GroupVersionForDiscoveryBuilder> predicate);
  public Boolean hasMatchingVersion(Predicate<GroupVersionForDiscoveryBuilder> predicate);
  public A withVersions(List<GroupVersionForDiscovery> versions);
  public A withVersions(io.fabric8.kubernetes.api.model.GroupVersionForDiscovery... versions);
  public Boolean hasVersions();
  public A addNewVersion(String groupVersion,String version);
  public APIGroupFluent.VersionsNested<A> addNewVersion();
  public APIGroupFluent.VersionsNested<A> addNewVersionLike(GroupVersionForDiscovery item);
  public APIGroupFluent.VersionsNested<A> setNewVersionLike(int index,GroupVersionForDiscovery item);
  public APIGroupFluent.VersionsNested<A> editVersion(int index);
  public APIGroupFluent.VersionsNested<A> editFirstVersion();
  public APIGroupFluent.VersionsNested<A> editLastVersion();
  public APIGroupFluent.VersionsNested<A> editMatchingVersion(Predicate<GroupVersionForDiscoveryBuilder> predicate);
  public A addToAdditionalProperties(String key,Object value);
  public A addToAdditionalProperties(Map<String,Object> map);
  public A removeFromAdditionalProperties(String key);
  public A removeFromAdditionalProperties(Map<String,Object> map);
  public Map<String,Object> getAdditionalProperties();
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties);
  public Boolean hasAdditionalProperties();
  public interface PreferredVersionNested<N> extends Nested<N>,GroupVersionForDiscoveryFluent<APIGroupFluent.PreferredVersionNested<N>>{
    public N and();
    public N endPreferredVersion();
    
  }
  public interface ServerAddressByClientCIDRsNested<N> extends Nested<N>,ServerAddressByClientCIDRFluent<APIGroupFluent.ServerAddressByClientCIDRsNested<N>>{
    public N and();
    public N endServerAddressByClientCIDR();
    
  }
  public interface VersionsNested<N> extends Nested<N>,GroupVersionForDiscoveryFluent<APIGroupFluent.VersionsNested<N>>{
    public N and();
    public N endVersion();
    
  }
  
}