package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class StatusBuilder extends StatusFluentImpl<StatusBuilder> implements VisitableBuilder<Status,StatusBuilder>{
  public StatusBuilder() {
    this(false);
  }
  public StatusBuilder(Boolean validationEnabled) {
    this(new Status(), validationEnabled);
  }
  public StatusBuilder(StatusFluent<?> fluent) {
    this(fluent, false);
  }
  public StatusBuilder(StatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Status(), validationEnabled);
  }
  public StatusBuilder(StatusFluent<?> fluent,Status instance) {
    this(fluent, instance, false);
  }
  public StatusBuilder(StatusFluent<?> fluent,Status instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withCode(instance.getCode()); 
    fluent.withDetails(instance.getDetails()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMessage(instance.getMessage()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withReason(instance.getReason()); 
    fluent.withStatus(instance.getStatus()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public StatusBuilder(Status instance) {
    this(instance,false);
  }
  public StatusBuilder(Status instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withCode(instance.getCode()); 
    this.withDetails(instance.getDetails()); 
    this.withKind(instance.getKind()); 
    this.withMessage(instance.getMessage()); 
    this.withMetadata(instance.getMetadata()); 
    this.withReason(instance.getReason()); 
    this.withStatus(instance.getStatus()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  StatusFluent<?> fluent;
  Boolean validationEnabled;
  public Status build() {
    Status buildable = new Status(fluent.getApiVersion(),fluent.getCode(),fluent.getDetails(),fluent.getKind(),fluent.getMessage(),fluent.getMetadata(),fluent.getReason(),fluent.getStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}