package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ClusterFluentImpl<A extends ClusterFluent<A>> extends BaseFluent<A> implements ClusterFluent<A>{
  public ClusterFluentImpl() {
  }
  public ClusterFluentImpl(Cluster instance) {
    this.withCertificateAuthority(instance.getCertificateAuthority()); 
    this.withCertificateAuthorityData(instance.getCertificateAuthorityData()); 
    this.withDisableCompression(instance.getDisableCompression()); 
    this.withExtensions(instance.getExtensions()); 
    this.withInsecureSkipTlsVerify(instance.getInsecureSkipTlsVerify()); 
    this.withProxyUrl(instance.getProxyUrl()); 
    this.withServer(instance.getServer()); 
    this.withTlsServerName(instance.getTlsServerName()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private String certificateAuthority;
  private String certificateAuthorityData;
  private Boolean disableCompression;
  private ArrayList<NamedExtensionBuilder> extensions = new ArrayList<NamedExtensionBuilder>();
  private Boolean insecureSkipTlsVerify;
  private String proxyUrl;
  private String server;
  private String tlsServerName;
  private Map<String,Object> additionalProperties;
  public String getCertificateAuthority() {
    return this.certificateAuthority;
  }
  public A withCertificateAuthority(String certificateAuthority) {
    this.certificateAuthority=certificateAuthority; return (A) this;
  }
  public Boolean hasCertificateAuthority() {
    return this.certificateAuthority != null;
  }
  public String getCertificateAuthorityData() {
    return this.certificateAuthorityData;
  }
  public A withCertificateAuthorityData(String certificateAuthorityData) {
    this.certificateAuthorityData=certificateAuthorityData; return (A) this;
  }
  public Boolean hasCertificateAuthorityData() {
    return this.certificateAuthorityData != null;
  }
  public Boolean getDisableCompression() {
    return this.disableCompression;
  }
  public A withDisableCompression(Boolean disableCompression) {
    this.disableCompression=disableCompression; return (A) this;
  }
  public Boolean hasDisableCompression() {
    return this.disableCompression != null;
  }
  public A addToExtensions(Integer index,NamedExtension item) {
    if (this.extensions == null) {this.extensions = new ArrayList<NamedExtensionBuilder>();}
    NamedExtensionBuilder builder = new NamedExtensionBuilder(item);_visitables.get("extensions").add(index >= 0 ? index : _visitables.get("extensions").size(), builder);this.extensions.add(index >= 0 ? index : extensions.size(), builder); return (A)this;
  }
  public A setToExtensions(Integer index,NamedExtension item) {
    if (this.extensions == null) {this.extensions = new ArrayList<NamedExtensionBuilder>();}
    NamedExtensionBuilder builder = new NamedExtensionBuilder(item);
    if (index < 0 || index >= _visitables.get("extensions").size()) { _visitables.get("extensions").add(builder); } else { _visitables.get("extensions").set(index, builder);}
    if (index < 0 || index >= extensions.size()) { extensions.add(builder); } else { extensions.set(index, builder);}
     return (A)this;
  }
  public A addToExtensions(io.fabric8.kubernetes.api.model.NamedExtension... items) {
    if (this.extensions == null) {this.extensions = new ArrayList<NamedExtensionBuilder>();}
    for (NamedExtension item : items) {NamedExtensionBuilder builder = new NamedExtensionBuilder(item);_visitables.get("extensions").add(builder);this.extensions.add(builder);} return (A)this;
  }
  public A addAllToExtensions(Collection<NamedExtension> items) {
    if (this.extensions == null) {this.extensions = new ArrayList<NamedExtensionBuilder>();}
    for (NamedExtension item : items) {NamedExtensionBuilder builder = new NamedExtensionBuilder(item);_visitables.get("extensions").add(builder);this.extensions.add(builder);} return (A)this;
  }
  public A removeFromExtensions(io.fabric8.kubernetes.api.model.NamedExtension... items) {
    for (NamedExtension item : items) {NamedExtensionBuilder builder = new NamedExtensionBuilder(item);_visitables.get("extensions").remove(builder);if (this.extensions != null) {this.extensions.remove(builder);}} return (A)this;
  }
  public A removeAllFromExtensions(Collection<NamedExtension> items) {
    for (NamedExtension item : items) {NamedExtensionBuilder builder = new NamedExtensionBuilder(item);_visitables.get("extensions").remove(builder);if (this.extensions != null) {this.extensions.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromExtensions(Predicate<NamedExtensionBuilder> predicate) {
    if (extensions == null) return (A) this;
    final Iterator<NamedExtensionBuilder> each = extensions.iterator();
    final List visitables = _visitables.get("extensions");
    while (each.hasNext()) {
      NamedExtensionBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildExtensions instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<NamedExtension> getExtensions() {
    return extensions != null ? build(extensions) : null;
  }
  public List<NamedExtension> buildExtensions() {
    return extensions != null ? build(extensions) : null;
  }
  public NamedExtension buildExtension(Integer index) {
    return this.extensions.get(index).build();
  }
  public NamedExtension buildFirstExtension() {
    return this.extensions.get(0).build();
  }
  public NamedExtension buildLastExtension() {
    return this.extensions.get(extensions.size() - 1).build();
  }
  public NamedExtension buildMatchingExtension(Predicate<NamedExtensionBuilder> predicate) {
    for (NamedExtensionBuilder item: extensions) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingExtension(Predicate<NamedExtensionBuilder> predicate) {
    for (NamedExtensionBuilder item: extensions) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withExtensions(List<NamedExtension> extensions) {
    if (this.extensions != null) { _visitables.get("extensions").removeAll(this.extensions);}
    if (extensions != null) {this.extensions = new ArrayList(); for (NamedExtension item : extensions){this.addToExtensions(item);}} else { this.extensions = null;} return (A) this;
  }
  public A withExtensions(io.fabric8.kubernetes.api.model.NamedExtension... extensions) {
    if (this.extensions != null) {this.extensions.clear();}
    if (extensions != null) {for (NamedExtension item :extensions){ this.addToExtensions(item);}} return (A) this;
  }
  public Boolean hasExtensions() {
    return extensions != null && !extensions.isEmpty();
  }
  public ClusterFluent.ExtensionsNested<A> addNewExtension() {
    return new ClusterFluentImpl.ExtensionsNestedImpl();
  }
  public ClusterFluent.ExtensionsNested<A> addNewExtensionLike(NamedExtension item) {
    return new ClusterFluentImpl.ExtensionsNestedImpl(-1, item);
  }
  public ClusterFluent.ExtensionsNested<A> setNewExtensionLike(Integer index,NamedExtension item) {
    return new ClusterFluentImpl.ExtensionsNestedImpl(index, item);
  }
  public ClusterFluent.ExtensionsNested<A> editExtension(Integer index) {
    if (extensions.size() <= index) throw new RuntimeException("Can't edit extensions. Index exceeds size.");
    return setNewExtensionLike(index, buildExtension(index));
  }
  public ClusterFluent.ExtensionsNested<A> editFirstExtension() {
    if (extensions.size() == 0) throw new RuntimeException("Can't edit first extensions. The list is empty.");
    return setNewExtensionLike(0, buildExtension(0));
  }
  public ClusterFluent.ExtensionsNested<A> editLastExtension() {
    int index = extensions.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last extensions. The list is empty.");
    return setNewExtensionLike(index, buildExtension(index));
  }
  public ClusterFluent.ExtensionsNested<A> editMatchingExtension(Predicate<NamedExtensionBuilder> predicate) {
    int index = -1;
    for (int i=0;i<extensions.size();i++) { 
    if (predicate.test(extensions.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching extensions. No match found.");
    return setNewExtensionLike(index, buildExtension(index));
  }
  public Boolean getInsecureSkipTlsVerify() {
    return this.insecureSkipTlsVerify;
  }
  public A withInsecureSkipTlsVerify(Boolean insecureSkipTlsVerify) {
    this.insecureSkipTlsVerify=insecureSkipTlsVerify; return (A) this;
  }
  public Boolean hasInsecureSkipTlsVerify() {
    return this.insecureSkipTlsVerify != null;
  }
  public String getProxyUrl() {
    return this.proxyUrl;
  }
  public A withProxyUrl(String proxyUrl) {
    this.proxyUrl=proxyUrl; return (A) this;
  }
  public Boolean hasProxyUrl() {
    return this.proxyUrl != null;
  }
  public String getServer() {
    return this.server;
  }
  public A withServer(String server) {
    this.server=server; return (A) this;
  }
  public Boolean hasServer() {
    return this.server != null;
  }
  public String getTlsServerName() {
    return this.tlsServerName;
  }
  public A withTlsServerName(String tlsServerName) {
    this.tlsServerName=tlsServerName; return (A) this;
  }
  public Boolean hasTlsServerName() {
    return this.tlsServerName != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ClusterFluentImpl that = (ClusterFluentImpl) o;
    if (certificateAuthority != null ? !certificateAuthority.equals(that.certificateAuthority) :that.certificateAuthority != null) return false;
    if (certificateAuthorityData != null ? !certificateAuthorityData.equals(that.certificateAuthorityData) :that.certificateAuthorityData != null) return false;
    if (disableCompression != null ? !disableCompression.equals(that.disableCompression) :that.disableCompression != null) return false;
    if (extensions != null ? !extensions.equals(that.extensions) :that.extensions != null) return false;
    if (insecureSkipTlsVerify != null ? !insecureSkipTlsVerify.equals(that.insecureSkipTlsVerify) :that.insecureSkipTlsVerify != null) return false;
    if (proxyUrl != null ? !proxyUrl.equals(that.proxyUrl) :that.proxyUrl != null) return false;
    if (server != null ? !server.equals(that.server) :that.server != null) return false;
    if (tlsServerName != null ? !tlsServerName.equals(that.tlsServerName) :that.tlsServerName != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(certificateAuthority,  certificateAuthorityData,  disableCompression,  extensions,  insecureSkipTlsVerify,  proxyUrl,  server,  tlsServerName,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (certificateAuthority != null) { sb.append("certificateAuthority:"); sb.append(certificateAuthority + ","); }
    if (certificateAuthorityData != null) { sb.append("certificateAuthorityData:"); sb.append(certificateAuthorityData + ","); }
    if (disableCompression != null) { sb.append("disableCompression:"); sb.append(disableCompression + ","); }
    if (extensions != null && !extensions.isEmpty()) { sb.append("extensions:"); sb.append(extensions + ","); }
    if (insecureSkipTlsVerify != null) { sb.append("insecureSkipTlsVerify:"); sb.append(insecureSkipTlsVerify + ","); }
    if (proxyUrl != null) { sb.append("proxyUrl:"); sb.append(proxyUrl + ","); }
    if (server != null) { sb.append("server:"); sb.append(server + ","); }
    if (tlsServerName != null) { sb.append("tlsServerName:"); sb.append(tlsServerName + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public A withDisableCompression() {
    return withDisableCompression(true);
  }
  public A withInsecureSkipTlsVerify() {
    return withInsecureSkipTlsVerify(true);
  }
  class ExtensionsNestedImpl<N> extends NamedExtensionFluentImpl<ClusterFluent.ExtensionsNested<N>> implements ClusterFluent.ExtensionsNested<N>,Nested<N>{
    ExtensionsNestedImpl(Integer index,NamedExtension item) {
      this.index = index;
      this.builder = new NamedExtensionBuilder(this, item);
    }
    ExtensionsNestedImpl() {
      this.index = -1;
      this.builder = new NamedExtensionBuilder(this);
    }
    NamedExtensionBuilder builder;
    Integer index;
    public N and() {
      return (N) ClusterFluentImpl.this.setToExtensions(index,builder.build());
    }
    public N endExtension() {
      return and();
    }
    
  }
  
}