package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class SysctlBuilder extends SysctlFluentImpl<SysctlBuilder> implements VisitableBuilder<Sysctl,SysctlBuilder>{
  public SysctlBuilder() {
    this(false);
  }
  public SysctlBuilder(Boolean validationEnabled) {
    this(new Sysctl(), validationEnabled);
  }
  public SysctlBuilder(SysctlFluent<?> fluent) {
    this(fluent, false);
  }
  public SysctlBuilder(SysctlFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Sysctl(), validationEnabled);
  }
  public SysctlBuilder(SysctlFluent<?> fluent,Sysctl instance) {
    this(fluent, instance, false);
  }
  public SysctlBuilder(SysctlFluent<?> fluent,Sysctl instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withName(instance.getName()); 
    fluent.withValue(instance.getValue()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public SysctlBuilder(Sysctl instance) {
    this(instance,false);
  }
  public SysctlBuilder(Sysctl instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withName(instance.getName()); 
    this.withValue(instance.getValue()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  SysctlFluent<?> fluent;
  Boolean validationEnabled;
  public Sysctl build() {
    Sysctl buildable = new Sysctl(fluent.getName(),fluent.getValue());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}