package io.fabric8.kubernetes.api.model;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.Integer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Long;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class StatusFluentImpl<A extends StatusFluent<A>> extends BaseFluent<A> implements StatusFluent<A>{
  public StatusFluentImpl() {
  }
  public StatusFluentImpl(Status instance) {
    this.withApiVersion(instance.getApiVersion()); 
    this.withCode(instance.getCode()); 
    this.withDetails(instance.getDetails()); 
    this.withKind(instance.getKind()); 
    this.withMessage(instance.getMessage()); 
    this.withMetadata(instance.getMetadata()); 
    this.withReason(instance.getReason()); 
    this.withStatus(instance.getStatus()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private String apiVersion;
  private Integer code;
  private StatusDetailsBuilder details;
  private String kind;
  private String message;
  private ListMetaBuilder metadata;
  private String reason;
  private String status;
  private Map<String,Object> additionalProperties;
  public String getApiVersion() {
    return this.apiVersion;
  }
  public A withApiVersion(String apiVersion) {
    this.apiVersion=apiVersion; return (A) this;
  }
  public Boolean hasApiVersion() {
    return this.apiVersion != null;
  }
  public Integer getCode() {
    return this.code;
  }
  public A withCode(Integer code) {
    this.code=code; return (A) this;
  }
  public Boolean hasCode() {
    return this.code != null;
  }
  
  /**
   * This method has been deprecated, please use method buildDetails instead.
   * @return The buildable object.
   */
  @Deprecated
  public StatusDetails getDetails() {
    return this.details!=null ?this.details.build():null;
  }
  public StatusDetails buildDetails() {
    return this.details!=null ?this.details.build():null;
  }
  public A withDetails(StatusDetails details) {
    _visitables.get("details").remove(this.details);
    if (details!=null){ this.details= new StatusDetailsBuilder(details); _visitables.get("details").add(this.details);} else { this.details = null; _visitables.get("details").remove(this.details); } return (A) this;
  }
  public Boolean hasDetails() {
    return this.details != null;
  }
  public StatusFluent.DetailsNested<A> withNewDetails() {
    return new StatusFluentImpl.DetailsNestedImpl();
  }
  public StatusFluent.DetailsNested<A> withNewDetailsLike(StatusDetails item) {
    return new StatusFluentImpl.DetailsNestedImpl(item);
  }
  public StatusFluent.DetailsNested<A> editDetails() {
    return withNewDetailsLike(getDetails());
  }
  public StatusFluent.DetailsNested<A> editOrNewDetails() {
    return withNewDetailsLike(getDetails() != null ? getDetails(): new StatusDetailsBuilder().build());
  }
  public StatusFluent.DetailsNested<A> editOrNewDetailsLike(StatusDetails item) {
    return withNewDetailsLike(getDetails() != null ? getDetails(): item);
  }
  public String getKind() {
    return this.kind;
  }
  public A withKind(String kind) {
    this.kind=kind; return (A) this;
  }
  public Boolean hasKind() {
    return this.kind != null;
  }
  public String getMessage() {
    return this.message;
  }
  public A withMessage(String message) {
    this.message=message; return (A) this;
  }
  public Boolean hasMessage() {
    return this.message != null;
  }
  
  /**
   * This method has been deprecated, please use method buildMetadata instead.
   * @return The buildable object.
   */
  @Deprecated
  public ListMeta getMetadata() {
    return this.metadata!=null ?this.metadata.build():null;
  }
  public ListMeta buildMetadata() {
    return this.metadata!=null ?this.metadata.build():null;
  }
  public A withMetadata(ListMeta metadata) {
    _visitables.get("metadata").remove(this.metadata);
    if (metadata!=null){ this.metadata= new ListMetaBuilder(metadata); _visitables.get("metadata").add(this.metadata);} else { this.metadata = null; _visitables.get("metadata").remove(this.metadata); } return (A) this;
  }
  public Boolean hasMetadata() {
    return this.metadata != null;
  }
  public A withNewMetadata(String _continue,Long remainingItemCount,String resourceVersion,String selfLink) {
    return (A)withMetadata(new ListMeta(_continue, remainingItemCount, resourceVersion, selfLink));
  }
  public StatusFluent.MetadataNested<A> withNewMetadata() {
    return new StatusFluentImpl.MetadataNestedImpl();
  }
  public StatusFluent.MetadataNested<A> withNewMetadataLike(ListMeta item) {
    return new StatusFluentImpl.MetadataNestedImpl(item);
  }
  public StatusFluent.MetadataNested<A> editMetadata() {
    return withNewMetadataLike(getMetadata());
  }
  public StatusFluent.MetadataNested<A> editOrNewMetadata() {
    return withNewMetadataLike(getMetadata() != null ? getMetadata(): new ListMetaBuilder().build());
  }
  public StatusFluent.MetadataNested<A> editOrNewMetadataLike(ListMeta item) {
    return withNewMetadataLike(getMetadata() != null ? getMetadata(): item);
  }
  public String getReason() {
    return this.reason;
  }
  public A withReason(String reason) {
    this.reason=reason; return (A) this;
  }
  public Boolean hasReason() {
    return this.reason != null;
  }
  public String getStatus() {
    return this.status;
  }
  public A withStatus(String status) {
    this.status=status; return (A) this;
  }
  public Boolean hasStatus() {
    return this.status != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    StatusFluentImpl that = (StatusFluentImpl) o;
    if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
    if (code != null ? !code.equals(that.code) :that.code != null) return false;
    if (details != null ? !details.equals(that.details) :that.details != null) return false;
    if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
    if (message != null ? !message.equals(that.message) :that.message != null) return false;
    if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
    if (reason != null ? !reason.equals(that.reason) :that.reason != null) return false;
    if (status != null ? !status.equals(that.status) :that.status != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(apiVersion,  code,  details,  kind,  message,  metadata,  reason,  status,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (apiVersion != null) { sb.append("apiVersion:"); sb.append(apiVersion + ","); }
    if (code != null) { sb.append("code:"); sb.append(code + ","); }
    if (details != null) { sb.append("details:"); sb.append(details + ","); }
    if (kind != null) { sb.append("kind:"); sb.append(kind + ","); }
    if (message != null) { sb.append("message:"); sb.append(message + ","); }
    if (metadata != null) { sb.append("metadata:"); sb.append(metadata + ","); }
    if (reason != null) { sb.append("reason:"); sb.append(reason + ","); }
    if (status != null) { sb.append("status:"); sb.append(status + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class DetailsNestedImpl<N> extends StatusDetailsFluentImpl<StatusFluent.DetailsNested<N>> implements StatusFluent.DetailsNested<N>,Nested<N>{
    DetailsNestedImpl(StatusDetails item) {
      this.builder = new StatusDetailsBuilder(this, item);
    }
    DetailsNestedImpl() {
      this.builder = new StatusDetailsBuilder(this);
    }
    StatusDetailsBuilder builder;
    public N and() {
      return (N) StatusFluentImpl.this.withDetails(builder.build());
    }
    public N endDetails() {
      return and();
    }
    
  }
  class MetadataNestedImpl<N> extends ListMetaFluentImpl<StatusFluent.MetadataNested<N>> implements StatusFluent.MetadataNested<N>,Nested<N>{
    MetadataNestedImpl(ListMeta item) {
      this.builder = new ListMetaBuilder(this, item);
    }
    MetadataNestedImpl() {
      this.builder = new ListMetaBuilder(this);
    }
    ListMetaBuilder builder;
    public N and() {
      return (N) StatusFluentImpl.this.withMetadata(builder.build());
    }
    public N endMetadata() {
      return and();
    }
    
  }
  
}