package io.fabric8.kubernetes.api.model;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ManagedFieldsEntryFluentImpl<A extends ManagedFieldsEntryFluent<A>> extends BaseFluent<A> implements ManagedFieldsEntryFluent<A>{
  public ManagedFieldsEntryFluentImpl() {
  }
  public ManagedFieldsEntryFluentImpl(ManagedFieldsEntry instance) {
    this.withApiVersion(instance.getApiVersion()); 
    this.withFieldsType(instance.getFieldsType()); 
    this.withFieldsV1(instance.getFieldsV1()); 
    this.withManager(instance.getManager()); 
    this.withOperation(instance.getOperation()); 
    this.withSubresource(instance.getSubresource()); 
    this.withTime(instance.getTime()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private String apiVersion;
  private String fieldsType;
  private FieldsV1Builder fieldsV1;
  private String manager;
  private String operation;
  private String subresource;
  private String time;
  private Map<String,Object> additionalProperties;
  public String getApiVersion() {
    return this.apiVersion;
  }
  public A withApiVersion(String apiVersion) {
    this.apiVersion=apiVersion; return (A) this;
  }
  public Boolean hasApiVersion() {
    return this.apiVersion != null;
  }
  public String getFieldsType() {
    return this.fieldsType;
  }
  public A withFieldsType(String fieldsType) {
    this.fieldsType=fieldsType; return (A) this;
  }
  public Boolean hasFieldsType() {
    return this.fieldsType != null;
  }
  
  /**
   * This method has been deprecated, please use method buildFieldsV1 instead.
   * @return The buildable object.
   */
  @Deprecated
  public FieldsV1 getFieldsV1() {
    return this.fieldsV1!=null ?this.fieldsV1.build():null;
  }
  public FieldsV1 buildFieldsV1() {
    return this.fieldsV1!=null ?this.fieldsV1.build():null;
  }
  public A withFieldsV1(FieldsV1 fieldsV1) {
    _visitables.get("fieldsV1").remove(this.fieldsV1);
    if (fieldsV1!=null){ this.fieldsV1= new FieldsV1Builder(fieldsV1); _visitables.get("fieldsV1").add(this.fieldsV1);} else { this.fieldsV1 = null; _visitables.get("fieldsV1").remove(this.fieldsV1); } return (A) this;
  }
  public Boolean hasFieldsV1() {
    return this.fieldsV1 != null;
  }
  public ManagedFieldsEntryFluent.FieldsV1Nested<A> withNewFieldsV1() {
    return new ManagedFieldsEntryFluentImpl.FieldsV1NestedImpl();
  }
  public ManagedFieldsEntryFluent.FieldsV1Nested<A> withNewFieldsV1Like(FieldsV1 item) {
    return new ManagedFieldsEntryFluentImpl.FieldsV1NestedImpl(item);
  }
  public ManagedFieldsEntryFluent.FieldsV1Nested<A> editFieldsV1() {
    return withNewFieldsV1Like(getFieldsV1());
  }
  public ManagedFieldsEntryFluent.FieldsV1Nested<A> editOrNewFieldsV1() {
    return withNewFieldsV1Like(getFieldsV1() != null ? getFieldsV1(): new FieldsV1Builder().build());
  }
  public ManagedFieldsEntryFluent.FieldsV1Nested<A> editOrNewFieldsV1Like(FieldsV1 item) {
    return withNewFieldsV1Like(getFieldsV1() != null ? getFieldsV1(): item);
  }
  public String getManager() {
    return this.manager;
  }
  public A withManager(String manager) {
    this.manager=manager; return (A) this;
  }
  public Boolean hasManager() {
    return this.manager != null;
  }
  public String getOperation() {
    return this.operation;
  }
  public A withOperation(String operation) {
    this.operation=operation; return (A) this;
  }
  public Boolean hasOperation() {
    return this.operation != null;
  }
  public String getSubresource() {
    return this.subresource;
  }
  public A withSubresource(String subresource) {
    this.subresource=subresource; return (A) this;
  }
  public Boolean hasSubresource() {
    return this.subresource != null;
  }
  public String getTime() {
    return this.time;
  }
  public A withTime(String time) {
    this.time=time; return (A) this;
  }
  public Boolean hasTime() {
    return this.time != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ManagedFieldsEntryFluentImpl that = (ManagedFieldsEntryFluentImpl) o;
    if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
    if (fieldsType != null ? !fieldsType.equals(that.fieldsType) :that.fieldsType != null) return false;
    if (fieldsV1 != null ? !fieldsV1.equals(that.fieldsV1) :that.fieldsV1 != null) return false;
    if (manager != null ? !manager.equals(that.manager) :that.manager != null) return false;
    if (operation != null ? !operation.equals(that.operation) :that.operation != null) return false;
    if (subresource != null ? !subresource.equals(that.subresource) :that.subresource != null) return false;
    if (time != null ? !time.equals(that.time) :that.time != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(apiVersion,  fieldsType,  fieldsV1,  manager,  operation,  subresource,  time,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (apiVersion != null) { sb.append("apiVersion:"); sb.append(apiVersion + ","); }
    if (fieldsType != null) { sb.append("fieldsType:"); sb.append(fieldsType + ","); }
    if (fieldsV1 != null) { sb.append("fieldsV1:"); sb.append(fieldsV1 + ","); }
    if (manager != null) { sb.append("manager:"); sb.append(manager + ","); }
    if (operation != null) { sb.append("operation:"); sb.append(operation + ","); }
    if (subresource != null) { sb.append("subresource:"); sb.append(subresource + ","); }
    if (time != null) { sb.append("time:"); sb.append(time + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class FieldsV1NestedImpl<N> extends FieldsV1FluentImpl<ManagedFieldsEntryFluent.FieldsV1Nested<N>> implements ManagedFieldsEntryFluent.FieldsV1Nested<N>,Nested<N>{
    FieldsV1NestedImpl(FieldsV1 item) {
      this.builder = new FieldsV1Builder(this, item);
    }
    FieldsV1NestedImpl() {
      this.builder = new FieldsV1Builder(this);
    }
    FieldsV1Builder builder;
    public N and() {
      return (N) ManagedFieldsEntryFluentImpl.this.withFieldsV1(builder.build());
    }
    public N endFieldsV1() {
      return and();
    }
    
  }
  
}