package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.lang.Integer;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class EndpointsFluentImpl<A extends EndpointsFluent<A>> extends BaseFluent<A> implements EndpointsFluent<A>{
  public EndpointsFluentImpl() {
  }
  public EndpointsFluentImpl(Endpoints instance) {
    this.withApiVersion(instance.getApiVersion()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withSubsets(instance.getSubsets()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private String apiVersion;
  private String kind;
  private ObjectMetaBuilder metadata;
  private ArrayList<EndpointSubsetBuilder> subsets = new ArrayList<EndpointSubsetBuilder>();
  private Map<String,Object> additionalProperties;
  public String getApiVersion() {
    return this.apiVersion;
  }
  public A withApiVersion(String apiVersion) {
    this.apiVersion=apiVersion; return (A) this;
  }
  public Boolean hasApiVersion() {
    return this.apiVersion != null;
  }
  public String getKind() {
    return this.kind;
  }
  public A withKind(String kind) {
    this.kind=kind; return (A) this;
  }
  public Boolean hasKind() {
    return this.kind != null;
  }
  
  /**
   * This method has been deprecated, please use method buildMetadata instead.
   * @return The buildable object.
   */
  @Deprecated
  public ObjectMeta getMetadata() {
    return this.metadata!=null ?this.metadata.build():null;
  }
  public ObjectMeta buildMetadata() {
    return this.metadata!=null ?this.metadata.build():null;
  }
  public A withMetadata(ObjectMeta metadata) {
    _visitables.get("metadata").remove(this.metadata);
    if (metadata!=null){ this.metadata= new ObjectMetaBuilder(metadata); _visitables.get("metadata").add(this.metadata);} else { this.metadata = null; _visitables.get("metadata").remove(this.metadata); } return (A) this;
  }
  public Boolean hasMetadata() {
    return this.metadata != null;
  }
  public EndpointsFluent.MetadataNested<A> withNewMetadata() {
    return new EndpointsFluentImpl.MetadataNestedImpl();
  }
  public EndpointsFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
    return new EndpointsFluentImpl.MetadataNestedImpl(item);
  }
  public EndpointsFluent.MetadataNested<A> editMetadata() {
    return withNewMetadataLike(getMetadata());
  }
  public EndpointsFluent.MetadataNested<A> editOrNewMetadata() {
    return withNewMetadataLike(getMetadata() != null ? getMetadata(): new ObjectMetaBuilder().build());
  }
  public EndpointsFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
    return withNewMetadataLike(getMetadata() != null ? getMetadata(): item);
  }
  public A addToSubsets(Integer index,EndpointSubset item) {
    if (this.subsets == null) {this.subsets = new ArrayList<EndpointSubsetBuilder>();}
    EndpointSubsetBuilder builder = new EndpointSubsetBuilder(item);_visitables.get("subsets").add(index >= 0 ? index : _visitables.get("subsets").size(), builder);this.subsets.add(index >= 0 ? index : subsets.size(), builder); return (A)this;
  }
  public A setToSubsets(Integer index,EndpointSubset item) {
    if (this.subsets == null) {this.subsets = new ArrayList<EndpointSubsetBuilder>();}
    EndpointSubsetBuilder builder = new EndpointSubsetBuilder(item);
    if (index < 0 || index >= _visitables.get("subsets").size()) { _visitables.get("subsets").add(builder); } else { _visitables.get("subsets").set(index, builder);}
    if (index < 0 || index >= subsets.size()) { subsets.add(builder); } else { subsets.set(index, builder);}
     return (A)this;
  }
  public A addToSubsets(io.fabric8.kubernetes.api.model.EndpointSubset... items) {
    if (this.subsets == null) {this.subsets = new ArrayList<EndpointSubsetBuilder>();}
    for (EndpointSubset item : items) {EndpointSubsetBuilder builder = new EndpointSubsetBuilder(item);_visitables.get("subsets").add(builder);this.subsets.add(builder);} return (A)this;
  }
  public A addAllToSubsets(Collection<EndpointSubset> items) {
    if (this.subsets == null) {this.subsets = new ArrayList<EndpointSubsetBuilder>();}
    for (EndpointSubset item : items) {EndpointSubsetBuilder builder = new EndpointSubsetBuilder(item);_visitables.get("subsets").add(builder);this.subsets.add(builder);} return (A)this;
  }
  public A removeFromSubsets(io.fabric8.kubernetes.api.model.EndpointSubset... items) {
    for (EndpointSubset item : items) {EndpointSubsetBuilder builder = new EndpointSubsetBuilder(item);_visitables.get("subsets").remove(builder);if (this.subsets != null) {this.subsets.remove(builder);}} return (A)this;
  }
  public A removeAllFromSubsets(Collection<EndpointSubset> items) {
    for (EndpointSubset item : items) {EndpointSubsetBuilder builder = new EndpointSubsetBuilder(item);_visitables.get("subsets").remove(builder);if (this.subsets != null) {this.subsets.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromSubsets(Predicate<EndpointSubsetBuilder> predicate) {
    if (subsets == null) return (A) this;
    final Iterator<EndpointSubsetBuilder> each = subsets.iterator();
    final List visitables = _visitables.get("subsets");
    while (each.hasNext()) {
      EndpointSubsetBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildSubsets instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<EndpointSubset> getSubsets() {
    return subsets != null ? build(subsets) : null;
  }
  public List<EndpointSubset> buildSubsets() {
    return subsets != null ? build(subsets) : null;
  }
  public EndpointSubset buildSubset(Integer index) {
    return this.subsets.get(index).build();
  }
  public EndpointSubset buildFirstSubset() {
    return this.subsets.get(0).build();
  }
  public EndpointSubset buildLastSubset() {
    return this.subsets.get(subsets.size() - 1).build();
  }
  public EndpointSubset buildMatchingSubset(Predicate<EndpointSubsetBuilder> predicate) {
    for (EndpointSubsetBuilder item: subsets) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingSubset(Predicate<EndpointSubsetBuilder> predicate) {
    for (EndpointSubsetBuilder item: subsets) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withSubsets(List<EndpointSubset> subsets) {
    if (this.subsets != null) { _visitables.get("subsets").removeAll(this.subsets);}
    if (subsets != null) {this.subsets = new ArrayList(); for (EndpointSubset item : subsets){this.addToSubsets(item);}} else { this.subsets = null;} return (A) this;
  }
  public A withSubsets(io.fabric8.kubernetes.api.model.EndpointSubset... subsets) {
    if (this.subsets != null) {this.subsets.clear();}
    if (subsets != null) {for (EndpointSubset item :subsets){ this.addToSubsets(item);}} return (A) this;
  }
  public Boolean hasSubsets() {
    return subsets != null && !subsets.isEmpty();
  }
  public EndpointsFluent.SubsetsNested<A> addNewSubset() {
    return new EndpointsFluentImpl.SubsetsNestedImpl();
  }
  public EndpointsFluent.SubsetsNested<A> addNewSubsetLike(EndpointSubset item) {
    return new EndpointsFluentImpl.SubsetsNestedImpl(-1, item);
  }
  public EndpointsFluent.SubsetsNested<A> setNewSubsetLike(Integer index,EndpointSubset item) {
    return new EndpointsFluentImpl.SubsetsNestedImpl(index, item);
  }
  public EndpointsFluent.SubsetsNested<A> editSubset(Integer index) {
    if (subsets.size() <= index) throw new RuntimeException("Can't edit subsets. Index exceeds size.");
    return setNewSubsetLike(index, buildSubset(index));
  }
  public EndpointsFluent.SubsetsNested<A> editFirstSubset() {
    if (subsets.size() == 0) throw new RuntimeException("Can't edit first subsets. The list is empty.");
    return setNewSubsetLike(0, buildSubset(0));
  }
  public EndpointsFluent.SubsetsNested<A> editLastSubset() {
    int index = subsets.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last subsets. The list is empty.");
    return setNewSubsetLike(index, buildSubset(index));
  }
  public EndpointsFluent.SubsetsNested<A> editMatchingSubset(Predicate<EndpointSubsetBuilder> predicate) {
    int index = -1;
    for (int i=0;i<subsets.size();i++) { 
    if (predicate.test(subsets.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching subsets. No match found.");
    return setNewSubsetLike(index, buildSubset(index));
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    EndpointsFluentImpl that = (EndpointsFluentImpl) o;
    if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
    if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
    if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
    if (subsets != null ? !subsets.equals(that.subsets) :that.subsets != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(apiVersion,  kind,  metadata,  subsets,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (apiVersion != null) { sb.append("apiVersion:"); sb.append(apiVersion + ","); }
    if (kind != null) { sb.append("kind:"); sb.append(kind + ","); }
    if (metadata != null) { sb.append("metadata:"); sb.append(metadata + ","); }
    if (subsets != null && !subsets.isEmpty()) { sb.append("subsets:"); sb.append(subsets + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class MetadataNestedImpl<N> extends ObjectMetaFluentImpl<EndpointsFluent.MetadataNested<N>> implements EndpointsFluent.MetadataNested<N>,Nested<N>{
    MetadataNestedImpl(ObjectMeta item) {
      this.builder = new ObjectMetaBuilder(this, item);
    }
    MetadataNestedImpl() {
      this.builder = new ObjectMetaBuilder(this);
    }
    ObjectMetaBuilder builder;
    public N and() {
      return (N) EndpointsFluentImpl.this.withMetadata(builder.build());
    }
    public N endMetadata() {
      return and();
    }
    
  }
  class SubsetsNestedImpl<N> extends EndpointSubsetFluentImpl<EndpointsFluent.SubsetsNested<N>> implements EndpointsFluent.SubsetsNested<N>,Nested<N>{
    SubsetsNestedImpl(Integer index,EndpointSubset item) {
      this.index = index;
      this.builder = new EndpointSubsetBuilder(this, item);
    }
    SubsetsNestedImpl() {
      this.index = -1;
      this.builder = new EndpointSubsetBuilder(this);
    }
    EndpointSubsetBuilder builder;
    Integer index;
    public N and() {
      return (N) EndpointsFluentImpl.this.setToSubsets(index,builder.build());
    }
    public N endSubset() {
      return and();
    }
    
  }
  
}