package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PersistentVolumeClaimStatusBuilder extends PersistentVolumeClaimStatusFluentImpl<PersistentVolumeClaimStatusBuilder> implements VisitableBuilder<PersistentVolumeClaimStatus,PersistentVolumeClaimStatusBuilder>{
  public PersistentVolumeClaimStatusBuilder() {
    this(false);
  }
  public PersistentVolumeClaimStatusBuilder(Boolean validationEnabled) {
    this(new PersistentVolumeClaimStatus(), validationEnabled);
  }
  public PersistentVolumeClaimStatusBuilder(PersistentVolumeClaimStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public PersistentVolumeClaimStatusBuilder(PersistentVolumeClaimStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new PersistentVolumeClaimStatus(), validationEnabled);
  }
  public PersistentVolumeClaimStatusBuilder(PersistentVolumeClaimStatusFluent<?> fluent,PersistentVolumeClaimStatus instance) {
    this(fluent, instance, false);
  }
  public PersistentVolumeClaimStatusBuilder(PersistentVolumeClaimStatusFluent<?> fluent,PersistentVolumeClaimStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withAccessModes(instance.getAccessModes()); 
    fluent.withAllocatedResources(instance.getAllocatedResources()); 
    fluent.withCapacity(instance.getCapacity()); 
    fluent.withConditions(instance.getConditions()); 
    fluent.withPhase(instance.getPhase()); 
    fluent.withResizeStatus(instance.getResizeStatus()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public PersistentVolumeClaimStatusBuilder(PersistentVolumeClaimStatus instance) {
    this(instance,false);
  }
  public PersistentVolumeClaimStatusBuilder(PersistentVolumeClaimStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withAccessModes(instance.getAccessModes()); 
    this.withAllocatedResources(instance.getAllocatedResources()); 
    this.withCapacity(instance.getCapacity()); 
    this.withConditions(instance.getConditions()); 
    this.withPhase(instance.getPhase()); 
    this.withResizeStatus(instance.getResizeStatus()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  PersistentVolumeClaimStatusFluent<?> fluent;
  Boolean validationEnabled;
  public PersistentVolumeClaimStatus build() {
    PersistentVolumeClaimStatus buildable = new PersistentVolumeClaimStatus(fluent.getAccessModes(),fluent.getAllocatedResources(),fluent.getCapacity(),fluent.getConditions(),fluent.getPhase(),fluent.getResizeStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}