package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ProjectedVolumeSourceFluentImpl<A extends ProjectedVolumeSourceFluent<A>> extends BaseFluent<A> implements ProjectedVolumeSourceFluent<A>{
  public ProjectedVolumeSourceFluentImpl() {
  }
  public ProjectedVolumeSourceFluentImpl(ProjectedVolumeSource instance) {
    this.withDefaultMode(instance.getDefaultMode()); 
    this.withSources(instance.getSources()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private Integer defaultMode;
  private ArrayList<VolumeProjectionBuilder> sources = new ArrayList<VolumeProjectionBuilder>();
  private Map<String,Object> additionalProperties;
  public Integer getDefaultMode() {
    return this.defaultMode;
  }
  public A withDefaultMode(Integer defaultMode) {
    this.defaultMode=defaultMode; return (A) this;
  }
  public Boolean hasDefaultMode() {
    return this.defaultMode != null;
  }
  public A addToSources(Integer index,VolumeProjection item) {
    if (this.sources == null) {this.sources = new ArrayList<VolumeProjectionBuilder>();}
    VolumeProjectionBuilder builder = new VolumeProjectionBuilder(item);_visitables.get("sources").add(index >= 0 ? index : _visitables.get("sources").size(), builder);this.sources.add(index >= 0 ? index : sources.size(), builder); return (A)this;
  }
  public A setToSources(Integer index,VolumeProjection item) {
    if (this.sources == null) {this.sources = new ArrayList<VolumeProjectionBuilder>();}
    VolumeProjectionBuilder builder = new VolumeProjectionBuilder(item);
    if (index < 0 || index >= _visitables.get("sources").size()) { _visitables.get("sources").add(builder); } else { _visitables.get("sources").set(index, builder);}
    if (index < 0 || index >= sources.size()) { sources.add(builder); } else { sources.set(index, builder);}
     return (A)this;
  }
  public A addToSources(io.fabric8.kubernetes.api.model.VolumeProjection... items) {
    if (this.sources == null) {this.sources = new ArrayList<VolumeProjectionBuilder>();}
    for (VolumeProjection item : items) {VolumeProjectionBuilder builder = new VolumeProjectionBuilder(item);_visitables.get("sources").add(builder);this.sources.add(builder);} return (A)this;
  }
  public A addAllToSources(Collection<VolumeProjection> items) {
    if (this.sources == null) {this.sources = new ArrayList<VolumeProjectionBuilder>();}
    for (VolumeProjection item : items) {VolumeProjectionBuilder builder = new VolumeProjectionBuilder(item);_visitables.get("sources").add(builder);this.sources.add(builder);} return (A)this;
  }
  public A removeFromSources(io.fabric8.kubernetes.api.model.VolumeProjection... items) {
    for (VolumeProjection item : items) {VolumeProjectionBuilder builder = new VolumeProjectionBuilder(item);_visitables.get("sources").remove(builder);if (this.sources != null) {this.sources.remove(builder);}} return (A)this;
  }
  public A removeAllFromSources(Collection<VolumeProjection> items) {
    for (VolumeProjection item : items) {VolumeProjectionBuilder builder = new VolumeProjectionBuilder(item);_visitables.get("sources").remove(builder);if (this.sources != null) {this.sources.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromSources(Predicate<VolumeProjectionBuilder> predicate) {
    if (sources == null) return (A) this;
    final Iterator<VolumeProjectionBuilder> each = sources.iterator();
    final List visitables = _visitables.get("sources");
    while (each.hasNext()) {
      VolumeProjectionBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildSources instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<VolumeProjection> getSources() {
    return sources != null ? build(sources) : null;
  }
  public List<VolumeProjection> buildSources() {
    return sources != null ? build(sources) : null;
  }
  public VolumeProjection buildSource(Integer index) {
    return this.sources.get(index).build();
  }
  public VolumeProjection buildFirstSource() {
    return this.sources.get(0).build();
  }
  public VolumeProjection buildLastSource() {
    return this.sources.get(sources.size() - 1).build();
  }
  public VolumeProjection buildMatchingSource(Predicate<VolumeProjectionBuilder> predicate) {
    for (VolumeProjectionBuilder item: sources) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingSource(Predicate<VolumeProjectionBuilder> predicate) {
    for (VolumeProjectionBuilder item: sources) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withSources(List<VolumeProjection> sources) {
    if (this.sources != null) { _visitables.get("sources").removeAll(this.sources);}
    if (sources != null) {this.sources = new ArrayList(); for (VolumeProjection item : sources){this.addToSources(item);}} else { this.sources = null;} return (A) this;
  }
  public A withSources(io.fabric8.kubernetes.api.model.VolumeProjection... sources) {
    if (this.sources != null) {this.sources.clear();}
    if (sources != null) {for (VolumeProjection item :sources){ this.addToSources(item);}} return (A) this;
  }
  public Boolean hasSources() {
    return sources != null && !sources.isEmpty();
  }
  public ProjectedVolumeSourceFluent.SourcesNested<A> addNewSource() {
    return new ProjectedVolumeSourceFluentImpl.SourcesNestedImpl();
  }
  public ProjectedVolumeSourceFluent.SourcesNested<A> addNewSourceLike(VolumeProjection item) {
    return new ProjectedVolumeSourceFluentImpl.SourcesNestedImpl(-1, item);
  }
  public ProjectedVolumeSourceFluent.SourcesNested<A> setNewSourceLike(Integer index,VolumeProjection item) {
    return new ProjectedVolumeSourceFluentImpl.SourcesNestedImpl(index, item);
  }
  public ProjectedVolumeSourceFluent.SourcesNested<A> editSource(Integer index) {
    if (sources.size() <= index) throw new RuntimeException("Can't edit sources. Index exceeds size.");
    return setNewSourceLike(index, buildSource(index));
  }
  public ProjectedVolumeSourceFluent.SourcesNested<A> editFirstSource() {
    if (sources.size() == 0) throw new RuntimeException("Can't edit first sources. The list is empty.");
    return setNewSourceLike(0, buildSource(0));
  }
  public ProjectedVolumeSourceFluent.SourcesNested<A> editLastSource() {
    int index = sources.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last sources. The list is empty.");
    return setNewSourceLike(index, buildSource(index));
  }
  public ProjectedVolumeSourceFluent.SourcesNested<A> editMatchingSource(Predicate<VolumeProjectionBuilder> predicate) {
    int index = -1;
    for (int i=0;i<sources.size();i++) { 
    if (predicate.test(sources.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching sources. No match found.");
    return setNewSourceLike(index, buildSource(index));
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ProjectedVolumeSourceFluentImpl that = (ProjectedVolumeSourceFluentImpl) o;
    if (defaultMode != null ? !defaultMode.equals(that.defaultMode) :that.defaultMode != null) return false;
    if (sources != null ? !sources.equals(that.sources) :that.sources != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(defaultMode,  sources,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (defaultMode != null) { sb.append("defaultMode:"); sb.append(defaultMode + ","); }
    if (sources != null && !sources.isEmpty()) { sb.append("sources:"); sb.append(sources + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class SourcesNestedImpl<N> extends VolumeProjectionFluentImpl<ProjectedVolumeSourceFluent.SourcesNested<N>> implements ProjectedVolumeSourceFluent.SourcesNested<N>,Nested<N>{
    SourcesNestedImpl(Integer index,VolumeProjection item) {
      this.index = index;
      this.builder = new VolumeProjectionBuilder(this, item);
    }
    SourcesNestedImpl() {
      this.index = -1;
      this.builder = new VolumeProjectionBuilder(this);
    }
    VolumeProjectionBuilder builder;
    Integer index;
    public N and() {
      return (N) ProjectedVolumeSourceFluentImpl.this.setToSources(index,builder.build());
    }
    public N endSource() {
      return and();
    }
    
  }
  
}