package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
public interface ServiceStatusFluent<A extends ServiceStatusFluent<A>> extends Fluent<A>{
  public A addToConditions(Integer index,Condition item);
  public A setToConditions(Integer index,Condition item);
  public A addToConditions(io.fabric8.kubernetes.api.model.Condition... items);
  public A addAllToConditions(Collection<Condition> items);
  public A removeFromConditions(io.fabric8.kubernetes.api.model.Condition... items);
  public A removeAllFromConditions(Collection<Condition> items);
  public A removeMatchingFromConditions(Predicate<ConditionBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildConditions instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<Condition> getConditions();
  public List<Condition> buildConditions();
  public Condition buildCondition(Integer index);
  public Condition buildFirstCondition();
  public Condition buildLastCondition();
  public Condition buildMatchingCondition(Predicate<ConditionBuilder> predicate);
  public Boolean hasMatchingCondition(Predicate<ConditionBuilder> predicate);
  public A withConditions(List<Condition> conditions);
  public A withConditions(io.fabric8.kubernetes.api.model.Condition... conditions);
  public Boolean hasConditions();
  public ServiceStatusFluent.ConditionsNested<A> addNewCondition();
  public ServiceStatusFluent.ConditionsNested<A> addNewConditionLike(Condition item);
  public ServiceStatusFluent.ConditionsNested<A> setNewConditionLike(Integer index,Condition item);
  public ServiceStatusFluent.ConditionsNested<A> editCondition(Integer index);
  public ServiceStatusFluent.ConditionsNested<A> editFirstCondition();
  public ServiceStatusFluent.ConditionsNested<A> editLastCondition();
  public ServiceStatusFluent.ConditionsNested<A> editMatchingCondition(Predicate<ConditionBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildLoadBalancer instead.
   * @return The buildable object.
   */
  @Deprecated
  public LoadBalancerStatus getLoadBalancer();
  public LoadBalancerStatus buildLoadBalancer();
  public A withLoadBalancer(LoadBalancerStatus loadBalancer);
  public Boolean hasLoadBalancer();
  public ServiceStatusFluent.LoadBalancerNested<A> withNewLoadBalancer();
  public ServiceStatusFluent.LoadBalancerNested<A> withNewLoadBalancerLike(LoadBalancerStatus item);
  public ServiceStatusFluent.LoadBalancerNested<A> editLoadBalancer();
  public ServiceStatusFluent.LoadBalancerNested<A> editOrNewLoadBalancer();
  public ServiceStatusFluent.LoadBalancerNested<A> editOrNewLoadBalancerLike(LoadBalancerStatus item);
  public A addToAdditionalProperties(String key,Object value);
  public A addToAdditionalProperties(Map<String,Object> map);
  public A removeFromAdditionalProperties(String key);
  public A removeFromAdditionalProperties(Map<String,Object> map);
  public Map<String,Object> getAdditionalProperties();
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties);
  public Boolean hasAdditionalProperties();
  public interface ConditionsNested<N> extends Nested<N>,ConditionFluent<ServiceStatusFluent.ConditionsNested<N>>{
    public N and();
    public N endCondition();
    
  }
  public interface LoadBalancerNested<N> extends Nested<N>,LoadBalancerStatusFluent<ServiceStatusFluent.LoadBalancerNested<N>>{
    public N and();
    public N endLoadBalancer();
    
  }
  
}